/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.result;

import java.io.IOException;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.PathSerializer;
import org.gradle.api.internal.project.ProjectIdentity;
import org.gradle.internal.serialize.AbstractSerializer;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.util.Path;

public class ProjectIdentitySerializer
extends AbstractSerializer<ProjectIdentity> {
    private final PathSerializer pathSerializer;

    public ProjectIdentitySerializer(PathSerializer pathSerializer) {
        this.pathSerializer = pathSerializer;
    }

    public ProjectIdentity read(Decoder decoder) throws IOException {
        Path buildPath = this.pathSerializer.read(decoder);
        boolean isRoot = decoder.readBoolean();
        if (isRoot) {
            String projectName = decoder.readString();
            return ProjectIdentity.forRootProject((Path)buildPath, (String)projectName);
        }
        Path projectPath = this.pathSerializer.read(decoder);
        return ProjectIdentity.forSubproject((Path)buildPath, (Path)projectPath);
    }

    public void write(Encoder encoder, ProjectIdentity value) throws IOException {
        this.pathSerializer.write(encoder, value.getBuildPath());
        boolean isRoot = value.getProjectPath().equals((Object)Path.ROOT);
        encoder.writeBoolean(isRoot);
        if (isRoot) {
            encoder.writeString((CharSequence)value.getProjectName());
        } else {
            this.pathSerializer.write(encoder, value.getProjectPath());
        }
    }
}

