/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transport.http;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.security.GeneralSecurityException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.gradle.authentication.Authentication;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.resource.transport.http.HttpProxySettings;
import org.gradle.internal.resource.transport.http.HttpSettings;
import org.gradle.internal.resource.transport.http.HttpTimeoutSettings;
import org.gradle.internal.resource.transport.http.JavaSystemPropertiesHttpProxySettings;
import org.gradle.internal.resource.transport.http.JavaSystemPropertiesHttpTimeoutSettings;
import org.gradle.internal.resource.transport.http.JavaSystemPropertiesSecureHttpProxySettings;
import org.gradle.internal.resource.transport.http.SslContextFactory;
import org.gradle.internal.verifier.HttpRedirectVerifier;

public class DefaultHttpSettings
implements HttpSettings {
    private static final int DEFAULT_MAX_REDIRECTS = 10;
    private static final int DEFAULT_MAX_CONNECTIONS = 20;
    private final Collection<Authentication> authenticationSettings;
    private final SslContextFactory sslContextFactory;
    private final HostnameVerifier hostnameVerifier;
    private final HttpRedirectVerifier redirectVerifier;
    private final int maxRedirects;
    private final int maxConnTotal;
    private final int maxConnPerRoute;
    private final HttpSettings.RedirectMethodHandlingStrategy redirectMethodHandlingStrategy;
    private HttpProxySettings proxySettings;
    private HttpProxySettings secureProxySettings;
    private HttpTimeoutSettings timeoutSettings;
    private static final HostnameVerifier ALL_TRUSTING_HOSTNAME_VERIFIER = new HostnameVerifier(){

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    };
    private static final SslContextFactory ALL_TRUSTING_SSL_CONTEXT_FACTORY = new SslContextFactory(){
        private final Supplier<SSLContext> sslContextSupplier = Suppliers.memoize((Supplier)new Supplier<SSLContext>(){

            public SSLContext get() {
                try {
                    SSLContext sslcontext = SSLContext.getInstance("TLS");
                    sslcontext.init(null, allTrustingTrustManager, null);
                    return sslcontext;
                }
                catch (GeneralSecurityException e) {
                    throw UncheckedException.throwAsUncheckedException((Throwable)e);
                }
            }
        });
        private final TrustManager[] allTrustingTrustManager = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};

        @Override
        public SSLContext createSslContext() {
            return (SSLContext)this.sslContextSupplier.get();
        }
    };

    public static Builder builder() {
        return new Builder();
    }

    private DefaultHttpSettings(Collection<Authentication> authenticationSettings, SslContextFactory sslContextFactory, HostnameVerifier hostnameVerifier, HttpRedirectVerifier redirectVerifier, HttpSettings.RedirectMethodHandlingStrategy redirectMethodHandlingStrategy, int maxRedirects, int maxConnTotal, int maxConnPerRoute) {
        Preconditions.checkArgument((maxRedirects >= 0 ? 1 : 0) != 0, (Object)"maxRedirects must be positive");
        Preconditions.checkArgument((maxConnTotal > 0 ? 1 : 0) != 0, (Object)"maxConnTotal must be positive");
        Preconditions.checkArgument((maxConnPerRoute > 0 ? 1 : 0) != 0, (Object)"maxConnPerRoute must be positive");
        Preconditions.checkNotNull(authenticationSettings, (Object)"authenticationSettings");
        Preconditions.checkNotNull((Object)sslContextFactory, (Object)"sslContextFactory");
        Preconditions.checkNotNull((Object)hostnameVerifier, (Object)"hostnameVerifier");
        Preconditions.checkNotNull((Object)redirectVerifier, (Object)"redirectVerifier");
        Preconditions.checkNotNull((Object)((Object)redirectMethodHandlingStrategy), (Object)"redirectMethodHandlingStrategy");
        this.maxRedirects = maxRedirects;
        this.maxConnTotal = maxConnTotal;
        this.maxConnPerRoute = maxConnPerRoute;
        this.authenticationSettings = authenticationSettings;
        this.sslContextFactory = sslContextFactory;
        this.hostnameVerifier = hostnameVerifier;
        this.redirectVerifier = redirectVerifier;
        this.redirectMethodHandlingStrategy = redirectMethodHandlingStrategy;
    }

    @Override
    public HttpProxySettings getProxySettings() {
        if (this.proxySettings == null) {
            this.proxySettings = new JavaSystemPropertiesHttpProxySettings();
        }
        return this.proxySettings;
    }

    @Override
    public HttpProxySettings getSecureProxySettings() {
        if (this.secureProxySettings == null) {
            this.secureProxySettings = new JavaSystemPropertiesSecureHttpProxySettings();
        }
        return this.secureProxySettings;
    }

    @Override
    public HttpTimeoutSettings getTimeoutSettings() {
        if (this.timeoutSettings == null) {
            this.timeoutSettings = new JavaSystemPropertiesHttpTimeoutSettings();
        }
        return this.timeoutSettings;
    }

    @Override
    public int getMaxRedirects() {
        return this.maxRedirects;
    }

    @Override
    public int getMaxConnTotal() {
        return this.maxConnTotal;
    }

    @Override
    public int getMaxConnPerRoute() {
        return this.maxConnPerRoute;
    }

    @Override
    public HttpRedirectVerifier getRedirectVerifier() {
        return this.redirectVerifier;
    }

    @Override
    public HttpSettings.RedirectMethodHandlingStrategy getRedirectMethodHandlingStrategy() {
        return this.redirectMethodHandlingStrategy;
    }

    @Override
    public Collection<Authentication> getAuthenticationSettings() {
        return this.authenticationSettings;
    }

    @Override
    public SslContextFactory getSslContextFactory() {
        return this.sslContextFactory;
    }

    @Override
    public HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public static class Builder {
        private Collection<Authentication> authenticationSettings;
        private SslContextFactory sslContextFactory;
        private HostnameVerifier hostnameVerifier;
        private HttpRedirectVerifier redirectVerifier;
        private int maxRedirects = 10;
        private int maxConnTotal = 20;
        private int maxConnPerRoute = 20;
        private HttpSettings.RedirectMethodHandlingStrategy redirectMethodHandlingStrategy = HttpSettings.RedirectMethodHandlingStrategy.ALWAYS_FOLLOW_AND_PRESERVE;

        public Builder withAuthenticationSettings(Collection<Authentication> authenticationSettings) {
            this.authenticationSettings = authenticationSettings;
            return this;
        }

        public Builder withSslContextFactory(SslContextFactory sslContextFactory) {
            this.sslContextFactory = sslContextFactory;
            this.hostnameVerifier = new DefaultHostnameVerifier(null);
            return this;
        }

        public Builder withRedirectVerifier(HttpRedirectVerifier redirectVerifier) {
            this.redirectVerifier = redirectVerifier;
            return this;
        }

        public Builder allowUntrustedConnections() {
            this.sslContextFactory = ALL_TRUSTING_SSL_CONTEXT_FACTORY;
            this.hostnameVerifier = ALL_TRUSTING_HOSTNAME_VERIFIER;
            return this;
        }

        public Builder maxRedirects(int maxRedirects) {
            Preconditions.checkArgument((maxRedirects >= 0 ? 1 : 0) != 0);
            this.maxRedirects = maxRedirects;
            return this;
        }

        public Builder maxConnTotal(int maxConnTotal) {
            Preconditions.checkArgument((maxConnTotal > 0 ? 1 : 0) != 0);
            this.maxConnTotal = maxConnTotal;
            return this;
        }

        public Builder maxConnPerRoute(int maxConnPerRoute) {
            Preconditions.checkArgument((maxConnPerRoute > 0 ? 1 : 0) != 0);
            this.maxConnPerRoute = maxConnPerRoute;
            return this;
        }

        public Builder withRedirectMethodHandlingStrategy(HttpSettings.RedirectMethodHandlingStrategy redirectMethodHandlingStrategy) {
            this.redirectMethodHandlingStrategy = redirectMethodHandlingStrategy;
            return this;
        }

        public HttpSettings build() {
            return new DefaultHttpSettings(this.authenticationSettings, this.sslContextFactory, this.hostnameVerifier, this.redirectVerifier, this.redirectMethodHandlingStrategy, this.maxRedirects, this.maxConnTotal, this.maxConnPerRoute);
        }
    }
}

