/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics;

import org.gradle.api.Incubating;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.diagnostics.AbstractConfigurationReportTask;
import org.gradle.api.tasks.diagnostics.internal.configurations.spec.AbstractConfigurationReportSpec;
import org.gradle.api.tasks.diagnostics.internal.configurations.spec.ResolvableConfigurationsSpec;
import org.gradle.api.tasks.options.Option;
import org.gradle.work.DisableCachingByDefault;

@Incubating
@DisableCachingByDefault(because="Produces only non-cacheable console output by examining configurations at execution time")
public abstract class ResolvableConfigurationsReportTask
extends AbstractConfigurationReportTask {
    @Input
    @Optional
    @Option(option="configuration", description="The name of the configuration to report")
    public abstract Property<String> getConfigurationName();

    @Input
    @Optional
    @Option(option="all", description="Shows all resolvable configurations, including legacy and deprecated configurations")
    public abstract Property<Boolean> getShowAll();

    @Input
    @Optional
    @Option(option="recursive", description="Lists all extended configurations of the reported configurations, including any which are extended transitively")
    public abstract Property<Boolean> getRecursive();

    @Override
    protected AbstractConfigurationReportSpec buildReportSpec() {
        return new ResolvableConfigurationsSpec((String)this.getConfigurationName().getOrNull(), (Boolean)this.getShowAll().get(), (Boolean)this.getRecursive().get(), true);
    }
}

