/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts;

import org.gradle.api.UnknownProjectException;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.artifacts.dependencies.DefaultProjectDependency;
import org.gradle.api.internal.artifacts.dsl.CapabilityNotationParser;
import org.gradle.api.internal.attributes.AttributesFactory;
import org.gradle.api.internal.project.ProjectState;
import org.gradle.api.internal.project.ProjectStateRegistry;
import org.gradle.api.model.ObjectFactory;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.util.Path;

@ServiceScope(value={Scope.Build.class, Scope.Project.class})
public class DefaultProjectDependencyFactory {
    private final Instantiator instantiator;
    private final NotationParser<Object, Capability> capabilityNotationParser;
    private final ObjectFactory objectFactory;
    private final AttributesFactory attributesFactory;
    private final ProjectStateRegistry projectStateRegistry;

    public DefaultProjectDependencyFactory(Instantiator instantiator, CapabilityNotationParser capabilityNotationParser, ObjectFactory objectFactory, AttributesFactory attributesFactory, ProjectStateRegistry projectStateRegistry) {
        this.instantiator = instantiator;
        this.capabilityNotationParser = capabilityNotationParser;
        this.objectFactory = objectFactory;
        this.attributesFactory = attributesFactory;
        this.projectStateRegistry = projectStateRegistry;
    }

    public ProjectDependency create(ProjectState projectState) {
        DefaultProjectDependency projectDependency = (DefaultProjectDependency)((Object)this.instantiator.newInstance(DefaultProjectDependency.class, new Object[]{projectState}));
        this.injectServices(projectDependency);
        return projectDependency;
    }

    public ProjectDependency create(Path projectIdentityPath) {
        ProjectState projectState = this.projectStateRegistry.findProjectState(projectIdentityPath);
        if (projectState == null) {
            throw new UnknownProjectException(String.format("Project with path '%s' could not be found.", projectIdentityPath.getPath()));
        }
        return this.create(projectState);
    }

    private void injectServices(DefaultProjectDependency projectDependency) {
        projectDependency.setAttributesFactory(this.attributesFactory);
        projectDependency.setCapabilityNotationParser(this.capabilityNotationParser);
        projectDependency.setObjectFactory(this.objectFactory);
    }
}

