/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import java.io.File;
import java.util.concurrent.locks.Lock;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.concurrent.GuardedBy;
import org.gradle.cache.FileLock;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.LockOptions;
import org.gradle.cache.internal.AbstractCrossProcessCacheAccess;
import org.gradle.cache.internal.CacheInitializationAction;
import org.gradle.internal.UncheckedException;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LockOnDemandEagerReleaseCrossProcessCacheAccess
extends AbstractCrossProcessCacheAccess {
    private static final Logger LOGGER = LoggerFactory.getLogger(LockOnDemandEagerReleaseCrossProcessCacheAccess.class);
    private final String cacheDisplayName;
    private final File lockTarget;
    private final LockOptions lockOptions;
    private final FileLockManager lockManager;
    private final Lock stateLock;
    private final Consumer<FileLock> onOpen;
    private final Consumer<FileLock> onClose;
    private final Runnable unlocker;
    @GuardedBy(value="stateLock")
    private int lockCount;
    @GuardedBy(value="stateLock")
    private @Nullable FileLock fileLock;
    private final CacheInitializationAction initAction;

    public LockOnDemandEagerReleaseCrossProcessCacheAccess(String cacheDisplayName, File lockTarget, LockOptions lockOptions, FileLockManager lockManager, Lock stateLock, CacheInitializationAction initAction, Consumer<FileLock> onOpen, Consumer<FileLock> onClose) {
        this.cacheDisplayName = cacheDisplayName;
        this.lockTarget = lockTarget;
        this.lockOptions = lockOptions;
        this.lockManager = lockManager;
        this.stateLock = stateLock;
        this.initAction = initAction;
        this.onOpen = onOpen;
        this.onClose = onClose;
        this.unlocker = this::decrementLockCount;
    }

    @Override
    public void open() {
    }

    @Override
    public void close() {
        this.stateLock.lock();
        try {
            if (this.lockCount != 0) {
                throw new IllegalStateException(String.format("Cannot close cache access for %s as it is currently in use for %s operations.", this.cacheDisplayName, this.lockCount));
            }
            this.releaseLockIfHeld();
        }
        finally {
            this.stateLock.unlock();
        }
    }

    @Override
    public <T> T withFileLock(Supplier<T> factory) {
        this.incrementLockCount();
        try {
            T t = factory.get();
            return t;
        }
        finally {
            this.decrementLockCount();
        }
    }

    private void incrementLockCount() {
        this.stateLock.lock();
        try {
            if (this.fileLock == null) {
                if (this.lockCount != 0) {
                    throw new IllegalStateException("Mismatched lock count.");
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Acquiring file lock for {}", (Object)this.cacheDisplayName);
                }
                this.fileLock = this.lockManager.lock(this.lockTarget, this.lockOptions, this.cacheDisplayName, "");
                try {
                    if (this.initAction.requiresInitialization(this.fileLock)) {
                        FileLock theLock = this.fileLock;
                        this.fileLock.writeFile(() -> this.initAction.initialize(theLock));
                    }
                    this.onOpen.accept(this.fileLock);
                }
                catch (Exception e) {
                    this.fileLock.close();
                    this.fileLock = null;
                    throw UncheckedException.throwAsUncheckedException((Throwable)e);
                }
            }
            ++this.lockCount;
        }
        finally {
            this.stateLock.unlock();
        }
    }

    private void decrementLockCount() {
        this.stateLock.lock();
        try {
            if (this.lockCount <= 0 || this.fileLock == null) {
                throw new IllegalStateException("Mismatched lock count.");
            }
            --this.lockCount;
            if (this.lockCount == 0) {
                this.releaseLockIfHeld();
            }
        }
        finally {
            this.stateLock.unlock();
        }
    }

    @GuardedBy(value="stateLock")
    private void releaseLockIfHeld() {
        if (this.fileLock == null) {
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Releasing file lock for {}", (Object)this.cacheDisplayName);
        }
        try {
            this.onClose.accept(this.fileLock);
        }
        finally {
            this.fileLock.close();
            this.fileLock = null;
        }
    }

    @Override
    public Runnable acquireFileLock() {
        this.incrementLockCount();
        return this.unlocker;
    }
}

