/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import com.google.common.collect.ImmutableSet;
import java.io.Serializable;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.api.internal.lambdas.SerializableLambdas;
import org.gradle.api.internal.plugins.ExtraPropertiesExtensionInternal;
import org.gradle.api.internal.project.ProjectHierarchyUtils;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.properties.GradleProperties;
import org.gradle.api.internal.properties.GradlePropertiesController;
import org.gradle.initialization.BuildLoader;
import org.gradle.initialization.properties.FilteringGradleProperties;

public class ProjectPropertySettingBuildLoader
implements BuildLoader {
    private final GradlePropertiesController gradlePropertiesController;
    private final BuildLoader buildLoader;

    public ProjectPropertySettingBuildLoader(GradlePropertiesController gradlePropertiesController, BuildLoader buildLoader) {
        this.gradlePropertiesController = gradlePropertiesController;
        this.buildLoader = buildLoader;
    }

    @Override
    public void load(SettingsInternal settings, GradleInternal gradle) {
        this.buildLoader.load(settings, gradle);
        this.setProjectProperties(gradle.getRootProject());
    }

    private void setProjectProperties(ProjectInternal project) {
        this.addPropertiesToProject(project);
        for (Project childProject : ProjectHierarchyUtils.getChildProjectsForInternalUse(project)) {
            this.setProjectProperties((ProjectInternal)childProject);
        }
    }

    private void addPropertiesToProject(ProjectInternal project) {
        this.gradlePropertiesController.loadGradleProperties(project.getProjectIdentity(), project.getProjectDir());
        GradleProperties projectGradleProperties = this.gradlePropertiesController.getGradleProperties(project.getProjectIdentity());
        Set<String> consumedProperties = ProjectPropertySettingBuildLoader.assignSelectedPropertiesDirectly(project, projectGradleProperties);
        ProjectPropertySettingBuildLoader.installProjectExtraPropertiesDefaults(project, projectGradleProperties, consumedProperties);
    }

    private static Set<String> assignSelectedPropertiesDirectly(ProjectInternal project, GradleProperties projectGradleProperties) {
        String descriptionName;
        Object descriptionValue;
        String buildDirName;
        Object buildDirValue;
        String statusName;
        Object statusValue;
        String groupName;
        Object groupValue;
        ImmutableSet.Builder consumedProperties = ImmutableSet.builder();
        consumedProperties.add((Object)"");
        String versionName = "version";
        Object versionValue = projectGradleProperties.findUnsafe(versionName);
        if (versionValue != null) {
            project.setVersion(versionValue);
            consumedProperties.add((Object)versionName);
        }
        if ((groupValue = projectGradleProperties.findUnsafe(groupName = "group")) != null) {
            project.setGroup(groupValue);
            consumedProperties.add((Object)groupName);
        }
        if ((statusValue = projectGradleProperties.findUnsafe(statusName = "status")) != null) {
            project.setStatus(statusValue);
            consumedProperties.add((Object)statusName);
        }
        if ((buildDirValue = projectGradleProperties.findUnsafe(buildDirName = "buildDir")) != null) {
            project.setBuildDir(buildDirValue);
            consumedProperties.add((Object)buildDirName);
        }
        if ((descriptionValue = projectGradleProperties.findUnsafe(descriptionName = "description")) instanceof String) {
            project.setDescription((String)descriptionValue);
            consumedProperties.add((Object)descriptionName);
        }
        return consumedProperties.build();
    }

    private static void installProjectExtraPropertiesDefaults(ProjectInternal project, GradleProperties projectGradleProperties, Set<String> consumedProperties) {
        ExtraPropertiesExtensionInternal extraPropertiesContainer = (ExtraPropertiesExtensionInternal)project.getExtensions().getExtraProperties();
        extraPropertiesContainer.setGradleProperties((GradleProperties)new FilteringGradleProperties(projectGradleProperties, (SerializableLambdas.SerializablePredicate<String>)(SerializableLambdas.SerializablePredicate & Serializable)it -> !consumedProperties.contains(it)));
    }
}

