/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.plan;

import java.util.IdentityHashMap;
import java.util.Map;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.internal.project.HoldsProjectState;
import org.gradle.api.internal.tasks.WorkNodeAction;
import org.gradle.execution.plan.ActionNode;
import org.gradle.execution.plan.DependencyResolver;
import org.gradle.execution.plan.Node;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;

@ServiceScope(value={Scope.Build.class})
public class WorkNodeDependencyResolver
implements DependencyResolver,
HoldsProjectState {
    private final Map<WorkNodeAction, ActionNode> nodesForAction = new IdentityHashMap<WorkNodeAction, ActionNode>();

    public boolean resolve(Task task, Object node, Action<? super Node> resolveAction) {
        if (!(node instanceof WorkNodeAction)) {
            return false;
        }
        WorkNodeAction action = (WorkNodeAction)node;
        ActionNode actionNode = this.actionNodeFor(action);
        resolveAction.execute((Object)actionNode);
        return true;
    }

    @Override
    public void discardAll() {
        this.nodesForAction.clear();
    }

    private ActionNode actionNodeFor(WorkNodeAction action) {
        ActionNode actionNode = this.nodesForAction.get(action);
        if (actionNode == null) {
            actionNode = new ActionNode(action);
            this.nodesForAction.put(action, actionNode);
        }
        return actionNode;
    }
}

