/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.impl;

import java.lang.ref.SoftReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnnotation;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiJavaParserFacade;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiElementFactoryImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import org.jetbrains.kotlin.com.intellij.psi.impl.java.stubs.PsiAnnotationStub;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.CharTableImpl;
import org.jetbrains.kotlin.com.intellij.psi.stubs.PsiFileStub;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubBase;
import org.jetbrains.kotlin.com.intellij.psi.stubs.StubElement;
import org.jetbrains.kotlin.com.intellij.testFramework.LightVirtualFile;
import org.jetbrains.kotlin.com.intellij.util.IncorrectOperationException;

public class PsiAnnotationStubImpl
extends StubBase<PsiAnnotation>
implements PsiAnnotationStub {
    private static final Logger LOG = Logger.getInstance(PsiAnnotationStubImpl.class);
    private final String myText;
    private SoftReference<PsiAnnotation> myParsedFromRepository;

    public PsiAnnotationStubImpl(StubElement<?> parent2, @NotNull String text) {
        if (text == null) {
            PsiAnnotationStubImpl.$$$reportNull$$$0(0);
        }
        super(parent2, JavaStubElementTypes.ANNOTATION);
        CharSequence interned = CharTableImpl.getStaticInterned(text);
        this.myText = interned == null ? text : interned.toString();
    }

    @Override
    public String getText() {
        return this.myText;
    }

    @Override
    public PsiAnnotation getPsiElement() {
        PsiAnnotation annotation = org.jetbrains.kotlin.com.intellij.reference.SoftReference.dereference(this.myParsedFromRepository);
        if (annotation != null) {
            return annotation;
        }
        String text = this.getText();
        try {
            PsiJavaParserFacade facade = JavaPsiFacade.getInstance(this.getProject()).getParserFacade();
            annotation = facade instanceof PsiElementFactoryImpl ? ((PsiElementFactoryImpl)facade).createAnnotationFromText(text, (PsiElement)this.getPsi(), false) : facade.createAnnotationFromText(text, (PsiElement)this.getPsi());
            ((LightVirtualFile)annotation.getContainingFile().getViewProvider().getVirtualFile()).setWritable(false);
            this.myParsedFromRepository = new SoftReference<PsiAnnotation>(annotation);
            return annotation;
        }
        catch (IncorrectOperationException e2) {
            LOG.error("Bad annotation in " + this.fileName(), e2);
            return null;
        }
    }

    private String fileName() {
        StubElement<PsiAnnotation> stub = this;
        while ((stub = stub.getParentStub()) != null) {
            PsiAnnotation psi;
            if (!(stub instanceof PsiFileStub) || !((psi = stub.getPsi()) instanceof PsiFile)) continue;
            VirtualFile file = ((PsiFile)((Object)psi)).getVirtualFile();
            return file != null ? file.getUrl() : ((PsiFile)((Object)psi)).getName();
        }
        return "<unknown file>";
    }

    @Override
    public String toString() {
        return "PsiAnnotationStub[" + this.myText + ']';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/com/intellij/psi/impl/java/stubs/impl/PsiAnnotationStubImpl", "<init>"));
    }
}

