/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.constraints;

import java.util.List;
import org.jetbrains.kotlin.com.intellij.core.JavaPsiBundle;
import org.jetbrains.kotlin.com.intellij.psi.LambdaUtil;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassType;
import org.jetbrains.kotlin.com.intellij.psi.PsiCodeBlock;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiLambdaExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypes;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.FunctionalInterfaceParameterizationUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.InferenceVariable;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.constraints.ConstraintFormula;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.constraints.ExpressionCompatibilityConstraint;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.constraints.StrictSubtypingConstraint;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.constraints.TypeEqualityConstraint;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.TypeConversionUtil;

public class LambdaExpressionCompatibilityConstraint
implements ConstraintFormula {
    private final PsiLambdaExpression myExpression;
    private PsiType myT;

    public LambdaExpressionCompatibilityConstraint(PsiLambdaExpression expression2, PsiType t2) {
        this.myExpression = expression2;
        this.myT = t2;
    }

    @Override
    public boolean reduce(InferenceSession session2, List<? super ConstraintFormula> constraints) {
        block17: {
            if (!LambdaUtil.isFunctionalType(this.myT)) {
                session2.registerIncompatibleErrorMessage(JavaPsiBundle.message("error.incompatible.type.not.a.functional.interface", session2.getPresentableText(this.myT)));
                return false;
            }
            PsiType groundTargetType = FunctionalInterfaceParameterizationUtil.getGroundTargetType(this.myT, this.myExpression, false);
            PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType(groundTargetType);
            PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod(resolveResult);
            if (interfaceMethod == null) {
                session2.registerIncompatibleErrorMessage(JavaPsiBundle.message("error.incompatible.type.no.valid.function.type.found", session2.getPresentableText(this.myT)));
                return false;
            }
            PsiSubstitutor substitutor2 = LambdaUtil.getSubstitutor(interfaceMethod, resolveResult);
            PsiParameter[] parameters = interfaceMethod.getParameterList().getParameters();
            PsiParameter[] lambdaParameters = this.myExpression.getParameterList().getParameters();
            if (lambdaParameters.length != parameters.length) {
                session2.registerIncompatibleErrorMessage(JavaPsiBundle.message("error.incompatible.type.incompatible.parameter.types.in.lambda", parameters.length, lambdaParameters.length));
                return false;
            }
            if (this.myExpression.hasFormalParameterTypes()) {
                for (int i2 = 0; i2 < lambdaParameters.length; ++i2) {
                    constraints.add(new TypeEqualityConstraint(lambdaParameters[i2].getType(), session2.substituteWithInferenceVariables(substitutor2.substitute(parameters[i2].getType()))));
                }
                constraints.add(new StrictSubtypingConstraint(this.myT, groundTargetType));
            } else {
                for (PsiParameter parameter : parameters) {
                    PsiType type2 = session2.substituteWithInferenceVariables(substitutor2.substitute(parameter.getType()));
                    if (session2.isProperType(type2)) continue;
                    return false;
                }
            }
            PsiType returnType = interfaceMethod.getReturnType();
            if (returnType == null) break block17;
            List<PsiExpression> returnExpressions = LambdaUtil.getReturnExpressions(this.myExpression);
            PsiElement lambdaBody = this.myExpression.getBody();
            if (returnType.equals(PsiTypes.voidType())) {
                if (!(lambdaBody instanceof PsiCodeBlock && this.myExpression.isVoidCompatible() || LambdaUtil.isExpressionStatementExpression(lambdaBody))) {
                    session2.registerIncompatibleErrorMessage(JavaPsiBundle.message("error.incompatible.type.incompatible.types.expected.void.lambda", new Object[0]));
                    return false;
                }
            } else {
                if (lambdaBody instanceof PsiCodeBlock && !this.myExpression.isValueCompatible()) {
                    session2.registerIncompatibleErrorMessage(JavaPsiBundle.message("error.incompatible.type.expected.value.lambda", new Object[0]));
                    return false;
                }
                PsiSubstitutor nestedSubstitutor = session2.getInferenceSessionContainer().findNestedSubstitutor(this.myExpression, session2.getInferenceSubstitution());
                returnType = nestedSubstitutor.substitute(substitutor2.substitute(returnType));
                boolean isProperType = InferenceSession.collectDependencies(returnType, null, type -> {
                    PsiClass psiClass = PsiUtil.resolveClassInClassTypeOnly(type);
                    return psiClass instanceof InferenceVariable && nestedSubstitutor.getSubstitutionMap().containsValue(type) ? (InferenceVariable)psiClass : null;
                });
                if (!isProperType || this.myExpression.hasFormalParameterTypes()) {
                    for (PsiExpression returnExpression : returnExpressions) {
                        if (InferenceSession.ignoreLambdaConstraintTree(returnExpression)) continue;
                        constraints.add(new ExpressionCompatibilityConstraint(returnExpression, returnType));
                    }
                } else {
                    for (PsiExpression returnExpression : returnExpressions) {
                        if (PsiPolyExpressionUtil.isPolyExpression(returnExpression) || TypeConversionUtil.areTypesAssignmentCompatible(returnType, returnExpression)) continue;
                        PsiType type3 = returnExpression.getType();
                        if (type3 != null) {
                            session2.registerIncompatibleErrorMessage(JavaPsiBundle.message("error.incompatible.type.bad.lambda.return.type", session2.getPresentableText(type3), session2.getPresentableText(returnType)));
                        } else {
                            session2.registerIncompatibleErrorMessage(JavaPsiBundle.message("error.incompatible.type", returnExpression.getText(), session2.getPresentableText(returnType)));
                        }
                        return false;
                    }
                }
            }
        }
        return true;
    }

    @Override
    public void apply(PsiSubstitutor substitutor2, boolean cache2) {
        this.myT = substitutor2.substitute(this.myT);
    }

    public String toString() {
        return this.myExpression.getText() + " -> " + this.myT.getPresentableText();
    }
}

