/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.fileEditor.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.BinaryFileDecompiler;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.BinaryFileTypeDecompilers;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.CharsetUtil;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.FileType;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.openapi.util.Pair;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.Strings;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.CharsetToolkit;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VfsUtilCore;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.encoding.EncodingRegistry;
import org.jetbrains.kotlin.com.intellij.testFramework.LightVirtualFile;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtilRt;
import org.jetbrains.kotlin.com.intellij.util.BitUtil;
import org.jetbrains.kotlin.com.intellij.util.ObjectUtils;
import org.jetbrains.kotlin.com.intellij.util.text.ByteArrayCharSequence;
import org.jetbrains.kotlin.com.intellij.util.text.CharArrayUtil;

public final class LoadTextUtil {
    private static final Logger LOG = Logger.getInstance(LoadTextUtil.class);
    private static final Charset INTERNAL_SEVEN_BIT_UTF8 = new SevenBitCharset(StandardCharsets.UTF_8);
    private static final Charset INTERNAL_SEVEN_BIT_ISO_8859_1 = new SevenBitCharset(StandardCharsets.ISO_8859_1);
    private static final Charset INTERNAL_SEVEN_BIT_WIN_1251 = new SevenBitCharset(CharsetToolkit.WIN_1251_CHARSET);
    private static final boolean GUESS_UTF = Boolean.parseBoolean(System.getProperty("idea.guess.utf.encoding", "true"));
    private static final Key<AutoDetectionReason> CHARSET_WAS_DETECTED_FROM_BYTES = Key.create("CHARSET_WAS_DETECTED_FROM_BYTES");

    private LoadTextUtil() {
    }

    @NotNull
    private static ConvertResult convertLineSeparatorsToSlashN(@NotNull CharBuffer buffer) {
        if (buffer == null) {
            LoadTextUtil.$$$reportNull$$$0(0);
        }
        int dst = 0;
        int prev = 32;
        int crCount = 0;
        int lfCount = 0;
        int crlfCount = 0;
        int length = buffer.length();
        char[] bufferArray = CharArrayUtil.fromSequenceWithoutCopying(buffer);
        for (int src = 0; src < length; ++src) {
            int c2 = bufferArray != null ? bufferArray[src] : buffer.charAt(src);
            switch (c2) {
                case 13: {
                    if (bufferArray != null) {
                        bufferArray[dst++] = 10;
                    } else {
                        buffer.put(dst++, '\n');
                    }
                    ++crCount;
                    break;
                }
                case 10: {
                    if (prev == 13) {
                        --crCount;
                        ++crlfCount;
                        break;
                    }
                    if (bufferArray != null) {
                        bufferArray[dst++] = 10;
                    } else {
                        buffer.put(dst++, '\n');
                    }
                    ++lfCount;
                    break;
                }
                default: {
                    if (bufferArray != null) {
                        bufferArray[dst++] = c2;
                        break;
                    }
                    buffer.put(dst++, (char)c2);
                }
            }
            prev = c2;
        }
        CharBuffer result2 = buffer.length() == dst ? buffer : buffer.subSequence(0, dst);
        return new ConvertResult(result2, crCount, lfCount, crlfCount);
    }

    @NotNull
    private static ConvertResult convertLineSeparatorsToSlashN(byte @NotNull [] charsAsBytes, int startOffset, int endOffset) {
        int lineBreak;
        if (charsAsBytes == null) {
            LoadTextUtil.$$$reportNull$$$0(1);
        }
        if (!BitUtil.isSet(lineBreak = LoadTextUtil.findLineBreakOrWideChar(charsAsBytes, startOffset, endOffset), 1) && !BitUtil.isSet(lineBreak, 4)) {
            ByteArrayCharSequence sequence2 = new ByteArrayCharSequence(charsAsBytes, startOffset, endOffset);
            return new ConvertResult(sequence2, 0, BitUtil.isSet(lineBreak, 2) ? 1 : 0, 0);
        }
        if (BitUtil.isSet(lineBreak, 4)) {
            return LoadTextUtil.convertWideCharacters(charsAsBytes, startOffset, endOffset);
        }
        int dst = 0;
        int prev = 32;
        int crCount = 0;
        int lfCount = 0;
        int crlfCount = 0;
        byte[] result2 = ArrayUtil.newByteArray(endOffset - startOffset);
        for (int src = startOffset; src < endOffset; ++src) {
            char c2 = (char)charsAsBytes[src];
            switch (c2) {
                case '\r': {
                    result2[dst++] = 10;
                    ++crCount;
                    break;
                }
                case '\n': {
                    if (prev == 13) {
                        --crCount;
                        ++crlfCount;
                        break;
                    }
                    result2[dst++] = 10;
                    ++lfCount;
                    break;
                }
                default: {
                    result2[dst++] = (byte)c2;
                }
            }
            prev = c2;
        }
        ByteArrayCharSequence sequence3 = new ByteArrayCharSequence(result2, 0, dst);
        return new ConvertResult(sequence3, crCount, lfCount, crlfCount);
    }

    @NotNull
    private static ConvertResult convertWideCharacters(byte @NotNull [] charsAsBytes, int startOffset, int endOffset) {
        if (charsAsBytes == null) {
            LoadTextUtil.$$$reportNull$$$0(2);
        }
        int prev = 32;
        int crCount = 0;
        int lfCount = 0;
        int crlfCount = 0;
        StringBuilder result2 = new StringBuilder(endOffset - startOffset);
        for (int src = startOffset; src < endOffset; ++src) {
            char c2 = (char)charsAsBytes[src];
            if (c2 >= '\u0080') {
                result2.append('\ufdff');
                continue;
            }
            switch (c2) {
                case '\r': {
                    result2.append('\n');
                    ++crCount;
                    break;
                }
                case '\n': {
                    if (prev == 13) {
                        --crCount;
                        ++crlfCount;
                        break;
                    }
                    result2.append('\n');
                    ++lfCount;
                    break;
                }
                default: {
                    result2.append(c2);
                }
            }
            prev = c2;
        }
        return new ConvertResult(result2, crCount, lfCount, crlfCount);
    }

    private static int findLineBreakOrWideChar(byte @NotNull [] ints, int start, int end) {
        if (ints == null) {
            LoadTextUtil.$$$reportNull$$$0(3);
        }
        int flags = 0;
        for (int i2 = start; i2 < end; ++i2) {
            byte c2 = ints[i2];
            if (c2 == 13) {
                flags |= 1;
            }
            if (c2 == 10) {
                flags |= 2;
            }
            if (c2 >= 0) continue;
            flags |= 4;
        }
        return flags;
    }

    @NotNull
    private static DetectResult detectHardCharset(@NotNull VirtualFile virtualFile, byte @NotNull [] internalBuffer, int length, @NotNull FileType fileType) {
        String charsetName;
        if (virtualFile == null) {
            LoadTextUtil.$$$reportNull$$$0(4);
        }
        if (fileType == null) {
            LoadTextUtil.$$$reportNull$$$0(5);
        }
        if (internalBuffer == null) {
            LoadTextUtil.$$$reportNull$$$0(6);
        }
        Charset charset = (charsetName = fileType.getCharset(virtualFile, internalBuffer)) == null ? null : CharsetToolkit.forName(charsetName);
        DetectResult detectResult = LoadTextUtil.guessFromContent(virtualFile, internalBuffer, length);
        Charset hardCodedCharset = charset == null ? detectResult.hardCodedCharset : charset;
        CharsetToolkit.GuessedEncoding guessed = detectResult.guessed;
        byte[] detectedBOM = detectResult.BOM;
        Charset result2 = hardCodedCharset == null && guessed == CharsetToolkit.GuessedEncoding.VALID_UTF8 ? StandardCharsets.UTF_8 : hardCodedCharset;
        return new DetectResult(result2, guessed, detectedBOM);
    }

    @NotNull
    private static Charset getDefaultCharsetFromEncodingManager(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            LoadTextUtil.$$$reportNull$$$0(11);
        }
        Charset specifiedExplicitly = EncodingRegistry.getInstance().getEncoding(virtualFile, true);
        Charset charset = ObjectUtils.notNull(specifiedExplicitly, EncodingRegistry.getInstance().getDefaultCharset());
        if (charset == null) {
            LoadTextUtil.$$$reportNull$$$0(12);
        }
        return charset;
    }

    @NotNull
    private static DetectResult detectInternalCharsetAndSetBOM(@NotNull VirtualFile file, byte @NotNull [] internalBuffer, int length, boolean saveBOM, @NotNull FileType fileType) {
        if (file == null) {
            LoadTextUtil.$$$reportNull$$$0(13);
        }
        if (fileType == null) {
            LoadTextUtil.$$$reportNull$$$0(14);
        }
        if (internalBuffer == null) {
            LoadTextUtil.$$$reportNull$$$0(15);
        }
        DetectResult info = LoadTextUtil.detectHardCharset(file, internalBuffer, length, fileType);
        Charset charset = info.hardCodedCharset == null ? (file.isCharsetSet() ? file.getCharset() : LoadTextUtil.getDefaultCharsetFromEncodingManager(file)) : info.hardCodedCharset;
        byte[] bom = info.BOM;
        if (saveBOM && bom != null && bom.length != 0) {
            file.setBOM(bom);
            LoadTextUtil.setCharsetAutoDetectionReason(file, AutoDetectionReason.FROM_BOM);
        }
        file.setCharset(charset);
        Charset result2 = charset;
        if (info.guessed == CharsetToolkit.GuessedEncoding.SEVEN_BIT) {
            if (charset == StandardCharsets.UTF_8) {
                result2 = INTERNAL_SEVEN_BIT_UTF8;
            } else if (charset == StandardCharsets.ISO_8859_1) {
                result2 = INTERNAL_SEVEN_BIT_ISO_8859_1;
            } else if (charset == CharsetToolkit.WIN_1251_CHARSET) {
                result2 = INTERNAL_SEVEN_BIT_WIN_1251;
            }
        }
        return new DetectResult(result2, info.guessed, bom);
    }

    @NotNull
    public static DetectResult guessFromContent(@NotNull VirtualFile virtualFile, byte @NotNull [] content) {
        if (virtualFile == null) {
            LoadTextUtil.$$$reportNull$$$0(16);
        }
        if (content == null) {
            LoadTextUtil.$$$reportNull$$$0(17);
        }
        return LoadTextUtil.guessFromContent(virtualFile, content, content.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static DetectResult guessFromContent(@NotNull VirtualFile virtualFile, byte @NotNull [] content, int length) {
        DetectResult detectResult;
        if (virtualFile == null) {
            LoadTextUtil.$$$reportNull$$$0(18);
        }
        if (content == null) {
            LoadTextUtil.$$$reportNull$$$0(19);
        }
        AutoDetectionReason detectedFromBytes = null;
        try {
            DetectResult info;
            if (GUESS_UTF) {
                info = LoadTextUtil.guessFromBytes(content, length, LoadTextUtil.getDefaultCharsetFromEncodingManager(virtualFile));
                if (info.BOM != null) {
                    detectedFromBytes = AutoDetectionReason.FROM_BOM;
                } else if (info.guessed == CharsetToolkit.GuessedEncoding.VALID_UTF8) {
                    detectedFromBytes = AutoDetectionReason.FROM_BYTES;
                }
            } else {
                info = new DetectResult(null, null, null);
            }
            detectResult = info;
        }
        catch (Throwable throwable) {
            LoadTextUtil.setCharsetAutoDetectionReason(virtualFile, detectedFromBytes);
            throw throwable;
        }
        LoadTextUtil.setCharsetAutoDetectionReason(virtualFile, detectedFromBytes);
        DetectResult detectResult2 = detectResult;
        if (detectResult2 == null) {
            LoadTextUtil.$$$reportNull$$$0(20);
        }
        return detectResult2;
    }

    @NotNull
    private static DetectResult guessFromBytes(byte @NotNull [] content, int endOffset, @NotNull Charset defaultCharset) {
        if (defaultCharset == null) {
            LoadTextUtil.$$$reportNull$$$0(21);
        }
        if (content == null) {
            LoadTextUtil.$$$reportNull$$$0(22);
        }
        if (endOffset == 0) {
            return new DetectResult(null, CharsetToolkit.GuessedEncoding.SEVEN_BIT, null);
        }
        CharsetToolkit toolkit = new CharsetToolkit(content, defaultCharset, true);
        Charset charset = toolkit.guessFromBOM();
        if (charset != null) {
            byte[] bom = ObjectUtils.notNull(CharsetToolkit.getMandatoryBom(charset), CharsetToolkit.UTF8_BOM);
            return new DetectResult(charset, null, bom);
        }
        CharsetToolkit.GuessedEncoding guessed = toolkit.guessFromContent(0, endOffset);
        if (guessed == CharsetToolkit.GuessedEncoding.VALID_UTF8) {
            return new DetectResult(StandardCharsets.UTF_8, CharsetToolkit.GuessedEncoding.VALID_UTF8, null);
        }
        return new DetectResult(null, guessed, null);
    }

    public static void write(@Nullable Project project, @NotNull VirtualFile virtualFile, @NotNull Object requestor, @NotNull String text, long newModificationStamp) throws IOException {
        if (virtualFile == null) {
            LoadTextUtil.$$$reportNull$$$0(31);
        }
        if (requestor == null) {
            LoadTextUtil.$$$reportNull$$$0(32);
        }
        if (text == null) {
            LoadTextUtil.$$$reportNull$$$0(33);
        }
        Charset existing = virtualFile.getCharset();
        Pair.NonNull<Charset, byte[]> chosen = LoadTextUtil.charsetForWriting(project, virtualFile, text, existing);
        Charset charset = (Charset)chosen.first;
        byte[] buffer = (byte[])chosen.second;
        if (!charset.equals(existing)) {
            virtualFile.setCharset(charset);
        }
        LoadTextUtil.restoreDetectedFromContentFlag(virtualFile, buffer);
        try (OutputStream stream = virtualFile.getOutputStream(requestor, newModificationStamp, -1L);){
            stream.write(buffer);
        }
    }

    @NotNull
    public static Pair.NonNull<Charset, byte[]> charsetForWriting(@Nullable Project project, @NotNull VirtualFile virtualFile, @NotNull String text, @NotNull Charset existing) {
        Charset fromBom;
        if (virtualFile == null) {
            LoadTextUtil.$$$reportNull$$$0(34);
        }
        if (text == null) {
            LoadTextUtil.$$$reportNull$$$0(35);
        }
        if (existing == null) {
            LoadTextUtil.$$$reportNull$$$0(36);
        }
        Charset specified = LoadTextUtil.extractCharsetFromFileContent(project, virtualFile, text);
        Pair.NonNull<Charset, byte[]> chosen = LoadTextUtil.chooseMostlyHarmlessCharset(existing, specified, text);
        Charset charset = (Charset)chosen.first;
        byte[] bom = virtualFile.getBOM();
        Charset charset2 = fromBom = bom == null ? null : CharsetToolkit.guessFromBOM(bom);
        if (fromBom != null && !fromBom.equals(charset)) {
            chosen = Pair.createNonNull(fromBom, text.getBytes(fromBom));
        }
        Pair.NonNull<Charset, byte[]> nonNull = chosen;
        if (nonNull == null) {
            LoadTextUtil.$$$reportNull$$$0(37);
        }
        return nonNull;
    }

    private static void restoreDetectedFromContentFlag(@NotNull VirtualFile virtualFile, byte @NotNull [] content) {
        if (virtualFile == null) {
            LoadTextUtil.$$$reportNull$$$0(38);
        }
        if (content == null) {
            LoadTextUtil.$$$reportNull$$$0(39);
        }
        if (virtualFile.getBOM() == null) {
            LoadTextUtil.guessFromContent(virtualFile, content);
        } else {
            LoadTextUtil.setCharsetAutoDetectionReason(virtualFile, AutoDetectionReason.FROM_BOM);
        }
    }

    @NotNull
    public static Pair.NonNull<Charset, byte[]> chooseMostlyHarmlessCharset(@NotNull Charset existing, @NotNull Charset specified, @NotNull String text) {
        block15: {
            byte[] out;
            block14: {
                block13: {
                    Pair.NonNull<Charset, byte[]> nonNull;
                    if (existing == null) {
                        LoadTextUtil.$$$reportNull$$$0(40);
                    }
                    if (specified == null) {
                        LoadTextUtil.$$$reportNull$$$0(41);
                    }
                    if (text == null) {
                        LoadTextUtil.$$$reportNull$$$0(42);
                    }
                    try {
                        if (!specified.equals(existing)) break block13;
                        nonNull = Pair.createNonNull(specified, text.getBytes(existing));
                    }
                    catch (RuntimeException e2) {
                        Charset defaultCharset = Charset.defaultCharset();
                        Pair.NonNull<Charset, byte[]> nonNull2 = Pair.createNonNull(defaultCharset, text.getBytes(defaultCharset));
                        if (nonNull2 == null) {
                            LoadTextUtil.$$$reportNull$$$0(47);
                        }
                        return nonNull2;
                    }
                    if (nonNull == null) {
                        LoadTextUtil.$$$reportNull$$$0(43);
                    }
                    return nonNull;
                }
                out = LoadTextUtil.isSupported(specified, text);
                if (out == null) break block14;
                Pair.NonNull<Charset, byte[]> nonNull = Pair.createNonNull(specified, out);
                if (nonNull == null) {
                    LoadTextUtil.$$$reportNull$$$0(44);
                }
                return nonNull;
            }
            out = LoadTextUtil.isSupported(existing, text);
            if (out == null) break block15;
            Pair.NonNull<Charset, byte[]> nonNull = Pair.createNonNull(existing, out);
            if (nonNull == null) {
                LoadTextUtil.$$$reportNull$$$0(45);
            }
            return nonNull;
        }
        Pair.NonNull<Charset, byte[]> nonNull = Pair.createNonNull(specified, text.getBytes(specified));
        if (nonNull == null) {
            LoadTextUtil.$$$reportNull$$$0(46);
        }
        return nonNull;
    }

    private static byte @Nullable(value="null means not supported, otherwise it is converted byte stream") [] isSupported(@NotNull Charset charset, @NotNull String str) {
        if (charset == null) {
            LoadTextUtil.$$$reportNull$$$0(48);
        }
        if (str == null) {
            LoadTextUtil.$$$reportNull$$$0(49);
        }
        try {
            if (!charset.canEncode()) {
                return null;
            }
            byte[] bytes = str.getBytes(charset);
            if (!str.equals(new String(bytes, charset))) {
                return null;
            }
            return bytes;
        }
        catch (Exception e2) {
            return null;
        }
    }

    @NotNull
    public static Charset extractCharsetFromFileContent(@Nullable Project project, @NotNull VirtualFile virtualFile, @NotNull CharSequence text) {
        if (virtualFile == null) {
            LoadTextUtil.$$$reportNull$$$0(50);
        }
        if (text == null) {
            LoadTextUtil.$$$reportNull$$$0(51);
        }
        Charset charset = ObjectUtils.notNull(LoadTextUtil.charsetFromContentOrNull(project, virtualFile, text), virtualFile.getCharset());
        if (charset == null) {
            LoadTextUtil.$$$reportNull$$$0(52);
        }
        return charset;
    }

    @Nullable(value="returns null if cannot determine from content")
    public static @Nullable(value="returns null if cannot determine from content") Charset charsetFromContentOrNull(@Nullable Project project, @NotNull VirtualFile virtualFile, @NotNull CharSequence text) {
        if (virtualFile == null) {
            LoadTextUtil.$$$reportNull$$$0(53);
        }
        if (text == null) {
            LoadTextUtil.$$$reportNull$$$0(54);
        }
        return CharsetUtil.extractCharsetFromFileContent(project, virtualFile, virtualFile.getFileType(), text);
    }

    @NotNull
    public static CharSequence loadText(@NotNull VirtualFile file) {
        FileType type;
        if (file == null) {
            LoadTextUtil.$$$reportNull$$$0(55);
        }
        if ((type = file.getFileType()).isBinary()) {
            BinaryFileDecompiler decompiler = (BinaryFileDecompiler)BinaryFileTypeDecompilers.getInstance().forFileType(type);
            if (decompiler != null) {
                CharSequence text = decompiler.decompile(file);
                try {
                    StringUtil.assertValidSeparators(text);
                }
                catch (AssertionError e2) {
                    LOG.error((Throwable)((Object)e2));
                }
                CharSequence charSequence = text;
                if (charSequence == null) {
                    LoadTextUtil.$$$reportNull$$$0(56);
                }
                return charSequence;
            }
            throw new IllegalArgumentException("Attempt to load text for binary file which doesn't have a decompiler plugged in: " + file.getPresentableUrl() + ". File type: " + type.getName());
        }
        return LoadTextUtil.loadText(file, -1);
    }

    @NotNull
    public static CharSequence loadText(@NotNull VirtualFile file, int limit) {
        FileType type;
        if (file == null) {
            LoadTextUtil.$$$reportNull$$$0(57);
        }
        if ((type = file.getFileType()).isBinary()) {
            throw new IllegalArgumentException("Attempt to load truncated text for binary file: " + file.getPresentableUrl() + ". File type: " + type.getName());
        }
        if (file instanceof LightVirtualFile) {
            return LoadTextUtil.limitCharSequence(((LightVirtualFile)file).getContent(), limit);
        }
        if (file.isDirectory()) {
            throw new AssertionError((Object)("'" + file.getPresentableUrl() + "' is a directory"));
        }
        try {
            byte[] bytes = limit == -1 ? file.contentsToByteArray() : VfsUtilCore.loadNBytes(file, limit);
            return LoadTextUtil.getTextByBinaryPresentation(bytes, file);
        }
        catch (IOException e2) {
            LOG.debug(e2);
            CharSequence charSequence = Strings.EMPTY_CHAR_SEQUENCE;
            if (charSequence == null) {
                LoadTextUtil.$$$reportNull$$$0(58);
            }
            return charSequence;
        }
    }

    @NotNull
    private static CharSequence limitCharSequence(@NotNull CharSequence sequence2, int limit) {
        if (sequence2 == null) {
            LoadTextUtil.$$$reportNull$$$0(59);
        }
        CharSequence charSequence = limit == -1 ? sequence2 : sequence2.subSequence(0, Math.min(limit, sequence2.length()));
        if (charSequence == null) {
            LoadTextUtil.$$$reportNull$$$0(60);
        }
        return charSequence;
    }

    @NotNull
    public static CharSequence getTextByBinaryPresentation(byte @NotNull [] bytes, @NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            LoadTextUtil.$$$reportNull$$$0(61);
        }
        if (bytes == null) {
            LoadTextUtil.$$$reportNull$$$0(62);
        }
        return LoadTextUtil.getTextByBinaryPresentation(bytes, virtualFile, true, true);
    }

    @NotNull
    public static CharSequence getTextByBinaryPresentation(byte @NotNull [] bytes, @NotNull VirtualFile virtualFile, boolean saveDetectedSeparators, boolean saveBOM) {
        if (virtualFile == null) {
            LoadTextUtil.$$$reportNull$$$0(63);
        }
        if (bytes == null) {
            LoadTextUtil.$$$reportNull$$$0(64);
        }
        DetectResult info = LoadTextUtil.detectInternalCharsetAndSetBOM(virtualFile, bytes, bytes.length, saveBOM, virtualFile.getFileType());
        ConvertResult result2 = LoadTextUtil.convertBytesAndSetSeparator(bytes, bytes.length, virtualFile, saveDetectedSeparators, info, info.hardCodedCharset);
        CharSequence charSequence = result2.text;
        if (charSequence == null) {
            LoadTextUtil.$$$reportNull$$$0(65);
        }
        return charSequence;
    }

    @NotNull
    private static ConvertResult convertBytesAndSetSeparator(byte @NotNull [] bytes, int length, @NotNull VirtualFile virtualFile, boolean saveDetectedSeparators, @NotNull DetectResult info, @NotNull Charset internalCharset) {
        String separator;
        byte[] bom;
        if (virtualFile == null) {
            LoadTextUtil.$$$reportNull$$$0(74);
        }
        if (info == null) {
            LoadTextUtil.$$$reportNull$$$0(75);
        }
        if (internalCharset == null) {
            LoadTextUtil.$$$reportNull$$$0(76);
        }
        if (bytes == null) {
            LoadTextUtil.$$$reportNull$$$0(77);
        }
        int BOMEndOffset = Math.min(length, (bom = info.BOM) == null ? 0 : bom.length);
        ConvertResult result2 = LoadTextUtil.convertBytes(bytes, BOMEndOffset, length, internalCharset);
        if (saveDetectedSeparators && (separator = result2.majorLineSeparator()) != null) {
            virtualFile.setDetectedLineSeparator(separator);
        }
        ConvertResult convertResult = result2;
        if (convertResult == null) {
            LoadTextUtil.$$$reportNull$$$0(78);
        }
        return convertResult;
    }

    @NotNull
    private static ConvertResult convertBytes(byte @NotNull [] bytes, int startOffset, int endOffset, @NotNull Charset internalCharset) {
        CharBuffer charBuffer;
        if (internalCharset == null) {
            LoadTextUtil.$$$reportNull$$$0(83);
        }
        if (bytes == null) {
            LoadTextUtil.$$$reportNull$$$0(84);
        }
        assert (startOffset >= 0 && startOffset <= endOffset && endOffset <= bytes.length) : startOffset + "," + endOffset + ": " + bytes.length;
        if (internalCharset instanceof SevenBitCharset || internalCharset == StandardCharsets.US_ASCII) {
            return LoadTextUtil.convertLineSeparatorsToSlashN(bytes, startOffset, endOffset);
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes, startOffset, endOffset - startOffset);
        try {
            charBuffer = internalCharset.decode(byteBuffer);
        }
        catch (Exception e2) {
            charBuffer = CharBuffer.wrap(ArrayUtilRt.EMPTY_CHAR_ARRAY);
        }
        return LoadTextUtil.convertLineSeparatorsToSlashN(charBuffer);
    }

    private static void setCharsetAutoDetectionReason(@NotNull VirtualFile virtualFile, @Nullable(value="null if was not detected, otherwise the reason it was") @Nullable(value="null if was not detected, otherwise the reason it was") AutoDetectionReason reason) {
        if (virtualFile == null) {
            LoadTextUtil.$$$reportNull$$$0(86);
        }
        virtualFile.putUserData(CHARSET_WAS_DETECTED_FROM_BYTES, reason);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 12: 
            case 20: 
            case 25: 
            case 26: 
            case 27: 
            case 37: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 52: 
            case 56: 
            case 58: 
            case 60: 
            case 65: 
            case 67: 
            case 68: 
            case 73: 
            case 78: 
            case 82: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 10: 
            case 12: 
            case 20: 
            case 25: 
            case 26: 
            case 27: 
            case 37: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 52: 
            case 56: 
            case 58: 
            case 60: 
            case 65: 
            case 67: 
            case 68: 
            case 73: 
            case 78: 
            case 82: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charsAsBytes";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ints";
                break;
            }
            case 4: 
            case 7: 
            case 11: 
            case 16: 
            case 18: 
            case 31: 
            case 34: 
            case 38: 
            case 50: 
            case 53: 
            case 61: 
            case 63: 
            case 66: 
            case 70: 
            case 74: 
            case 85: 
            case 86: 
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 5: 
            case 8: 
            case 14: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 6: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "internalBuffer";
                break;
            }
            case 9: 
            case 17: 
            case 19: 
            case 22: 
            case 24: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 10: 
            case 12: 
            case 20: 
            case 25: 
            case 26: 
            case 27: 
            case 37: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 52: 
            case 56: 
            case 58: 
            case 60: 
            case 65: 
            case 67: 
            case 68: 
            case 73: 
            case 78: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/openapi/fileEditor/impl/LoadTextUtil";
                break;
            }
            case 13: 
            case 28: 
            case 55: 
            case 57: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultCharset";
                break;
            }
            case 23: 
            case 48: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charset";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSeparator";
                break;
            }
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestor";
                break;
            }
            case 33: 
            case 35: 
            case 42: 
            case 51: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 36: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existing";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "specified";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 62: 
            case 64: 
            case 69: 
            case 77: 
            case 81: 
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bytes";
                break;
            }
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileTextProcessor";
                break;
            }
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 76: 
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "internalCharset";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/fileEditor/impl/LoadTextUtil";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "detectCharsetAndSetBOM";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultCharsetFromEncodingManager";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "guessFromContent";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getOverriddenCharsetByBOM";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "charsetForWriting";
                break;
            }
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "chooseMostlyHarmlessCharset";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "extractCharsetFromFileContent";
                break;
            }
            case 56: 
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "loadText";
                break;
            }
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "limitCharSequence";
                break;
            }
            case 65: 
            case 82: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextByBinaryPresentation";
                break;
            }
            case 67: 
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "detectAllLineSeparators";
                break;
            }
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "processTextFromBinaryPresentationOrNull";
                break;
            }
            case 78: {
                objectArray = objectArray2;
                objectArray2[1] = "convertBytesAndSetSeparator";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "convertLineSeparatorsToSlashN";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "convertWideCharacters";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findLineBreakOrWideChar";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "detectHardCharset";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "detectCharsetAndSetBOM";
                break;
            }
            case 10: 
            case 12: 
            case 20: 
            case 25: 
            case 26: 
            case 27: 
            case 37: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 52: 
            case 56: 
            case 58: 
            case 60: 
            case 65: 
            case 67: 
            case 68: 
            case 73: 
            case 78: 
            case 82: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultCharsetFromEncodingManager";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "detectInternalCharsetAndSetBOM";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "guessFromContent";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "guessFromBytes";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getOverriddenCharsetByBOM";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "changeLineSeparators";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "write";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "charsetForWriting";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "restoreDetectedFromContentFlag";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "chooseMostlyHarmlessCharset";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "isSupported";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "extractCharsetFromFileContent";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "charsetFromContentOrNull";
                break;
            }
            case 55: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "loadText";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "limitCharSequence";
                break;
            }
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 80: 
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "getTextByBinaryPresentation";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "detectAllLineSeparators";
                break;
            }
            case 69: 
            case 70: 
            case 71: 
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "processTextFromBinaryPresentationOrNull";
                break;
            }
            case 74: 
            case 75: 
            case 76: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "convertBytesAndSetSeparator";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "detectLineSeparator";
                break;
            }
            case 83: 
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "convertBytes";
                break;
            }
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "getCharsetAutoDetectionReason";
                break;
            }
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "setCharsetAutoDetectionReason";
                break;
            }
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "clearCharsetAutoDetectionReason";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 12: 
            case 20: 
            case 25: 
            case 26: 
            case 27: 
            case 37: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 52: 
            case 56: 
            case 58: 
            case 60: 
            case 65: 
            case 67: 
            case 68: 
            case 73: 
            case 78: 
            case 82: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ConvertResult {
        @NotNull
        private final CharSequence text;
        private final int CR_count;
        private final int LF_count;
        private final int CRLF_count;

        ConvertResult(@NotNull CharSequence text, int CR_count, int LF_count, int CRLF_count) {
            if (text == null) {
                ConvertResult.$$$reportNull$$$0(0);
            }
            this.text = text;
            this.CR_count = CR_count;
            this.LF_count = LF_count;
            this.CRLF_count = CRLF_count;
        }

        String majorLineSeparator() {
            String detectedLineSeparator = null;
            if (this.CRLF_count > this.CR_count && this.CRLF_count > this.LF_count) {
                detectedLineSeparator = "\r\n";
            } else if (this.CR_count > this.LF_count) {
                detectedLineSeparator = "\r";
            } else if (this.LF_count > 0) {
                detectedLineSeparator = "\n";
            }
            return detectedLineSeparator;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 1: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/com/intellij/openapi/fileEditor/impl/LoadTextUtil$ConvertResult";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/fileEditor/impl/LoadTextUtil$ConvertResult";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "allLineSeparators";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class DetectResult {
        public final Charset hardCodedCharset;
        public final CharsetToolkit.GuessedEncoding guessed;
        public final byte @Nullable [] BOM;

        DetectResult(Charset hardCodedCharset, CharsetToolkit.GuessedEncoding guessed, byte @Nullable [] BOM) {
            this.hardCodedCharset = hardCodedCharset;
            this.guessed = guessed;
            this.BOM = BOM;
        }
    }

    private static class SevenBitCharset
    extends Charset {
        private final Charset myBaseCharset;

        SevenBitCharset(@NotNull Charset baseCharset) {
            if (baseCharset == null) {
                SevenBitCharset.$$$reportNull$$$0(0);
            }
            super("IJ__7BIT_" + baseCharset.name(), ArrayUtilRt.EMPTY_STRING_ARRAY);
            this.myBaseCharset = baseCharset;
        }

        @Override
        public boolean contains(Charset cs) {
            throw new IllegalStateException();
        }

        @Override
        public CharsetDecoder newDecoder() {
            throw new IllegalStateException();
        }

        @Override
        public CharsetEncoder newEncoder() {
            throw new IllegalStateException();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseCharset", "org/jetbrains/kotlin/com/intellij/openapi/fileEditor/impl/LoadTextUtil$SevenBitCharset", "<init>"));
        }
    }

    public static enum AutoDetectionReason {
        FROM_BOM,
        FROM_BYTES;

    }
}

