/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.reflect;

import java.io.IOException;
import java.net.URLClassLoader;
import java.util.Set;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import org.gradle.api.internal.tasks.compile.filter.AnnotationProcessorFilter;
import org.gradle.internal.classpath.ClassPath;

public class GradleStandardJavaFileManager
extends ForwardingJavaFileManager<StandardJavaFileManager> {
    private final ClassPath annotationProcessorPath;
    private final boolean hasEmptySourcePaths;

    private GradleStandardJavaFileManager(StandardJavaFileManager fileManager, ClassPath annotationProcessorPath, boolean hasEmptySourcePaths) {
        super(fileManager);
        this.annotationProcessorPath = annotationProcessorPath;
        this.hasEmptySourcePaths = hasEmptySourcePaths;
    }

    public static JavaFileManager wrap(StandardJavaFileManager delegate, ClassPath annotationProcessorPath, boolean hasEmptySourcePaths) {
        return new GradleStandardJavaFileManager(delegate, annotationProcessorPath, hasEmptySourcePaths);
    }

    @Override
    public boolean hasLocation(JavaFileManager.Location location) {
        if (this.hasEmptySourcePaths && location.equals(StandardLocation.SOURCE_PATH)) {
            return false;
        }
        return super.hasLocation(location);
    }

    @Override
    public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
        if (this.hasEmptySourcePaths && location.equals(StandardLocation.CLASS_PATH)) {
            kinds.remove((Object)JavaFileObject.Kind.SOURCE);
        }
        return super.list(location, packageName, kinds, recurse);
    }

    @Override
    public ClassLoader getClassLoader(JavaFileManager.Location location) {
        ClassLoader classLoader = super.getClassLoader(location);
        if (location.equals(StandardLocation.ANNOTATION_PROCESSOR_PATH) && classLoader instanceof URLClassLoader) {
            return new URLClassLoader(this.annotationProcessorPath.getAsURLArray(), (ClassLoader)AnnotationProcessorFilter.getFilteredClassLoader(classLoader.getParent()));
        }
        return classLoader;
    }
}

