/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.nativeintegration.filesystem.services;

import java.io.File;
import java.io.IOException;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.file.FileMetadata;
import org.gradle.internal.file.FileMetadataAccessor;
import org.gradle.internal.file.impl.DefaultFileMetadata;

public class FallbackFileMetadataAccessor
implements FileMetadataAccessor {
    public FileMetadata stat(File f) {
        if (!f.exists()) {
            return DefaultFileMetadata.missing((FileMetadata.AccessType)FileMetadata.AccessType.DIRECT);
        }
        if (f.isDirectory()) {
            return DefaultFileMetadata.directory((FileMetadata.AccessType)FileMetadata.AccessType.DIRECT);
        }
        if (f.isFile()) {
            return DefaultFileMetadata.file((long)f.lastModified(), (long)f.length(), (FileMetadata.AccessType)FileMetadata.AccessType.DIRECT);
        }
        throw UncheckedException.throwAsUncheckedException((Throwable)new IOException("Unsupported file type for " + f.getAbsolutePath()), (boolean)true);
    }
}

