/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.ide.xcode.internal.xcodeproj;

import com.google.common.base.Optional;
import com.google.common.io.Files;
import org.gradle.ide.xcode.internal.xcodeproj.FileTypes;
import org.gradle.ide.xcode.internal.xcodeproj.PBXReference;
import org.gradle.ide.xcode.internal.xcodeproj.XcodeprojSerializer;

public class PBXFileReference
extends PBXReference {
    private Optional<String> explicitFileType;
    private Optional<String> lastKnownFileType;

    public PBXFileReference(String name, String path, PBXReference.SourceTree sourceTree) {
        super(name, path, sourceTree);
        String fileType = (String)FileTypes.FILE_EXTENSION_TO_UTI.get((Object)Files.getFileExtension((String)name));
        this.explicitFileType = Optional.fromNullable((Object)fileType);
        this.lastKnownFileType = Optional.absent();
    }

    public Optional<String> getExplicitFileType() {
        return this.explicitFileType;
    }

    public void setExplicitFileType(Optional<String> explicitFileType) {
        this.explicitFileType = explicitFileType;
    }

    @Override
    public String isa() {
        return "PBXFileReference";
    }

    @Override
    public void serializeInto(XcodeprojSerializer s) {
        super.serializeInto(s);
        if (this.explicitFileType.isPresent()) {
            s.addField("explicitFileType", (String)this.explicitFileType.get());
        }
        if (this.lastKnownFileType.isPresent()) {
            s.addField("lastKnownFileType", (String)this.lastKnownFileType.get());
        }
    }

    @Override
    public String toString() {
        return String.format("%s explicitFileType=%s", super.toString(), this.getExplicitFileType());
    }
}

