/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.ide.visualstudio.internal;

import java.io.File;
import java.util.List;
import java.util.Set;
import org.gradle.api.Buildable;
import org.gradle.api.Task;
import org.gradle.api.internal.tasks.TaskDependencyUtil;
import org.gradle.ide.visualstudio.internal.DefaultVisualStudioProject;
import org.gradle.ide.visualstudio.internal.VisualStudioProjectConfigurationMetadata;
import org.gradle.internal.Describables;
import org.gradle.internal.DisplayName;
import org.gradle.plugins.ide.internal.IdeProjectMetadata;
import org.gradle.util.internal.CollectionUtils;

public class VisualStudioProjectMetadata
implements IdeProjectMetadata {
    private final DefaultVisualStudioProject project;

    public VisualStudioProjectMetadata(DefaultVisualStudioProject project) {
        this.project = project;
    }

    public DisplayName getDisplayName() {
        return Describables.withTypeAndName((Object)"Visual Studio project", (String)this.project.getName());
    }

    public String getName() {
        return this.project.getName();
    }

    public File getFile() {
        return this.project.getProjectFile().getLocation();
    }

    public Set<? extends Task> getGeneratorTasks() {
        return TaskDependencyUtil.getDependenciesForInternalUse((Buildable)this.project);
    }

    public List<VisualStudioProjectConfigurationMetadata> getConfigurations() {
        return CollectionUtils.collect(this.project.getConfigurations(), configuration -> new VisualStudioProjectConfigurationMetadata(configuration.getName(), configuration.isBuildable()));
    }
}

