/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts;

import java.util.Collection;
import java.util.stream.Collectors;
import org.gradle.api.Action;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ComponentState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ModuleResolveState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.NodeState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.ConflictResolutionResult;

class DefaultConflictResolutionResult
implements ConflictResolutionResult {
    private final Collection<? extends ModuleIdentifier> participatingModules;
    private final ComponentState selected;

    private static ComponentState findComponent(Object selected) {
        if (selected instanceof ComponentState) {
            return (ComponentState)selected;
        }
        if (selected instanceof NodeState) {
            return ((NodeState)selected).getComponent();
        }
        throw new IllegalArgumentException("Cannot extract a ComponentState from " + selected.getClass());
    }

    public DefaultConflictResolutionResult(Collection<? extends ModuleIdentifier> participatingModules, Object selected) {
        this.selected = DefaultConflictResolutionResult.findComponent(selected);
        this.participatingModules = participatingModules.stream().sorted((first, second) -> {
            if (this.selected.getId().getModule().equals(first)) {
                return -1;
            }
            if (this.selected.getId().getModule().equals(second)) {
                return 1;
            }
            return 0;
        }).collect(Collectors.toList());
    }

    @Override
    public void withParticipatingModules(Action<? super ModuleIdentifier> action, ConflictResolutionResult result) {
        ModuleResolveState winningModule = result.getSelected().getModule();
        action.execute((Object)winningModule.getId());
        for (ModuleIdentifier moduleIdentifier : this.participatingModules) {
            if (moduleIdentifier.equals(winningModule.getId())) continue;
            action.execute((Object)moduleIdentifier);
        }
    }

    @Override
    public ComponentState getSelected() {
        return this.selected;
    }
}

