/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ear;

import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.attributes.HasConfigurableAttributes;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.artifacts.configurations.RoleBasedConfigurationContainerInternal;
import org.gradle.api.internal.artifacts.dsl.LazyPublishArtifact;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.TaskDependencyFactory;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.plugins.internal.JavaPluginHelper;
import org.gradle.api.plugins.jvm.internal.JvmFeatureInternal;
import org.gradle.api.plugins.jvm.internal.JvmPluginServices;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.jvm.component.internal.JvmSoftwareComponentInternal;
import org.gradle.plugins.ear.Ear;
import org.gradle.plugins.ear.descriptor.DeploymentDescriptor;
import org.gradle.plugins.ear.descriptor.internal.DefaultDeploymentDescriptor;

public abstract class EarPlugin
implements Plugin<Project> {
    public static final String EAR_TASK_NAME = "ear";
    public static final String DEPLOY_CONFIGURATION_NAME = "deploy";
    public static final String EARLIB_CONFIGURATION_NAME = "earlib";
    static final String DEFAULT_LIB_DIR_NAME = "lib";
    private final ObjectFactory objectFactory;
    private final JvmPluginServices jvmPluginServices;
    private final TaskDependencyFactory taskDependencyFactory;

    @Inject
    public EarPlugin(ObjectFactory objectFactory, JvmPluginServices jvmPluginServices, TaskDependencyFactory taskDependencyFactory) {
        this.objectFactory = objectFactory;
        this.jvmPluginServices = jvmPluginServices;
        this.taskDependencyFactory = taskDependencyFactory;
    }

    public void apply(Project project) {
        project.getPluginManager().apply(JavaBasePlugin.class);
        this.configureConfigurations((ProjectInternal)project);
        PluginContainer plugins = project.getPlugins();
        this.setupEarTask(project, plugins);
        this.wireEarTaskConventions(project);
        this.wireEarTaskConventionsWithJavaPluginApplied(project, plugins);
    }

    private void wireEarTaskConventionsWithJavaPluginApplied(Project project, PluginContainer plugins) {
        plugins.withType(JavaPlugin.class, javaPlugin -> {
            JvmFeatureInternal mainFeature = JavaPluginHelper.getJavaComponent((Project)project).getMainFeature();
            project.getTasks().withType(Ear.class).configureEach(task -> {
                task.dependsOn(new Object[]{() -> mainFeature.getSourceSet().getRuntimeClasspath()});
                task.from(new Object[]{() -> mainFeature.getSourceSet().getOutput()});
            });
        });
    }

    private void setupEarTask(Project project, PluginContainer plugins) {
        TaskProvider ear = project.getTasks().register(EAR_TASK_NAME, Ear.class, task -> {
            task.setDescription("Generates a ear archive with all the modules, the application descriptor and the libraries.");
            task.setGroup("build");
            task.getGenerateDeploymentDescriptor().convention((Object)true);
            plugins.withType(JavaPlugin.class, javaPlugin -> {
                JvmSoftwareComponentInternal component = JavaPluginHelper.getJavaComponent((Project)project);
                component.getMainFeature().getSourceSet().getResources().srcDir((Object)task.getAppDirectory());
            });
            DeploymentDescriptor deploymentDescriptor = (DeploymentDescriptor)this.objectFactory.newInstance(DefaultDeploymentDescriptor.class, new Object[0]);
            deploymentDescriptor.readFrom("META-INF/application.xml");
            deploymentDescriptor.readFrom("src/main/application/META-INF/" + deploymentDescriptor.getFileName());
            if (deploymentDescriptor != null) {
                if (deploymentDescriptor.getDisplayName() == null) {
                    deploymentDescriptor.setDisplayName(project.getName());
                }
                if (deploymentDescriptor.getDescription() == null) {
                    deploymentDescriptor.setDescription(project.getDescription());
                }
            }
            task.setDeploymentDescriptor(deploymentDescriptor);
        });
        project.getConfigurations().getByName("archives").getArtifacts().add((Object)new LazyPublishArtifact((Provider)ear, ((ProjectInternal)project).getFileResolver(), this.taskDependencyFactory));
    }

    private void wireEarTaskConventions(Project project) {
        project.getTasks().withType(Ear.class).configureEach(task -> {
            task.getAppDirectory().convention(project.provider(() -> project.getLayout().getProjectDirectory().dir("src/main/application")));
            task.getConventionMapping().map("libDirName", (Callable)new Callable<String>(){

                @Override
                public String call() throws Exception {
                    return EarPlugin.DEFAULT_LIB_DIR_NAME;
                }
            });
            task.getConventionMapping().map("deploymentDescriptor", (Callable)new Callable<DeploymentDescriptor>(){

                @Override
                public DeploymentDescriptor call() throws Exception {
                    DeploymentDescriptor deploymentDescriptor = (DeploymentDescriptor)EarPlugin.this.objectFactory.newInstance(DefaultDeploymentDescriptor.class, new Object[0]);
                    deploymentDescriptor.readFrom("META-INF/application.xml");
                    deploymentDescriptor.readFrom("src/main/application/META-INF/" + deploymentDescriptor.getFileName());
                    return deploymentDescriptor;
                }
            });
            task.from(new Object[]{() -> {
                if (project.getPlugins().hasPlugin(JavaPlugin.class)) {
                    return null;
                }
                return task.getAppDirectory().getAsFileTree();
            }});
            task.getLib().from(new Object[]{() -> project.getConfigurations().getByName(EARLIB_CONFIGURATION_NAME).minus((FileCollection)project.getConfigurations().getByName(DEPLOY_CONFIGURATION_NAME))});
            task.from(new Object[]{() -> project.getConfigurations().getByName(DEPLOY_CONFIGURATION_NAME)});
        });
    }

    private void configureConfigurations(ProjectInternal project) {
        RoleBasedConfigurationContainerInternal configurations = project.getConfigurations();
        Configuration deployConfiguration = configurations.resolvableDependencyScopeLocked(DEPLOY_CONFIGURATION_NAME, conf -> {
            conf.setTransitive(false);
            conf.setDescription("Classpath for deployable modules, not transitive.");
            this.jvmPluginServices.configureAsRuntimeClasspath((HasConfigurableAttributes)conf);
        });
        Configuration earlibConfiguration = configurations.resolvableDependencyScopeLocked(EARLIB_CONFIGURATION_NAME, conf -> {
            conf.setDescription("Classpath for module dependencies.");
            this.jvmPluginServices.configureAsRuntimeClasspath((HasConfigurableAttributes)conf);
        });
        configurations.getByName("default").extendsFrom(new Configuration[]{deployConfiguration, earlibConfiguration});
    }
}

