/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.local.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Objects;
import org.gradle.api.artifacts.capability.CapabilitySelector;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentSelector;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.artifacts.DefaultProjectComponentIdentifier;
import org.gradle.api.internal.artifacts.ProjectComponentIdentifierInternal;
import org.gradle.api.internal.artifacts.capability.DefaultSpecificCapabilitySelector;
import org.gradle.api.internal.artifacts.capability.SpecificCapabilitySelector;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.project.ProjectIdentity;
import org.gradle.internal.component.local.model.ProjectComponentSelectorInternal;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.util.Path;

public class DefaultProjectComponentSelector
implements ProjectComponentSelectorInternal {
    private final ProjectIdentity projectIdentity;
    private final ImmutableAttributes attributes;
    private final ImmutableSet<CapabilitySelector> capabilitySelectors;

    public DefaultProjectComponentSelector(ProjectIdentity projectIdentity, ImmutableAttributes attributes, ImmutableSet<CapabilitySelector> capabilitySelectors) {
        this.projectIdentity = projectIdentity;
        this.attributes = attributes;
        this.capabilitySelectors = capabilitySelectors;
    }

    @Override
    public ProjectIdentity getProjectIdentity() {
        return this.projectIdentity;
    }

    public String getDisplayName() {
        return this.projectIdentity.getDisplayName();
    }

    public String getBuildPath() {
        return this.projectIdentity.getBuildIdentifier().getBuildPath();
    }

    public String getBuildName() {
        ((DeprecationMessageBuilder.WithDocumentation)((DeprecationMessageBuilder.DeprecateMethod)DeprecationLogger.deprecateMethod(ProjectComponentSelector.class, (String)"getBuildName()").withAdvice("Use getBuildPath() to get a unique identifier for the build.")).willBeRemovedInGradle9().withUpgradeGuideSection(8, "build_identifier_name_and_current_deprecation")).nagUser();
        return (String)DeprecationLogger.whileDisabled(() -> this.projectIdentity.getBuildIdentifier().getName());
    }

    @Override
    public Path getIdentityPath() {
        return this.projectIdentity.getBuildTreePath();
    }

    public String getProjectPath() {
        return this.projectIdentity.getProjectPath().getPath();
    }

    public boolean matchesStrictly(ComponentIdentifier identifier) {
        assert (identifier != null) : "identifier cannot be null";
        if (identifier instanceof ProjectComponentIdentifier) {
            ProjectComponentIdentifierInternal projectComponentIdentifier = (ProjectComponentIdentifierInternal)identifier;
            return projectComponentIdentifier.getProjectIdentity().equals((Object)this.projectIdentity);
        }
        return false;
    }

    @Override
    public ImmutableAttributes getAttributes() {
        return this.attributes;
    }

    public List<Capability> getRequestedCapabilities() {
        return (List)this.capabilitySelectors.stream().filter(c -> c instanceof SpecificCapabilitySelector).map(c -> ((DefaultSpecificCapabilitySelector)c).getBackingCapability()).collect(ImmutableList.toImmutableList());
    }

    @Override
    public ImmutableSet<CapabilitySelector> getCapabilitySelectors() {
        return this.capabilitySelectors;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultProjectComponentSelector)) {
            return false;
        }
        DefaultProjectComponentSelector that = (DefaultProjectComponentSelector)o;
        if (!this.projectIdentity.equals((Object)that.projectIdentity)) {
            return false;
        }
        if (!this.attributes.equals(that.attributes)) {
            return false;
        }
        return this.capabilitySelectors.equals(that.capabilitySelectors);
    }

    public int hashCode() {
        return Objects.hash(this.projectIdentity, this.attributes, this.capabilitySelectors);
    }

    public String toString() {
        return this.getDisplayName();
    }

    public static ProjectComponentSelector withAttributes(ProjectComponentSelector selector, ImmutableAttributes attributes) {
        ProjectComponentSelectorInternal current = (ProjectComponentSelectorInternal)selector;
        return new DefaultProjectComponentSelector(current.getProjectIdentity(), attributes, current.getCapabilitySelectors());
    }

    public static ProjectComponentSelector withCapabilities(ProjectComponentSelector selector, ImmutableSet<CapabilitySelector> capabilitySelectors) {
        ProjectComponentSelectorInternal current = (ProjectComponentSelectorInternal)selector;
        return new DefaultProjectComponentSelector(current.getProjectIdentity(), current.getAttributes(), capabilitySelectors);
    }

    public static ProjectComponentSelector withAttributesAndCapabilities(ProjectComponentSelector selector, ImmutableAttributes attributes, ImmutableSet<CapabilitySelector> capabilitySelectors) {
        ProjectComponentSelectorInternal current = (ProjectComponentSelectorInternal)selector;
        return new DefaultProjectComponentSelector(current.getProjectIdentity(), attributes, capabilitySelectors);
    }

    public ProjectComponentIdentifier toIdentifier() {
        return new DefaultProjectComponentIdentifier(this.projectIdentity);
    }
}

