/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.configurations;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import groovy.lang.Closure;
import java.io.File;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import org.apache.commons.lang.WordUtils;
import org.gradle.api.Action;
import org.gradle.api.Describable;
import org.gradle.api.DomainObjectCollection;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.GradleException;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Named;
import org.gradle.api.artifacts.ArtifactCollection;
import org.gradle.api.artifacts.ArtifactView;
import org.gradle.api.artifacts.ConfigurablePublishArtifact;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationPublications;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencyConstraint;
import org.gradle.api.artifacts.DependencyConstraintSet;
import org.gradle.api.artifacts.DependencyResolutionListener;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.ExcludeRule;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.artifacts.PublishArtifactSet;
import org.gradle.api.artifacts.ResolutionStrategy;
import org.gradle.api.artifacts.ResolvableDependencies;
import org.gradle.api.artifacts.ResolvedConfiguration;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.result.DependencyResult;
import org.gradle.api.artifacts.result.ResolutionResult;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.CompositeDomainObjectSet;
import org.gradle.api.internal.DefaultDomainObjectSet;
import org.gradle.api.internal.DomainObjectContext;
import org.gradle.api.internal.artifacts.ConfigurationResolver;
import org.gradle.api.internal.artifacts.DefaultDependencyConstraintSet;
import org.gradle.api.internal.artifacts.DefaultDependencySet;
import org.gradle.api.internal.artifacts.DefaultExcludeRule;
import org.gradle.api.internal.artifacts.DefaultPublishArtifactSet;
import org.gradle.api.internal.artifacts.ExcludeRuleNotationConverter;
import org.gradle.api.internal.artifacts.ResolveExceptionMapper;
import org.gradle.api.internal.artifacts.ResolverResults;
import org.gradle.api.internal.artifacts.configurations.ConfigurationInternal;
import org.gradle.api.internal.artifacts.configurations.ConfigurationRole;
import org.gradle.api.internal.artifacts.configurations.ConfigurationRoles;
import org.gradle.api.internal.artifacts.configurations.ConfigurationRolesForMigration;
import org.gradle.api.internal.artifacts.configurations.Configurations;
import org.gradle.api.internal.artifacts.configurations.ConfigurationsProvider;
import org.gradle.api.internal.artifacts.configurations.DefaultConfigurationFactory;
import org.gradle.api.internal.artifacts.configurations.DefaultConfigurationPublications;
import org.gradle.api.internal.artifacts.configurations.DefaultUnlockedConfiguration;
import org.gradle.api.internal.artifacts.configurations.DetachedConfigurationsProvider;
import org.gradle.api.internal.artifacts.configurations.MutationValidator;
import org.gradle.api.internal.artifacts.configurations.PublishArtifactSetProvider;
import org.gradle.api.internal.artifacts.configurations.ResolutionBackedFileCollection;
import org.gradle.api.internal.artifacts.configurations.ResolutionHost;
import org.gradle.api.internal.artifacts.configurations.ResolutionResultProvider;
import org.gradle.api.internal.artifacts.configurations.ResolutionResultProviderBackedSelectedArtifactSet;
import org.gradle.api.internal.artifacts.configurations.ResolutionStrategyInternal;
import org.gradle.api.internal.artifacts.configurations.ResolvableDependenciesInternal;
import org.gradle.api.internal.artifacts.configurations.ResolveConfigurationResolutionBuildOperationDetails;
import org.gradle.api.internal.artifacts.configurations.ResolveConfigurationResolutionBuildOperationResult;
import org.gradle.api.internal.artifacts.configurations.TasksFromDependentProjects;
import org.gradle.api.internal.artifacts.configurations.TasksFromProjectDependencies;
import org.gradle.api.internal.artifacts.configurations.UsageDescriber;
import org.gradle.api.internal.artifacts.dependencies.DependencyConstraintInternal;
import org.gradle.api.internal.artifacts.ivyservice.ResolutionParameters;
import org.gradle.api.internal.artifacts.ivyservice.TypedResolveException;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.RootComponentMetadataBuilder;
import org.gradle.api.internal.artifacts.resolver.DefaultResolutionOutputs;
import org.gradle.api.internal.artifacts.resolver.ResolutionAccess;
import org.gradle.api.internal.artifacts.resolver.ResolutionOutputsInternal;
import org.gradle.api.internal.artifacts.result.DefaultResolutionResult;
import org.gradle.api.internal.artifacts.result.DefaultResolvedComponentResult;
import org.gradle.api.internal.artifacts.result.MinimalResolutionResult;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.AttributeDesugaring;
import org.gradle.api.internal.attributes.AttributesFactory;
import org.gradle.api.internal.attributes.FreezableAttributeContainer;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.collections.DomainObjectCollectionFactory;
import org.gradle.api.internal.file.AbstractFileCollection;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.file.FileCollectionStructureVisitor;
import org.gradle.api.internal.initialization.ResettableConfiguration;
import org.gradle.api.internal.project.ProjectIdentity;
import org.gradle.api.internal.project.ProjectStateRegistry;
import org.gradle.api.internal.tasks.TaskDependencyFactory;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.problems.internal.InternalProblems;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.internal.Actions;
import org.gradle.internal.Cast;
import org.gradle.internal.Describables;
import org.gradle.internal.DisplayName;
import org.gradle.internal.Factories;
import org.gradle.internal.Factory;
import org.gradle.internal.ImmutableActionSet;
import org.gradle.internal.code.UserCodeApplicationContext;
import org.gradle.internal.deprecation.DeprecatableConfiguration;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.internal.event.ListenerBroadcast;
import org.gradle.internal.logging.text.TreeFormatter;
import org.gradle.internal.model.CalculatedModelValue;
import org.gradle.internal.model.CalculatedValue;
import org.gradle.internal.model.CalculatedValueContainer;
import org.gradle.internal.model.CalculatedValueContainerFactory;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationRunner;
import org.gradle.internal.operations.CallableBuildOperation;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.service.scopes.DetachedDependencyMetadataProvider;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.internal.work.WorkerThreadRegistry;
import org.gradle.operations.dependencies.configurations.ConfigurationIdentity;
import org.gradle.util.Path;
import org.gradle.util.internal.CollectionUtils;
import org.gradle.util.internal.ConfigureUtil;
import org.gradle.util.internal.WrapUtil;

public abstract class DefaultConfiguration
extends AbstractFileCollection
implements ConfigurationInternal,
MutationValidator,
ResettableConfiguration {
    private final ConfigurationResolver resolver;
    private final DefaultDependencySet dependencies;
    private final DefaultDependencyConstraintSet dependencyConstraints;
    private final DefaultDomainObjectSet<Dependency> ownDependencies;
    private final DefaultDomainObjectSet<DependencyConstraint> ownDependencyConstraints;
    private final CalculatedValueContainerFactory calculatedValueContainerFactory;
    private final ProjectStateRegistry projectStateRegistry;
    private CompositeDomainObjectSet<Dependency> inheritedDependencies;
    private CompositeDomainObjectSet<DependencyConstraint> inheritedDependencyConstraints;
    private DefaultDependencySet allDependencies;
    private DefaultDependencyConstraintSet allDependencyConstraints;
    private ImmutableActionSet<DependencySet> defaultDependencyActions = ImmutableActionSet.empty();
    private ImmutableActionSet<DependencySet> withDependencyActions = ImmutableActionSet.empty();
    private final DefaultPublishArtifactSet artifacts;
    private final DefaultDomainObjectSet<PublishArtifact> ownArtifacts;
    private CompositeDomainObjectSet<PublishArtifact> inheritedArtifacts;
    private DefaultPublishArtifactSet allArtifacts;
    private final ConfigurationResolvableDependencies resolvableDependencies;
    private ListenerBroadcast<DependencyResolutionListener> dependencyResolutionListeners;
    private final BuildOperationRunner buildOperationRunner;
    private final Instantiator instantiator;
    private Factory<ResolutionStrategyInternal> resolutionStrategyFactory;
    private ResolutionStrategyInternal resolutionStrategy;
    private final FileCollectionFactory fileCollectionFactory;
    private final ResolveExceptionMapper exceptionMapper;
    private final AttributeDesugaring attributeDesugaring;
    private final Set<MutationValidator> childMutationValidators = new HashSet<MutationValidator>();
    private final MutationValidator parentMutationValidator = this::validateParentMutation;
    private final RootComponentMetadataBuilder rootComponentMetadataBuilder;
    private final ConfigurationsProvider configurationsProvider;
    private final Path identityPath;
    private final Path projectPath;
    private final String name;
    private final DefaultConfigurationPublications outgoing;
    private boolean visible = true;
    private boolean transitive = true;
    private Set<Configuration> extendsFrom = new LinkedHashSet<Configuration>();
    private String description;
    private final Set<Object> excludeRules = new LinkedHashSet<Object>();
    private Set<ExcludeRule> parsedExcludeRules;
    private final Object observationLock = new Object();
    private volatile ConfigurationInternal.InternalState observedState = ConfigurationInternal.InternalState.UNRESOLVED;
    private boolean insideBeforeResolve;
    private boolean canBeConsumed;
    private boolean canBeResolved;
    private boolean canBeDeclaredAgainst;
    private final boolean consumptionDeprecated;
    private final boolean resolutionDeprecated;
    private final boolean declarationDeprecated;
    private boolean usageCanBeMutated = true;
    private final ConfigurationRole roleAtCreation;
    private Supplier<String> observationReason = null;
    private final FreezableAttributeContainer configurationAttributes;
    private final DomainObjectContext domainObjectContext;
    private final AttributesFactory attributesFactory;
    private final ResolutionAccess resolutionAccess;
    private FileCollectionInternal intrinsicFiles;
    private final DisplayName displayName;
    private final UserCodeApplicationContext userCodeApplicationContext;
    private final WorkerThreadRegistry workerThreadRegistry;
    private final DomainObjectCollectionFactory domainObjectCollectionFactory;
    private final AtomicInteger copyCount = new AtomicInteger();
    private List<String> declarationAlternatives = ImmutableList.of();
    private List<String> resolutionAlternatives = ImmutableList.of();
    private final CalculatedModelValue<Optional<ResolverResults>> currentResolveState;
    private ConfigurationInternal consistentResolutionSource;
    private String consistentResolutionReason;
    private final DefaultConfigurationFactory defaultConfigurationFactory;
    private final InternalProblems problemsService;

    public DefaultConfiguration(DomainObjectContext domainObjectContext, String name, ConfigurationsProvider configurationsProvider, ConfigurationResolver resolver, ListenerBroadcast<DependencyResolutionListener> dependencyResolutionListeners, Factory<ResolutionStrategyInternal> resolutionStrategyFactory, FileCollectionFactory fileCollectionFactory, BuildOperationRunner buildOperationRunner, Instantiator instantiator, NotationParser<Object, ConfigurablePublishArtifact> artifactNotationParser, NotationParser<Object, Capability> capabilityNotationParser, AttributesFactory attributesFactory, RootComponentMetadataBuilder rootComponentMetadataBuilder, ResolveExceptionMapper exceptionMapper, AttributeDesugaring attributeDesugaring, UserCodeApplicationContext userCodeApplicationContext, ProjectStateRegistry projectStateRegistry, WorkerThreadRegistry workerThreadRegistry, DomainObjectCollectionFactory domainObjectCollectionFactory, CalculatedValueContainerFactory calculatedValueContainerFactory, DefaultConfigurationFactory defaultConfigurationFactory, TaskDependencyFactory taskDependencyFactory, ConfigurationRole roleAtCreation, InternalProblems problemsService, boolean lockUsage) {
        super(taskDependencyFactory);
        this.userCodeApplicationContext = userCodeApplicationContext;
        this.projectStateRegistry = projectStateRegistry;
        this.workerThreadRegistry = workerThreadRegistry;
        this.domainObjectCollectionFactory = domainObjectCollectionFactory;
        this.calculatedValueContainerFactory = calculatedValueContainerFactory;
        this.identityPath = domainObjectContext.identityPath(name);
        this.projectPath = domainObjectContext.projectPath(name);
        this.name = name;
        this.configurationsProvider = configurationsProvider;
        this.resolver = resolver;
        this.resolutionStrategyFactory = resolutionStrategyFactory;
        this.fileCollectionFactory = fileCollectionFactory;
        this.dependencyResolutionListeners = dependencyResolutionListeners;
        this.buildOperationRunner = buildOperationRunner;
        this.instantiator = instantiator;
        this.attributesFactory = attributesFactory;
        this.domainObjectContext = domainObjectContext;
        this.exceptionMapper = exceptionMapper;
        this.attributeDesugaring = attributeDesugaring;
        this.displayName = Describables.memoize((Describable)new ConfigurationDescription(this.identityPath));
        this.configurationAttributes = new FreezableAttributeContainer(attributesFactory.mutable(), (Describable)this.displayName);
        this.resolutionAccess = new ConfigurationResolutionAccess();
        this.resolvableDependencies = (ConfigurationResolvableDependencies)instantiator.newInstance(ConfigurationResolvableDependencies.class, new Object[]{this});
        this.ownDependencies = (DefaultDomainObjectSet)domainObjectCollectionFactory.newDomainObjectSet(Dependency.class);
        this.ownDependencies.beforeCollectionChanges(DefaultConfiguration.validateMutationType(this, MutationValidator.MutationType.DEPENDENCIES));
        this.ownDependencyConstraints = (DefaultDomainObjectSet)domainObjectCollectionFactory.newDomainObjectSet(DependencyConstraint.class);
        this.ownDependencyConstraints.beforeCollectionChanges(DefaultConfiguration.validateMutationType(this, MutationValidator.MutationType.DEPENDENCIES));
        this.dependencies = new DefaultDependencySet((Describable)Describables.of((Object)this.displayName, (Object)"dependencies"), this, (DomainObjectSet<Dependency>)this.ownDependencies);
        this.dependencyConstraints = new DefaultDependencyConstraintSet((Describable)Describables.of((Object)this.displayName, (Object)"dependency constraints"), this, (DomainObjectSet<DependencyConstraint>)this.ownDependencyConstraints);
        this.ownArtifacts = (DefaultDomainObjectSet)domainObjectCollectionFactory.newDomainObjectSet(PublishArtifact.class);
        this.ownArtifacts.beforeCollectionChanges(DefaultConfiguration.validateMutationType(this, MutationValidator.MutationType.ARTIFACTS));
        this.artifacts = new DefaultPublishArtifactSet((Describable)Describables.of((Object)this.displayName, (Object)"artifacts"), (DomainObjectSet<PublishArtifact>)this.ownArtifacts, fileCollectionFactory, taskDependencyFactory);
        this.outgoing = (DefaultConfigurationPublications)instantiator.newInstance(DefaultConfigurationPublications.class, new Object[]{this.displayName, this.artifacts, new AllArtifactsProvider(), this.configurationAttributes, instantiator, artifactNotationParser, capabilityNotationParser, fileCollectionFactory, attributesFactory, domainObjectCollectionFactory, taskDependencyFactory});
        this.rootComponentMetadataBuilder = rootComponentMetadataBuilder;
        this.currentResolveState = domainObjectContext.getModel().newCalculatedValue(Optional.empty());
        this.defaultConfigurationFactory = defaultConfigurationFactory;
        this.problemsService = problemsService;
        this.canBeConsumed = roleAtCreation.isConsumable();
        this.canBeResolved = roleAtCreation.isResolvable();
        this.canBeDeclaredAgainst = roleAtCreation.isDeclarable();
        this.consumptionDeprecated = roleAtCreation.isConsumptionDeprecated();
        this.resolutionDeprecated = roleAtCreation.isResolutionDeprecated();
        this.declarationDeprecated = roleAtCreation.isDeclarationAgainstDeprecated();
        this.usageCanBeMutated = !lockUsage;
        this.roleAtCreation = roleAtCreation;
    }

    private static Action<String> validateMutationType(MutationValidator mutationValidator, MutationValidator.MutationType type) {
        return arg -> mutationValidator.validateMutation(type);
    }

    public String getName() {
        return this.name;
    }

    public Configuration.State getState() {
        Optional currentState = (Optional)this.currentResolveState.get();
        if (!currentState.isPresent()) {
            return Configuration.State.UNRESOLVED;
        }
        ResolverResults resolvedState = (ResolverResults)currentState.get();
        if (resolvedState.getVisitedGraph().hasAnyFailure()) {
            return Configuration.State.RESOLVED_WITH_FAILURES;
        }
        if (resolvedState.isFullyResolved()) {
            return Configuration.State.RESOLVED;
        }
        return Configuration.State.UNRESOLVED;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public Configuration setVisible(boolean visible) {
        this.validateMutation(MutationValidator.MutationType.DEPENDENCIES);
        this.visible = visible;
        return this;
    }

    public Set<Configuration> getExtendsFrom() {
        return Collections.unmodifiableSet(this.extendsFrom);
    }

    public Configuration setExtendsFrom(Iterable<Configuration> extendsFrom) {
        this.validateMutation(MutationValidator.MutationType.HIERARCHY);
        this.assertNotDetachedExtensionDoingExtending(extendsFrom);
        for (Configuration configuration : this.extendsFrom) {
            if (this.inheritedArtifacts != null) {
                this.inheritedArtifacts.removeCollection((DomainObjectCollection)configuration.getAllArtifacts());
            }
            if (this.inheritedDependencies != null) {
                this.inheritedDependencies.removeCollection((DomainObjectCollection)configuration.getAllDependencies());
            }
            if (this.inheritedDependencyConstraints != null) {
                this.inheritedDependencyConstraints.removeCollection((DomainObjectCollection)configuration.getAllDependencyConstraints());
            }
            ((ConfigurationInternal)configuration).removeMutationValidator(this.parentMutationValidator);
        }
        this.extendsFrom = new LinkedHashSet<Configuration>();
        for (Configuration configuration : extendsFrom) {
            this.extendsFrom(configuration);
        }
        return this;
    }

    public Configuration extendsFrom(Configuration ... extendsFrom) {
        this.validateMutation(MutationValidator.MutationType.HIERARCHY);
        this.assertNotDetachedExtensionDoingExtending(Arrays.asList(extendsFrom));
        for (Configuration extended : extendsFrom) {
            ConfigurationInternal other = Objects.requireNonNull((ConfigurationInternal)Cast.uncheckedCast((Object)extended));
            if (!this.domainObjectContext.equals(other.getDomainObjectContext())) {
                String message = String.format("Configuration '%s' in %s extends configuration '%s' in %s.", this.getName(), this.domainObjectContext.getDisplayName(), other.getName(), other.getDomainObjectContext().getDisplayName());
                ((DeprecationMessageBuilder.WithDocumentation)((DeprecationMessageBuilder.DeprecateBehaviour)DeprecationLogger.deprecateBehaviour((String)message).withAdvice("Configurations can only extend from configurations in the same project.")).willBeRemovedInGradle9().withUpgradeGuideSection(8, "extending_configurations_in_same_project")).nagUser();
            }
            if (other.getHierarchy().contains(this)) {
                throw new InvalidUserDataException(String.format("Cyclic extendsFrom from %s and %s is not allowed. See existing hierarchy: %s", this, other, other.getHierarchy()));
            }
            if (!this.extendsFrom.add(other)) continue;
            if (this.inheritedArtifacts != null) {
                this.inheritedArtifacts.addCollection((DomainObjectCollection)other.getAllArtifacts());
            }
            if (this.inheritedDependencies != null) {
                this.inheritedDependencies.addCollection((DomainObjectCollection)other.getAllDependencies());
            }
            if (this.inheritedDependencyConstraints != null) {
                this.inheritedDependencyConstraints.addCollection((DomainObjectCollection)other.getAllDependencyConstraints());
            }
            other.addMutationValidator(this.parentMutationValidator);
        }
        return this;
    }

    public boolean isTransitive() {
        return this.transitive;
    }

    public Configuration setTransitive(boolean transitive) {
        this.validateMutation(MutationValidator.MutationType.DEPENDENCIES);
        this.transitive = transitive;
        return this;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public Configuration setDescription(@Nullable String description) {
        this.description = description;
        return this;
    }

    public Set<Configuration> getHierarchy() {
        if (this.extendsFrom.isEmpty()) {
            return Collections.singleton(this);
        }
        Set result = WrapUtil.toLinkedSet((Object[])new Configuration[]{this});
        this.collectSuperConfigs(this, result);
        return result;
    }

    private void collectSuperConfigs(Configuration configuration, Set<Configuration> result) {
        for (Configuration superConfig : configuration.getExtendsFrom()) {
            result.remove(superConfig);
            result.add(superConfig);
            this.collectSuperConfigs(superConfig, result);
        }
    }

    public Configuration defaultDependencies(Action<? super DependencySet> action) {
        this.warnOnDeprecatedUsage("defaultDependencies(Action)", ProperMethodUsage.DECLARABLE_AGAINST);
        this.validateMutation(MutationValidator.MutationType.DEPENDENCIES);
        this.defaultDependencyActions = this.defaultDependencyActions.add(dependencies -> {
            if (dependencies.isEmpty()) {
                action.execute(dependencies);
            }
        });
        return this;
    }

    public Configuration withDependencies(Action<? super DependencySet> action) {
        this.validateMutation(MutationValidator.MutationType.DEPENDENCIES);
        this.withDependencyActions = this.withDependencyActions.add(action);
        return this;
    }

    @Override
    public void runDependencyActions() {
        this.runActionInHierarchy((Action<DefaultConfiguration>)((Action)conf -> {
            conf.defaultDependencyActions.execute((Object)conf.dependencies);
            conf.withDependencyActions.execute((Object)conf.dependencies);
            conf.defaultDependencyActions = ImmutableActionSet.empty();
            conf.withDependencyActions = ImmutableActionSet.empty();
        }));
    }

    @Deprecated
    public Set<Configuration> getAll() {
        ((DeprecationMessageBuilder.WithDocumentation)((DeprecationMessageBuilder.DeprecateMethod)DeprecationLogger.deprecateMethod(Configuration.class, (String)"getAll()").withAdvice("Use the configurations container to access the set of configurations instead.")).willBeRemovedInGradle9().withUpgradeGuideSection(8, "deprecated_configuration_get_all")).nagUser();
        return ImmutableSet.copyOf(this.configurationsProvider.getAll());
    }

    private FileCollectionInternal getIntrinsicFiles() {
        if (this.intrinsicFiles == null) {
            this.assertIsResolvable();
            this.intrinsicFiles = this.resolutionAccess.getPublicView().getFiles();
        }
        return this.intrinsicFiles;
    }

    public Set<File> resolve() {
        this.warnOnDeprecatedUsage("resolve()", ProperMethodUsage.RESOLVABLE);
        return this.getFiles();
    }

    public Iterator<File> iterator() {
        return this.getIntrinsicFiles().iterator();
    }

    protected void visitContents(FileCollectionStructureVisitor visitor) {
        this.getIntrinsicFiles().visitStructure(visitor);
    }

    protected void appendContents(TreeFormatter formatter) {
        formatter.node("configuration: " + this.identityPath);
    }

    public boolean contains(File file) {
        this.warnOnInvalidInternalAPIUsage("contains(File)", ProperMethodUsage.RESOLVABLE);
        return this.getIntrinsicFiles().contains(file);
    }

    public boolean isEmpty() {
        return this.getIntrinsicFiles().isEmpty();
    }

    @Deprecated
    public Set<File> files(Dependency ... dependencies) {
        Set deps = WrapUtil.toLinkedSet((Object[])dependencies);
        return this.fileCollectionInternal("files(Dependency...)", (Spec<? super Dependency>)((Spec)deps::contains)).getFiles();
    }

    @Deprecated
    public Set<File> files(Closure dependencySpecClosure) {
        return this.fileCollectionInternal("files(Closure)", (Spec<? super Dependency>)Specs.convertClosureToSpec((Closure)dependencySpecClosure)).getFiles();
    }

    @Deprecated
    public Set<File> files(Spec<? super Dependency> dependencySpec) {
        return this.fileCollectionInternal("files(Spec)", dependencySpec).getFiles();
    }

    @Deprecated
    public FileCollection fileCollection(Closure dependencySpecClosure) {
        return this.fileCollectionInternal("fileCollection(Closure)", (Spec<? super Dependency>)Specs.convertClosureToSpec((Closure)dependencySpecClosure));
    }

    @Deprecated
    public FileCollection fileCollection(Dependency ... dependencies) {
        Set deps = WrapUtil.toLinkedSet((Object[])dependencies);
        return this.fileCollectionInternal("fileCollection(Dependency...)", (Spec<? super Dependency>)((Spec)deps::contains));
    }

    @Deprecated
    public FileCollection fileCollection(Spec<? super Dependency> dependencySpec) {
        return this.fileCollectionInternal("fileCollection(Spec)", dependencySpec);
    }

    private FileCollection fileCollectionInternal(String methodName, Spec<? super Dependency> dependencySpec) {
        this.assertIsResolvable();
        ((DeprecationMessageBuilder.WithDocumentation)((DeprecationMessageBuilder.DeprecateMethod)DeprecationLogger.deprecateMethod(Configuration.class, (String)methodName).withAdvice("Use Configuration.getIncoming().artifactView(Action) with a componentFilter instead.")).willBeRemovedInGradle9().withUpgradeGuideSection(8, "deprecate_filtered_configuration_file_and_filecollection_methods")).nagUser();
        return new ResolutionBackedFileCollection(new ResolutionResultProviderBackedSelectedArtifactSet(this.resolutionAccess.getResults().map(resolverResults -> resolverResults.getLegacyResults().getLegacyVisitedArtifactSet().select(dependencySpec))), false, this.getResolutionHost(), this.taskDependencyFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markAsObserved(ConfigurationInternal.InternalState requestedState) {
        Object object = this.observationLock;
        synchronized (object) {
            if (this.observedState.compareTo(requestedState) >= 0) {
                return;
            }
            this.observedState = requestedState;
        }
        this.markParentsObserved(requestedState);
    }

    @VisibleForTesting
    protected ConfigurationInternal.InternalState getObservedState() {
        return this.observedState;
    }

    private void markParentsObserved(ConfigurationInternal.InternalState requestedState) {
        for (Configuration configuration : this.extendsFrom) {
            ((ConfigurationInternal)configuration).markAsObserved(requestedState);
        }
    }

    public ResolvedConfiguration getResolvedConfiguration() {
        this.warnOnDeprecatedUsage("getResolvedConfiguration()", ProperMethodUsage.RESOLVABLE);
        return this.resolutionAccess.getResults().getValue().getLegacyResults().getResolvedConfiguration();
    }

    private static Boolean isFullyResoled(Optional<ResolverResults> currentState) {
        return currentState.map(ResolverResults::isFullyResolved).orElse(false);
    }

    private ResolverResults resolveGraphIfRequired() {
        ResolverResults newState;
        this.assertIsResolvable();
        this.maybeEmitResolutionDeprecation();
        Optional currentState = (Optional)this.currentResolveState.get();
        if (DefaultConfiguration.isFullyResoled(currentState).booleanValue()) {
            return (ResolverResults)currentState.get();
        }
        if (!this.domainObjectContext.getModel().hasMutableState()) {
            if (!this.workerThreadRegistry.isWorkerThread()) {
                throw new IllegalStateException("The configuration " + this.identityPath.toString() + " was resolved from a thread not managed by Gradle.");
            }
            ((DeprecationMessageBuilder.WithDocumentation)DeprecationLogger.deprecateBehaviour((String)("Resolution of the configuration " + this.identityPath.toString() + " was attempted from a context different than the project context. Have a look at the documentation to understand why this is a problem and how it can be resolved.")).willBecomeAnErrorInGradle9().withUserManual("viewing_debugging_dependencies", "sub:resolving-unsafe-configuration-resolution-errors")).nagUser();
            newState = (ResolverResults)this.domainObjectContext.getModel().fromMutableState(p -> this.resolveExclusivelyIfRequired());
        } else {
            newState = this.resolveExclusivelyIfRequired();
        }
        return newState;
    }

    private ResolverResults resolveExclusivelyIfRequired() {
        return (ResolverResults)((Optional)this.currentResolveState.update(currentState -> {
            if (DefaultConfiguration.isFullyResoled(currentState).booleanValue()) {
                return currentState;
            }
            return Optional.of(this.resolveGraphInBuildOperation());
        })).get();
    }

    private ResolverResults resolveGraphInBuildOperation() {
        return (ResolverResults)this.buildOperationRunner.call((CallableBuildOperation)new CallableBuildOperation<ResolverResults>(){

            public ResolverResults call(BuildOperationContext context) {
                ResolverResults results;
                DefaultConfiguration.this.runDependencyActions();
                DefaultConfiguration.this.runBeforeResolve();
                try {
                    results = DefaultConfiguration.this.resolver.resolveGraph(DefaultConfiguration.this);
                }
                catch (Exception e) {
                    throw DefaultConfiguration.this.exceptionMapper.mapFailure(e, "dependencies", DefaultConfiguration.this.displayName.getDisplayName());
                }
                DefaultConfiguration.this.currentResolveState.set(Optional.of(results));
                DefaultConfiguration.this.markParentsObserved(ConfigurationInternal.InternalState.GRAPH_RESOLVED);
                if (!results.getVisitedGraph().getResolutionFailure().isPresent()) {
                    ((DependencyResolutionListener)DefaultConfiguration.this.dependencyResolutionListeners.getSource()).afterResolve(DefaultConfiguration.this.getIncoming());
                }
                DefaultConfiguration.this.dependencyResolutionListeners.removeAll();
                if (DefaultConfiguration.this.resolutionStrategy != null) {
                    DefaultConfiguration.this.resolutionStrategy.maybeDiscardStateRequiredForGraphResolution();
                }
                this.captureBuildOperationResult(context, results);
                return results;
            }

            private void captureBuildOperationResult(BuildOperationContext context, ResolverResults results) {
                results.getVisitedGraph().getResolutionFailure().ifPresent(arg_0 -> ((BuildOperationContext)context).failed(arg_0));
                MinimalResolutionResult resolutionResult = results.getVisitedGraph().getResolutionResult();
                context.setResult((Object)new ResolveConfigurationResolutionBuildOperationResult(resolutionResult.getRootSource(), resolutionResult.getRequestedAttributes(), DefaultConfiguration.this.attributesFactory));
            }

            public BuildOperationDescriptor.Builder description() {
                String displayName = "Resolve dependencies of " + DefaultConfiguration.this.identityPath;
                ProjectIdentity projectId = DefaultConfiguration.this.domainObjectContext.getProjectIdentity();
                String projectPathString = null;
                if (!DefaultConfiguration.this.domainObjectContext.isScript() && projectId != null) {
                    projectPathString = projectId.getProjectPath().getPath();
                }
                return BuildOperationDescriptor.displayName((String)displayName).progressDisplayName(displayName).details((Object)new ResolveConfigurationResolutionBuildOperationDetails(DefaultConfiguration.this.getName(), DefaultConfiguration.this.domainObjectContext.isScript(), DefaultConfiguration.this.getDescription(), DefaultConfiguration.this.domainObjectContext.getBuildPath().getPath(), projectPathString, DefaultConfiguration.this.isVisible(), DefaultConfiguration.this.isTransitive(), DefaultConfiguration.this.resolver.getAllRepositories()));
            }
        });
    }

    @Override
    public ConfigurationInternal getConsistentResolutionSource() {
        this.warnOnInvalidInternalAPIUsage("getConsistentResolutionSource()", ProperMethodUsage.RESOLVABLE);
        return this.consistentResolutionSource;
    }

    @Override
    public ImmutableList<ResolutionParameters.ModuleVersionLock> getConsistentResolutionVersionLocks() {
        if (this.consistentResolutionSource == null) {
            return ImmutableList.of();
        }
        this.assertThatConsistentResolutionIsPropertyConfigured();
        ResolvedComponentResult root = this.consistentResolutionSource.getIncoming().getResolutionResult().getRoot();
        ImmutableList.Builder locks = ImmutableList.builder();
        DefaultResolvedComponentResult.eachElement(root, (Action<? super ResolvedComponentResult>)((Action)component -> {
            if (component.getId() instanceof ModuleComponentIdentifier) {
                ModuleComponentIdentifier moduleId = (ModuleComponentIdentifier)component.getId();
                locks.add((Object)new ResolutionParameters.ModuleVersionLock(moduleId.getModuleIdentifier(), moduleId.getVersion(), this.consistentResolutionReason, true));
            }
        }), (Action<? super DependencyResult>)Actions.doNothing(), new HashSet<ResolvedComponentResult>());
        return locks.build();
    }

    private void assertThatConsistentResolutionIsPropertyConfigured() {
        if (!this.consistentResolutionSource.isCanBeResolved()) {
            throw new InvalidUserCodeException("You can't use " + this.consistentResolutionSource + " as a consistent resolution source for " + this + " because it isn't a resolvable configuration.");
        }
        LinkedHashSet<DefaultConfiguration> sources = new LinkedHashSet<DefaultConfiguration>();
        for (ConfigurationInternal src = this; src != null; src = src.getConsistentResolutionSource()) {
            if (sources.add((DefaultConfiguration)src)) continue;
            String cycle = sources.stream().map(Named::getName).collect(Collectors.joining(" -> ")) + " -> " + this.getName();
            throw new InvalidUserDataException("Cycle detected in consistent resolution sources: " + cycle);
        }
    }

    private void runBeforeResolve() {
        DependencyResolutionListener dependencyResolutionListener = (DependencyResolutionListener)this.dependencyResolutionListeners.getSource();
        this.insideBeforeResolve = true;
        try {
            dependencyResolutionListener.beforeResolve(this.getIncoming());
        }
        finally {
            this.insideBeforeResolve = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T callAndResetResolutionState(Factory<T> factory) {
        this.warnOnInvalidInternalAPIUsage("callAndResetResolutionState()", ProperMethodUsage.RESOLVABLE);
        try {
            this.getResolutionStrategy().setKeepStateRequiredForGraphResolution(true);
            Object value = factory.create();
            this.currentResolveState.set(Optional.empty());
            Object object = value;
            return (T)object;
        }
        finally {
            this.getResolutionStrategy().setKeepStateRequiredForGraphResolution(false);
        }
    }

    private ResolverResults resolveGraphForBuildDependenciesIfRequired() {
        this.assertIsResolvable();
        return (ResolverResults)((Optional)this.currentResolveState.update(initial -> {
            if (!initial.isPresent()) {
                CalculatedValueContainer futureCompleteResults = this.calculatedValueContainerFactory.create(Describables.of((Object)"Full results for", (Object)this.getName()), context -> {
                    Optional currentState = (Optional)this.currentResolveState.get();
                    if (!DefaultConfiguration.isFullyResoled(currentState).booleanValue()) {
                        return this.resolveExclusivelyIfRequired();
                    }
                    return (ResolverResults)currentState.get();
                });
                try {
                    return Optional.of(this.resolver.resolveBuildDependencies(this, (CalculatedValue<ResolverResults>)futureCompleteResults));
                }
                catch (Exception e) {
                    throw this.exceptionMapper.mapFailure(e, "dependencies", this.displayName.getDisplayName());
                }
            }
            return initial;
        })).get();
    }

    public void visitDependencies(TaskDependencyResolveContext context) {
        context.add((Object)this.getIntrinsicFiles());
    }

    public TaskDependency getTaskDependencyFromProjectDependency(boolean useDependedOn, String taskName) {
        if (useDependedOn) {
            return new TasksFromProjectDependencies(taskName, () -> this.getAllDependencies().withType(ProjectDependency.class), this.taskDependencyFactory, this.projectStateRegistry);
        }
        return new TasksFromDependentProjects(taskName, this.getName(), this.taskDependencyFactory);
    }

    public DependencySet getDependencies() {
        return this.dependencies;
    }

    public DependencySet getAllDependencies() {
        if (this.allDependencies == null) {
            this.initAllDependencies();
        }
        return this.allDependencies;
    }

    private synchronized void initAllDependencies() {
        if (this.allDependencies != null) {
            return;
        }
        this.inheritedDependencies = this.domainObjectCollectionFactory.newDomainObjectSet(Dependency.class, this.ownDependencies);
        for (Configuration configuration : this.extendsFrom) {
            this.inheritedDependencies.addCollection((DomainObjectCollection)configuration.getAllDependencies());
        }
        this.allDependencies = new DefaultDependencySet((Describable)Describables.of((Object)this.displayName, (Object)"all dependencies"), this, (DomainObjectSet<Dependency>)this.inheritedDependencies);
    }

    public DependencyConstraintSet getDependencyConstraints() {
        return this.dependencyConstraints;
    }

    public DependencyConstraintSet getAllDependencyConstraints() {
        if (this.allDependencyConstraints == null) {
            this.initAllDependencyConstraints();
        }
        return this.allDependencyConstraints;
    }

    private synchronized void initAllDependencyConstraints() {
        if (this.allDependencyConstraints != null) {
            return;
        }
        this.inheritedDependencyConstraints = this.domainObjectCollectionFactory.newDomainObjectSet(DependencyConstraint.class, this.ownDependencyConstraints);
        for (Configuration configuration : this.extendsFrom) {
            this.inheritedDependencyConstraints.addCollection((DomainObjectCollection)configuration.getAllDependencyConstraints());
        }
        this.allDependencyConstraints = new DefaultDependencyConstraintSet((Describable)Describables.of((Object)this.displayName, (Object)"all dependency constraints"), this, (DomainObjectSet<DependencyConstraint>)this.inheritedDependencyConstraints);
    }

    public PublishArtifactSet getArtifacts() {
        return this.artifacts;
    }

    public PublishArtifactSet getAllArtifacts() {
        this.initAllArtifacts();
        return this.allArtifacts;
    }

    private synchronized void initAllArtifacts() {
        if (this.allArtifacts != null) {
            return;
        }
        DisplayName displayName = Describables.of((Object)this.displayName, (Object)"all artifacts");
        if (this.isObserved() && this.extendsFrom.isEmpty()) {
            this.allArtifacts = new DefaultPublishArtifactSet((Describable)displayName, (DomainObjectSet<PublishArtifact>)this.ownArtifacts, this.fileCollectionFactory, this.taskDependencyFactory);
            return;
        }
        if (!this.isObserved()) {
            this.inheritedArtifacts = this.domainObjectCollectionFactory.newDomainObjectSet(PublishArtifact.class, this.ownArtifacts);
        }
        for (Configuration configuration : this.extendsFrom) {
            PublishArtifactSet allArtifacts = configuration.getAllArtifacts();
            if (this.inheritedArtifacts == null && allArtifacts.isEmpty()) continue;
            if (this.inheritedArtifacts == null) {
                this.inheritedArtifacts = this.domainObjectCollectionFactory.newDomainObjectSet(PublishArtifact.class, this.ownArtifacts);
            }
            this.inheritedArtifacts.addCollection((DomainObjectCollection)allArtifacts);
        }
        this.allArtifacts = this.inheritedArtifacts != null ? new DefaultPublishArtifactSet((Describable)displayName, (DomainObjectSet<PublishArtifact>)this.inheritedArtifacts, this.fileCollectionFactory, this.taskDependencyFactory) : new DefaultPublishArtifactSet((Describable)displayName, (DomainObjectSet<PublishArtifact>)this.ownArtifacts, this.fileCollectionFactory, this.taskDependencyFactory);
    }

    public Set<ExcludeRule> getExcludeRules() {
        this.initExcludeRules();
        return Collections.unmodifiableSet(this.parsedExcludeRules);
    }

    @Override
    public Set<ExcludeRule> getAllExcludeRules() {
        LinkedHashSet<ExcludeRule> result = new LinkedHashSet<ExcludeRule>();
        result.addAll(this.getExcludeRules());
        for (Configuration config : this.extendsFrom) {
            result.addAll(((ConfigurationInternal)config).getAllExcludeRules());
        }
        return result;
    }

    private synchronized void initExcludeRules() {
        if (this.parsedExcludeRules == null) {
            NotationParser parser = ExcludeRuleNotationConverter.parser();
            this.parsedExcludeRules = new LinkedHashSet<ExcludeRule>();
            for (Object excludeRule : this.excludeRules) {
                this.parsedExcludeRules.add((ExcludeRule)parser.parseNotation(excludeRule));
            }
        }
    }

    public DefaultConfiguration exclude(Map<String, String> excludeRuleArgs) {
        this.validateMutation(MutationValidator.MutationType.DEPENDENCIES);
        this.parsedExcludeRules = null;
        this.excludeRules.add(excludeRuleArgs);
        return this;
    }

    @Deprecated
    public String getUploadTaskName() {
        return Configurations.uploadTaskName(this.getName());
    }

    @Override
    public String getDisplayName() {
        return this.displayName.getDisplayName();
    }

    @Override
    public DisplayName asDescribable() {
        return this.displayName;
    }

    public ResolvableDependencies getIncoming() {
        return this.resolvableDependencies;
    }

    public ConfigurationPublications getOutgoing() {
        return this.outgoing;
    }

    @Override
    public void collectVariants(ConfigurationInternal.VariantVisitor visitor) {
        this.outgoing.collectVariants(visitor);
    }

    @Override
    public boolean isCanBeMutated() {
        boolean immutable = this.isObserved() || ((Optional)this.currentResolveState.get()).isPresent();
        return !immutable;
    }

    @Override
    public void markAsObserved(String reason) {
        if (this.isObserved()) {
            return;
        }
        this.runActionInHierarchy((Action<DefaultConfiguration>)((Action)conf -> {
            if (!conf.isObserved()) {
                conf.configurationAttributes.freeze();
                conf.outgoing.preventFromFurtherMutation();
                conf.preventUsageMutation();
                conf.observationReason = () -> {
                    String target = conf == this ? "the configuration" : "the configuration's child " + this.getDisplayName();
                    return target + " was " + reason;
                };
            }
        }));
    }

    private boolean isObserved() {
        return this.observationReason != null;
    }

    private void runActionInHierarchy(Action<DefaultConfiguration> action) {
        HashSet<Configuration> seen = new HashSet<Configuration>();
        ArrayDeque<Configuration> remaining = new ArrayDeque<Configuration>();
        remaining.add(this);
        while (!remaining.isEmpty()) {
            Configuration current = (Configuration)remaining.remove();
            action.execute((Object)((DefaultConfiguration)current));
            for (Configuration parent : current.getExtendsFrom()) {
                if (!seen.add(parent)) continue;
                remaining.add(parent);
            }
        }
    }

    public void outgoing(Action<? super ConfigurationPublications> action) {
        action.execute((Object)this.outgoing);
    }

    public ConfigurationInternal copy() {
        this.warnOnDeprecatedUsage("copy()", ProperMethodUsage.RESOLVABLE);
        return this.createCopy((Set<Dependency>)this.getDependencies(), (Set<DependencyConstraint>)this.getDependencyConstraints());
    }

    public Configuration copyRecursive() {
        this.warnOnDeprecatedUsage("copyRecursive()", ProperMethodUsage.RESOLVABLE);
        return this.createCopy((Set<Dependency>)this.getAllDependencies(), (Set<DependencyConstraint>)this.getAllDependencyConstraints());
    }

    public Configuration copy(Spec<? super Dependency> dependencySpec) {
        this.warnOnDeprecatedUsage("copy(Spec)", ProperMethodUsage.RESOLVABLE);
        return this.createCopy(CollectionUtils.filter((Set)this.getDependencies(), dependencySpec), (Set<DependencyConstraint>)this.getDependencyConstraints());
    }

    public Configuration copyRecursive(Spec<? super Dependency> dependencySpec) {
        this.warnOnDeprecatedUsage("copyRecursive(Spec)", ProperMethodUsage.RESOLVABLE);
        return this.createCopy(CollectionUtils.filter((Set)this.getAllDependencies(), dependencySpec), (Set<DependencyConstraint>)this.getAllDependencyConstraints());
    }

    private DefaultConfiguration createCopy(Set<Dependency> dependencies, Set<DependencyConstraint> dependencyConstraints) {
        DefaultConfiguration copiedConfiguration = this.copyAsDetached();
        copiedConfiguration.visible = this.visible;
        copiedConfiguration.transitive = this.transitive;
        copiedConfiguration.description = this.description;
        copiedConfiguration.defaultDependencyActions = this.defaultDependencyActions;
        copiedConfiguration.withDependencyActions = this.withDependencyActions;
        copiedConfiguration.dependencyResolutionListeners = this.dependencyResolutionListeners.copy();
        copiedConfiguration.declarationAlternatives = this.declarationAlternatives;
        copiedConfiguration.resolutionAlternatives = this.resolutionAlternatives;
        copiedConfiguration.getArtifacts().addAll((Collection)this.getAllArtifacts());
        if (!this.configurationAttributes.isEmpty()) {
            for (Attribute attribute : this.configurationAttributes.keySet()) {
                Object value = this.configurationAttributes.getAttribute(attribute);
                copiedConfiguration.getAttributes().attribute((Attribute)Cast.uncheckedNonnullCast((Object)attribute), value);
            }
        }
        for (ExcludeRule excludeRule : this.getAllExcludeRules()) {
            copiedConfiguration.excludeRules.add(new DefaultExcludeRule(excludeRule.getGroup(), excludeRule.getModule()));
        }
        DependencySet copiedDependencies = copiedConfiguration.getDependencies();
        for (Dependency dependency : dependencies) {
            copiedDependencies.add((Object)dependency.copy());
        }
        DependencyConstraintSet dependencyConstraintSet = copiedConfiguration.getDependencyConstraints();
        for (DependencyConstraint dependencyConstraint : dependencyConstraints) {
            dependencyConstraintSet.add((Object)((DependencyConstraintInternal)dependencyConstraint).copy());
        }
        return copiedConfiguration;
    }

    private DefaultConfiguration copyAsDetached() {
        String newName = this.getNameWithCopySuffix();
        DetachedConfigurationsProvider configurationsProvider = new DetachedConfigurationsProvider();
        DetachedDependencyMetadataProvider componentIdentity = new DetachedDependencyMetadataProvider(this.rootComponentMetadataBuilder.getComponentIdentity());
        RootComponentMetadataBuilder rootComponentMetadataBuilder = this.rootComponentMetadataBuilder.newBuilder(componentIdentity, configurationsProvider);
        Factory childResolutionStrategy = this.resolutionStrategy != null ? Factories.constant((Object)this.resolutionStrategy.copy()) : this.resolutionStrategyFactory;
        DefaultUnlockedConfiguration copiedConfiguration = this.defaultConfigurationFactory.create(newName, configurationsProvider, (Factory<ResolutionStrategyInternal>)childResolutionStrategy, rootComponentMetadataBuilder, ConfigurationRolesForMigration.LEGACY_TO_RESOLVABLE_DEPENDENCY_SCOPE);
        configurationsProvider.setTheOnlyConfiguration(copiedConfiguration);
        return copiedConfiguration;
    }

    private String getNameWithCopySuffix() {
        int count = this.copyCount.incrementAndGet();
        String copyName = this.name + "Copy";
        return count == 1 ? copyName : copyName + count;
    }

    public Configuration copy(Closure dependencySpec) {
        return this.copy((Spec<? super Dependency>)Specs.convertClosureToSpec((Closure)dependencySpec));
    }

    public Configuration copyRecursive(Closure dependencySpec) {
        return this.copyRecursive((Spec<? super Dependency>)Specs.convertClosureToSpec((Closure)dependencySpec));
    }

    @Override
    public ResolutionStrategyInternal getResolutionStrategy() {
        if (this.resolutionStrategy == null) {
            this.resolutionStrategy = (ResolutionStrategyInternal)this.resolutionStrategyFactory.create();
            this.resolutionStrategy.setMutationValidator(this);
            this.resolutionStrategyFactory = null;
        }
        return this.resolutionStrategy;
    }

    @Override
    public RootComponentMetadataBuilder.RootComponentState toRootComponent() {
        this.warnOnInvalidInternalAPIUsage("toRootComponent()", ProperMethodUsage.RESOLVABLE);
        return this.rootComponentMetadataBuilder.toRootComponent(this.getName());
    }

    @Override
    public DomainObjectContext getDomainObjectContext() {
        return this.domainObjectContext;
    }

    public Configuration resolutionStrategy(Closure closure) {
        ConfigureUtil.configure((Closure)closure, (Object)this.getResolutionStrategy());
        return this;
    }

    public Configuration resolutionStrategy(Action<? super ResolutionStrategy> action) {
        action.execute((Object)this.getResolutionStrategy());
        return this;
    }

    @Override
    public void addMutationValidator(MutationValidator validator) {
        this.childMutationValidators.add(validator);
    }

    @Override
    public void removeMutationValidator(MutationValidator validator) {
        this.childMutationValidators.remove(validator);
    }

    private void validateParentMutation(MutationValidator.MutationType type) {
        if (type == MutationValidator.MutationType.STRATEGY) {
            return;
        }
        this.preventIllegalParentMutation(type);
        boolean emittedDeprecation = this.maybePreventMutation(type, (Object)((Object)type) + " of parent");
        if (emittedDeprecation) {
            DeprecationLogger.whileDisabled(() -> this.notifyChildren(type));
        } else {
            this.notifyChildren(type);
        }
    }

    @Override
    public void validateMutation(MutationValidator.MutationType type) {
        this.preventIllegalMutation(type);
        boolean emittedDeprecation = this.maybePreventMutation(type, type.toString());
        if (emittedDeprecation) {
            DeprecationLogger.whileDisabled(() -> this.notifyChildren(type));
        } else {
            this.notifyChildren(type);
        }
    }

    private boolean maybePreventMutation(MutationValidator.MutationType type, String typeDescription) {
        if (this.observationReason != null && type != MutationValidator.MutationType.STRATEGY) {
            String verb = type.isPlural() ? "were" : "was";
            ((DeprecationMessageBuilder.WithDocumentation)((DeprecationMessageBuilder.DeprecateBehaviour)((DeprecationMessageBuilder.DeprecateBehaviour)DeprecationLogger.deprecateBehaviour((String)"Mutating a configuration after it has been resolved, consumed as a variant, or used for generating published metadata.").withContext(String.format("The %s of %s %s mutated after %s.", typeDescription, this.getDisplayName(), verb, this.observationReason.get()))).withAdvice("After a configuration has been observed, it should not be modified.")).willBecomeAnErrorInGradle9().withUpgradeGuideSection(8, "mutate_configuration_after_locking")).nagUser();
            return true;
        }
        return false;
    }

    private void preventIllegalParentMutation(MutationValidator.MutationType type) {
        if (type == MutationValidator.MutationType.DEPENDENCY_ATTRIBUTES || type == MutationValidator.MutationType.DEPENDENCY_CONSTRAINT_ATTRIBUTES) {
            return;
        }
        if (DefaultConfiguration.isFullyResoled((Optional)this.currentResolveState.get()).booleanValue()) {
            throw new InvalidUserDataException(String.format("Cannot change %s of parent of %s after it has been resolved", new Object[]{type, this.getDisplayName()}));
        }
    }

    private void preventIllegalMutation(MutationValidator.MutationType type) {
        if (type == MutationValidator.MutationType.DEPENDENCY_ATTRIBUTES || type == MutationValidator.MutationType.DEPENDENCY_CONSTRAINT_ATTRIBUTES) {
            this.assertIsDeclarable("Changing " + (Object)((Object)type));
            return;
        }
        if (DefaultConfiguration.isFullyResoled((Optional)this.currentResolveState.get()).booleanValue()) {
            throw new InvalidUserDataException(String.format("Cannot change %s of dependency %s after it has been resolved.", new Object[]{type, this.getDisplayName()}));
        }
        if (this.observedState == ConfigurationInternal.InternalState.GRAPH_RESOLVED && type != MutationValidator.MutationType.STRATEGY) {
            String extraMessage = this.insideBeforeResolve ? " Use 'defaultDependencies' instead of 'beforeResolve' to specify default dependencies for a configuration." : "";
            throw new InvalidUserDataException(String.format("Cannot change %s of dependency %s after it has been included in dependency resolution.%s", new Object[]{type, this.getDisplayName(), extraMessage}));
        }
        if (type == MutationValidator.MutationType.USAGE) {
            this.assertUsageIsMutable();
        }
    }

    private void notifyChildren(MutationValidator.MutationType type) {
        for (MutationValidator validator : this.childMutationValidators) {
            validator.validateMutation(type);
        }
    }

    @Override
    public ConfigurationIdentity getConfigurationIdentity() {
        String name = this.getName();
        ProjectIdentity projectId = this.domainObjectContext.getProjectIdentity();
        String projectPath = projectId == null ? null : projectId.getProjectPath().getPath();
        String buildPath = this.domainObjectContext.getBuildPath().toString();
        return new DefaultConfigurationIdentity(buildPath, projectPath, name);
    }

    private boolean isProperUsage(boolean allowDeprecated, ProperMethodUsage ... properUsages) {
        for (ProperMethodUsage properUsage : properUsages) {
            if (!properUsage.isProperUsage(this, allowDeprecated)) continue;
            return true;
        }
        return false;
    }

    private void warnOnInvalidInternalAPIUsage(String methodName, ProperMethodUsage ... properUsages) {
        this.warnOnDeprecatedUsage(methodName, true, properUsages);
    }

    private void warnOnDeprecatedUsage(String methodName, ProperMethodUsage ... properUsages) {
        this.warnOnDeprecatedUsage(methodName, false, properUsages);
    }

    private void warnOnDeprecatedUsage(String methodName, boolean allowDeprecated, ProperMethodUsage ... properUsages) {
        if (!this.isProperUsage(allowDeprecated, properUsages)) {
            String msgTemplate = "Calling configuration method '%s' is deprecated for configuration '%s', which has permitted usage(s):\n%s\nThis method is only meant to be called on configurations which allow the %susage(s): '%s'.";
            String currentUsageDesc = UsageDescriber.describeCurrentUsage((DeprecatableConfiguration)this);
            String properUsageDesc = ProperMethodUsage.summarizeProperUsage(properUsages);
            ((DeprecationMessageBuilder.WithDocumentation)DeprecationLogger.deprecateBehaviour((String)String.format(msgTemplate, methodName, this.getName(), currentUsageDesc, allowDeprecated ? "" : "(non-deprecated) ", properUsageDesc)).willBeRemovedInGradle9().withUpgradeGuideSection(8, "deprecated_configuration_usage")).nagUser();
        }
    }

    private void assertIsResolvable() {
        if (!this.canBeResolved) {
            throw new IllegalStateException("Resolving dependency configuration '" + this.name + "' is not allowed as it is defined as 'canBeResolved=false'.\nInstead, a resolvable ('canBeResolved=true') dependency configuration that extends '" + this.name + "' should be resolved.");
        }
    }

    private void assertIsDeclarable(String action) {
        if (!this.canBeDeclaredAgainst) {
            throw new IllegalStateException(action + " for configuration '" + this.name + "' is not allowed as it is defined as 'canBeDeclared=false'.");
        }
    }

    protected void assertCanCarryBuildDependencies() {
        this.assertIsResolvable();
    }

    @Override
    public AttributeContainerInternal getAttributes() {
        return this.configurationAttributes;
    }

    public Configuration attributes(Action<? super AttributeContainer> action) {
        this.warnOnDeprecatedUsage("attributes(Action)", ProperMethodUsage.CONSUMABLE, ProperMethodUsage.RESOLVABLE);
        action.execute((Object)this.configurationAttributes);
        return this;
    }

    public void preventUsageMutation() {
        this.usageCanBeMutated = false;
    }

    @Override
    public boolean usageCanBeMutated() {
        return this.usageCanBeMutated;
    }

    private void assertUsageIsMutable() {
        if (!this.usageCanBeMutated) {
            if (this.roleAtCreation != ConfigurationRoles.LEGACY) {
                throw new GradleException(String.format("Cannot change the allowed usage of %s, as it was locked upon creation to the role: '%s'.\nThis role permits the following usage:\n%s\nIdeally, each configuration should be used for a single purpose.", this.getDisplayName(), this.roleAtCreation.getName(), this.roleAtCreation.describeUsage()));
            }
            throw new GradleException(String.format("Cannot change the allowed usage of %s, as it has been locked.", this.getDisplayName()));
        }
    }

    private void maybeWarnOnChangingUsage(String methodName, boolean current, boolean newValue) {
        boolean disableUsageForDetached;
        if (this.isInLegacyRole()) {
            return;
        }
        if (!this.usageCanBeMutated && current != newValue) {
            return;
        }
        boolean redundantChange = current == newValue;
        boolean bl = disableUsageForDetached = this.isDetachedConfiguration() && !newValue;
        if ((redundantChange || disableUsageForDetached) && !Boolean.getBoolean("org.gradle.internal.deprecation.preliminary.Configuration.redundantUsageChangeWarning.enabled")) {
            return;
        }
        ((DeprecationMessageBuilder.WithDocumentation)((DeprecationMessageBuilder.DeprecateAction)DeprecationLogger.deprecateAction((String)String.format("Calling %s(%b) on %s", methodName, newValue, this)).withContext("This configuration's role was set upon creation and its usage should not be changed.")).willBecomeAnErrorInGradle9().withUpgradeGuideSection(8, "configurations_allowed_usage")).nagUser();
    }

    private boolean isDetachedConfiguration() {
        return this.configurationsProvider instanceof DetachedConfigurationsProvider;
    }

    private boolean isInLegacyRole() {
        return this.roleAtCreation == ConfigurationRoles.LEGACY;
    }

    public boolean isDeprecatedForConsumption() {
        return this.consumptionDeprecated;
    }

    public boolean isDeprecatedForResolution() {
        return this.resolutionDeprecated;
    }

    public boolean isDeprecatedForDeclarationAgainst() {
        return this.declarationDeprecated;
    }

    public boolean isCanBeConsumed() {
        return this.canBeConsumed;
    }

    public void setCanBeConsumed(boolean allowed) {
        this.maybeWarnOnChangingUsage("setCanBeConsumed", this.canBeConsumed, allowed);
        this.setCanBeConsumedInternal(allowed);
    }

    private void setCanBeConsumedInternal(boolean allowed) {
        if (this.canBeConsumed != allowed) {
            this.validateMutation(MutationValidator.MutationType.USAGE);
            this.canBeConsumed = allowed;
        }
    }

    public boolean isCanBeResolved() {
        return this.canBeResolved;
    }

    public void setCanBeResolved(boolean allowed) {
        this.maybeWarnOnChangingUsage("setCanBeResolved", this.canBeResolved, allowed);
        this.setCanBeResolvedInternal(allowed);
    }

    private void setCanBeResolvedInternal(boolean allowed) {
        if (this.canBeResolved != allowed) {
            this.validateMutation(MutationValidator.MutationType.USAGE);
            this.canBeResolved = allowed;
        }
    }

    public boolean isCanBeDeclared() {
        return this.canBeDeclaredAgainst;
    }

    public void setCanBeDeclared(boolean allowed) {
        this.maybeWarnOnChangingUsage("setCanBeDeclared", this.canBeDeclaredAgainst, allowed);
        this.setCanBeDeclaredInternal(allowed);
    }

    private void setCanBeDeclaredInternal(boolean allowed) {
        if (this.canBeDeclaredAgainst != allowed) {
            this.validateMutation(MutationValidator.MutationType.USAGE);
            this.canBeDeclaredAgainst = allowed;
        }
    }

    @Override
    public void setAllowedUsageFromRole(ConfigurationRole role) {
        if (this.isCanBeConsumed() != role.isConsumable()) {
            this.setCanBeConsumedInternal(role.isConsumable());
        }
        if (this.isCanBeResolved() != role.isResolvable()) {
            this.setCanBeResolvedInternal(role.isResolvable());
        }
        if (this.isCanBeDeclared() != role.isDeclarable()) {
            this.setCanBeDeclaredInternal(role.isDeclarable());
        }
    }

    @VisibleForTesting
    ListenerBroadcast<DependencyResolutionListener> getDependencyResolutionListeners() {
        return this.dependencyResolutionListeners;
    }

    public List<String> getDeclarationAlternatives() {
        return this.declarationAlternatives;
    }

    public List<String> getResolutionAlternatives() {
        return this.resolutionAlternatives;
    }

    public void addDeclarationAlternatives(String ... alternativesForDeclaring) {
        this.declarationAlternatives = ImmutableList.builder().addAll(this.declarationAlternatives).addAll(Arrays.asList(alternativesForDeclaring)).build();
    }

    public void addResolutionAlternatives(String ... alternativesForResolving) {
        this.resolutionAlternatives = ImmutableList.builder().addAll(this.resolutionAlternatives).addAll(Arrays.asList(alternativesForResolving)).build();
    }

    public Configuration shouldResolveConsistentlyWith(Configuration versionsSource) {
        this.warnOnDeprecatedUsage("shouldResolveConsistentlyWith(Configuration)", ProperMethodUsage.RESOLVABLE);
        this.consistentResolutionSource = (ConfigurationInternal)versionsSource;
        this.consistentResolutionReason = "version resolved in " + versionsSource + " by consistent resolution";
        return this;
    }

    public Configuration disableConsistentResolution() {
        this.warnOnDeprecatedUsage("disableConsistentResolution()", ProperMethodUsage.RESOLVABLE);
        this.consistentResolutionSource = null;
        this.consistentResolutionReason = null;
        return this;
    }

    @Override
    public ConfigurationRole getRoleAtCreation() {
        return this.roleAtCreation;
    }

    public InternalProblems getProblems() {
        return this.problemsService;
    }

    private void assertNotDetachedExtensionDoingExtending(Iterable<Configuration> extendsFrom) {
        if (this.isDetachedConfiguration()) {
            String summarizedExtensionTargets = StreamSupport.stream(extendsFrom.spliterator(), false).map(c -> "'" + c.getName() + "'").collect(Collectors.joining(", "));
            ((DeprecationMessageBuilder.WithDocumentation)((DeprecationMessageBuilder.DeprecateAction)DeprecationLogger.deprecateAction((String)String.format("Calling extendsFrom on %s", this.getDisplayName())).withContext(String.format("Detached configurations should not extend other configurations, this was extending: %s.", summarizedExtensionTargets))).willBecomeAnErrorInGradle9().withUpgradeGuideSection(8, "detached_configurations_cannot_extend")).nagUser();
        }
    }

    @Override
    public ResolutionHost getResolutionHost() {
        return this.resolutionAccess.getHost();
    }

    private static class ConfigurationDescription
    implements Describable {
        private final Path identityPath;

        ConfigurationDescription(Path identityPath) {
            this.identityPath = identityPath;
        }

        public String getDisplayName() {
            return "configuration '" + this.identityPath + "'";
        }
    }

    private class ConfigurationResolutionAccess
    implements ResolutionAccess {
        private ConfigurationResolutionAccess() {
        }

        @Override
        public ResolutionHost getHost() {
            return new DefaultResolutionHost(DefaultConfiguration.this.identityPath, DefaultConfiguration.this.displayName, DefaultConfiguration.this.problemsService, DefaultConfiguration.this.exceptionMapper);
        }

        @Override
        public ImmutableAttributes getAttributes() {
            DefaultConfiguration.this.configurationAttributes.freeze();
            return DefaultConfiguration.this.configurationAttributes.asImmutable();
        }

        @Override
        public ResolutionStrategy.SortOrder getDefaultSortOrder() {
            return DefaultConfiguration.this.getResolutionStrategy().getSortOrder();
        }

        @Override
        public ResolutionResultProvider<ResolverResults> getResults() {
            return new ResolverResultsResolutionResultProvider();
        }

        @Override
        public ResolutionOutputsInternal getPublicView() {
            return new DefaultResolutionOutputs(this, DefaultConfiguration.this.taskDependencyFactory, DefaultConfiguration.this.calculatedValueContainerFactory, DefaultConfiguration.this.attributesFactory, DefaultConfiguration.this.instantiator);
        }
    }

    public class ConfigurationResolvableDependencies
    implements ResolvableDependenciesInternal {
        public String getName() {
            return DefaultConfiguration.this.name;
        }

        public String getPath() {
            return DefaultConfiguration.this.projectPath.getPath();
        }

        public String toString() {
            return "dependencies '" + DefaultConfiguration.this.identityPath + "'";
        }

        public FileCollection getFiles() {
            return DefaultConfiguration.this.getIntrinsicFiles();
        }

        public DependencySet getDependencies() {
            DefaultConfiguration.this.runDependencyActions();
            return DefaultConfiguration.this.getAllDependencies();
        }

        public DependencyConstraintSet getDependencyConstraints() {
            DefaultConfiguration.this.runDependencyActions();
            return DefaultConfiguration.this.getAllDependencyConstraints();
        }

        public void beforeResolve(Action<? super ResolvableDependencies> action) {
            DefaultConfiguration.this.dependencyResolutionListeners.add("beforeResolve", DefaultConfiguration.this.userCodeApplicationContext.reapplyCurrentLater(action));
        }

        public void beforeResolve(Closure action) {
            this.beforeResolve((Action<? super ResolvableDependencies>)ConfigureUtil.configureUsing((Closure)action));
        }

        public void afterResolve(Action<? super ResolvableDependencies> action) {
            DefaultConfiguration.this.dependencyResolutionListeners.add("afterResolve", DefaultConfiguration.this.userCodeApplicationContext.reapplyCurrentLater(action));
        }

        public void afterResolve(Closure action) {
            this.afterResolve((Action<? super ResolvableDependencies>)ConfigureUtil.configureUsing((Closure)action));
        }

        public ResolutionResult getResolutionResult() {
            DefaultConfiguration.this.assertIsResolvable();
            return new DefaultResolutionResult(DefaultConfiguration.this.resolutionAccess, DefaultConfiguration.this.attributeDesugaring);
        }

        public ArtifactCollection getArtifacts() {
            return DefaultConfiguration.this.resolutionAccess.getPublicView().getArtifacts();
        }

        public ArtifactView artifactView(Action<? super ArtifactView.ViewConfiguration> configAction) {
            return DefaultConfiguration.this.resolutionAccess.getPublicView().artifactView(configAction);
        }

        public AttributeContainer getAttributes() {
            return DefaultConfiguration.this.configurationAttributes;
        }

        @Override
        public ResolutionOutputsInternal getResolutionOutputs() {
            DefaultConfiguration.this.assertIsResolvable();
            return DefaultConfiguration.this.resolutionAccess.getPublicView();
        }
    }

    private class AllArtifactsProvider
    implements PublishArtifactSetProvider {
        private AllArtifactsProvider() {
        }

        @Override
        public PublishArtifactSet getPublishArtifactSet() {
            return DefaultConfiguration.this.getAllArtifacts();
        }
    }

    private static enum ProperMethodUsage {
        CONSUMABLE{

            @Override
            boolean isAllowed(ConfigurationInternal configuration) {
                return configuration.isCanBeConsumed();
            }

            @Override
            boolean isDeprecated(ConfigurationInternal configuration) {
                return configuration.isDeprecatedForConsumption();
            }
        }
        ,
        RESOLVABLE{

            @Override
            boolean isAllowed(ConfigurationInternal configuration) {
                return configuration.isCanBeResolved();
            }

            @Override
            boolean isDeprecated(ConfigurationInternal configuration) {
                return configuration.isDeprecatedForResolution();
            }
        }
        ,
        DECLARABLE_AGAINST{

            @Override
            boolean isAllowed(ConfigurationInternal configuration) {
                return configuration.isCanBeDeclared();
            }

            @Override
            boolean isDeprecated(ConfigurationInternal configuration) {
                return configuration.isDeprecatedForDeclarationAgainst();
            }
        };


        abstract boolean isAllowed(ConfigurationInternal var1);

        abstract boolean isDeprecated(ConfigurationInternal var1);

        boolean isProperUsage(ConfigurationInternal configuration, boolean allowDeprecated) {
            return this.isAllowed(configuration) && (allowDeprecated || !this.isDeprecated(configuration));
        }

        public static String buildProperName(ProperMethodUsage usage) {
            return WordUtils.capitalizeFully((String)usage.name().replace('_', ' '));
        }

        public static String summarizeProperUsage(ProperMethodUsage ... properUsages) {
            return Arrays.stream(properUsages).map(ProperMethodUsage::buildProperName).collect(Collectors.joining(", "));
        }
    }

    private static class DefaultConfigurationIdentity
    implements ConfigurationIdentity {
        private final String buildPath;
        private final String projectPath;
        private final String name;

        public DefaultConfigurationIdentity(String buildPath, @Nullable String projectPath, String name) {
            this.buildPath = buildPath;
            this.projectPath = projectPath;
            this.name = name;
        }

        public String getBuildPath() {
            return this.buildPath;
        }

        @Nullable
        public String getProjectPath() {
            return this.projectPath;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            Path path = Path.path((String)this.buildPath);
            if (this.projectPath != null) {
                path = path.append(Path.path((String)this.projectPath));
            }
            path = path.child(this.name);
            return "Configuration '" + path.toString() + "'";
        }
    }

    private static class DefaultResolutionHost
    implements ResolutionHost {
        private final Path buildTreePath;
        private final DisplayName displayName;
        private final InternalProblems problems;
        private final ResolveExceptionMapper exceptionMapper;

        public DefaultResolutionHost(Path buildTreePath, DisplayName displayName, InternalProblems problems, ResolveExceptionMapper exceptionMapper) {
            this.buildTreePath = buildTreePath;
            this.displayName = displayName;
            this.problems = problems;
            this.exceptionMapper = exceptionMapper;
        }

        @Override
        public InternalProblems getProblems() {
            return this.problems;
        }

        @Override
        public DisplayName displayName() {
            return this.displayName;
        }

        @Override
        public Optional<TypedResolveException> consolidateFailures(String resolutionType, Collection<Throwable> failures) {
            return Optional.ofNullable(this.exceptionMapper.mapFailures(failures, resolutionType, this.displayName));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DefaultResolutionHost that = (DefaultResolutionHost)o;
            return this.buildTreePath.equals((Object)that.buildTreePath);
        }

        public int hashCode() {
            return this.buildTreePath.hashCode();
        }
    }

    private class ResolverResultsResolutionResultProvider
    implements ResolutionResultProvider<ResolverResults> {
        private ResolverResultsResolutionResultProvider() {
        }

        @Override
        public ResolverResults getTaskDependencyValue() {
            if (DefaultConfiguration.this.getResolutionStrategy().resolveGraphToDetermineTaskDependencies()) {
                return this.getValue();
            }
            return DefaultConfiguration.this.resolveGraphForBuildDependenciesIfRequired();
        }

        @Override
        public ResolverResults getValue() {
            return DefaultConfiguration.this.resolveGraphIfRequired();
        }
    }
}

