/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.parser;

import io.sf.carte.doc.style.css.CSSMathFunctionValue;
import io.sf.carte.doc.style.css.CSSValueSyntax;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.parser.Dimension;
import io.sf.carte.doc.style.css.parser.DimensionalAnalyzer;
import io.sf.carte.doc.style.css.parser.FunctionUnitImpl;
import org.w3c.dom.DOMException;

abstract class MathFunctionUnitImpl
extends FunctionUnitImpl {
    private static final long serialVersionUID = 1L;
    private final CSSMathFunctionValue.MathFunction functionID;

    public MathFunctionUnitImpl(CSSMathFunctionValue.MathFunction functionID) {
        super(LexicalUnit.LexicalType.MATH_FUNCTION);
        this.functionID = functionID;
    }

    @Override
    public CSSMathFunctionValue.MathFunction getMathFunction() {
        return this.functionID;
    }

    @Override
    public int getMathFunctionIndex() {
        return this.functionID.ordinal();
    }

    @Override
    CSSValueSyntax.Match typeMatch(CSSValueSyntax rootSyntax, CSSValueSyntax syntax) {
        CSSValueSyntax.Category cat = syntax.getCategory();
        switch (cat) {
            case integer: 
            case number: 
            case percentage: 
            case lengthPercentage: 
            case length: 
            case angle: 
            case time: 
            case frequency: 
            case resolution: 
            case flex: {
                return this.dimensionalMatch(rootSyntax, syntax);
            }
            case universal: {
                return CSSValueSyntax.Match.TRUE;
            }
        }
        return CSSValueSyntax.Match.FALSE;
    }

    private CSSValueSyntax.Match dimensionalMatch(CSSValueSyntax rootSyntax, CSSValueSyntax syntax) {
        Dimension dim;
        DimensionalAnalyzer danal = new DimensionalAnalyzer();
        try {
            dim = this.dimension(danal);
        }
        catch (DOMException e) {
            return CSSValueSyntax.Match.FALSE;
        }
        return dim != null ? dim.matches(syntax) : CSSValueSyntax.Match.PENDING;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.functionID.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        MathFunctionUnitImpl other = (MathFunctionUnitImpl)obj;
        return this.functionID == other.functionID;
    }

    public abstract Dimension dimension(DimensionalAnalyzer var1) throws DOMException;

    @Override
    abstract MathFunctionUnitImpl instantiateLexicalUnit();
}

