/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.CSSValueSyntax;
import io.sf.carte.doc.style.css.nsac.CSSException;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.parser.CSSParser;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.TypedValue;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import java.io.StringReader;
import org.w3c.dom.DOMException;

class ElementReferenceValue
extends TypedValue {
    private static final long serialVersionUID = 1L;
    private String refname = null;

    ElementReferenceValue() {
        super(CSSValue.Type.ELEMENT_REFERENCE);
    }

    protected ElementReferenceValue(ElementReferenceValue copied) {
        super(copied);
        this.refname = copied.refname;
    }

    @Override
    public String getCssText() {
        return "element(#" + this.refname + ")";
    }

    @Override
    public void writeCssText(SimpleWriter wri) throws IOException {
        wri.write((CharSequence)"element(#");
        wri.write((CharSequence)this.refname);
        wri.write(')');
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        LexicalUnit lu;
        this.checkModifiableProperty();
        CSSParser parser = new CSSParser();
        try {
            lu = parser.parsePropertyValue(new StringReader(cssText));
        }
        catch (IOException e) {
            lu = null;
        }
        catch (CSSException e) {
            DOMException ex = new DOMException(5, "Bad element reference: " + cssText);
            ex.initCause(e);
            throw ex;
        }
        if (lu.getLexicalUnitType() != LexicalUnit.LexicalType.ELEMENT_REFERENCE || lu.getNextLexicalUnit() != null) {
            throw new DOMException(13, "Not an element reference: " + cssText);
        }
        PrimitiveValue.LexicalSetter setter = this.newLexicalSetter();
        setter.setLexicalUnit(lu);
    }

    @Override
    CSSValueSyntax.Match matchesComponent(CSSValueSyntax syntax) {
        switch (syntax.getCategory()) {
            case image: 
            case universal: {
                return CSSValueSyntax.Match.TRUE;
            }
        }
        return CSSValueSyntax.Match.FALSE;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.refname == null ? 0 : this.refname.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ElementReferenceValue other = (ElementReferenceValue)obj;
        if (this.refname == null) {
            return other.refname == null;
        }
        return this.refname.equals(other.refname);
    }

    @Override
    PrimitiveValue.LexicalSetter newLexicalSetter() {
        return new MyLexicalSetter();
    }

    @Override
    public String getStringValue() {
        return this.refname;
    }

    @Override
    public void setStringValue(CSSValue.Type stringType, String stringValue) throws DOMException {
        if (stringType != this.getPrimitiveType()) {
            throw new DOMException(13, "Type not supported.");
        }
        if (stringValue == null || (stringValue = stringValue.trim()).length() == 0) {
            throw new DOMException(5, "Empty or null value.");
        }
        this.refname = stringValue;
    }

    @Override
    public ElementReferenceValue clone() {
        return new ElementReferenceValue(this);
    }

    class MyLexicalSetter
    extends PrimitiveValue.LexicalSetter {
        MyLexicalSetter() {
            super(ElementReferenceValue.this);
        }

        @Override
        void setLexicalUnit(LexicalUnit lunit) {
            ElementReferenceValue.this.refname = lunit.getStringValue();
            if (ElementReferenceValue.this.refname == null) {
                LexicalUnit param = lunit.getParameters();
                if (param != null) {
                    this.checkProxyValue(param);
                }
                throw new DOMException(12, "Invalid element reference: " + lunit.toString());
            }
            this.nextLexicalUnit = lunit.getNextLexicalUnit();
        }
    }
}

