/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.parser;

import io.sf.carte.doc.DOMNullCharacterException;
import io.sf.carte.doc.style.css.BooleanCondition;
import io.sf.carte.doc.style.css.CSSCanvas;
import io.sf.carte.doc.style.css.CSSDocument;
import io.sf.carte.doc.style.css.CSSMediaException;
import io.sf.carte.doc.style.css.MediaQuery;
import io.sf.carte.doc.style.css.MediaQueryHandler;
import io.sf.carte.doc.style.css.MediaQueryList;
import io.sf.carte.doc.style.css.nsac.CSSBudgetException;
import io.sf.carte.doc.style.css.nsac.CSSParseException;
import io.sf.carte.doc.style.css.nsac.Parser;
import io.sf.carte.doc.style.css.parser.AbstractMediaQuery;
import io.sf.carte.doc.style.css.parser.CSSParser;
import io.sf.carte.doc.style.css.parser.NSACMediaQueryFactory;
import io.sf.carte.doc.style.css.parser.ParseHelper;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

class NSACMediaQueryList
implements MediaQueryList {
    private final LinkedList<NSACMediaQuery> queryList = new LinkedList();
    private LinkedList<CSSParseException> queryErrorList = null;
    boolean invalidQueryList = false;

    NSACMediaQueryList() {
    }

    @Override
    public String getMedia() {
        if (this.queryList.isEmpty()) {
            if (this.invalidQueryList) {
                return "not all";
            }
            return "all";
        }
        StringBuilder buf = new StringBuilder();
        Iterator it = this.queryList.iterator();
        buf.append(((NSACMediaQuery)it.next()).getMedia());
        while (it.hasNext()) {
            buf.append(',').append(((NSACMediaQuery)it.next()).getMedia());
        }
        return buf.toString();
    }

    @Override
    public String getMinifiedMedia() {
        if (this.queryList.isEmpty()) {
            if (this.invalidQueryList) {
                return "not all";
            }
            return "all";
        }
        StringBuilder buf = new StringBuilder();
        Iterator it = this.queryList.iterator();
        buf.append(((NSACMediaQuery)it.next()).getMinifiedMedia());
        while (it.hasNext()) {
            buf.append(',').append(((NSACMediaQuery)it.next()).getMinifiedMedia());
        }
        return buf.toString();
    }

    @Override
    public String getMediaText() {
        return this.getMedia();
    }

    @Override
    public void setMediaText(String mediaText) throws DOMException {
        this.queryList.clear();
        this.parse(mediaText, null);
    }

    @Override
    public int getLength() {
        int sz = this.queryList.size();
        if (sz == 0 && this.invalidQueryList) {
            return 1;
        }
        return sz;
    }

    @Override
    public String item(int index) {
        int sz = this.queryList.size();
        if (sz == 0 && this.invalidQueryList && index == 0) {
            return "not all";
        }
        if (index < 0 || index >= sz) {
            return null;
        }
        return this.queryList.get(index).getMedia();
    }

    @Override
    public MediaQuery getMediaQuery(int index) {
        int sz = this.queryList.size();
        if (index < 0 || index >= sz || this.invalidQueryList) {
            return null;
        }
        return this.queryList.get(index);
    }

    @Override
    public void appendMedium(String newMedium) throws DOMException {
        throw new DOMException(7, "Cannot modify target media: you must re-create the style sheet with a different media list.");
    }

    @Override
    public void deleteMedium(String oldMedium) throws DOMException {
        throw new DOMException(7, "Cannot modify target media: you must re-create the style sheet with a different media list.");
    }

    @Override
    public boolean matches(String medium, CSSCanvas canvas) {
        for (NSACMediaQuery query : this.queryList) {
            if (!query.matches(medium, canvas)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean matches(MediaQueryList otherMedia) {
        if (otherMedia == null) {
            return !this.isNotAllMedia();
        }
        if (otherMedia.isNotAllMedia()) {
            return false;
        }
        if (this.isAllMedia()) {
            return true;
        }
        if (otherMedia.isAllMedia()) {
            return false;
        }
        if (otherMedia.getClass() != NSACMediaQueryList.class) {
            return this.oldMatch(otherMedia);
        }
        NSACMediaQueryList otherqlist = (NSACMediaQueryList)otherMedia;
        HashSet<NSACMediaQuery> otherList = new HashSet<NSACMediaQuery>(otherqlist.queryList.size());
        otherList.addAll(otherqlist.queryList);
        for (NSACMediaQuery query : this.queryList) {
            Iterator otherIt = otherList.iterator();
            while (otherIt.hasNext()) {
                NSACMediaQuery othermq = (NSACMediaQuery)otherIt.next();
                if (!query.matches(othermq)) continue;
                otherIt.remove();
            }
            if (!otherList.isEmpty()) continue;
            return true;
        }
        return false;
    }

    private boolean oldMatch(MediaQueryList otherMedia) {
        int sz = this.getLength();
        HashSet<String> mediastringList = new HashSet<String>(sz);
        for (int i = 0; i < sz; ++i) {
            String item = this.item(i).toLowerCase(Locale.ROOT);
            mediastringList.add(item);
        }
        int osz = otherMedia.getLength();
        for (int i = 0; i < osz; ++i) {
            String item = otherMedia.item(i).toLowerCase(Locale.ROOT);
            if (!mediastringList.contains(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isAllMedia() {
        return this.queryList.isEmpty() && !this.invalidQueryList;
    }

    @Override
    public boolean isNotAllMedia() {
        return this.invalidQueryList || this.queryList.size() == 1 && this.queryList.get(0).isNotAllMedia();
    }

    @Override
    public boolean hasErrors() {
        return this.invalidQueryList || this.queryErrorList != null;
    }

    public LinkedList<CSSParseException> getExceptions() {
        return this.queryErrorList;
    }

    public int hashCode() {
        int result = 1;
        if (this.queryList != null) {
            for (MediaQuery mediaQuery : this.queryList) {
                result += mediaQuery.hashCode();
            }
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NSACMediaQueryList other = (NSACMediaQueryList)obj;
        return !(this.queryList == null ? other.queryList != null : this.queryList.size() != other.queryList.size() || !this.queryList.containsAll(other.queryList));
    }

    public String toString() {
        return this.getMedia();
    }

    boolean parse(String mediaQueryString, Node owner) {
        CSSParser parser = new CSSParser();
        return this.parse(parser, mediaQueryString, owner);
    }

    boolean parse(Parser parser, String mediaQueryString, Node owner) throws CSSBudgetException {
        this.invalidQueryList = false;
        MyMediaQueryHandler qhandler = new MyMediaQueryHandler(owner);
        parser.parseMediaQueryList(mediaQueryString, new NSACMediaQueryFactory(), qhandler);
        return !this.invalidQueryList;
    }

    private class NSACMediaQuery
    extends AbstractMediaQuery {
        private static final long serialVersionUID = 1L;

        private NSACMediaQuery() {
        }

        @Override
        protected boolean matchesPredicate(BooleanCondition condition, CSSCanvas canvas) {
            return true;
        }

        @Override
        protected byte matches(BooleanCondition condition, BooleanCondition otherCondition, byte negatedQuery) {
            return 2;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            return obj instanceof MediaQuery && this.getMedia().equals(((MediaQuery)obj).getMedia());
        }
    }

    class MyMediaQueryHandler
    implements MediaQueryHandler {
        private NSACMediaQuery currentQuery;
        private boolean invalidQuery = false;
        private boolean compatQuery = false;
        private boolean allMedia = false;
        private final Node ownerNode;

        MyMediaQueryHandler(Node ownerNode) {
            this.ownerNode = ownerNode;
        }

        @Override
        public void startQuery() {
            this.currentQuery = new NSACMediaQuery();
        }

        @Override
        public void mediaType(String mediaType) {
            String unescaped;
            try {
                unescaped = ParseHelper.unescapeStringValue(mediaType, false, false);
            }
            catch (DOMNullCharacterException e) {
                unescaped = mediaType;
            }
            this.currentQuery.setMediaType(unescaped);
        }

        @Override
        public void negativeQuery() {
            this.currentQuery.setNegative(true);
        }

        @Override
        public void onlyPrefix() {
            this.currentQuery.setOnlyPrefix(true);
        }

        @Override
        public void condition(BooleanCondition condition) {
            this.currentQuery.setFeaturePredicate(condition);
        }

        @Override
        public void endQuery() {
            if (!this.invalidQuery) {
                if (!this.currentQuery.isNotAllMedia() || !this.containsNotAll()) {
                    NSACMediaQueryList.this.queryList.add(this.currentQuery);
                }
                if (NSACMediaQueryList.this.invalidQueryList && !this.compatQuery) {
                    NSACMediaQueryList.this.invalidQueryList = false;
                }
                if (this.currentQuery.isAllMedia()) {
                    this.allMedia = true;
                }
            }
            this.currentQuery = null;
            this.invalidQuery = false;
            this.compatQuery = false;
        }

        private boolean containsNotAll() {
            for (NSACMediaQuery query : NSACMediaQueryList.this.queryList) {
                if (!query.isNotAllMedia()) continue;
                return true;
            }
            return false;
        }

        @Override
        public void endQueryList() {
            if (this.allMedia) {
                NSACMediaQueryList.this.queryList.clear();
            }
        }

        @Override
        public boolean reportsErrors() {
            return this.ownerNode != null;
        }

        @Override
        public MediaQueryList getMediaQueryList() {
            return NSACMediaQueryList.this;
        }

        @Override
        public void invalidQuery(CSSParseException queryError) {
            this.invalidQuery = true;
            NSACMediaQueryList.this.invalidQueryList = true;
            if (NSACMediaQueryList.this.queryErrorList == null) {
                NSACMediaQueryList.this.queryErrorList = new LinkedList();
            }
            NSACMediaQueryList.this.queryErrorList.add(queryError);
            if (this.ownerNode != null) {
                CSSMediaException e = new CSSMediaException(queryError);
                ((CSSDocument)this.ownerNode.getOwnerDocument()).getErrorHandler().mediaQueryError(this.ownerNode, e);
            }
        }

        @Override
        public void compatQuery(CSSParseException exception) {
            NSACMediaQueryList.this.invalidQueryList = true;
            this.compatQuery = true;
            if (NSACMediaQueryList.this.queryErrorList == null) {
                NSACMediaQueryList.this.queryErrorList = new LinkedList();
            }
            NSACMediaQueryList.this.queryErrorList.add(exception);
            if (this.ownerNode != null) {
                CSSMediaException e = new CSSMediaException(exception);
                ((CSSDocument)this.ownerNode.getOwnerDocument()).getErrorHandler().mediaQueryWarning(this.ownerNode, e);
            }
        }
    }
}

