/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.DirectionalityHelper;
import io.sf.carte.doc.style.css.CSSDocument;
import io.sf.carte.doc.style.css.SelectorMatcher;
import io.sf.carte.doc.style.css.nsac.CombinatorSelector;
import io.sf.carte.doc.style.css.nsac.Selector;
import io.sf.carte.doc.style.css.nsac.SelectorList;
import io.sf.carte.doc.style.css.nsac.SimpleSelector;
import io.sf.carte.doc.style.css.om.AbstractSelectorMatcher;
import java.util.Locale;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public abstract class BaseSelectorMatcher<E extends Element>
extends AbstractSelectorMatcher {
    private static final long serialVersionUID = 1L;
    private final E element;

    protected BaseSelectorMatcher(E elm) {
        this.element = elm;
        String name = elm.getLocalName();
        if (name == null) {
            name = elm.getTagName();
        }
        name = name.toLowerCase(Locale.ROOT).intern();
        this.setLocalName(name);
    }

    protected E getElement() {
        return this.element;
    }

    @Override
    protected AbstractSelectorMatcher getParentSelectorMatcher() {
        Node parent = this.element.getParentNode();
        if (parent.getNodeType() == 1) {
            return (AbstractSelectorMatcher)this.obtainSelectorMatcher((Element)parent);
        }
        return null;
    }

    @Override
    protected AbstractSelectorMatcher getPreviousSiblingSelectorMatcher() {
        for (Node sibling = this.element.getPreviousSibling(); sibling != null; sibling = sibling.getPreviousSibling()) {
            if (sibling.getNodeType() != 1) continue;
            return (AbstractSelectorMatcher)this.obtainSelectorMatcher((Element)sibling);
        }
        return null;
    }

    @Override
    protected int indexOf(SelectorList selectors) {
        int idx = 0;
        for (Node node = this.element.getParentNode().getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1 || !this.matchSelectors(selectors, (Element)node)) continue;
            ++idx;
            if (node != this.element) continue;
            return idx;
        }
        return -1;
    }

    @Override
    protected int reverseIndexOf(SelectorList selectors) {
        int idx = 0;
        for (Node node = this.element.getParentNode().getLastChild(); node != null; node = node.getPreviousSibling()) {
            if (node.getNodeType() != 1 || !this.matchSelectors(selectors, (Element)node)) continue;
            ++idx;
            if (node != this.element) continue;
            return idx;
        }
        return -1;
    }

    private boolean matchSelectors(SelectorList selectors, E element) {
        if (selectors == null) {
            return true;
        }
        SelectorMatcher matcher = this.obtainSelectorMatcher(element);
        int sz = selectors.getLength();
        for (int i = 0; i < sz; ++i) {
            if (!matcher.matches(selectors.item(i))) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean isActivePseudoClass(String pseudoclassName) {
        return false;
    }

    @Override
    protected boolean isFirstChild() {
        for (Node sibling = this.element.getPreviousSibling(); sibling != null; sibling = sibling.getPreviousSibling()) {
            if (sibling.getNodeType() != 1) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean isLastChild() {
        for (Node sibling = this.element.getNextSibling(); sibling != null; sibling = sibling.getNextSibling()) {
            if (sibling.getNodeType() != 1) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean isFirstOfType() {
        for (Node sibling = this.element.getPreviousSibling(); sibling != null; sibling = sibling.getPreviousSibling()) {
            if (sibling.getNodeType() != 1 || !this.getLocalName().equals(sibling.getNodeName())) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean isLastOfType() {
        for (Node sibling = this.element.getNextSibling(); sibling != null; sibling = sibling.getNextSibling()) {
            if (sibling.getNodeType() != 1 || !this.getLocalName().equals(sibling.getNodeName())) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean isNthOfType(int step, int offset) {
        int idx = 0;
        for (Node node = this.element.getParentNode().getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1 || !this.getLocalName().equals(node.getLocalName())) continue;
            ++idx;
            if (node == this.element) break;
        }
        return step == 0 ? idx == 0 : Math.floorMod(idx -= offset, step) == 0;
    }

    @Override
    protected boolean isNthLastOfType(int step, int offset) {
        int idx = 0;
        for (Node node = this.element.getParentNode().getLastChild(); node != null; node = node.getPreviousSibling()) {
            if (node.getNodeType() != 1 || !this.getLocalName().equals(node.getNodeName())) continue;
            ++idx;
            if (node == this.element) break;
        }
        return step == 0 ? idx == 0 : Math.floorMod(idx -= offset, step) == 0;
    }

    @Override
    protected boolean isTarget() {
        int idx;
        String uri = this.element.getOwnerDocument().getDocumentURI();
        if (uri != null && (idx = uri.lastIndexOf(35)) != -1) {
            int len = uri.length();
            return ++idx < len && this.getId().equals(uri.subSequence(idx, len));
        }
        return false;
    }

    @Override
    protected boolean isRoot() {
        return this.element.getOwnerDocument().getDocumentElement().isSameNode((Node)this.element);
    }

    @Override
    protected boolean isEmpty() {
        for (Node node = this.element.getFirstChild(); node != null; node = node.getNextSibling()) {
            String value;
            short type = node.getNodeType();
            if (type == 1) {
                return false;
            }
            if (!(type == 3 ? (value = node.getNodeValue()).trim().length() != 0 : type == 5)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean isBlank() {
        for (Node node = this.element.getFirstChild(); node != null; node = node.getNextSibling()) {
            String value;
            short type = node.getNodeType();
            if (type == 1) {
                return false;
            }
            if (!(type == 3 ? (value = node.getNodeValue()) != null && !((Text)node).isElementContentWhitespace() : type == 5)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean isDisabled() {
        if (this.element.hasAttribute("disabled")) {
            return true;
        }
        Node parent = this.element.getParentNode();
        if (parent != null && parent.getNodeType() == 1 && "fieldset".equals(parent.getNodeName()) && !"legend".equals(this.getLocalName())) {
            return ((Element)parent).hasAttribute("disabled");
        }
        return false;
    }

    @Override
    protected boolean isDefaultButton() {
        Node parent = this.element.getParentNode();
        if (parent == null) {
            return false;
        }
        while (parent != null && parent.getNodeType() == 1 && !"form".equalsIgnoreCase(((Element)parent).getTagName())) {
            parent = parent.getParentNode();
        }
        String formid = parent == null ? null : this.getElementId((Element)parent);
        Node sibling = this.element.getPreviousSibling();
        while (sibling != null) {
            if (sibling.getNodeType() != 1) continue;
            Element element = (Element)sibling;
            if (!BaseSelectorMatcher.defaultButtonCheck(element, formid)) {
                return false;
            }
            for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (node.getNodeType() != 1 || BaseSelectorMatcher.defaultButtonCheck((Element)node, formid)) continue;
                return false;
            }
            sibling = sibling.getPreviousSibling();
        }
        return true;
    }

    private static boolean defaultButtonCheck(Element element, String formid) {
        String form;
        if (!element.hasAttribute("disabled") && ((form = element.getAttribute("form")) == null || form.equals(formid))) {
            String tagname = element.getTagName().toLowerCase(Locale.ROOT);
            if (tagname.equals("input")) {
                String type = element.getAttribute("type");
                return !"submit".equalsIgnoreCase(type) && !"image".equalsIgnoreCase(type);
            }
            if (tagname.equals("button")) {
                return !"submit".equalsIgnoreCase(element.getAttribute("type"));
            }
        }
        return true;
    }

    @Override
    protected String getNamespaceURI() {
        return this.element.getNamespaceURI();
    }

    @Override
    protected String getAttributeValue(String attrName) {
        return this.element.getAttribute(attrName);
    }

    @Override
    protected boolean hasAttribute(String attrName) {
        return this.element.hasAttribute(attrName);
    }

    @Override
    protected CSSDocument.ComplianceMode getComplianceMode() {
        Document doc = this.getOwnerDocument();
        return doc.getDoctype() != null ? CSSDocument.ComplianceMode.STRICT : CSSDocument.ComplianceMode.QUIRKS;
    }

    protected Document getOwnerDocument() {
        return this.element.getOwnerDocument();
    }

    @Override
    protected String getId() {
        return this.getElementId(this.element);
    }

    protected String getElementId(E element) {
        String idAttr = element.getAttribute("id");
        if (idAttr.length() == 0 && this.getComplianceMode() == CSSDocument.ComplianceMode.QUIRKS && (idAttr = this.getAttributeValue("ID")).length() == 0) {
            idAttr = this.getAttributeValue("Id");
        }
        return idAttr;
    }

    @Override
    protected String getLanguage() {
        String lang = this.element.getAttribute("lang");
        Object parent = this.element;
        while (lang.length() == 0 && (parent = parent.getParentNode()) != null) {
            if (!(parent instanceof Element)) continue;
            lang = ((Element)parent).getAttribute("lang");
        }
        return lang;
    }

    @Override
    protected DirectionalityHelper.Directionality getDirectionality() {
        return DirectionalityHelper.getDirectionality(this.element);
    }

    @Override
    protected boolean scopeMatchChild(CombinatorSelector selector) {
        SimpleSelector desc = selector.getSecondSelector();
        for (Node node = this.element.getFirstChild(); node != null; node = node.getNextSibling()) {
            SelectorMatcher childSM;
            if (node.getNodeType() != 1 || !(childSM = this.obtainSelectorMatcher((Element)node)).matches(desc)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean scopeMatchDescendant(CombinatorSelector selector) {
        SimpleSelector desc = selector.getSecondSelector();
        Node first = this.element.getFirstChild();
        return this.scopeMatchRecursive(first, desc);
    }

    @Override
    public boolean matchesRelational(Selector selector) {
        Node first = this.element.getFirstChild();
        return this.scopeMatchRecursive(first, selector);
    }

    private boolean scopeMatchRecursive(Node node, Selector desc) {
        while (node != null) {
            SelectorMatcher childSM;
            if (node.getNodeType() == 1 && ((childSM = this.obtainSelectorMatcher((Element)node)).matches(desc) || this.scopeMatchRecursive(node.getFirstChild(), desc))) {
                return true;
            }
            node = node.getNextSibling();
        }
        return false;
    }

    @Override
    protected boolean scopeMatchDirectAdjacent(CombinatorSelector selector) {
        SelectorMatcher siblingSM = null;
        for (Node sibling = this.element.getNextSibling(); sibling != null; sibling = sibling.getNextSibling()) {
            if (sibling.getNodeType() != 1) continue;
            siblingSM = this.obtainSelectorMatcher((Element)sibling);
            break;
        }
        if (siblingSM != null) {
            return siblingSM.matches(selector.getSecondSelector());
        }
        return false;
    }

    protected abstract SelectorMatcher obtainSelectorMatcher(E var1);
}

