/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.dom;

import io.sf.carte.doc.DOMTokenList;
import io.sf.carte.doc.DOMTokenSetImpl;
import io.sf.carte.doc.dom.AbstractDOMNode;
import io.sf.carte.doc.dom.AttributeNamedNodeMap;
import io.sf.carte.doc.dom.DOMAttr;
import io.sf.carte.doc.dom.DOMDocument;
import io.sf.carte.doc.dom.DOMNamedNodeMap;
import io.sf.carte.doc.dom.DOMNode;
import io.sf.carte.doc.dom.DOMNodeList;
import io.sf.carte.doc.dom.DOMTypeInfo;
import io.sf.carte.doc.dom.ElementList;
import io.sf.carte.doc.dom.NDTNode;
import io.sf.carte.doc.dom.NamespacedNode;
import io.sf.carte.doc.dom.NodeFilter;
import io.sf.carte.doc.dom.NodeListIterator;
import io.sf.carte.doc.dom.ParentNode;
import io.sf.carte.doc.style.css.CSSDocument;
import io.sf.carte.doc.style.css.CSSElement;
import io.sf.carte.doc.style.css.CSSStyleDeclaration;
import io.sf.carte.doc.style.css.CSSStyleSheetFactory;
import io.sf.carte.doc.style.css.SelectorMatcher;
import io.sf.carte.doc.style.css.nsac.Condition;
import io.sf.carte.doc.style.css.nsac.SelectorList;
import io.sf.carte.doc.style.css.om.ComputedCSSStyle;
import io.sf.carte.doc.style.css.om.DOMSelectorMatcher;
import io.sf.carte.doc.style.css.parser.CSSParser;
import java.io.Serializable;
import java.io.StringReader;
import java.lang.ref.WeakReference;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.TypeInfo;

public abstract class DOMElement
extends NamespacedNode
implements CSSElement,
ParentNode {
    private static final long serialVersionUID = 2L;
    final String localName;
    final MyNamedNodeMap nodeMap;
    private final AbstractDOMNode.ChildCollections child;
    ClassList classList = null;
    private TypeInfo schemaTypeInfo = null;
    private transient WeakReference<SelectorMatcher> selectorMatcherRef = null;
    private Map<Condition, CSSStyleDeclaration> overrideStyleSet = null;
    private boolean rawTextElement = false;

    DOMElement(String localName, String namespaceUri) {
        super((short)1, namespaceUri);
        this.localName = localName;
        this.nodeMap = new MyNamedNodeMap();
        this.child = new NDTNode.DefaultChildNodeList(this);
    }

    @Override
    AbstractDOMNode.ChildCollections getNodeList() {
        return this.child;
    }

    void setRawText() {
        this.rawTextElement = true;
    }

    boolean isRawText() {
        return this.rawTextElement || "preserve".equalsIgnoreCase(this.getAttributeNS("http://www.w3.org/XML/1998/namespace", "space"));
    }

    @Override
    public AttributeNamedNodeMap getAttributes() {
        return this.nodeMap;
    }

    @Override
    public boolean hasAttributes() {
        return !this.nodeMap.isEmpty();
    }

    @Override
    public String getAttribute(String name) {
        Attr attr = (Attr)this.nodeMap.getNamedItem(name);
        String attrStr = attr == null ? "" : attr.getValue();
        return attrStr;
    }

    @Override
    public String getAttributeNS(String namespaceURI, String localName) throws DOMException {
        Attr attr = (Attr)this.nodeMap.getNamedItemNS(namespaceURI, localName);
        String attrStr = attr == null ? "" : attr.getValue();
        return attrStr;
    }

    @Override
    public Attr getAttributeNode(String name) {
        return (Attr)this.nodeMap.getNamedItem(name);
    }

    @Override
    public Attr getAttributeNodeNS(String namespaceURI, String localName) throws DOMException {
        return (Attr)this.nodeMap.getNamedItemNS(namespaceURI, localName);
    }

    @Override
    public boolean hasAttribute(String name) {
        boolean ret = this.nodeMap.hasAttribute(name);
        if (!ret && name.indexOf(58) == -1) {
            name = name.toLowerCase(Locale.ROOT);
            ret = this.nodeMap.hasAttribute(name);
        }
        return ret;
    }

    @Override
    public boolean hasAttributeNS(String namespaceURI, String localName) throws DOMException {
        return this.nodeMap.getNamedItemNS(namespaceURI, localName) != null;
    }

    @Override
    public void removeAttribute(String name) throws DOMException {
        block2: {
            try {
                this.nodeMap.removeNamedItem(name);
            }
            catch (DOMException e) {
                if (e.code == 8) break block2;
                throw e;
            }
        }
    }

    @Override
    public void removeAttributeNS(String namespaceURI, String localName) throws DOMException {
        block2: {
            try {
                this.nodeMap.removeNamedItemNS(namespaceURI, localName);
            }
            catch (DOMException e) {
                if (e.code == 8) break block2;
                throw e;
            }
        }
    }

    @Override
    public Attr removeAttributeNode(Attr oldAttr) throws DOMException {
        return (Attr)this.nodeMap.removeItem(oldAttr);
    }

    @Override
    public void setAttribute(String name, String value) throws DOMException {
        Attr attr = (Attr)this.nodeMap.getNamedItem(name);
        if (attr == null) {
            attr = this.getOwnerDocument().createAttribute(name);
            attr.setValue(value);
            this.nodeMap.setNamedItem(attr);
        } else {
            attr.setValue(value);
        }
    }

    @Override
    public void setAttributeNS(String namespaceURI, String qualifiedName, String value) throws DOMException {
        Attr attr = (Attr)this.nodeMap.getNamedItem(qualifiedName);
        if (attr == null || !Objects.equals(namespaceURI, attr.getNamespaceURI())) {
            attr = this.getOwnerDocument().createAttributeNS(namespaceURI, qualifiedName);
            this.nodeMap.setNamedItemNS(attr);
        }
        attr.setValue(value);
    }

    @Override
    public Attr setAttributeNode(Attr newAttr) throws DOMException {
        return (Attr)this.nodeMap.setNamedItem(newAttr);
    }

    @Override
    public Attr setAttributeNodeNS(Attr newAttr) throws DOMException {
        return this.setAttributeNode(newAttr);
    }

    @Override
    public String getId() {
        if (!this.nodeMap.isEmpty()) {
            for (Attr attr : this.nodeMap.getNodeList()) {
                if (!attr.isId()) continue;
                return attr.getValue();
            }
        }
        return "";
    }

    @Override
    @Deprecated
    public void setIdAttribute(String name, boolean isId) {
    }

    @Override
    @Deprecated
    public void setIdAttributeNS(String namespaceURI, String localName, boolean isId) {
    }

    @Override
    @Deprecated
    public void setIdAttributeNode(Attr idAttr, boolean isId) {
    }

    boolean isIdAttribute(String localName) {
        return this.getOwnerDocument().isIdAttribute(localName);
    }

    @Override
    public ElementList getElementsByTagNameNS(String namespaceURI, String localName) {
        return this.child.getElementsByTagNameNS(namespaceURI, localName);
    }

    @Override
    public ElementList getElementsByTagName(String name) {
        return this.child.getElementsByTagName(name, this.getOwnerDocument().isHTML());
    }

    public DOMTokenList getClassList() {
        if (this.classList == null) {
            DOMAttr attr = (DOMAttr)this.nodeMap.getNamedItem("class");
            this.classList = this.getOwnerDocument().getComplianceMode() == CSSDocument.ComplianceMode.STRICT ? new ClassList() : new QuirksClassList();
            if (attr != null && attr.value.length() != 0) {
                this.classList.setValue(attr.value);
            }
        }
        return this.classList;
    }

    @Override
    public ElementList getElementsByClassName(String names) {
        return this.child.getElementsByClassName(names, this.getOwnerDocument().getComplianceMode());
    }

    public String getClassName() {
        return this.getAttribute("class");
    }

    public void setClassName(String className) {
        this.setAttribute("class", className);
    }

    public DOMElement querySelector(String selectors) {
        return DOMElement.querySelector(selectors, this.getFirstChild());
    }

    @Override
    public ElementList querySelectorAll(String selectors) {
        return DOMElement.querySelectorAll(selectors, this.getFirstChild());
    }

    @Override
    public String getLocalName() {
        return this.localName;
    }

    @Override
    public String getTagName() {
        String tagname = this.localName;
        String prefix = this.getPrefix();
        if (prefix == null) {
            return tagname;
        }
        StringBuilder buf = new StringBuilder(tagname.length() + prefix.length() + 1);
        buf.append(prefix).append(':').append(tagname);
        return buf.toString();
    }

    @Override
    public String getNodeName() {
        return this.getTagName();
    }

    @Override
    public String lookupNamespaceURI(String prefix) {
        String namespaceURI = super.lookupNamespaceURI(prefix);
        if (namespaceURI == null) {
            AbstractDOMNode.RawNodeList nodelist = this.nodeMap.getNodeList();
            if (!nodelist.isEmpty()) {
                for (Attr attr : nodelist) {
                    String localName = attr.getLocalName();
                    String pre = attr.getPrefix();
                    if (!"http://www.w3.org/2000/xmlns/".equals(attr.getNamespaceURI())) continue;
                    if ("xmlns".equals(localName) && prefix.equals(pre)) {
                        return attr.getValue();
                    }
                    if (!"xmlns".equals(pre) || !pre.equals(localName)) continue;
                    return attr.getValue();
                }
            }
            Node pnode = this;
            while ((pnode = pnode.getParentNode()) != null && pnode.getNodeType() != 1) {
            }
            if (pnode != null) {
                namespaceURI = pnode.lookupNamespaceURI(namespaceURI);
            }
        }
        return namespaceURI;
    }

    @Override
    public String lookupPrefix(String namespaceURI) {
        if (namespaceURI == null) {
            return null;
        }
        if (namespaceURI.equals(this.getNamespaceURI())) {
            return this.getPrefix();
        }
        AbstractDOMNode.RawNodeList nodelist = this.nodeMap.getNodeList();
        if (!nodelist.isEmpty()) {
            for (Attr attr : nodelist) {
                if (!"http://www.w3.org/2000/xmlns/".equals(attr.getNamespaceURI()) || !namespaceURI.equals(attr.getValue())) continue;
                String localName = attr.getLocalName();
                String prefix = attr.getPrefix();
                if ("xmlns".equals(localName)) {
                    return prefix;
                }
                if (!"xmlns".equals(prefix)) continue;
                return localName;
            }
        }
        Node pnode = this;
        while ((pnode = pnode.getParentNode()) != null && pnode.getNodeType() != 1) {
        }
        if (pnode != null) {
            return pnode.lookupPrefix(namespaceURI);
        }
        return namespaceURI == "http://www.w3.org/XML/1998/namespace" ? "xml" : null;
    }

    @Override
    void checkAppendNodeHierarchy(Node newChild) {
        super.checkAppendNodeHierarchy(newChild);
        if (newChild.getNodeType() == 10) {
            throw new DOMException(3, "Doctype must be added to document.");
        }
    }

    @Override
    public DOMElement getFirstElementChild() {
        return super.getFirstElementChild();
    }

    @Override
    public DOMElement getLastElementChild() {
        return super.getLastElementChild();
    }

    @Override
    public ElementList getChildren() {
        return this.child.getChildren();
    }

    @Override
    public int getChildElementCount() {
        return super.getChildElementCount();
    }

    @Override
    public Iterator<DOMNode> iterator() {
        return this.child.iterator();
    }

    @Override
    public Iterator<DOMNode> descendingIterator() {
        return this.child.createDescendingIterator();
    }

    @Override
    public Iterator<DOMNode> iterator(BitSet whatToShow) {
        return this.child.createIterator(whatToShow);
    }

    @Override
    public Iterator<DOMElement> elementIterator() {
        return this.child.elementIterator();
    }

    @Override
    public Iterator<DOMElement> elementIterator(String name) {
        return this.child.elementIterator(name);
    }

    @Override
    public Iterator<DOMElement> elementIteratorNS(String namespaceURI, String localName) {
        return this.child.elementIteratorNS(namespaceURI, localName);
    }

    @Override
    public Iterator<DOMNode> iterator(int whatToShow, NodeFilter filter) {
        return this.child.createIterator(whatToShow, filter);
    }

    @Override
    public Iterator<DOMNode> typeIterator(short typeToShow) {
        return this.iterator(NodeFilter.maskTable[typeToShow - 1], null);
    }

    @Override
    public Iterator<DOMNode> iterator(NodeFilter filter) {
        return this.child.createIterator(-1, filter);
    }

    @Override
    public NodeListIterator listIterator() {
        return this.child.createListIterator();
    }

    @Override
    public String getTextContent() throws DOMException {
        String text;
        if (this.getNodeList().isEmpty()) {
            text = "";
        } else {
            StringBuilder buf = new StringBuilder(64);
            this.appendTextContent(buf);
            text = buf.toString();
        }
        return text;
    }

    public String getInnerText() {
        StringBuilder buf = new StringBuilder(256);
        this.addInnerText(this, buf, false);
        return buf.toString();
    }

    private boolean addInnerText(DOMElement element, StringBuilder buf, boolean lastTextPreserved) throws DOMException {
        boolean isBlock;
        ComputedCSSStyle style = element.getComputedStyle(null);
        String display = style.getPropertyValue("display");
        String[] displays = display.split(" ");
        if (!element.hasPrintableNodes() || DOMElement.matchesString(displays, "none") || element.isNonPrintableElement()) {
            return lastTextPreserved;
        }
        String sTextTransform = style.getPropertyValue("text-transform");
        short textTransform = 0;
        if ("uppercase".equalsIgnoreCase(sTextTransform)) {
            textTransform = 2;
        } else if ("lowercase".equalsIgnoreCase(sTextTransform)) {
            textTransform = 1;
        } else if ("capitalize".equalsIgnoreCase(sTextTransform)) {
            textTransform = 3;
        }
        boolean visible = !"hidden".equalsIgnoreCase(style.getPropertyValue("visibility"));
        boolean inline = false;
        boolean bl = isBlock = DOMElement.matchesString(displays, "block") || DOMElement.matchesString(displays, "list-item") || (DOMElement.matchesString(displays, "table") || DOMElement.matchesString(displays, "table-caption")) && !(inline = DOMElement.matchesString(displays, "inline"));
        if (visible) {
            int buflenM1;
            if (isBlock && (buflenM1 = buf.length() - 1) != -1 && buf.charAt(buflenM1) != '\n') {
                buf.append('\n');
            }
            if (DOMElement.hasPrecedingAnonymousBox(displays, style)) {
                buf.append(' ');
            } else if (DOMElement.matchesString(displays, "table-cell") && element.getPreviousElementSibling() != null) {
                buf.append('\t');
            }
        }
        boolean firstTextAdded = true;
        for (DOMNode node : element.getNodeList()) {
            switch (node.getNodeType()) {
                case 1: {
                    if (!node.getChildNodes().isEmpty()) {
                        lastTextPreserved = this.addInnerText((DOMElement)node, buf, lastTextPreserved);
                        firstTextAdded = false;
                        break;
                    }
                    if (!visible) break;
                    DOMElement childElm = (DOMElement)node;
                    ComputedCSSStyle childStyle = childElm.getComputedStyle(null);
                    String childDisplay = childStyle.getPropertyValue("display");
                    String[] childDisplays = childDisplay.split(" ");
                    if (DOMElement.matchesString(childDisplays, "table-cell") && childElm.getPreviousElementSibling() != null) {
                        buf.append('\t');
                        break;
                    }
                    lastTextPreserved = this.innerTextVoidElement(childElm, lastTextPreserved, buf);
                    break;
                }
                case 3: {
                    if (!visible) break;
                    String text = node.getNodeValue();
                    String whiteSpace = style.getPropertyValue("white-space");
                    if ("pre".equalsIgnoreCase(whiteSpace) || "pre-wrap".equalsIgnoreCase(whiteSpace) || "break-spaces".equalsIgnoreCase(whiteSpace)) {
                        if (textTransform == 0) {
                            buf.append(text);
                        } else {
                            DOMElement.appendTransformedText(text, textTransform, buf);
                        }
                        lastTextPreserved = true;
                    } else {
                        DOMElement.appendNormalizedWhitespace(text, "pre-line".equalsIgnoreCase(whiteSpace), isBlock && firstTextAdded, textTransform, buf);
                        lastTextPreserved = false;
                    }
                    firstTextAdded = false;
                    break;
                }
                case 4: {
                    if (!visible) break;
                    String text = node.getNodeValue();
                    buf.append(text);
                    firstTextAdded = false;
                    lastTextPreserved = true;
                }
            }
        }
        if (visible) {
            boolean isRow = false;
            if (isBlock || (isRow = DOMElement.matchesString(displays, "table-row")) && !inline) {
                this.trimBuffer(lastTextPreserved, buf);
                if (!isRow || element.getNextElementSibling() != null) {
                    buf.append('\n');
                }
            }
        }
        return lastTextPreserved;
    }

    private static boolean matchesString(String[] values, String value) {
        for (String s : values) {
            if (!value.equalsIgnoreCase(s)) continue;
            return true;
        }
        return false;
    }

    boolean isNonPrintableElement() {
        return false;
    }

    private boolean hasPrintableNodes() {
        for (DOMNode node : this.getNodeList()) {
            switch (node.getNodeType()) {
                case 1: {
                    if (!((DOMElement)node).hasPrintableNodes()) break;
                    return true;
                }
                case 3: 
                case 4: {
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean hasPrecedingAnonymousBox(String[] displays, ComputedCSSStyle style) {
        return DOMElement.matchesString(displays, "list-item") && "inside".equalsIgnoreCase(style.getPropertyValue("list-style-position"));
    }

    boolean innerTextVoidElement(DOMElement element, boolean lastTextPreserved, StringBuilder buf) {
        return lastTextPreserved;
    }

    /*
     * Unable to fully structure code
     */
    private static void appendTransformedText(String text, short textTransform, StringBuilder buf) {
        whitespaceLast = false;
        len = text.length();
        i = 0;
        while (i < len) {
            block7: {
                c = text.codePointAt(i);
                if (!Character.isWhitespace(c)) break block7;
                if (!whitespaceLast) {
                    whitespaceLast = true;
                }
                ** GOTO lbl23
            }
            if (!whitespaceLast) ** GOTO lbl-1000
            whitespaceLast = false;
            if (textTransform == 3) {
                c = Character.toUpperCase(c);
                buf.appendCodePoint(c);
            } else lbl-1000:
            // 2 sources

            {
                if (textTransform == 2) {
                    c = Character.toUpperCase(c);
                } else if (textTransform == 1) {
                    c = Character.toLowerCase(c);
                }
lbl23:
                // 5 sources

                buf.appendCodePoint(c);
            }
            i = text.offsetByCodePoints(i, 1);
        }
    }

    /*
     * Unable to fully structure code
     */
    private static void appendNormalizedWhitespace(String text, boolean preserveNL, boolean firstText, short textTransform, StringBuilder buf) {
        whitespaceLast = firstText;
        buflen = buf.length();
        if (buflen != 0 && Character.isWhitespace(c = buf.charAt(buflen - 1)) && (!preserveNL || c != '\n')) {
            whitespaceLast = true;
        }
        len = text.length();
        i = 0;
        while (i < len) {
            block14: {
                block13: {
                    cp = text.codePointAt(i);
                    if (!Character.isWhitespace(cp)) break block13;
                    if (!preserveNL || cp != 10) {
                        if (!whitespaceLast) {
                            whitespaceLast = true;
                            buf.append(' ');
                        }
                    } else {
                        if (whitespaceLast) {
                            buflenM1 = buf.length() - 1;
                            b = buf.charAt(buflenM1);
                            if (b != '\n') {
                                buf.setLength(buflenM1);
                            }
                        } else {
                            whitespaceLast = true;
                        }
                        buf.appendCodePoint(cp);
                    }
                    break block14;
                }
                if (!whitespaceLast) ** GOTO lbl-1000
                whitespaceLast = false;
                if (textTransform == 3) {
                    cp = Character.toUpperCase(cp);
                    buf.appendCodePoint(cp);
                } else lbl-1000:
                // 2 sources

                {
                    if (textTransform == 2) {
                        cp = Character.toUpperCase(cp);
                    } else if (textTransform == 1) {
                        cp = Character.toLowerCase(cp);
                    }
                    buf.appendCodePoint(cp);
                }
            }
            i = text.offsetByCodePoints(i, 1);
        }
    }

    void trimBuffer(boolean lastTextPreserved, StringBuilder buf) {
        int buflenM1;
        if (!lastTextPreserved && (buflenM1 = buf.length() - 1) != -1 && buf.charAt(buflenM1) == ' ') {
            buf.setLength(buflenM1);
        }
    }

    @Override
    public SelectorMatcher getSelectorMatcher() {
        SelectorMatcher matcher = null;
        if (this.selectorMatcherRef != null) {
            matcher = (SelectorMatcher)this.selectorMatcherRef.get();
        }
        if (matcher == null) {
            matcher = new DOMSelectorMatcher(this);
            this.selectorMatcherRef = new WeakReference<SelectorMatcher>(matcher);
        }
        return matcher;
    }

    @Override
    public boolean matches(String selectorString, String pseudoElement) throws DOMException {
        Condition peCond;
        SelectorList list;
        CSSParser parser = new CSSParser();
        try {
            list = parser.parseSelectors(new StringReader(selectorString));
        }
        catch (Exception e) {
            throw new DOMException(12, "Unable to parse selector in: " + selectorString);
        }
        if (pseudoElement != null) {
            try {
                peCond = parser.parsePseudoElement(pseudoElement);
            }
            catch (Exception e) {
                throw new DOMException(12, "Unable to parse pseudo-element in: " + pseudoElement);
            }
        } else {
            peCond = null;
        }
        return this.matches(list, peCond);
    }

    @Override
    public boolean matches(SelectorList selist, Condition pseudoElement) {
        SelectorMatcher matcher = this.getSelectorMatcher();
        matcher.setPseudoElement(pseudoElement);
        return matcher.matches(selist) != -1;
    }

    @Override
    public CSSStyleDeclaration getStyle() {
        DOMDocument.StyleAttr styleAttr = (DOMDocument.StyleAttr)this.getAttributeNode("style");
        if (styleAttr == null) {
            if (this.getOwnerDocument().getComplianceMode() == CSSDocument.ComplianceMode.QUIRKS) {
                for (Attr node : this.getAttributes()) {
                    if (!"style".equalsIgnoreCase(node.getNodeName())) continue;
                    return ((DOMDocument.StyleAttr)node).getStyle();
                }
            }
            return null;
        }
        return styleAttr.getStyle();
    }

    @Override
    public boolean hasOverrideStyle(Condition pseudoElt) {
        if (this.overrideStyleSet == null) {
            return false;
        }
        return this.overrideStyleSet.containsKey(pseudoElt);
    }

    @Override
    public CSSStyleDeclaration getOverrideStyle(Condition pseudoElt) {
        CSSStyleDeclaration overrideStyle = null;
        if (this.overrideStyleSet == null) {
            this.overrideStyleSet = new HashMap<Condition, CSSStyleDeclaration>(1);
        } else {
            overrideStyle = this.overrideStyleSet.get(pseudoElt);
        }
        if (overrideStyle == null) {
            overrideStyle = this.getOwnerDocument().getStyleSheetFactory().createInlineStyle(this);
            this.overrideStyleSet.put(pseudoElt, overrideStyle);
        }
        return overrideStyle;
    }

    @Override
    public boolean hasPresentationalHints() {
        return false;
    }

    @Override
    public void exportHintsToStyle(CSSStyleDeclaration style) {
    }

    @Override
    public ComputedCSSStyle getComputedStyle(String pseudoElt) {
        Condition peCond;
        if (pseudoElt != null) {
            CSSParser parser = new CSSParser();
            peCond = parser.parsePseudoElement(pseudoElt);
        } else {
            peCond = null;
        }
        return (ComputedCSSStyle)this.getOwnerDocument().getStyleSheet().getComputedStyle(this, peCond);
    }

    @Override
    public abstract DOMElement cloneNode(boolean var1);

    abstract boolean isNonHTMLOrVoid();

    abstract CSSStyleSheetFactory getStyleSheetFactory();

    public String getStartTag() {
        StringBuilder buf = new StringBuilder(128);
        buf.append('<').append(this.getTagName());
        if (this.nodeMap.getLength() > 0) {
            buf.append(' ');
            this.nodeMap.appendTo(buf);
        }
        if (this.hasChildNodes()) {
            buf.append('>');
        } else {
            buf.append(" />");
        }
        return buf.toString();
    }

    public String toString() {
        int bufsz = 32;
        if (this.hasChildNodes()) {
            bufsz = 720;
        } else if (this.hasAttributes()) {
            bufsz = 128;
        }
        String tagname = this.getTagName();
        StringBuilder buf = new StringBuilder(bufsz);
        buf.append('<').append(tagname);
        if (this.nodeMap.getLength() > 0) {
            buf.append(' ');
            this.nodeMap.appendTo(buf);
        }
        if (this.hasChildNodes() || !this.isNonHTMLOrVoid()) {
            buf.append('>');
            if (this.hasChildNodes()) {
                DOMNodeList list = this.getChildNodes();
                for (int i = 0; i < list.getLength(); ++i) {
                    buf.append(list.item(i).toString());
                }
            }
            buf.append("</").append(tagname).append('>');
        } else {
            if (this.getNamespaceURI() == "http://www.w3.org/1999/xhtml") {
                buf.append(' ');
            }
            buf.append("/>");
        }
        return buf.toString();
    }

    @Override
    public TypeInfo getSchemaTypeInfo() {
        if (this.schemaTypeInfo == null) {
            this.schemaTypeInfo = new ElementTypeInfo();
        }
        return this.schemaTypeInfo;
    }

    class ClassList
    extends DOMTokenSetImpl {
        private static final long serialVersionUID = 1L;

        ClassList() {
        }

        @Override
        public void setValue(String value) throws DOMException {
            if (value == null || value.length() == 0) {
                this.clear();
                value = "";
            }
            super.setValue(value);
        }

        @Override
        protected void addUnchecked(String token) throws DOMException {
            super.addUnchecked(token);
            if (!DOMElement.this.nodeMap.hasAttribute("class")) {
                DOMAttr attr = (DOMAttr)DOMElement.this.getOwnerDocument().createAttributeNS(null, "class");
                attr.setValue(token);
                DOMElement.this.nodeMap.setNamedItem(attr);
                attr.setAttributeOwner(DOMElement.this);
            }
        }
    }

    class MyNamedNodeMap
    extends DOMNamedNodeMap<DOMAttr>
    implements AttributeNamedNodeMap {
        private static final long serialVersionUID = 1L;

        MyNamedNodeMap() {
            super((short)2);
        }

        @Override
        public Iterator<Attr> iterator() {
            return this.getNodeList().attributeIterator();
        }

        @Override
        void registerNode(DOMAttr arg) {
            arg.setAttributeOwner(DOMElement.this);
        }

        @Override
        void unregisterNode(DOMAttr removedItem) {
            removedItem.setAttributeOwner(null);
        }

        @Override
        void verifyNewNode(Node arg) throws DOMException {
            super.verifyNewNode(arg);
            Element owner = ((Attr)arg).getOwnerElement();
            if (owner != null && owner != DOMElement.this) {
                throw new DOMException(10, "Attribute is already in use.");
            }
        }

        @Override
        DOMElement getOwnerNode() {
            return DOMElement.this;
        }
    }

    class QuirksClassList
    extends ClassList {
        private static final long serialVersionUID = 1L;

        QuirksClassList() {
        }

        @Override
        public void setValue(String value) throws DOMException {
            if (value != null) {
                value = value.toLowerCase(Locale.ROOT);
            }
            super.setValue(value);
        }

        @Override
        public boolean contains(String token) {
            if (token == null) {
                return false;
            }
            token = token.toLowerCase(Locale.ROOT);
            return super.contains(token);
        }

        @Override
        public void add(String token) throws DOMException {
            this.argumentCheckVoidSpaces(token);
            token = token.toLowerCase(Locale.ROOT);
            this.addUnchecked(token);
        }

        @Override
        public void remove(String token) throws DOMException {
            this.argumentCheckVoidSpaces(token);
            token = token.toLowerCase(Locale.ROOT);
            this.removeUnchecked(token);
        }

        @Override
        public boolean toggle(String token) throws DOMException {
            this.argumentCheckVoidSpaces(token);
            token = token.toLowerCase(Locale.ROOT);
            return this.toggleUnchecked(token);
        }

        @Override
        public void replace(String oldToken, String newToken) throws DOMException {
            this.argumentCheckVoidSpaces(oldToken);
            this.argumentCheckVoidSpaces(newToken);
            oldToken = oldToken.toLowerCase(Locale.ROOT);
            newToken = newToken.toLowerCase(Locale.ROOT);
            this.replaceUnchecked(oldToken, newToken);
        }
    }

    static class ElementTypeInfo
    extends DOMTypeInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;

        ElementTypeInfo() {
        }

        @Override
        public String getTypeNamespace() {
            return null;
        }
    }
}

