/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.dom;

import io.sf.carte.doc.DOMPolicyException;
import io.sf.carte.doc.agent.DeviceFactory;
import io.sf.carte.doc.dom.AbstractDOMNode;
import io.sf.carte.doc.dom.CSSDOMConfiguration;
import io.sf.carte.doc.dom.CSSDOMImplementation;
import io.sf.carte.doc.dom.DOMAttr;
import io.sf.carte.doc.dom.DOMElement;
import io.sf.carte.doc.dom.DOMNode;
import io.sf.carte.doc.dom.DOMNodeList;
import io.sf.carte.doc.dom.DOMParentNode;
import io.sf.carte.doc.dom.DefaultNodeList;
import io.sf.carte.doc.dom.DocumentTypeImpl;
import io.sf.carte.doc.dom.ElementList;
import io.sf.carte.doc.dom.ExtendedNodeList;
import io.sf.carte.doc.dom.NDTNode;
import io.sf.carte.doc.dom.NodeFilter;
import io.sf.carte.doc.dom.NodeIterator;
import io.sf.carte.doc.dom.NodeIteratorImpl;
import io.sf.carte.doc.dom.StyleDefinerElementHelper;
import io.sf.carte.doc.dom.TreeWalker;
import io.sf.carte.doc.dom.TreeWalkerImpl;
import io.sf.carte.doc.style.css.CSSCanvas;
import io.sf.carte.doc.style.css.CSSDocument;
import io.sf.carte.doc.style.css.CSSMediaException;
import io.sf.carte.doc.style.css.CSSPropertyDefinition;
import io.sf.carte.doc.style.css.DocumentCSSStyleSheet;
import io.sf.carte.doc.style.css.ErrorHandler;
import io.sf.carte.doc.style.css.LinkStyle;
import io.sf.carte.doc.style.css.MediaQueryList;
import io.sf.carte.doc.style.css.SheetErrorHandler;
import io.sf.carte.doc.style.css.StyleDatabase;
import io.sf.carte.doc.style.css.StyleDeclarationErrorHandler;
import io.sf.carte.doc.style.css.nsac.CSSBudgetException;
import io.sf.carte.doc.style.css.om.AbstractCSSRule;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheetFactory;
import io.sf.carte.doc.style.css.om.BaseCSSStyleSheetFactory;
import io.sf.carte.doc.style.css.om.BaseDocumentCSSStyleSheet;
import io.sf.carte.doc.style.css.om.DOMUtil;
import io.sf.carte.doc.style.css.om.DefaultErrorHandler;
import io.sf.carte.doc.style.css.om.MediaFactory;
import io.sf.carte.doc.style.css.om.StyleSheetList;
import io.sf.carte.doc.xml.dtd.ContentModel;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMStringList;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public abstract class DOMDocument
extends DOMParentNode
implements CSSDocument {
    private static final long serialVersionUID = 2L;
    static final String XMLNS_NAMESPACE_URI = "http://www.w3.org/2000/xmlns/";
    static final String XML_NAMESPACE_URI = "http://www.w3.org/XML/1998/namespace";
    private boolean strictErrorChecking = true;
    CSSDOMConfiguration domConfig = new CSSDOMConfiguration();
    private String documentURI = null;
    final Set<LinkStyleDefiner> linkedStyle = new LinkedHashSet<LinkStyleDefiner>(4);
    final Set<LinkStyleDefiner> embeddedStyle = new LinkedHashSet<LinkStyleDefiner>(3);
    private Set<CSSPropertyDefinition> registeredPropertySet = null;
    private BaseDocumentCSSStyleSheet mergedStyleSheet = null;
    private final MyOMStyleSheetList sheets = new MyOMStyleSheetList(7);
    private final ErrorHandler errorHandler = this.createErrorHandler();
    private String metaDefaultStyleSet = "";
    private String metaReferrerPolicy = "";
    private String lastStyleSheetSet = null;
    private String targetMedium = null;
    private final Map<String, CSSCanvas> canvases = new HashMap<String, CSSCanvas>(3);

    public DOMDocument(DocumentType documentType) {
        super((short)9);
        if (documentType != null && documentType.getOwnerDocument() == null) {
            DocumentTypeImpl doctype = (DocumentTypeImpl)documentType;
            this.getNodeList().add(doctype);
            doctype.setParentNode(this);
        }
    }

    @Override
    public String getCompatMode() {
        DocumentType doctype = this.getDoctype();
        if (doctype != null) {
            return "CSS1Compat";
        }
        return "BackCompat";
    }

    @Override
    public CSSDocument.ComplianceMode getComplianceMode() {
        DocumentType doctype = this.getDoctype();
        if (doctype != null) {
            return CSSDocument.ComplianceMode.STRICT;
        }
        return CSSDocument.ComplianceMode.QUIRKS;
    }

    @Override
    public DOMElement getDocumentElement() {
        return this.getLastElementChild();
    }

    @Override
    public DocumentType getDoctype() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 10) continue;
            return (DocumentType)node;
        }
        return null;
    }

    @Override
    public String getNodeName() {
        return "#document";
    }

    @Override
    public DOMDocument getOwnerDocument() {
        return null;
    }

    @Override
    public DOMNode getParentNode() {
        return null;
    }

    @Override
    public boolean isVisitedURI(String href) {
        return false;
    }

    @Override
    public DOMDocument cloneNode(boolean deep) {
        boolean hasDocType;
        DocumentType docType = this.getDoctype();
        boolean bl = hasDocType = docType != null;
        if (hasDocType) {
            docType = (DocumentType)docType.cloneNode(deep);
        }
        DOMDocument doc = this.cloneDocument(docType);
        if (deep) {
            boolean foundDoctype = !hasDocType;
            for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (node.getNodeType() != 10) {
                    if (foundDoctype) {
                        doc.appendChild(doc.importNode(node, true));
                        continue;
                    }
                    doc.insertBefore(doc.importNode(node, true), docType);
                    continue;
                }
                foundDoctype = true;
            }
        } else if (hasDocType) {
            doc.removeChild(docType);
        }
        DOMDocument.callUserHandlers((short)1, this, doc);
        return doc;
    }

    DOMDocument cloneDocument(DocumentType docType) {
        String nsUri = null;
        String qName = null;
        DOMElement docElm = this.getDocumentElement();
        if (docElm != null) {
            nsUri = docElm.getNamespaceURI();
            qName = docElm.getTagName();
        }
        if (!(nsUri != null || "html".equals(qName) || docType != null && "html".equalsIgnoreCase(docType.getName()))) {
            nsUri = "";
        }
        DOMDocument doc = this.getImplementation().createDocument(nsUri, qName, docType);
        if (docElm != null) {
            doc.removeChild(doc.getDocumentElement());
        }
        return doc;
    }

    @Override
    public abstract CSSDOMImplementation getImplementation();

    protected abstract CSSDOMImplementation getStyleSheetFactory();

    MediaQueryList parseMediaList(String media, Node node) {
        MediaQueryList mediaList;
        if (media.length() == 0) {
            mediaList = MediaFactory.createImmutable();
        } else {
            try {
                mediaList = this.getStyleSheetFactory().createImmutableMediaQueryList(media, node);
            }
            catch (CSSBudgetException e) {
                this.getErrorHandler().linkedStyleError(node, e.getMessage());
                return null;
            }
            if (mediaList.isNotAllMedia() && mediaList.hasErrors()) {
                return null;
            }
        }
        return mediaList;
    }

    AbstractCSSStyleSheet loadStyleSheet(AbstractCSSStyleSheet sheet, String href, String title, MediaQueryList media, Node ownerNode) {
        if (sheet == null) {
            sheet = this.getStyleSheetFactory().createLinkedStyleSheet(ownerNode, title, media);
        } else {
            CSSDOMImplementation.MyCSSStyleSheet mysheet = (CSSDOMImplementation.MyCSSStyleSheet)sheet;
            mysheet.setTitle(title);
            mysheet.setMedia(media);
            mysheet.getCssRules().clear();
        }
        String referrerPolicy = this.getReferrerpolicyAttribute(ownerNode);
        try {
            URL url = this.getURL(href);
            if (this.isAuthorizedOrigin(url)) {
                sheet.setHref(url.toExternalForm());
                sheet.loadStyleSheet(url, referrerPolicy);
            } else {
                this.getErrorHandler().policyError(ownerNode, "Unauthorized URL: " + url.toExternalForm());
            }
        }
        catch (IOException e) {
            this.getErrorHandler().ioError(href, e);
        }
        catch (DOMPolicyException e) {
            sheet = null;
        }
        catch (DOMException e) {
        }
        catch (Exception e) {
            this.getErrorHandler().linkedSheetError(e, sheet);
        }
        return sheet;
    }

    private String getReferrerpolicyAttribute(Node node) {
        Node rp;
        NamedNodeMap nnm = node.getAttributes();
        if (nnm != null && (rp = nnm.getNamedItem("referrerpolicy")) != null) {
            return rp.getNodeValue();
        }
        return "";
    }

    AbstractCSSStyleSheet parseEmbeddedStyleSheet(AbstractCSSStyleSheet sheet, String styleText, String title, MediaQueryList media, Node ownerNode) {
        if (sheet == null) {
            sheet = this.getStyleSheetFactory().createLinkedStyleSheet(ownerNode, title, media);
        } else {
            CSSDOMImplementation.MyCSSStyleSheet mysheet = (CSSDOMImplementation.MyCSSStyleSheet)sheet;
            mysheet.setTitle(title);
            mysheet.setMedia(media);
            mysheet.getCssRules().clear();
        }
        sheet.setHref(this.getBaseURI());
        if (styleText.length() != 0) {
            StringReader re = new StringReader(styleText);
            try {
                sheet.parseStyleSheet(re);
            }
            catch (Exception e) {
                this.getErrorHandler().linkedSheetError(e, sheet);
            }
        } else {
            sheet.getCssRules().clear();
        }
        return sheet;
    }

    LinkStyleDefiner getEmbeddedStyleDefiner(DOMElement element) {
        if (element != null) {
            return this.getEmbeddedStyleDefiner(element.getId());
        }
        return null;
    }

    static boolean isValidName(String name) {
        int len = name.length();
        if (len == 0) {
            return false;
        }
        if (!DOMDocument.isValidStartCharacter(name.codePointAt(0))) {
            return false;
        }
        int i = name.offsetByCodePoints(0, 1);
        while (i < len) {
            if (!DOMDocument.isValidCharacter(name.codePointAt(i))) {
                return false;
            }
            i = name.offsetByCodePoints(i, 1);
        }
        return true;
    }

    private static boolean isValidCharacter(int cp) {
        return cp >= 97 && cp <= 122 || cp >= 65 && cp <= 90 || cp >= 48 && cp <= 57 || cp == 45 || cp == 95 || cp == 46 || cp == 183 || cp >= 192 && cp <= 214 || cp >= 216 && cp <= 246 || cp >= 248 && cp <= 767 || cp >= 768 && cp <= 893 || cp >= 895 && cp <= 8191 || cp >= 8204 && cp <= 8205 || cp >= 8255 && cp <= 8256 || cp >= 8304 && cp <= 8591 || cp >= 11264 && cp <= 12271 || cp >= 12289 && cp <= 55295 || cp >= 63744 && cp <= 64975 || cp >= 65008 && cp <= 65533 || cp >= 65536 && cp <= 983039;
    }

    private static boolean isValidStartCharacter(int cp) {
        return cp >= 97 && cp <= 122 || cp >= 65 && cp <= 90 || cp == 95 || cp >= 192 && cp <= 214 || cp >= 216 && cp <= 246 || cp >= 248 && cp <= 767 || cp >= 880 && cp <= 893 || cp >= 895 && cp <= 8191 || cp >= 8204 && cp <= 8205 || cp >= 8304 && cp <= 8591 || cp >= 11264 && cp <= 12271 || cp >= 12289 && cp <= 55295 || cp >= 63744 && cp <= 64975 || cp >= 65008 && cp <= 65533 || cp >= 65536 && cp <= 983039;
    }

    static String escapeCloseTag(String tagname, String data) {
        int idx = data.indexOf(60);
        if (idx == -1) {
            return data;
        }
        int tnidx = data.indexOf(tagname, 2);
        if (tnidx == -1) {
            return data;
        }
        StringBuilder buf = null;
        int tnlen = tagname.length();
        int lenm1 = data.length() - 1;
        while (idx < lenm1) {
            int i;
            char d;
            char c = data.charAt(idx);
            if (c == '<' && (d = data.charAt(i = idx + 1)) == '/' && lenm1 - i > tnlen) {
                ++i;
                if ((i = DOMDocument.skipIgnorableChars(i, data, lenm1)) < lenm1 && data.regionMatches(true, i, tagname, 0, tnlen) && (i = DOMDocument.skipIgnorableChars(i + tnlen, data, lenm1)) <= lenm1 && data.charAt(i) == '>') {
                    if (buf == null) {
                        buf = new StringBuilder(lenm1 + 4);
                        buf.append(data.subSequence(0, idx));
                    }
                    buf.append("&lt;");
                    buf.append(data.subSequence(idx + 1, i + 1));
                    idx = i + 1;
                    continue;
                }
            }
            if (buf != null) {
                buf.append(c);
            }
            ++idx;
        }
        if (buf != null && idx == lenm1) {
            buf.append(data.charAt(idx));
        }
        return buf == null ? data : buf.toString();
    }

    private static int skipIgnorableChars(int idx, String text, int lenm1) {
        while (idx < lenm1) {
            char c = text.charAt(idx);
            if (c != ' ' && c != '\t' && c != '\n') {
                if (c != '\r') break;
                int i = idx + 1;
                if (text.charAt(i) == '\n') {
                    idx = i;
                }
            }
            ++idx;
        }
        return idx;
    }

    static String escapeLtGtEntities(String text) {
        StringBuilder buf = null;
        int len = text.length();
        for (int i = 0; i < len; ++i) {
            char c = text.charAt(i);
            if (c == '<') {
                buf = DOMDocument.appendEntityToBuffer(buf, "lt", text, i, len);
                continue;
            }
            if (c == '>') {
                buf = DOMDocument.appendEntityToBuffer(buf, "gt", text, i, len);
                continue;
            }
            if (buf == null) continue;
            buf.append(c);
        }
        if (buf != null) {
            text = buf.toString();
        }
        return text;
    }

    static StringBuilder appendEntityToBuffer(StringBuilder buf, String string, String text, int index, int inilen) {
        if (buf == null) {
            buf = new StringBuilder(inilen + string.length() + 2);
            buf.append(text.subSequence(0, index));
        }
        buf.append('&').append(string).append(';');
        return buf;
    }

    boolean isIdAttribute(String localName) {
        if (this.getComplianceMode() == CSSDocument.ComplianceMode.STRICT) {
            return "id".equals(localName);
        }
        return "id".equalsIgnoreCase(localName);
    }

    @Override
    public DOMElement createElement(String tagName) throws DOMException {
        if (tagName == null) {
            throw new DOMException(5, "null tag name");
        }
        return this.createElementNS(null, tagName);
    }

    @Override
    public DOMElement createElementNS(String namespaceURI, String qualifiedName) throws DOMException {
        String localName;
        if (qualifiedName == null) {
            throw new DOMException(5, "null qualified name");
        }
        String prefix = null;
        if (namespaceURI != null) {
            if (namespaceURI.length() == 0) {
                namespaceURI = null;
                localName = qualifiedName.toLowerCase(Locale.ROOT);
            } else {
                namespaceURI = namespaceURI.intern();
                int idx = qualifiedName.indexOf(58);
                if (idx == -1) {
                    prefix = this.lookupPrefix(namespaceURI);
                    localName = qualifiedName;
                } else {
                    if (idx == qualifiedName.length() - 1) {
                        throw new DOMException(5, "Empty local name");
                    }
                    if (idx == 0) {
                        throw new DOMException(5, "Empty prefix");
                    }
                    prefix = qualifiedName.substring(0, idx).intern();
                    localName = qualifiedName.substring(idx + 1);
                }
            }
        } else {
            if (qualifiedName.indexOf(58) != -1) {
                throw new DOMException(14, "Prefix with null namespace");
            }
            localName = qualifiedName.toLowerCase(Locale.ROOT);
        }
        if (!DOMDocument.isValidName(localName)) {
            throw new DOMException(5, "Invalid name: " + localName);
        }
        MyXMLElement myelem = !"style".equals(localName) ? new MyXMLElement(localName, namespaceURI) : new StyleElement(namespaceURI);
        if (prefix != null) {
            myelem.setPrefix(prefix);
        }
        return myelem;
    }

    @Override
    public DocumentFragment createDocumentFragment() {
        return new DOMDocumentFragment();
    }

    @Override
    public Text createTextNode(String data) {
        if (data == null) {
            throw new DOMException(5, "null data");
        }
        MyText text = new MyText();
        text.setData(data);
        return text;
    }

    @Override
    public Comment createComment(String data) {
        if (data == null) {
            throw new DOMException(5, "null data");
        }
        MyComment my = new MyComment();
        my.setData(data);
        return my;
    }

    @Override
    public CDATASection createCDATASection(String data) throws DOMException {
        if (data == null) {
            throw new DOMException(5, "null data");
        }
        MyCDATASection my = new MyCDATASection();
        my.setData(data);
        return my;
    }

    @Override
    public ProcessingInstruction createProcessingInstruction(String target, String data) throws DOMException {
        if (target == null || target.length() == 0) {
            throw new DOMException(5, "Void target");
        }
        if (target.equalsIgnoreCase("xml")) {
            throw new DOMException(5, "An xml declaration is not a processing instruction");
        }
        if (!DOMDocument.isValidName(target)) {
            throw new DOMException(5, "Invalid target: " + target);
        }
        if (data.contains("?>")) {
            throw new DOMException(5, "A processing instruction data cannot contain a '?>'");
        }
        if ("xml-stylesheet".equals(target)) {
            return new MyStyleProcessingInstruction(data);
        }
        return new MyProcessingInstruction(target, data);
    }

    @Override
    public EntityReference createEntityReference(String name) throws DOMException {
        if (name == null) {
            throw new DOMException(5, "null entity reference name");
        }
        return new MyEntityReference(name);
    }

    @Override
    public Attr createAttribute(String name) throws DOMException {
        return this.createAttributeNS(null, name);
    }

    @Override
    public Attr createAttributeNS(String namespaceURI, String qualifiedName) throws DOMException {
        if (qualifiedName == null) {
            throw new DOMException(5, "null name");
        }
        String localName = qualifiedName;
        String prefix = null;
        if (namespaceURI != null) {
            if (namespaceURI.length() != 0) {
                namespaceURI = namespaceURI.intern();
                int idx = qualifiedName.indexOf(58);
                if (idx == -1) {
                    prefix = this.lookupPrefix(namespaceURI);
                } else {
                    if (idx == qualifiedName.length() - 1) {
                        throw new DOMException(14, "Empty local name");
                    }
                    if (idx == 0) {
                        throw new DOMException(14, "Empty prefix");
                    }
                    prefix = qualifiedName.substring(0, idx).intern();
                    localName = qualifiedName.substring(idx + 1);
                }
                if ("http://www.w3.org/1999/xhtml" == namespaceURI) {
                    localName = localName.toLowerCase(Locale.ROOT);
                }
            } else {
                if (qualifiedName.indexOf(58) != -1) {
                    throw new DOMException(14, "Prefix with null namespace");
                }
                namespaceURI = null;
            }
        } else if (qualifiedName.indexOf(58) != -1) {
            throw new DOMException(14, "Prefix with null namespace");
        }
        Attr my = this.createAttributeNS(namespaceURI, prefix, localName);
        return my;
    }

    Attr createAttributeNS(String namespaceURI, String prefix, String localName) throws DOMException {
        MyAttr my;
        if (!DOMDocument.isValidName(localName)) {
            throw new DOMException(5, "Invalid name: " + localName);
        }
        if ("xmlns".equals(localName)) {
            if (namespaceURI != null && !XMLNS_NAMESPACE_URI.equals(namespaceURI)) {
                throw new DOMException(14, "xmlns local name but not xmlns namespace");
            }
            my = new XmlnsAttr();
        } else {
            my = "class".equals(localName) ? new ClassAttr(namespaceURI) : ("base".equals(localName) && "xml".equals(prefix) ? new BaseEventAttr() : ("style".equals(localName) && prefix == null ? new MyStyleAttr(localName) : ("media".equals(localName) || "type".equals(localName) || "crossorigin".equals(localName) ? new StyleEventAttr(localName, namespaceURI) : new MyAttr(localName, namespaceURI))));
        }
        if (prefix != null) {
            my.setPrefix(prefix);
        }
        return my;
    }

    public NodeIterator createNodeIterator(Node rootNode, int whatToShow, NodeFilter filter) {
        return new NodeIteratorImpl((AbstractDOMNode)rootNode, whatToShow, filter);
    }

    public TreeWalker createTreeWalker(Node rootNode, int whatToShow, NodeFilter filter) {
        return new TreeWalkerImpl((AbstractDOMNode)rootNode, whatToShow, filter);
    }

    @Override
    public ElementList getElementsByClassName(String names) {
        return this.getNodeList().getElementsByClassName(names, this.getComplianceMode());
    }

    @Override
    public String lookupPrefix(String namespaceURI) {
        DOMElement html = this.getDocumentElement();
        if (html == null) {
            return null;
        }
        return this.lookupPrefix(html, namespaceURI);
    }

    private String lookupPrefix(Node node, String namespaceURI) {
        if (node.getNamespaceURI() == namespaceURI) {
            String prefix = node.getPrefix();
            return prefix;
        }
        for (Node cnode = node.getFirstChild(); cnode != null; cnode = cnode.getNextSibling()) {
            String prefix;
            if (cnode.getNodeType() != 1 || (prefix = this.lookupPrefix(cnode, namespaceURI)) == null) continue;
            return prefix;
        }
        return null;
    }

    @Override
    public DOMElement getElementById(String elementId) {
        return this.findElementById(this.getFirstChild(), elementId);
    }

    private DOMElement findElementById(Node node, String elementId) {
        while (node != null) {
            DOMElement elm;
            String idValue;
            if (node.getNodeType() == 1 && (idValue = (elm = (DOMElement)node).getId()).equals(elementId)) {
                return elm;
            }
            elm = this.findElementById(node.getFirstChild(), elementId);
            if (elm != null) {
                return elm;
            }
            node = node.getNextSibling();
        }
        return null;
    }

    @Override
    public String getInputEncoding() {
        return null;
    }

    @Override
    @Deprecated
    public String getXmlEncoding() {
        return null;
    }

    @Override
    @Deprecated
    public boolean getXmlStandalone() {
        return false;
    }

    @Override
    @Deprecated
    public void setXmlStandalone(boolean xmlStandalone) throws DOMException {
    }

    @Override
    @Deprecated
    public String getXmlVersion() {
        return null;
    }

    @Override
    @Deprecated
    public void setXmlVersion(String xmlVersion) throws DOMException {
    }

    @Override
    public boolean getStrictErrorChecking() {
        return this.strictErrorChecking;
    }

    @Override
    public void setStrictErrorChecking(boolean strictErrorChecking) {
        this.strictErrorChecking = strictErrorChecking;
    }

    @Override
    public String getDocumentURI() {
        return this.documentURI;
    }

    @Override
    public void setDocumentURI(String documentURI) {
        this.documentURI = documentURI;
        if (!this.linkedStyle.isEmpty()) {
            this.onBaseModify();
        }
    }

    @Override
    public Node importNode(Node importedNode, boolean deep) throws DOMException {
        switch (importedNode.getNodeType()) {
            case 2: {
                Attr importedAttr = (Attr)importedNode;
                DOMAttr attr = (DOMAttr)this.createAttributeNS(importedAttr.getNamespaceURI(), importedAttr.getNodeName());
                attr.specified = importedAttr.getSpecified();
                attr.setValue(importedNode.getNodeValue());
                return attr;
            }
            case 1: {
                Element foreignElm = (Element)importedNode;
                DOMElement elm = this.createElementNS(foreignElm.getNamespaceURI(), foreignElm.getNodeName());
                if (foreignElm.hasAttributes()) {
                    NamedNodeMap attributes = foreignElm.getAttributes();
                    int count = attributes.getLength();
                    for (int i = 0; i < count; ++i) {
                        Attr importedAttr = (Attr)attributes.item(i);
                        DOMAttr attr = (DOMAttr)this.importNode(importedAttr, true);
                        attr.specified = importedAttr.getSpecified();
                        elm.setAttributeNode(attr);
                    }
                }
                if (deep) {
                    for (Node node = importedNode.getFirstChild(); node != null; node = node.getNextSibling()) {
                        elm.appendChild(this.importNode(node, true));
                    }
                }
                return elm;
            }
            case 3: {
                return this.createTextNode(importedNode.getNodeValue());
            }
            case 4: {
                return this.createCDATASection(importedNode.getNodeValue());
            }
            case 8: {
                return this.createComment(importedNode.getNodeValue());
            }
            case 11: {
                DocumentFragment df = this.createDocumentFragment();
                if (deep) {
                    for (Node node = importedNode.getFirstChild(); node != null; node = node.getNextSibling()) {
                        df.appendChild(this.importNode(node, true));
                    }
                }
                return df;
            }
            case 5: {
                return this.createEntityReference(importedNode.getNodeName());
            }
            case 7: {
                return this.createProcessingInstruction(importedNode.getNodeName(), importedNode.getNodeValue());
            }
        }
        throw new DOMException(9, "Cannot import this node type.");
    }

    @Override
    public Node adoptNode(Node source) throws DOMException {
        throw new DOMException(9, "Node adoption not supported");
    }

    @Override
    public DOMNode insertBefore(Node newChild, Node refChild) throws DOMException {
        block3: {
            short newType;
            block2: {
                newType = newChild.getNodeType();
                if (newType != 1) break block2;
                for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
                    if (node.getNodeType() != 1) continue;
                    throw new DOMException(3, "Document already has a root element.");
                }
                break block3;
            }
            if (newType != 10) break block3;
            for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (node.getNodeType() != 10) continue;
                throw new DOMException(3, "Document already has a doctype.");
            }
        }
        return super.insertBefore(newChild, refChild);
    }

    @Override
    public DOMNode replaceChild(Node newChild, Node oldChild) throws DOMException {
        block2: {
            short newType;
            block3: {
                newType = newChild.getNodeType();
                if (newType == oldChild.getNodeType()) break block2;
                if (newType != 1) break block3;
                for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
                    if (node.getNodeType() != 1) continue;
                    throw new DOMException(3, "Document already has a root element.");
                }
                break block2;
            }
            if (newType != 10) break block2;
            for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (node.getNodeType() != 10) continue;
                throw new DOMException(3, "Document already has a doctype.");
            }
        }
        return super.replaceChild(newChild, oldChild);
    }

    @Override
    void preAddChild(Node newChild) {
        block3: {
            block2: {
                super.preAddChild(newChild);
                if (newChild.getNodeType() != 1) break block2;
                for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
                    if (node.getNodeType() != 1) continue;
                    throw new DOMException(3, "Document already has a root element.");
                }
                break block3;
            }
            if (newChild.getNodeType() != 10) break block3;
            for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (node.getNodeType() != 10) continue;
                throw new DOMException(3, "Document already has a doctype.");
            }
        }
    }

    @Override
    void checkDocumentOwner(Node newChild) {
        if (newChild.getOwnerDocument() != this && newChild.getNodeType() != 10) {
            throw new DOMException(4, "Different document owners.");
        }
    }

    @Override
    void preReplaceChild(AbstractDOMNode newChild, AbstractDOMNode replaced) {
        block4: {
            block3: {
                super.preAddChild(newChild);
                if (newChild.getNodeType() != 1) break block3;
                if (replaced.getNodeType() == 1) break block4;
                for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
                    if (node.getNodeType() != 1) continue;
                    throw new DOMException(3, "Document already has a root element.");
                }
                break block4;
            }
            if (newChild.getNodeType() == 10 && replaced.getNodeType() != 10) {
                for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
                    if (node.getNodeType() != 10) continue;
                    throw new DOMException(3, "Document already has a doctype.");
                }
            }
        }
    }

    @Override
    void postAddChild(AbstractDOMNode newChild) {
        String data;
        super.postAddChild(newChild);
        if (newChild.getNodeType() == 7 && "xml-stylesheet".equals(newChild.getNodeName()) && (data = newChild.getNodeValue()) != null && data.contains("text/css")) {
            this.onSheetModify();
        }
    }

    @Override
    @Deprecated
    public Node renameNode(Node n, String namespaceURI, String qualifiedName) throws DOMException {
        throw new DOMException(9, "This operation is not supported.");
    }

    @Override
    public DOMConfiguration getDomConfig() {
        return this.domConfig;
    }

    @Override
    public void normalizeDocument() {
        DOMElement docelm = this.getDocumentElement();
        if (docelm != null) {
            docelm.normalize();
        }
    }

    @Override
    public String lookupNamespaceURI(String prefix) {
        DOMElement docelm = this.getDocumentElement();
        return docelm != null ? docelm.lookupNamespaceURI(prefix) : null;
    }

    @Override
    public boolean isDefaultNamespace(String namespaceURI) {
        DOMElement docelm = this.getDocumentElement();
        if (docelm != null) {
            return docelm.getNamespaceURI() == namespaceURI;
        }
        return namespaceURI == null;
    }

    boolean isHTML() {
        return false;
    }

    @Override
    public void registerProperty(CSSPropertyDefinition definition) {
        if (this.registeredPropertySet == null) {
            this.registeredPropertySet = new HashSet<CSSPropertyDefinition>();
        }
        this.registeredPropertySet.add(definition);
        this.mergedStyleSheet = null;
    }

    @Override
    public StyleSheetList getStyleSheets() {
        if (this.sheets.needsUpdate()) {
            this.sheets.update();
        }
        return this.sheets;
    }

    private void updateStyleLists() {
        this.linkedStyle.clear();
        for (LinkStyleDefiner linkStyleDefiner : this.getLinkedStyleNodeList()) {
            if (linkStyleDefiner.getSheet() == null) continue;
            this.linkedStyle.add(linkStyleDefiner);
        }
        this.embeddedStyle.clear();
        for (LinkStyleDefiner linkStyleDefiner : this.getEmbeddedStyleNodeList()) {
            this.embeddedStyle.add(linkStyleDefiner);
        }
        Iterator<LinkStyleDefiner> iterator = this.linkedStyle.iterator();
        while (iterator.hasNext()) {
            this.addLinkedSheet(iterator.next().getSheet());
        }
        Iterator<LinkStyleDefiner> embd = this.embeddedStyle.iterator();
        while (embd.hasNext()) {
            this.addLinkedSheet(embd.next().getSheet());
        }
        this.sheets.setNeedsUpdate(false);
        if (this.lastStyleSheetSet != null) {
            this.setSelectedStyleSheetSet(this.lastStyleSheetSet);
        } else if (this.metaDefaultStyleSet.length() > 0) {
            this.setSelectedStyleSheetSet(this.metaDefaultStyleSet);
            this.lastStyleSheetSet = null;
        } else {
            this.setSelectedStyleSheetSet(this.sheets.getPreferredStyleSheetSet());
            this.lastStyleSheetSet = null;
        }
        if (this.getCanvas() != null) {
            this.getCanvas().reloadStyleState();
        }
    }

    private void addLinkedSheet(AbstractCSSStyleSheet linkedSheet) {
        if (linkedSheet != null) {
            this.sheets.add(linkedSheet);
        }
    }

    ExtendedNodeList<? extends DOMNode> getLinkedStyleNodeList() {
        return this.getLinkedStyleNodeList(true);
    }

    ExtendedNodeList<? extends DOMNode> getEmbeddedStyleNodeList() {
        return this.getLinkedStyleNodeList(false);
    }

    private DOMNodeList getLinkedStyleNodeList(boolean external) {
        LinkedList list = null;
        AbstractDOMNode node = this.getNodeList().getFirst();
        while (node != null) {
            short type = node.getNodeType();
            if (type == 7 && "xml-stylesheet".equals(node.getNodeName())) {
                LinkStyleProcessingInstruction pi = (LinkStyleProcessingInstruction)((Object)node);
                String href = pi.getPseudoAttribute("href");
                if (href.length() > 1) {
                    if (href.charAt(0) == '#') {
                        if (!external) {
                            if (list == null) {
                                list = new DefaultNodeList();
                            }
                            list.add(node);
                        }
                    } else if (external) {
                        if (list == null) {
                            list = new DefaultNodeList();
                        }
                        list.add(node);
                    }
                }
            } else if (type == 1) break;
            node = node.nextSibling;
        }
        return list == null ? AbstractDOMNode.emptyNodeList : list;
    }

    LinkStyleDefiner getEmbeddedStyleDefiner(String id) {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            short type = node.getNodeType();
            if (type == 7 && "xml-stylesheet".equals(node.getNodeName())) {
                LinkStyleProcessingInstruction pi = (LinkStyleProcessingInstruction)node;
                String href = pi.getPseudoAttribute("href");
                if (href.length() <= 1 || href.charAt(0) != '#' || !id.equals(href.substring(1))) continue;
                return pi;
            }
            if (type == 1) break;
        }
        return null;
    }

    @Override
    public DocumentCSSStyleSheet getStyleSheet() {
        if (this.mergedStyleSheet == null) {
            this.mergeStyleSheets();
        }
        return this.mergedStyleSheet;
    }

    private void mergeStyleSheets() {
        this.getStyleSheets();
        BaseDocumentCSSStyleSheet defSheet = this.getStyleSheetFactory().getDefaultStyleSheet(this.getComplianceMode());
        this.mergedStyleSheet = this.targetMedium == null ? defSheet.clone() : defSheet.clone(this.targetMedium);
        this.mergedStyleSheet.setOwnerDocument(this);
        Iterator<AbstractCSSStyleSheet> it = this.sheets.iterator();
        while (it.hasNext()) {
            this.mergedStyleSheet.addStyleSheet(it.next());
        }
        if (this.registeredPropertySet != null) {
            for (CSSPropertyDefinition def : this.registeredPropertySet) {
                this.mergedStyleSheet.registerProperty(def);
            }
        }
    }

    @Override
    public DOMStringList getStyleSheetSets() {
        if (this.sheets.needsUpdate()) {
            this.sheets.update();
        }
        return this.sheets.getStyleSheetSets();
    }

    @Override
    public String getSelectedStyleSheetSet() {
        if (this.sheets.needsUpdate()) {
            this.sheets.update();
        }
        String selectedSetName = "";
        Iterator<LinkStyleDefiner> links = this.linkedStyle.iterator();
        while (links.hasNext()) {
            String title;
            AbstractCSSStyleSheet sheet = links.next().getSheet();
            if (sheet == null || (title = sheet.getTitle()) == null || title.length() <= 0 || sheet.getDisabled()) continue;
            if (selectedSetName.length() > 0) {
                if (selectedSetName.equalsIgnoreCase(title)) continue;
                return null;
            }
            selectedSetName = title;
        }
        Iterator<LinkStyleDefiner> style = this.embeddedStyle.iterator();
        while (links.hasNext()) {
            String title;
            AbstractCSSStyleSheet sheet = style.next().getSheet();
            if (sheet == null || (title = sheet.getTitle()) == null || title.length() <= 0 || sheet.getDisabled()) continue;
            if (selectedSetName.length() > 0) {
                if (selectedSetName.equalsIgnoreCase(title)) continue;
                return null;
            }
            selectedSetName = title;
        }
        return selectedSetName;
    }

    @Override
    public void setSelectedStyleSheetSet(String name) {
        if (name == null || name.length() > 0 && !this.getStyleSheetSets().contains(name)) {
            return;
        }
        this.selectSheetSet(name, this.linkedStyle);
        this.selectSheetSet(name, this.embeddedStyle);
    }

    private void selectSheetSet(String name, Set<LinkStyleDefiner> styleDefinerSet) {
        Iterator<LinkStyleDefiner> links = styleDefinerSet.iterator();
        while (links.hasNext()) {
            String title;
            AbstractCSSStyleSheet sheet = links.next().getSheet();
            if (sheet == null || (title = sheet.getTitle()) == null || title.length() == 0) continue;
            if (title.equalsIgnoreCase(name)) {
                sheet.setDisabled(false);
                this.lastStyleSheetSet = name;
                continue;
            }
            sheet.setDisabled(true);
        }
    }

    @Override
    public String getLastStyleSheetSet() {
        return this.lastStyleSheetSet;
    }

    @Override
    public void enableStyleSheetsForSet(String name) {
        if (name == null || name.length() == 0) {
            return;
        }
        DOMDocument.enableStyleSheetSet(name, this.linkedStyle);
        DOMDocument.enableStyleSheetSet(name, this.embeddedStyle);
    }

    private static void enableStyleSheetSet(String name, Set<LinkStyleDefiner> styleDefinerSet) {
        Iterator<LinkStyleDefiner> links = styleDefinerSet.iterator();
        while (links.hasNext()) {
            String title;
            AbstractCSSStyleSheet sheet = links.next().getSheet();
            if (sheet == null || (title = sheet.getTitle()) == null || title.length() <= 0 || !title.equals(name)) continue;
            sheet.setDisabled(false);
        }
    }

    void onBaseModify() {
        for (LinkStyleDefiner linkStyleDefiner : this.getLinkedStyleNodeList()) {
            linkStyleDefiner.resetSheet();
        }
    }

    void onSheetModify() {
        this.mergedStyleSheet = null;
        this.sheets.setNeedsUpdate(true);
        this.onStyleModify();
    }

    void onStyleModify() {
    }

    @Override
    public StyleDatabase getStyleDatabase() {
        DeviceFactory df;
        StyleDatabase sdb = null;
        if (this.targetMedium != null && (df = this.getStyleSheetFactory().getDeviceFactory()) != null) {
            sdb = df.getStyleDatabase(this.targetMedium);
        }
        return sdb;
    }

    @Override
    public String getTargetMedium() {
        return this.targetMedium;
    }

    @Override
    public void setTargetMedium(String medium) throws CSSMediaException {
        if ("all".equals(medium)) {
            this.targetMedium = null;
        } else {
            if (medium != null) {
                medium = medium.intern();
            }
            this.targetMedium = medium;
        }
        this.onSheetModify();
    }

    @Override
    public CSSCanvas getCanvas() {
        CSSCanvas canvas;
        if (this.targetMedium == null) {
            return null;
        }
        if (this.canvases.containsKey(this.targetMedium)) {
            return this.canvases.get(this.targetMedium);
        }
        DeviceFactory df = this.getStyleSheetFactory().getDeviceFactory();
        if (df != null) {
            canvas = df.createCanvas(this.targetMedium, this);
            this.canvases.put(this.targetMedium, canvas);
        } else {
            canvas = null;
        }
        return canvas;
    }

    @Override
    public void rebuildCascade() {
        this.onSheetModify();
    }

    ErrorHandler createErrorHandler() {
        return new MyDefaultErrorHandler();
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    @Override
    public boolean hasStyleIssues() {
        return this.sheets.hasErrorsOrWarnings() || this.getErrorHandler().hasErrors() || this.getErrorHandler().hasWarnings();
    }

    public void onMetaAdded(String name, String attribute) {
        if ("default-style".equalsIgnoreCase(name)) {
            this.metaDefaultStyleSet = attribute;
            this.onSheetModify();
        } else if ("referrer".equalsIgnoreCase(name)) {
            this.metaReferrerPolicy = attribute;
        }
    }

    public void onMetaRemoved(String name, String attribute) {
        if ("default-style".equalsIgnoreCase(name)) {
            this.metaDefaultStyleSet = "";
            this.onSheetModify();
        } else if ("referrer".equalsIgnoreCase(name)) {
            this.metaReferrerPolicy = "";
        }
    }

    @Override
    public URL getBaseURL() {
        URL baseURL = null;
        String buri = this.getBaseURI();
        if (buri != null) {
            try {
                baseURL = new URL(buri);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return baseURL;
    }

    @Override
    public String getBaseURI() {
        String attr;
        String buri = this.getDocumentURI();
        DOMElement elm = this.getDocumentElement();
        if (elm != null && (attr = elm.getAttribute("xml:base")).length() != 0) {
            if (buri != null) {
                URL bUrl;
                URL docUrl;
                try {
                    docUrl = new URL(buri);
                }
                catch (MalformedURLException e) {
                    return this.getBaseForNullDocumentURI(attr, elm);
                }
                try {
                    bUrl = new URL(docUrl, attr);
                }
                catch (MalformedURLException e) {
                    this.getErrorHandler().ioError(attr, e);
                    return docUrl.toExternalForm();
                }
                buri = bUrl.toExternalForm();
                String docscheme = docUrl.getProtocol();
                String bscheme = bUrl.getProtocol();
                if (!(docscheme.equals(bscheme) || bscheme.equals("https") || bscheme.equals("http") || docscheme.equals("file") || docscheme.equals("jar"))) {
                    this.getErrorHandler().policyError(elm, "Remote document wants to set a non-http base URL: " + buri);
                    buri = docUrl.toExternalForm();
                }
            } else {
                buri = this.getBaseForNullDocumentURI(attr, elm);
            }
        }
        return buri;
    }

    private String getBaseForNullDocumentURI(String attr, DOMElement documentElement) {
        try {
            URL bUrl = new URL(attr);
            String bscheme = bUrl.getProtocol();
            if (bscheme.equals("https") || bscheme.equals("http")) {
                return attr;
            }
            this.getErrorHandler().policyError(documentElement, "Untrusted document wants to set a non-http base URL: " + attr);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public URL getURL(String uri) throws MalformedURLException {
        if (uri.length() == 0) {
            throw new MalformedURLException("Empty URI");
        }
        URL url = uri.indexOf("://") < 0 ? new URL(this.getBaseURL(), uri) : new URL(uri);
        return url;
    }

    @Override
    public boolean isSafeOrigin(URL linkedURL) {
        URL base = this.getBaseURL();
        String docHost = base.getHost();
        int docPort = base.getPort();
        if (docPort == -1) {
            docPort = base.getDefaultPort();
        }
        String linkedHost = linkedURL.getHost();
        int linkedPort = linkedURL.getPort();
        if (linkedPort == -1) {
            linkedPort = linkedURL.getDefaultPort();
        }
        return (docHost.equalsIgnoreCase(linkedHost) || linkedHost.endsWith(docHost)) && docPort == linkedPort;
    }

    @Override
    public boolean isAuthorizedOrigin(URL url) {
        String scheme = url.getProtocol();
        if (this.documentURI != null) {
            URL base = this.getBaseURL();
            String baseScheme = base.getProtocol();
            if (!(scheme.equalsIgnoreCase("https") || scheme.equalsIgnoreCase("http") || baseScheme.equals("file") || baseScheme.equals("jar"))) {
                return false;
            }
        } else if (!scheme.equalsIgnoreCase("https") && !scheme.equalsIgnoreCase("http")) {
            return false;
        }
        return true;
    }

    @Override
    public String getReferrerPolicy() {
        return this.metaReferrerPolicy;
    }

    protected void setReferrerPolicyHeader(String policy) {
        if (this.metaReferrerPolicy.length() == 0) {
            this.metaReferrerPolicy = policy;
        }
    }

    public String toString() {
        return this.getChildNodes().toString();
    }

    public InputStream openStream(String uri) throws IOException {
        return this.openConnection(this.getURL(uri)).getInputStream();
    }

    class MyOMStyleSheetList
    extends StyleSheetList {
        private static final long serialVersionUID = 2L;

        protected MyOMStyleSheetList(int initialCapacity) {
            super(initialCapacity);
        }

        @Override
        protected boolean hasErrorsOrWarnings() {
            boolean hasRuleErrors = false;
            Iterator<AbstractCSSStyleSheet> it = this.iterator();
            while (it.hasNext()) {
                AbstractCSSStyleSheet sheet = it.next();
                SheetErrorHandler eh = sheet.getErrorHandler();
                if (!sheet.hasRuleErrorsOrWarnings() && !eh.hasSacErrors() && !eh.hasSacWarnings() && !eh.hasOMErrors() && !eh.hasOMWarnings()) continue;
                hasRuleErrors = true;
                break;
            }
            return hasRuleErrors;
        }

        @Override
        protected Iterator<AbstractCSSStyleSheet> iterator() {
            return super.iterator();
        }

        @Override
        protected void clear() {
            super.clear();
        }

        @Override
        protected boolean needsUpdate() {
            return super.needsUpdate();
        }

        @Override
        protected void setNeedsUpdate(boolean needsUpdate) {
            super.setNeedsUpdate(needsUpdate);
        }

        @Override
        protected void update() {
            super.update();
            DOMDocument.this.updateStyleLists();
        }
    }

    static interface LinkStyleDefiner
    extends LinkStyle<AbstractCSSRule>,
    Node {
        public AbstractCSSStyleSheet getSheet();

        public void resetSheet();
    }

    class MyXMLElement
    extends DOMElement {
        private static final long serialVersionUID = 2L;

        MyXMLElement(String localName, String namespaceURI) {
            super(localName, namespaceURI);
        }

        @Override
        boolean isNonHTMLOrVoid() {
            if (this.getNamespaceURI() != "http://www.w3.org/1999/xhtml") {
                return true;
            }
            DocumentType docType = DOMDocument.this.getDoctype();
            if (docType != null) {
                ContentModel contentModel;
                try {
                    contentModel = ContentModel.getModel((DocumentType)docType);
                }
                catch (IOException | SAXException e) {
                    contentModel = null;
                }
                if (contentModel != null) {
                    return contentModel.isEmpty(this.localName);
                }
            }
            return false;
        }

        @Override
        public DOMDocument getOwnerDocument() {
            return DOMDocument.this;
        }

        @Override
        protected BaseCSSStyleSheetFactory getStyleSheetFactory() {
            return DOMDocument.this.getStyleSheetFactory();
        }

        @Override
        public String getBaseURI() {
            return DOMDocument.this.getBaseURI();
        }

        @Override
        public DOMElement cloneNode(boolean deep) {
            return this.cloneElementNode(new MyXMLElement(this.getLocalName(), this.getNamespaceURI()), deep);
        }

        DOMElement cloneElementNode(MyXMLElement my, boolean deep) {
            my.setPrefix(this.getPrefix());
            for (DOMAttr attr : this.nodeMap.getNodeList()) {
                DOMAttr myattr = (DOMAttr)attr.cloneNode(deep);
                myattr.specified = attr.getSpecified();
                my.setAttributeNode(myattr);
            }
            if (deep) {
                for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
                    my.appendChild(node.cloneNode(true));
                }
            }
            MyXMLElement.callUserHandlers((short)1, this, my);
            return my;
        }
    }

    private class StyleElement
    extends MyXMLElement
    implements LinkStyleDefiner {
        private static final long serialVersionUID = 2L;
        private final StyleDefinerElementHelper helper;

        StyleElement(String namespaceURI) {
            super("style", namespaceURI);
            this.helper = new StyleDefinerElementHelper(this);
        }

        @Override
        boolean isRawText() {
            return true;
        }

        @Override
        public AbstractCSSStyleSheet getSheet() {
            return this.helper.getInlineSheet();
        }

        @Override
        public void resetSheet() {
            this.helper.resetSheet();
        }

        @Override
        void setParentNode(AbstractDOMNode parentNode) throws DOMException {
            super.setParentNode(parentNode);
            DOMDocument.this.onSheetModify();
        }

        @Override
        void postAddChild(AbstractDOMNode newChild) {
            super.postAddChild(newChild);
            this.helper.postAddChildInline(newChild);
        }

        @Override
        void postRemoveChild(AbstractDOMNode removed) {
            this.resetSheet();
            this.getSheet();
        }

        @Override
        public void setTextContent(String textContent) throws DOMException {
            super.setTextContent(textContent);
            this.resetSheet();
            this.getSheet();
        }

        @Override
        public void normalize() {
            if (!this.helper.containsCSS()) {
                super.normalize();
            } else {
                AbstractCSSStyleSheet sheet = this.getSheet();
                if (sheet != null) {
                    super.setTextContent(sheet.toString());
                } else {
                    super.normalize();
                }
            }
        }

        @Override
        public DOMElement cloneNode(boolean deep) {
            return this.cloneElementNode(new StyleElement(this.getNamespaceURI()), deep);
        }
    }

    class DOMDocumentFragment
    extends DOMParentNode
    implements DocumentFragment {
        private static final long serialVersionUID = 2L;

        DOMDocumentFragment() {
            super((short)11);
        }

        @Override
        public String getNodeName() {
            return "#document-fragment";
        }

        @Override
        public String lookupNamespaceURI(String prefix) {
            return null;
        }

        @Override
        void checkAppendNodeHierarchy(Node newChild) {
            super.checkAppendNodeHierarchy(newChild);
            if (newChild.getNodeType() == 10) {
                throw new DOMException(3, "Doctype must be added to document.");
            }
        }

        @Override
        public DOMDocument getOwnerDocument() {
            return DOMDocument.this;
        }

        @Override
        public String getBaseURI() {
            return DOMDocument.this.getBaseURI();
        }

        @Override
        public DOMDocumentFragment cloneNode(boolean deep) {
            DOMDocumentFragment my = new DOMDocumentFragment();
            if (deep) {
                for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
                    my.appendChild(node.cloneNode(true));
                }
            }
            DOMDocumentFragment.callUserHandlers((short)1, this, my);
            return my;
        }

        public String toString() {
            int sz = this.getChildNodes().getLength();
            StringBuilder buf = new StringBuilder(64 + sz * 32);
            for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
                buf.append(node.toString());
            }
            return buf.toString();
        }
    }

    class MyText
    extends MyCharacterData
    implements Text {
        private static final long serialVersionUID = 2L;
        boolean elementContentWhitespace;

        MyText() {
            super((short)3);
            this.elementContentWhitespace = false;
        }

        MyText(short nodeType) {
            super(nodeType);
            this.elementContentWhitespace = false;
        }

        @Override
        void setParentNode(AbstractDOMNode parentNode) {
            DOMNode oldParent = this.getParentNode();
            if (oldParent != null && oldParent.getNodeType() == 1) {
                this.onDOMChange((DOMElement)oldParent);
            }
            if (parentNode == null) {
                super.setParentNode(parentNode);
            } else {
                super.setParentNode(parentNode);
                if (parentNode.getNodeType() == 1) {
                    this.onDOMChange((DOMElement)parentNode);
                }
            }
        }

        @Override
        public void setData(String data) throws DOMException {
            super.setData(data);
            DOMNode parent = this.getParentNode();
            if (parent != null && parent.getNodeType() == 1) {
                this.onDOMChange((DOMElement)parent);
            }
        }

        void onDOMChange(DOMElement container) {
            LinkStyleDefiner definer = DOMDocument.this.getEmbeddedStyleDefiner(container);
            if (definer != null) {
                definer.resetSheet();
            }
        }

        @Override
        public Text splitText(int offset) throws DOMException {
            Text newnode;
            DOMNode parent = this.getParentNode();
            try {
                String newdata = this.data.substring(0, offset);
                newnode = this.getOwnerDocument().createTextNode(this.data.substring(offset));
                if (parent != null) {
                    parent.insertBefore(newnode, this.getNextSibling());
                }
                this.setData(newdata);
            }
            catch (IndexOutOfBoundsException e) {
                DOMException ex = new DOMException(1, e.getMessage());
                ex.initCause(e);
                throw ex;
            }
            return newnode;
        }

        @Override
        public boolean isElementContentWhitespace() {
            DOMElement parentEl;
            AbstractDOMNode parentNd;
            if (this.data != null) {
                int dl = this.data.length();
                for (int i = 0; i < dl; ++i) {
                    if (Character.isWhitespace(this.data.charAt(i))) continue;
                    return false;
                }
            }
            return (parentNd = this.parentNode()) == null || parentNd.getNodeType() != 1 || !(parentEl = (DOMElement)parentNd).isRawText();
        }

        @Override
        public String getWholeText() {
            short type;
            short type2;
            Node node;
            DOMNode firstnode = this;
            for (node = this.getPreviousSibling(); node != null && ((type2 = node.getNodeType()) == 3 || type2 == 5); node = node.getPreviousSibling()) {
                firstnode = node;
            }
            Node lastnode = this;
            for (node = this.getNextSibling(); node != null && ((type = node.getNodeType()) == 3 || type == 5); node = node.getNextSibling()) {
                lastnode = node;
            }
            if (firstnode == lastnode) {
                return this.getData();
            }
            StringBuilder buf = new StringBuilder(this.data.length() * 2);
            for (node = firstnode; node != lastnode; node = node.getNextSibling()) {
                buf.append(node.toString());
            }
            buf.append(lastnode.toString());
            return buf.toString();
        }

        @Override
        public Text replaceWholeText(String content) throws DOMException {
            if (content == null) {
                throw new DOMException(5, "null content (use empty string instead)");
            }
            DOMNode parent = this.getParentNode();
            if (parent != null) {
                Node sibling;
                short type;
                Node node = this.getPreviousSibling();
                while (node != null && ((type = node.getNodeType()) == 5 || type == 3)) {
                    sibling = node.getPreviousSibling();
                    parent.removeChild(node);
                    node = sibling;
                }
                node = this.getNextSibling();
                while (node != null && ((type = node.getNodeType()) == 5 || type == 3)) {
                    sibling = node.getNextSibling();
                    parent.removeChild(node);
                    node = sibling;
                }
            }
            this.setData(content);
            if (content.length() == 0) {
                if (parent != null) {
                    parent.removeChild(this);
                }
                return null;
            }
            return this;
        }

        @Override
        public String getNodeName() {
            return "#text";
        }

        @Override
        public Text cloneNode(boolean deep) {
            MyText my = new MyText();
            my.setData(this.getData());
            MyText.callUserHandlers((short)1, this, my);
            return my;
        }

        public String toString() {
            String text = this.getData();
            if (!this.isElementContentWhitespace()) {
                DOMNode node = this.getParentNode();
                if (node != null && node.getNodeType() == 1 && ((DOMElement)node).isRawText()) {
                    String parentLName = node.getLocalName();
                    text = DOMDocument.escapeCloseTag(parentLName, text);
                } else {
                    text = DOMDocument.escapeLtGtEntities(text);
                }
            }
            return text;
        }
    }

    class MyComment
    extends MyCharacterData
    implements Comment {
        private static final long serialVersionUID = 2L;

        MyComment() {
            super((short)8);
        }

        @Override
        public String getNodeName() {
            return "#comment";
        }

        @Override
        public void setData(String data) throws DOMException {
            if (data.contains("-->")) {
                throw new DOMException(5, "Comment cannot contain '--'");
            }
            super.setData(data);
        }

        @Override
        public Comment cloneNode(boolean deep) {
            MyComment my = new MyComment();
            my.setData(this.getData());
            MyComment.callUserHandlers((short)1, this, my);
            return my;
        }

        public String toString() {
            return "<!--" + this.getData() + "-->";
        }
    }

    class MyCDATASection
    extends MyText
    implements CDATASection {
        private static final long serialVersionUID = 2L;

        MyCDATASection() {
            super((short)4);
        }

        @Override
        public String getNodeName() {
            return "#cdata-section";
        }

        @Override
        public void setData(String data) throws DOMException {
            if (data.contains("]]>")) {
                throw new DOMException(5, "cdata-section cannot contain ']]>'");
            }
            super.setData(data);
        }

        @Override
        public CDATASection cloneNode(boolean deep) {
            MyCDATASection my = new MyCDATASection();
            my.setData(this.getData());
            MyCDATASection.callUserHandlers((short)1, this, my);
            return my;
        }

        @Override
        public String toString() {
            return "<![CDATA[" + this.getData() + "]]>";
        }
    }

    private class MyStyleProcessingInstruction
    extends MyProcessingInstruction
    implements LinkStyleProcessingInstruction {
        private static final long serialVersionUID = 2L;
        private AbstractCSSStyleSheet linkedSheet;
        private final LinkedHashMap<String, String> pseudoAttrs;

        private MyStyleProcessingInstruction(String data) {
            super("xml-stylesheet", data);
            this.linkedSheet = null;
            this.pseudoAttrs = new LinkedHashMap();
            this.parseData();
        }

        @Override
        public void setData(String data) throws DOMException {
            super.setData(data);
            this.parseData();
            this.resetSheet();
            if (this.getParentNode() != null) {
                DOMDocument.this.onSheetModify();
            }
        }

        private void parseData() throws DOMException {
            DOMUtil.parsePseudoAttributes(this.getData(), this.pseudoAttrs);
        }

        @Override
        void setParentNode(AbstractDOMNode parentNode) throws DOMException {
            super.setParentNode(parentNode);
            DOMDocument.this.onSheetModify();
        }

        @Override
        public AbstractCSSStyleSheet getSheet() {
            if (this.linkedSheet == null) {
                boolean alternate;
                String type = this.getPseudoAttribute("type");
                if (type.length() != 0 && !"text/css".equalsIgnoreCase(type)) {
                    return null;
                }
                MediaQueryList media = DOMDocument.this.parseMediaList(this.getPseudoAttribute("media").trim(), this);
                if (media == null) {
                    return null;
                }
                String title = this.getPseudoAttribute("title");
                if (title.length() == 0) {
                    title = null;
                }
                if ((alternate = "yes".equalsIgnoreCase(this.getPseudoAttribute("alternate"))) && title == null) {
                    DOMDocument.this.getErrorHandler().linkedStyleError(this, "Alternate sheet without title");
                    return null;
                }
                String href = this.getPseudoAttribute("href");
                int hreflen = href.length();
                if (hreflen > 1) {
                    if (href.charAt(0) != '#') {
                        this.linkedSheet = DOMDocument.this.loadStyleSheet(this.linkedSheet, href, title, media, this);
                    } else {
                        String id = href.substring(1);
                        DOMElement elm = DOMDocument.this.getElementById(id);
                        if (elm != null) {
                            String text = elm.getTextContent().trim();
                            this.linkedSheet = DOMDocument.this.parseEmbeddedStyleSheet(this.linkedSheet, text, title, media, this);
                        } else {
                            DOMDocument.this.getErrorHandler().linkedStyleError(this, "Could not find element with id: " + id);
                        }
                    }
                    if (alternate && this.linkedSheet != null) {
                        this.linkedSheet.setDisabled(true);
                    }
                } else {
                    DOMDocument.this.getErrorHandler().linkedStyleError(this, "Missing or void href pseudo-attribute.");
                }
            }
            return this.linkedSheet;
        }

        @Override
        public String getPseudoAttribute(String attrname) {
            String value = this.pseudoAttrs.get(attrname);
            if (value == null) {
                value = "";
            }
            return value;
        }

        @Override
        public void resetSheet() {
            this.linkedSheet = null;
            DOMDocument.this.onSheetModify();
        }

        @Override
        public ProcessingInstruction cloneNode(boolean deep) {
            MyStyleProcessingInstruction my = new MyStyleProcessingInstruction(this.getData());
            MyStyleProcessingInstruction.callUserHandlers((short)1, this, my);
            return my;
        }
    }

    class MyProcessingInstruction
    extends MyNode
    implements ProcessingInstruction {
        private static final long serialVersionUID = 2L;
        String data;
        private final String target;

        MyProcessingInstruction(String target, String data) {
            super((short)7);
            this.target = target;
            this.data = data;
        }

        @Override
        public String getNodeName() {
            return this.getTarget();
        }

        @Override
        public String getData() {
            return this.data;
        }

        @Override
        public String getTarget() {
            return this.target;
        }

        @Override
        public void setData(String data) throws DOMException {
            if (data == null) {
                data = "";
            } else if (data.indexOf(62) != -1) {
                throw new DOMException(5, "PI is not allowed to contain '>'");
            }
            this.data = data;
        }

        @Override
        public String getNodeValue() throws DOMException {
            return this.getData();
        }

        @Override
        public void setNodeValue(String nodeValue) throws DOMException {
            this.setData(nodeValue);
        }

        @Override
        public String getTextContent() throws DOMException {
            return this.getData();
        }

        @Override
        public void setTextContent(String textContent) throws DOMException {
            this.setData(textContent);
        }

        @Override
        public ProcessingInstruction cloneNode(boolean deep) {
            MyProcessingInstruction my = new MyProcessingInstruction(this.getTarget(), this.getData());
            MyProcessingInstruction.callUserHandlers((short)1, this, my);
            return my;
        }

        public String toString() {
            return "<?" + this.getTarget() + " " + this.getData() + "?>";
        }
    }

    class MyEntityReference
    extends MyNode
    implements EntityReference {
        private static final long serialVersionUID = 2L;
        private final String name;

        MyEntityReference(String name) {
            super((short)5);
            this.name = name;
        }

        @Override
        public String getNodeName() {
            return this.name;
        }

        @Override
        void checkAppendNodeHierarchy(Node newChild) {
            super.checkAppendNodeHierarchy(newChild);
            throw new DOMException(9, "This implementation does not support appending nodes to an entity reference.");
        }

        @Override
        public String lookupNamespaceURI(String prefix) {
            return null;
        }

        public String toString() {
            return '&' + this.name + ';';
        }
    }

    class XmlnsAttr
    extends MyAttr {
        private static final long serialVersionUID = 2L;

        XmlnsAttr() {
            super("xmlns", DOMDocument.XMLNS_NAMESPACE_URI);
        }

        @Override
        public void setPrefix(String prefix) throws DOMException {
            throw new DOMException(14, "Cannot set prefix for xmlns attribute");
        }

        @Override
        boolean isBooleanAttribute() {
            return false;
        }
    }

    class ClassAttr
    extends MyAttr {
        private static final long serialVersionUID = 2L;

        ClassAttr(String namespaceURI) {
            super("class", namespaceURI);
        }

        @Override
        void setAttributeOwner(DOMElement newOwner) throws DOMException {
            DOMElement oldOwner;
            if (newOwner == null && (oldOwner = this.getOwnerElement()) != null && this.isSameNamespace(oldOwner.getNamespaceURI()) && oldOwner.classList != null) {
                this.value = oldOwner.classList.getValue();
                oldOwner.classList.clear();
            }
            super.setAttributeOwner(newOwner);
            if (newOwner != null && this.isSameNamespace(newOwner.getNamespaceURI()) && newOwner.classList != null) {
                newOwner.classList.setValue(this.value);
            }
        }

        private boolean isSameNamespace(String ownerNamespaceURI) {
            String namespaceURI = this.getNamespaceURI();
            if (namespaceURI == null) {
                return ownerNamespaceURI == null || this.isDefaultNamespace(ownerNamespaceURI);
            }
            return namespaceURI.equals(ownerNamespaceURI);
        }

        @Override
        public String getValue() {
            DOMElement.ClassList list = this.getListValue();
            if (list == null) {
                return super.getValue();
            }
            return list.getValue();
        }

        @Override
        public void setValue(String value) throws DOMException {
            super.setValue(value);
            DOMElement.ClassList list = this.getListValue();
            if (list != null) {
                list.setValue(value);
            }
        }

        DOMElement.ClassList getListValue() {
            DOMElement owner = this.getOwnerElement();
            if (owner == null || !this.isSameNamespace(owner.getNamespaceURI())) {
                return null;
            }
            return (DOMElement.ClassList)owner.getClassList();
        }

        @Override
        boolean isBooleanAttribute() {
            return false;
        }
    }

    private class BaseEventAttr
    extends EventAttr {
        private static final long serialVersionUID = 2L;

        BaseEventAttr() {
            super("base", DOMDocument.XML_NAMESPACE_URI);
        }

        @Override
        void onAttributeRemoval() {
            DOMElement owner = this.getOwnerElement();
            this.onDOMChange(owner);
        }

        @Override
        void onDOMChange(DOMElement owner) {
            if (owner == DOMDocument.this.getDocumentElement()) {
                DOMDocument.this.onBaseModify();
            }
        }
    }

    class MyStyleAttr
    extends MyAttr
    implements StyleAttr {
        private static final long serialVersionUID = 2L;
        private AbstractCSSStyleDeclaration inlineStyle;

        MyStyleAttr(String name) {
            super(name, null);
            this.inlineStyle = null;
        }

        @Override
        void setAttributeOwner(DOMElement newOwner) {
            super.setAttributeOwner(newOwner);
            this.onDOMChange();
        }

        @Override
        public String getValue() {
            if (this.inlineStyle == null) {
                return super.getValue();
            }
            return this.inlineStyle.getCssText();
        }

        @Override
        public void setValue(String value) throws DOMException {
            super.setValue(value);
            if (this.inlineStyle != null) {
                this.setInlineStyle(value);
            } else {
                this.getStyle();
            }
            this.onDOMChange();
        }

        @Override
        public AbstractCSSStyleDeclaration getStyle() {
            if (this.inlineStyle == null) {
                this.inlineStyle = this.getOwnerDocument().getStyleSheetFactory().createInlineStyle(this);
                this.setInlineStyle(super.getValue());
            }
            return this.inlineStyle;
        }

        private void setInlineStyle(String value) {
            block4: {
                if (value == null) {
                    value = "";
                }
                try {
                    StyleDeclarationErrorHandler eh;
                    this.inlineStyle.setCssText(value);
                    if (this.inlineStyle.getLength() == 0 && ((eh = this.inlineStyle.getStyleDeclarationErrorHandler()) == null || eh.hasErrors())) {
                        this.inlineStyle = null;
                    }
                }
                catch (DOMException e) {
                    DOMDocument.this.getErrorHandler().inlineStyleError(this.getOwnerElement(), e, value);
                    if (this.inlineStyle.getLength() != 0) break block4;
                    this.inlineStyle = null;
                }
            }
        }

        @Override
        boolean isBooleanAttribute() {
            return false;
        }

        void onDOMChange() {
            DOMDocument.this.onStyleModify();
        }
    }

    class StyleEventAttr
    extends EventAttr {
        private static final long serialVersionUID = 2L;

        StyleEventAttr(String name, String namespaceURI) {
            super(name, namespaceURI);
        }

        @Override
        void onAttributeRemoval() {
            DOMElement owner = this.getOwnerElement();
            if (owner instanceof LinkStyleDefiner) {
                ((LinkStyleDefiner)((Object)owner)).resetSheet();
            }
        }

        @Override
        void onDOMChange(DOMElement owner) {
            if (owner instanceof LinkStyleDefiner) {
                ((LinkStyleDefiner)((Object)owner)).resetSheet();
            }
        }
    }

    class MyAttr
    extends DOMAttr {
        private static final long serialVersionUID = 2L;

        MyAttr(String localName, String namespaceURI) {
            super(localName, namespaceURI);
        }

        @Override
        public DOMDocument getOwnerDocument() {
            return DOMDocument.this;
        }

        @Override
        public String getBaseURI() {
            return DOMDocument.this.getBaseURI();
        }

        @Override
        public boolean isId() {
            DOMElement owner = this.getOwnerElement();
            return owner != null && owner.isIdAttribute(this.getLocalName());
        }

        @Override
        public Attr cloneNode(boolean deep) {
            MyAttr my = (MyAttr)this.getOwnerDocument().createAttributeNS(this.getNamespaceURI(), this.getName());
            my.setValue(this.getValue());
            MyAttr.callUserHandlers((short)1, this, my);
            return my;
        }
    }

    static interface LinkStyleProcessingInstruction
    extends LinkStyleDefiner,
    ProcessingInstruction {
        public String getPseudoAttribute(String var1);
    }

    class MyDefaultErrorHandler
    extends DefaultErrorHandler {
        private static final long serialVersionUID = 2L;

        MyDefaultErrorHandler() {
        }

        @Override
        protected AbstractCSSStyleSheetFactory getStyleSheetFactory() {
            return DOMDocument.this.getStyleSheetFactory();
        }
    }

    abstract class EventAttr
    extends MyAttr {
        private static final long serialVersionUID = 2L;

        EventAttr(String localName, String namespaceURI) {
            super(localName, namespaceURI);
        }

        @Override
        void setAttributeOwner(DOMElement newOwner) {
            if (newOwner != null) {
                super.setAttributeOwner(newOwner);
                this.onDOMChange(newOwner);
            } else {
                this.onAttributeRemoval();
                super.setAttributeOwner(null);
            }
        }

        @Override
        public void setValue(String value) throws DOMException {
            super.setValue(value);
            DOMElement owner = this.getOwnerElement();
            if (owner != null) {
                this.onDOMChange(owner);
            }
        }

        @Override
        boolean isBooleanAttribute() {
            return false;
        }

        abstract void onAttributeRemoval();

        abstract void onDOMChange(DOMElement var1);
    }

    static interface StyleAttr
    extends Attr {
        public AbstractCSSStyleDeclaration getStyle();
    }

    abstract class MyCharacterData
    extends MyNode
    implements CharacterData {
        private static final long serialVersionUID = 2L;
        String data;

        MyCharacterData(short nodeType) {
            super(nodeType);
            this.data = "";
        }

        @Override
        void checkAppendNodeHierarchy(Node newChild) {
            throw new DOMException(3, "Cannot append the node to text/comment/cdatasection");
        }

        @Override
        public String getData() throws DOMException {
            return this.data;
        }

        @Override
        public void setData(String data) throws DOMException {
            if (data == null) {
                data = "";
            }
            this.data = data;
        }

        @Override
        public int getLength() {
            return this.data.length();
        }

        @Override
        public String substringData(int offset, int count) throws DOMException {
            int dl = this.data.length();
            int oc = offset + count;
            if (offset <= dl && oc >= dl) {
                return this.data;
            }
            try {
                return this.data.substring(offset, oc);
            }
            catch (IndexOutOfBoundsException e) {
                DOMException ex = new DOMException(1, e.getMessage());
                ex.initCause(e);
                throw ex;
            }
        }

        @Override
        public void appendData(String arg) throws DOMException {
            StringBuilder buf = new StringBuilder(this.data.length() + arg.length());
            buf.append(this.data).append(arg);
            this.setData(buf.toString());
        }

        @Override
        public void insertData(int offset, String arg) throws DOMException {
            int dl = this.data.length();
            if (offset < 0 || offset > dl) {
                throw new DOMException(1, "Wrong arguments");
            }
            StringBuilder buf = new StringBuilder(dl + arg.length());
            buf.append(this.data.subSequence(0, offset)).append(arg).append(this.data.subSequence(offset, dl));
            this.setData(buf.toString());
        }

        @Override
        public void deleteData(int offset, int count) throws DOMException {
            int dl = this.data.length();
            if (offset < 0 || count < 0 || offset >= dl) {
                throw new DOMException(1, "Wrong arguments");
            }
            int begin2 = offset + count;
            if (begin2 > dl) {
                begin2 = dl;
                count = dl - offset;
            }
            StringBuilder buf = new StringBuilder(dl - count);
            buf.append(this.data.subSequence(0, offset)).append(this.data.subSequence(begin2, dl));
            this.setData(buf.toString());
        }

        @Override
        public void replaceData(int offset, int count, String arg) throws DOMException {
            int dl = this.data.length();
            StringBuilder buf = new StringBuilder(dl + arg.length() - count);
            try {
                buf.append(this.data.subSequence(0, offset)).append(arg);
                if (offset + count < dl) {
                    buf.append(this.data.subSequence(offset + count, dl));
                }
            }
            catch (IndexOutOfBoundsException e) {
                DOMException ex = new DOMException(1, e.getMessage());
                ex.initCause(e);
                throw ex;
            }
            this.setData(buf.toString());
        }

        @Override
        public String getNodeValue() {
            return this.getData();
        }

        @Override
        public void setNodeValue(String nodeValue) throws DOMException {
            this.setData(nodeValue);
        }

        @Override
        public String getTextContent() throws DOMException {
            return this.getData();
        }

        @Override
        public void setTextContent(String textContent) throws DOMException {
            this.setData(textContent);
        }
    }

    abstract class MyNode
    extends NDTNode {
        private static final long serialVersionUID = 2L;

        MyNode(short nodeType) {
            super(nodeType);
        }

        @Override
        void checkAppendNode(Node newChild) {
            throw new DOMException(3, "Cannot append the node to " + this.getNodeName());
        }

        @Override
        public DOMDocument getOwnerDocument() {
            return DOMDocument.this;
        }

        @Override
        public String getBaseURI() {
            return DOMDocument.this.getBaseURI();
        }

        @Override
        public Node cloneNode(boolean deep) {
            return this;
        }
    }
}

