/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.css.engine.value.svg;

import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.echosvg.css.engine.CSSEngine;
import io.sf.carte.echosvg.css.engine.CSSStylableElement;
import io.sf.carte.echosvg.css.engine.StyleMap;
import io.sf.carte.echosvg.css.engine.value.FloatValue;
import io.sf.carte.echosvg.css.engine.value.LengthManager;
import io.sf.carte.echosvg.css.engine.value.StringMap;
import io.sf.carte.echosvg.css.engine.value.Value;
import io.sf.carte.echosvg.css.engine.value.ValueConstants;
import io.sf.carte.echosvg.css.engine.value.svg.SVGValueConstants;
import java.util.Locale;
import org.w3c.dom.DOMException;

public class BaselineShiftManager
extends LengthManager {
    protected static final StringMap values = new StringMap();

    @Override
    public boolean isInheritedProperty() {
        return false;
    }

    @Override
    public boolean isAnimatableProperty() {
        return true;
    }

    @Override
    public boolean isAdditiveProperty() {
        return false;
    }

    @Override
    public int getPropertyType() {
        return 40;
    }

    @Override
    public String getPropertyName() {
        return "baseline-shift";
    }

    @Override
    public Value getDefaultValue() {
        return SVGValueConstants.BASELINE_VALUE;
    }

    @Override
    public Value createValue(LexicalUnit lu, CSSEngine engine) throws DOMException {
        switch (lu.getLexicalUnitType()) {
            case IDENT: {
                Object v = values.get(lu.getStringValue().toLowerCase(Locale.ROOT).intern());
                if (v == null) {
                    throw this.createInvalidIdentifierDOMException(lu.getStringValue());
                }
                return (Value)v;
            }
            case INHERIT: {
                return ValueConstants.INHERIT_VALUE;
            }
        }
        return super.createValue(lu, engine);
    }

    @Override
    public Value createStringValue(CSSValue.Type type, String value, CSSEngine engine) throws DOMException {
        if (type != CSSValue.Type.IDENT) {
            throw this.createInvalidStringTypeDOMException(type);
        }
        Object v = values.get(value.toLowerCase(Locale.ROOT).intern());
        if (v == null) {
            throw this.createInvalidIdentifierDOMException(value);
        }
        return (Value)v;
    }

    @Override
    public Value computeValue(CSSStylableElement elt, String pseudo, CSSEngine engine, int idx, StyleMap sm, Value value) {
        if (value.getUnitType() == 2) {
            sm.putLineHeightRelative(idx, true);
            int lhi = engine.getLineHeightIndex();
            CSSStylableElement parent = (CSSStylableElement)elt.getParentNode();
            if (parent == null) {
                parent = elt;
            }
            Value lh = engine.getComputedStyle(parent, null, lhi);
            float flh = this.lineHeightValue(parent, null, engine, lh);
            float v = value.getFloatValue();
            return new FloatValue(3, flh * v * 0.01f);
        }
        return super.computeValue(elt, pseudo, engine, idx, sm, value);
    }

    @Override
    protected int getOrientation() {
        return 2;
    }

    static {
        values.put("baseline", SVGValueConstants.BASELINE_VALUE);
        values.put("sub", SVGValueConstants.SUB_VALUE);
        values.put("super", SVGValueConstants.SUPER_VALUE);
    }
}

