/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.css.dom;

import io.sf.carte.echosvg.css.dom.CSSOMSVGColor;
import io.sf.carte.echosvg.css.dom.CSSOMSVGPaint;
import io.sf.carte.echosvg.css.dom.CSSOMStyleDeclaration;
import io.sf.carte.echosvg.css.engine.CSSEngine;
import io.sf.carte.echosvg.css.engine.value.AbstractValueModificationHandler;
import io.sf.carte.echosvg.css.engine.value.CSSVal;
import io.sf.carte.echosvg.css.engine.value.Value;
import io.sf.carte.echosvg.css.engine.value.svg.SVGColorManager;
import io.sf.carte.echosvg.css.engine.value.svg.SVGPaintManager;
import org.w3c.css.om.CSSRule;
import org.w3c.dom.DOMException;

public class CSSOMSVGStyleDeclaration
extends CSSOMStyleDeclaration {
    protected CSSEngine cssEngine;

    public CSSOMSVGStyleDeclaration(CSSOMStyleDeclaration.ValueProvider vp, CSSRule parent, CSSEngine eng) {
        super(vp, parent);
        this.cssEngine = eng;
    }

    @Override
    protected CSSVal createCSSValue(String name) {
        int idx = this.cssEngine.getPropertyIndex(name);
        if (idx > 63) {
            if (this.cssEngine.getValueManagers()[idx] instanceof SVGPaintManager) {
                return new StyleDeclarationPaintValue(name);
            }
            if (this.cssEngine.getValueManagers()[idx] instanceof SVGColorManager) {
                return new StyleDeclarationColorValue(name);
            }
        } else {
            switch (idx) {
                case 14: 
                case 49: {
                    return new StyleDeclarationPaintValue(name);
                }
                case 18: 
                case 32: 
                case 47: {
                    return new StyleDeclarationColorValue(name);
                }
            }
        }
        return super.createCSSValue(name);
    }

    public class StyleDeclarationPaintValue
    extends CSSOMSVGPaint
    implements CSSOMSVGColor.ValueProvider {
        protected String property;

        public StyleDeclarationPaintValue(String prop) {
            super(null);
            this.valueProvider = this;
            this.setModificationHandler(new CSSOMSVGPaint.AbstractModificationHandler(){

                @Override
                protected Value getValue() {
                    return StyleDeclarationPaintValue.this.getValue();
                }

                @Override
                protected void setPropertyText(String text) throws DOMException {
                    if (StyleDeclarationPaintValue.this.handler == null) {
                        throw new DOMException(7, "");
                    }
                    String prio = CSSOMSVGStyleDeclaration.this.getPropertyPriority(StyleDeclarationPaintValue.this.property);
                    CSSOMSVGStyleDeclaration.this.handler.propertyChanged(StyleDeclarationPaintValue.this.property, text, prio);
                }
            });
            this.property = prop;
        }

        @Override
        public Value getValue() {
            return CSSOMSVGStyleDeclaration.this.valueProvider.getValue(this.property);
        }
    }

    public class StyleDeclarationColorValue
    extends CSSOMSVGColor
    implements CSSOMSVGColor.ValueProvider {
        protected String property;

        public StyleDeclarationColorValue(String prop) {
            super(null);
            this.valueProvider = this;
            this.setModificationHandler(new AbstractValueModificationHandler(){

                @Override
                protected Value getValue() {
                    return StyleDeclarationColorValue.this.getValue();
                }

                @Override
                protected void setPropertyText(String text) throws DOMException {
                    if (StyleDeclarationColorValue.this.handler == null) {
                        throw new DOMException(7, "");
                    }
                    String prio = CSSOMSVGStyleDeclaration.this.getPropertyPriority(StyleDeclarationColorValue.this.property);
                    CSSOMSVGStyleDeclaration.this.handler.propertyChanged(StyleDeclarationColorValue.this.property, text, prio);
                }
            });
            this.property = prop;
        }

        @Override
        public Value getValue() {
            return CSSOMSVGStyleDeclaration.this.valueProvider.getValue(this.property);
        }
    }
}

