/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.uparser;

import io.sf.carte.uparser.TokenControl;
import io.sf.carte.uparser.TokenHandler2;

public class CommentRemovalHandler
implements TokenHandler2 {
    private final StringBuilder buffer;
    private int prevcp;

    public CommentRemovalHandler(int bufSize) {
        this(new StringBuilder(bufSize));
    }

    public CommentRemovalHandler(StringBuilder buffer) {
        this.buffer = buffer;
    }

    public StringBuilder getBuffer() {
        return this.buffer;
    }

    protected int getPreviousCodepoint() {
        return this.prevcp;
    }

    protected void setPreviousCodepoint(int codePoint) {
        this.prevcp = codePoint;
    }

    @Override
    public void tokenStart(TokenControl control) {
    }

    @Override
    public void word(int index, CharSequence word) {
        this.buffer.append(word);
        this.prevcp = 65;
    }

    @Override
    public void separator(int index, int codePoint) {
        this.buffer.appendCodePoint(codePoint);
        this.prevcp = 32;
    }

    @Override
    public void quoted(int index, CharSequence quoted, int quoteCp) {
        char[] quote = Character.toChars(quoteCp);
        this.buffer.append(quote);
        this.buffer.append(quoted);
        this.buffer.append(quote);
        this.prevcp = quoteCp;
    }

    @Override
    public void quotedWithControl(int index, CharSequence quoted, int quoteCp) {
        this.quoted(index, quoted, quoteCp);
    }

    @Override
    public void quotedNewlineChar(int index, int codePoint) {
        this.buffer.appendCodePoint(codePoint);
        this.prevcp = 32;
    }

    @Override
    public void leftParenthesis(int index) {
        this.buffer.append('(');
        this.prevcp = 40;
    }

    @Override
    public void leftSquareBracket(int index) {
        this.buffer.append('[');
        this.prevcp = 91;
    }

    @Override
    public void leftCurlyBracket(int index) {
        this.buffer.append('{');
        this.prevcp = 123;
    }

    @Override
    public void rightParenthesis(int index) {
        this.buffer.append(')');
        this.prevcp = 41;
    }

    @Override
    public void rightSquareBracket(int index) {
        this.buffer.append(']');
        this.prevcp = 93;
    }

    @Override
    public void rightCurlyBracket(int index) {
        this.buffer.append('}');
        this.prevcp = 125;
    }

    @Override
    public void character(int index, int codePoint) {
        this.buffer.appendCodePoint(codePoint);
        this.prevcp = codePoint;
    }

    @Override
    public void escaped(int index, int codePoint) {
        this.buffer.append('\\').appendCodePoint(codePoint);
        this.prevcp = codePoint;
    }

    @Override
    public void control(int index, int codePoint) {
        this.buffer.appendCodePoint(codePoint);
        this.prevcp = 32;
    }

    @Override
    public void commented(int index, int commentType, String comment) {
        if (this.prevcp != 32) {
            this.buffer.append(' ');
            this.prevcp = 32;
        }
    }

    @Override
    public void endOfStream(int len) {
    }

    @Override
    public void error(int index, byte errCode, CharSequence context) {
    }
}

