/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css;

import io.sf.carte.doc.style.css.CSSComputedProperties;
import io.sf.carte.doc.style.css.CSSFontFaceRule;
import io.sf.carte.doc.style.css.CSSTypedValue;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.nsac.SelectorList;
import org.w3c.dom.DOMException;

public interface StyleDatabase {
    public CSSTypedValue getInitialColor();

    public void setInitialColor(String var1);

    public String getDefaultGenericFontFamily(String var1);

    default public String getDefaultGenericFontFamily() {
        return this.getDefaultGenericFontFamily("serif");
    }

    public String getUsedFontFamily(CSSComputedProperties var1);

    default public float getFontSizeFromIdentifier(String string, String string2) throws DOMException {
        float f;
        float f2 = Math.max(0.9f, this.getDeviceWidth() / 595.0f);
        if (string2.equals("xx-small")) {
            f = 8.0f * f2;
        } else if (string2.equals("x-small")) {
            f = 9.0f * f2;
        } else if (string2.equals("small")) {
            f = 10.0f * f2;
        } else if (string2.equals("medium")) {
            f = 12.0f * f2;
        } else if (string2.equals("large")) {
            f = 14.0f * f2;
        } else if (string2.equals("x-large")) {
            f = 18.0f * f2;
        } else if (string2.equals("xx-large")) {
            f = 24.0f * f2;
        } else {
            throw new DOMException(15, "Unknown size identifier: " + string2);
        }
        return f;
    }

    default public String getSystemFontDeclaration(String string) {
        return null;
    }

    public boolean isFontFaceName(String var1);

    public void loadFontFaceRule(CSSFontFaceRule var1);

    default public short getNaturalUnit() {
        return 3;
    }

    default public float getExSizeInPt(String string, float f) {
        return Math.round(0.5f * f);
    }

    @Deprecated
    default public float getWidthSize(String string, float f) throws DOMException {
        if ("thin".equalsIgnoreCase(string)) {
            return 0.75f;
        }
        if ("thick".equalsIgnoreCase(string)) {
            return 3.75f;
        }
        if ("medium".equalsIgnoreCase(string)) {
            return 2.25f;
        }
        throw new DOMException(12, "Unknown identifier " + string);
    }

    public int getColorDepth();

    public float getDeviceHeight();

    public float getDeviceWidth();

    default public CSSValue getEnvValue(String string) {
        return null;
    }

    default public boolean supports(SelectorList selectorList) {
        return true;
    }

    default public boolean supports(String string, LexicalUnit lexicalUnit) {
        return false;
    }

    @Deprecated(forRemoval=true)
    default public boolean supports(String string, CSSValue cSSValue) {
        return false;
    }
}

