/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.graph.ui.widgets;

import com.jogamp.graph.curve.opengl.RegionRenderer;
import com.jogamp.graph.ui.GraphShape;
import com.jogamp.graph.ui.Group;
import com.jogamp.graph.ui.Shape;
import com.jogamp.graph.ui.layout.Padding;
import com.jogamp.graph.ui.shapes.BaseButton;
import com.jogamp.graph.ui.shapes.Rectangle;
import com.jogamp.graph.ui.widgets.Widget;
import com.jogamp.math.FloatUtil;
import com.jogamp.math.Vec2f;
import com.jogamp.math.Vec3f;
import com.jogamp.math.Vec4f;
import com.jogamp.newt.event.KeyAdapter;
import com.jogamp.newt.event.KeyEvent;
import com.jogamp.newt.event.MouseEvent;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GLProfile;
import java.util.ArrayList;

public final class RangeSlider
extends Widget {
    private static final boolean DEBUG = false;
    private static final float pageKnobScale = 0.6f;
    private static final float pageBarLineScale = 0.25f;
    private static final float pageKnobSizePctMin = 0.05f;
    private final boolean horizontal;
    private float knobThickn;
    private float knobLength;
    private final Vec2f size;
    private final Group barAndKnob;
    private final Group marks;
    private final Rectangle bar;
    private final GraphShape knob;
    private ArrayList<ChangeListener> changeListeners = new ArrayList();
    private ArrayList<PeekListener> peekListeners = new ArrayList();
    private final Vec2f minMax = new Vec2f(0.0f, 100.0f);
    private final float knobScale;
    private float pageSize;
    private float val = 0.0f;
    private float val_pct = 0.0f;
    private boolean inverted = false;
    private float unitSize = 1.0f;
    private final Vec4f activeColMod = new Vec4f(0.1f, 0.1f, 0.1f, 1.0f);
    private boolean paddingSet = false;

    public RangeSlider(int n, Vec2f vec2f, float f, Vec2f vec2f2, float f2, float f3) {
        this(n, vec2f, f, vec2f2, f2, Float.NaN, f3);
    }

    public RangeSlider(int n, Vec2f vec2f, Vec2f vec2f2, float f, float f2, float f3) {
        this(n, vec2f, 0.0f, vec2f2, f, f2, f3);
    }

    private RangeSlider(int n, Vec2f vec2f, float f, Vec2f vec2f2, final float f2, float f3, float f4) {
        int n2 = n & 0xFFFFFDFF;
        this.knobScale = f;
        this.unitSize = f2;
        this.pageSize = f3;
        this.horizontal = vec2f.x() >= vec2f.y();
        this.barAndKnob = new Group();
        this.barAndKnob.setInteractive(false);
        this.marks = new Group();
        this.marks.setInteractive(false);
        this.size = new Vec2f(vec2f);
        this.setMinMaxImpl(vec2f2.x(), vec2f2.y());
        this.setKnobSize(this.pageSize, false, false);
        if (Float.isFinite(this.pageSize)) {
            float f5;
            if (this.horizontal) {
                f5 = (vec2f.y() - this.knobThickn) * 0.25f;
                this.knob = new Rectangle(n2, this.knobLength, this.knobThickn, 0.0f);
            } else {
                f5 = (vec2f.x() - this.knobThickn) * 0.25f;
                this.knob = new Rectangle(n2, this.knobThickn, this.knobLength, 0.0f);
            }
            this.bar = new Rectangle(n2, this.size.x(), this.size.y(), f5);
        } else {
            this.bar = new Rectangle(n2, this.size.x(), this.size.y(), 0.0f);
            this.knob = new BaseButton(n2, this.knobThickn * 1.01f, this.knobThickn);
            this.setBackgroundBarColor(0.6f, 0.6f, 0.6f, 0.5f);
        }
        this.setColor(0.8f, 0.8f, 0.8f, 0.7f);
        this.setName("RangeSlider.container");
        this.bar.setToggleable(false).setInteractive(true).setDragAndResizable(false).setName("RangeSlider.bar");
        this.knob.setToggleable(false).setInteractive(true).setResizable(false).setName("RangeSlider.knob");
        this.barAndKnob.addShape(this.bar);
        this.barAndKnob.addShape(this.marks);
        this.barAndKnob.addShape(this.knob);
        this.addShape(this.barAndKnob);
        this.reconfig(vec2f2, true, f4, false, 0.0f);
        this.knob.onMove((shape, vec3f, vec3f2, mouseEvent) -> {
            float f = this.val;
            float f2 = this.val_pct;
            if (Float.isFinite(this.pageSize)) {
                float f3 = this.inverted ? this.knobLength : 0.0f;
                this.setValue(vec3f2.x(), vec3f2.y(), f3);
            } else {
                this.setValue(vec3f2.x(), vec3f2.y(), this.knobLength / 2.0f);
            }
            this.dispatchToListener((ChangeListener changeListener) -> changeListener.dragged(this, f, this.val, f2, this.val_pct, vec3f2, mouseEvent));
        });
        this.bar.onClicked((shape, vec3f, mouseEvent) -> {
            float f = this.val;
            float f2 = this.val_pct;
            this.setValue(vec3f.x(), vec3f.y(), 0.0f);
            this.dispatchToListener((ChangeListener changeListener) -> changeListener.dragged(this, f, this.val, f2, this.val_pct, vec3f, mouseEvent));
        });
        this.bar.onHover((shape, vec3f, mouseEvent) -> {
            float f = this.getKnobValuePct(vec3f.x(), vec3f.y(), 0.0f);
            float f2 = this.valuePctToValue(f);
            this.dispatchToListener((PeekListener peekListener) -> peekListener.peeked(this, f2, f, vec3f, mouseEvent));
        });
        this.bar.addActivationListener(shape -> this.dispatchActivationEvent(shape));
        Shape.MouseGestureAdapter mouseGestureAdapter = new Shape.MouseGestureAdapter(){

            @Override
            public void mouseWheelMoved(MouseEvent mouseEvent) {
                float f = RangeSlider.this.val;
                float f22 = RangeSlider.this.val_pct;
                float f3 = f;
                if (!mouseEvent.isControlDown()) {
                    f3 = mouseEvent.getRotation()[1] < 0.0f ? (RangeSlider.this.inverted ? (f3 += f2) : (f3 -= f2)) : (RangeSlider.this.inverted ? (f3 -= f2) : (f3 += f2));
                } else if (Float.isFinite(RangeSlider.this.pageSize)) {
                    f3 = mouseEvent.getRotation()[1] < 0.0f ? (RangeSlider.this.inverted ? (f3 += RangeSlider.this.pageSize) : (f3 -= RangeSlider.this.pageSize)) : (RangeSlider.this.inverted ? (f3 -= RangeSlider.this.pageSize) : (f3 += RangeSlider.this.pageSize));
                }
                RangeSlider.this.setValue(f3);
                RangeSlider.this.dispatchToListener(changeListener -> changeListener.dragged(RangeSlider.this, f, RangeSlider.this.val, f22, RangeSlider.this.val_pct, RangeSlider.this.knob.getPosition().minus(RangeSlider.this.bar.getPosition()), mouseEvent));
            }
        };
        KeyAdapter keyAdapter = new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                float f = RangeSlider.this.val;
                float f22 = RangeSlider.this.val_pct;
                float f3 = f;
                short s = keyEvent.getKeySymbol();
                boolean bl = false;
                if (RangeSlider.this.horizontal) {
                    if (s == 151) {
                        bl = true;
                        f3 = RangeSlider.this.inverted ? (f3 -= f2) : (f3 += f2);
                    } else if (s == 149) {
                        bl = true;
                        f3 = RangeSlider.this.inverted ? (f3 += f2) : (f3 -= f2);
                    }
                } else if (s == 152) {
                    bl = true;
                    f3 = RangeSlider.this.inverted ? (f3 += f2) : (f3 -= f2);
                } else if (s == 150) {
                    bl = true;
                    f3 = RangeSlider.this.inverted ? (f3 -= f2) : (f3 += f2);
                }
                if (!bl && Float.isFinite(RangeSlider.this.pageSize)) {
                    if (s == 11) {
                        bl = true;
                        f3 = RangeSlider.this.inverted ? (f3 += RangeSlider.this.pageSize) : (f3 -= RangeSlider.this.pageSize);
                    } else if (s == 16) {
                        bl = true;
                        f3 = RangeSlider.this.inverted ? (f3 -= RangeSlider.this.pageSize) : (f3 += RangeSlider.this.pageSize);
                    }
                }
                if (bl) {
                    RangeSlider.this.setValue(f3);
                    RangeSlider.this.dispatchToListener(changeListener -> changeListener.dragged(RangeSlider.this, f, RangeSlider.this.val, f22, RangeSlider.this.val_pct, RangeSlider.this.knob.getPosition().minus(RangeSlider.this.bar.getPosition()), null));
                }
            }
        };
        this.bar.addKeyListener(keyAdapter);
        this.knob.addKeyListener(keyAdapter);
        this.bar.addMouseListener(mouseGestureAdapter);
        this.knob.addMouseListener(mouseGestureAdapter);
        Shape.Listener listener = new Shape.Listener(){
            private final Vec4f origCol = new Vec4f();
            private boolean oriColSet = false;
            private final Vec4f tmp = new Vec4f();

            @Override
            public void run(Shape shape) {
                if (RangeSlider.this.bar.isActive() || RangeSlider.this.knob.isActive()) {
                    if (!this.oriColSet) {
                        this.origCol.set(RangeSlider.this.knob.getColor());
                        this.oriColSet = true;
                    }
                    RangeSlider.this.knob.setColor(this.tmp.mul(this.origCol, RangeSlider.this.activeColMod));
                } else {
                    this.oriColSet = false;
                    RangeSlider.this.knob.setColor(this.origCol);
                }
            }
        };
        this.bar.addActivationListener(listener);
        this.knob.addActivationListener(listener);
    }

    @Override
    public void receiveKeyEvents(Shape shape) {
        shape.addKeyListener(new Shape.ForwardKeyListener(this.barAndKnob));
        shape.addKeyListener(new Shape.ForwardKeyListener(this.knob));
    }

    @Override
    public void receiveMouseEvents(Shape shape) {
        shape.addMouseListener(new Shape.ForwardMouseListener(this.barAndKnob){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
            }
        });
    }

    @Override
    protected void clearImpl0(GL2ES2 gL2ES2, RegionRenderer regionRenderer) {
        super.clearImpl0(gL2ES2, regionRenderer);
        this.changeListeners.clear();
        this.peekListeners.clear();
    }

    @Override
    protected void destroyImpl0(GL2ES2 gL2ES2, RegionRenderer regionRenderer) {
        super.destroyImpl0(gL2ES2, regionRenderer);
        this.changeListeners.clear();
        this.peekListeners.clear();
    }

    public final RangeSlider addChangeListener(ChangeListener changeListener) {
        if (changeListener == null) {
            return this;
        }
        ArrayList arrayList = (ArrayList)this.changeListeners.clone();
        arrayList.add(changeListener);
        this.changeListeners = arrayList;
        return this;
    }

    public final RangeSlider removeChangeListener(ChangeListener changeListener) {
        if (changeListener == null) {
            return this;
        }
        ArrayList arrayList = (ArrayList)this.changeListeners.clone();
        arrayList.remove(changeListener);
        this.changeListeners = arrayList;
        return this;
    }

    private final void dispatchToListener(ChangedAction changedAction) {
        int n = this.changeListeners.size();
        for (int i = 0; i < n; ++i) {
            changedAction.run(this.changeListeners.get(i));
        }
    }

    public final RangeSlider addPeekListener(PeekListener peekListener) {
        if (peekListener == null) {
            return this;
        }
        ArrayList arrayList = (ArrayList)this.peekListeners.clone();
        arrayList.add(peekListener);
        this.peekListeners = arrayList;
        return this;
    }

    public final RangeSlider removePeekListener(PeekListener peekListener) {
        if (peekListener == null) {
            return this;
        }
        ArrayList arrayList = (ArrayList)this.peekListeners.clone();
        arrayList.remove(peekListener);
        this.peekListeners = arrayList;
        return this;
    }

    private final void dispatchToListener(PeekAction peekAction) {
        int n = this.peekListeners.size();
        for (int i = 0; i < n; ++i) {
            peekAction.run(this.peekListeners.get(i));
        }
    }

    public Rectangle getBar() {
        return this.bar;
    }

    public GraphShape getKnob() {
        return this.knob;
    }

    public Group getMarks() {
        return this.marks;
    }

    public RangeSlider clearMarks(GL2ES2 gL2ES2, RegionRenderer regionRenderer) {
        this.marks.clear(gL2ES2, regionRenderer);
        return this;
    }

    public Shape addMark(float f, Vec4f vec4f) {
        float f2;
        float f3;
        float f4;
        float f5;
        if (this.horizontal) {
            f5 = this.size.y();
            f3 = f4 = 2.0f * f5;
            f2 = f5;
        } else {
            f4 = this.size.x();
            f3 = f5 = 2.0f * f4;
            f2 = f4;
        }
        Rectangle rectangle = new Rectangle(this.knob.getRenderModes(), f4, f5, 0.0f);
        Vec2f vec2f = this.getItemValuePos(new Vec2f(), f, f3, f2);
        rectangle.setInteractive(true).setToggleable(false).setDraggable(false).setResizable(false);
        rectangle.setColor(vec4f);
        rectangle.moveTo(vec2f.x(), vec2f.y(), 0.0f);
        this.marks.addShape(rectangle);
        return rectangle;
    }

    public final Vec2f getSize() {
        return this.size;
    }

    public final float getKnobThickness() {
        return this.knobThickn;
    }

    public final float getKnobLength() {
        return this.knobLength;
    }

    public Vec2f getMinMax() {
        return this.minMax;
    }

    public float getRange() {
        return this.minMax.y() - this.minMax.x();
    }

    private static float getRange(Vec2f vec2f) {
        return vec2f.y() - vec2f.x();
    }

    public float getValue() {
        return this.val;
    }

    public float getValuePct() {
        return this.val_pct;
    }

    public RangeSlider setPageSize(float f) {
        return this.setKnobSize(f, true, true);
    }

    private RangeSlider setKnobSize(float f, boolean bl, boolean bl2) {
        if (Float.isFinite(this.pageSize) && Float.isFinite(f)) {
            float f2;
            float f3;
            float f4 = RangeSlider.getRange(this.minMax);
            if (Float.isFinite(f4) && !FloatUtil.isZero(f4)) {
                this.pageSize = Math.min(this.minMax.y(), Math.max(this.minMax.x(), f));
            }
            float f5 = this.getPageSizePct(0.05f);
            if (this.horizontal) {
                f3 = f5 * this.size.x();
                f2 = this.size.y() * 0.6f;
                this.knobLength = f3;
                this.knobThickn = f2;
                if (!this.paddingSet) {
                    this.setPaddding(new Padding(this.size.y() / 2.0f, 0.0f, this.size.y() / 2.0f, 0.0f));
                    this.paddingSet = true;
                }
            } else {
                f3 = this.size.x() * 0.6f;
                this.knobLength = f2 = f5 * this.size.y();
                this.knobThickn = f3;
                if (!this.paddingSet) {
                    this.setPaddding(new Padding(0.0f, this.size.x() / 2.0f, 0.0f, this.size.x() / 2.0f));
                    this.paddingSet = true;
                }
            }
            if (bl) {
                ((Rectangle)this.knob).setDimension(f3, f2, 0.0f);
            }
            if (bl2) {
                this.setValue(this.val);
            }
        } else if (!Float.isFinite(this.pageSize)) {
            if (this.horizontal) {
                this.knobThickn = this.size.y() * this.knobScale;
                if (!this.paddingSet) {
                    this.setPaddding(new Padding(this.knobThickn / 2.0f, 0.0f, this.knobThickn / 2.0f, 0.0f));
                    this.paddingSet = true;
                }
            } else {
                this.knobThickn = this.size.x() * this.knobScale;
                if (!this.paddingSet) {
                    this.setPaddding(new Padding(0.0f, this.knobThickn / 2.0f, 0.0f, this.knobThickn / 2.0f));
                    this.paddingSet = true;
                }
            }
            this.knobLength = this.knobThickn;
        }
        return this;
    }

    private void setMinMaxImpl(float f, float f2) {
        this.minMax.set(Float.isFinite(f) ? f : 0.0f, Float.isFinite(f2) ? f2 : 0.0f);
    }

    private RangeSlider reconfig(Vec2f vec2f, boolean bl, float f, boolean bl2, float f2) {
        if (null != vec2f) {
            this.setMinMaxImpl(vec2f.x(), vec2f.y());
        }
        if (bl2) {
            this.setKnobSize(f2, true, !bl);
        }
        if (bl) {
            this.setValue(f);
        }
        return this;
    }

    public float getPageSize() {
        return this.pageSize;
    }

    public float getPageSizePct(float f) {
        if (Float.isFinite(this.pageSize)) {
            float f2 = RangeSlider.getRange(this.minMax);
            return Float.isFinite(f2) && !FloatUtil.isZero(f2) ? Math.max(f, this.pageSize / f2) : f;
        }
        return Float.NaN;
    }

    public RangeSlider setUnitSize(float f) {
        this.unitSize = f;
        return this;
    }

    public float getUnitSize() {
        return this.unitSize;
    }

    public RangeSlider setInverted(boolean bl) {
        this.inverted = bl;
        return this.setValue(this.val);
    }

    public boolean isInverted() {
        return this.inverted;
    }

    public RangeSlider setMinMax(Vec2f vec2f, float f) {
        return this.reconfig(vec2f, true, f, true, this.pageSize);
    }

    public RangeSlider setMinMax(Vec2f vec2f) {
        return this.reconfig(vec2f, false, 0.0f, true, this.pageSize);
    }

    public RangeSlider setMinMaxPgSz(Vec2f vec2f, float f, float f2) {
        return this.reconfig(vec2f, true, f, true, f2);
    }

    public RangeSlider setMinMaxPgSz(Vec2f vec2f, float f) {
        return this.reconfig(vec2f, false, 0.0f, true, f);
    }

    private RangeSlider setValue(float f, float f2, float f3) {
        return this.setValue(this.valuePctToValue(this.getKnobValuePct(f, f2, f3)));
    }

    public RangeSlider setValue(float f) {
        float f2 = Float.isFinite(f) ? f : 0.0f;
        float f3 = Float.isFinite(this.pageSize) ? this.pageSize : 0.0f;
        float f4 = this.getRange();
        this.val = Math.max(this.minMax.x(), Math.min(this.minMax.y() - f3, f2));
        this.val_pct = Float.isFinite(f4) && !FloatUtil.isZero(f4) ? (this.val - this.minMax.x()) / f4 : 0.0f;
        this.setKnob();
        return this;
    }

    private Vec2f getItemValuePos(Vec2f vec2f, float f, float f2, float f3) {
        return this.getItemPctPos(vec2f, (f - this.minMax.x()) / this.getRange(), f2, f3);
    }

    private Vec2f getItemPctPos(Vec2f vec2f, float f, float f2, float f3) {
        float f4;
        float f5 = f4 = this.inverted ? 1.0f - f : f;
        float f6 = Float.isFinite(this.pageSize) ? (this.inverted ? f2 : 0.0f) : f2 * 0.5f;
        if (this.horizontal) {
            vec2f.setX(Math.max(0.0f, Math.min(this.size.x() - f2, f4 * this.size.x() - f6)));
            vec2f.setY(-(f3 - this.size.y()) * 0.5f);
        } else {
            vec2f.setX(-(f3 - this.size.x()) * 0.5f);
            vec2f.setY(Math.max(0.0f, Math.min(this.size.y() - f2, f4 * this.size.y() - f6)));
        }
        return vec2f;
    }

    private float getKnobValuePct(float f, float f2, float f3) {
        float f4 = this.horizontal ? (f + f3) / this.size.x() : (f2 + f3) / this.size.y();
        return Math.max(0.0f, Math.min(1.0f, this.inverted ? 1.0f - f4 : f4));
    }

    private float valuePctToValue(float f) {
        float f2 = this.getRange();
        if (Float.isFinite(f) && Float.isFinite(f2) && !FloatUtil.isZero(f2)) {
            float f3 = Float.isFinite(this.pageSize) ? this.pageSize / f2 : 0.0f;
            float f4 = Math.max(0.0f, Math.min(1.0f - f3, f));
            return this.minMax.x() + f4 * f2;
        }
        return 0.0f;
    }

    private void setKnob() {
        Vec2f vec2f = this.getItemPctPos(new Vec2f(), this.val_pct, this.knobLength, this.knobThickn);
        this.knob.moveTo(vec2f.x(), vec2f.y(), 1.53E-4f);
    }

    @Override
    public final Shape setColor(float f, float f2, float f3, float f4) {
        super.setColor(f, f2, f3, f4);
        this.knob.setColor(f, f2, f3, f4);
        if (Float.isFinite(this.pageSize)) {
            this.bar.setColor(f, f2, f3, 1.0f);
        }
        return this;
    }

    @Override
    public Shape setColor(Vec4f vec4f) {
        this.rgbaColor.set(vec4f);
        this.knob.setColor(vec4f);
        if (Float.isFinite(this.pageSize)) {
            this.bar.setColor(vec4f.x(), vec4f.y(), vec4f.z(), 1.0f);
        }
        return this;
    }

    public Shape setActiveKnobColorMod(Vec4f vec4f) {
        if (!Float.isFinite(this.pageSize)) {
            this.activeColMod.set(vec4f);
        }
        return this;
    }

    public Shape setBackgroundBarColor(float f, float f2, float f3, float f4) {
        if (!Float.isFinite(this.pageSize)) {
            this.bar.setColor(f, f2, f3, f4);
        }
        return this;
    }

    public Shape setBackgroundBarColor(Vec4f vec4f) {
        if (!Float.isFinite(this.pageSize)) {
            this.bar.setColor(vec4f);
        }
        return this;
    }

    @Override
    public final Shape setPressedColorMod(float f, float f2, float f3, float f4) {
        super.setPressedColorMod(f, f2, f3, f4);
        this.bar.setPressedColorMod(f, f2, f3, f4);
        this.knob.setPressedColorMod(f, f2, f3, f4);
        return this;
    }

    public String getDescription() {
        String string = "value " + this.val + " " + 100.0f * this.val_pct + "%, range " + this.minMax;
        String string2 = ", ssize " + this.size + ", knob[l " + this.knobLength + ", t " + this.knobThickn + "]";
        if (Float.isFinite(this.pageSize)) {
            float f = this.getPageSizePct(0.05f);
            String string3 = ", pageSize " + this.pageSize + " " + f * 100.0f + "% -> " + this.knobLength;
            if (this.horizontal) {
                return "H " + string + string3 + "/" + this.size.x() + string2;
            }
            return "V " + string + string3 + "/" + this.size.y() + string2;
        }
        if (this.horizontal) {
            return "H " + string + string2;
        }
        return "V " + string + string2;
    }

    @Override
    public String getSubString() {
        return super.getSubString() + ", " + this.getDescription() + " @ " + this.val + ", " + 100.0f * this.val_pct + "%";
    }

    @Override
    protected void validateImpl(GL2ES2 gL2ES2, GLProfile gLProfile) {
        if (this.isShapeDirty()) {
            super.validateImpl(gL2ES2, gLProfile);
            this.setKnobSize(this.pageSize, true, true);
        }
    }

    public static interface ChangeListener {
        public void dragged(RangeSlider var1, float var2, float var3, float var4, float var5, Vec3f var6, MouseEvent var7);
    }

    private static interface ChangedAction {
        public void run(ChangeListener var1);
    }

    private static interface PeekAction {
        public void run(PeekListener var1);
    }

    public static interface PeekListener {
        public void peeked(RangeSlider var1, float var2, float var3, Vec3f var4, MouseEvent var5);
    }
}

