/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.ext.awt.image.impl;

import io.sf.carte.echosvg.ext.awt.color.StandardColorSpaces;
import io.sf.carte.echosvg.ext.awt.image.GraphicsUtil;
import io.sf.carte.echosvg.ext.awt.image.rendered.AbstractRed;
import io.sf.carte.echosvg.ext.awt.image.rendered.CachableRed;
import java.awt.color.ColorSpace;
import java.awt.image.BandCombineOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;

public class Any2RGBRed
extends AbstractRed {
    public Any2RGBRed(CachableRed cachableRed, ColorSpace colorSpace) {
        super(cachableRed, cachableRed.getBounds(), Any2RGBRed.mergeColorModel(cachableRed, colorSpace), Any2RGBRed.fixSampleModel(cachableRed), cachableRed.getTileGridXOffset(), cachableRed.getTileGridYOffset(), null);
    }

    private static boolean is_INT_PACK_COMP(SampleModel sampleModel) {
        if (!(sampleModel instanceof SinglePixelPackedSampleModel)) {
            return false;
        }
        if (sampleModel.getDataType() != 3) {
            return false;
        }
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)sampleModel;
        int[] nArray = singlePixelPackedSampleModel.getBitMasks();
        if (nArray.length != 3 && nArray.length != 4) {
            return false;
        }
        if (nArray[0] != 0xFF0000) {
            return false;
        }
        if (nArray[1] != 65280) {
            return false;
        }
        if (nArray[2] != 255) {
            return false;
        }
        return nArray.length != 4 || nArray[3] == -16777216;
    }

    @Override
    public WritableRaster copyData(WritableRaster writableRaster) {
        CachableRed cachableRed = (CachableRed)this.getSources().get(0);
        ColorModel colorModel = cachableRed.getColorModel();
        SampleModel sampleModel = cachableRed.getSampleModel();
        if (colorModel == null) {
            float[][] fArray = null;
            switch (sampleModel.getNumBands()) {
                case 1: {
                    fArray = new float[3][1];
                    fArray[0][0] = 1.0f;
                    fArray[1][0] = 1.0f;
                    fArray[2][0] = 1.0f;
                    break;
                }
                case 2: {
                    fArray = new float[4][2];
                    fArray[0][0] = 1.0f;
                    fArray[1][0] = 1.0f;
                    fArray[2][0] = 1.0f;
                    fArray[3][1] = 1.0f;
                    break;
                }
                case 3: {
                    fArray = new float[3][3];
                    fArray[0][0] = 1.0f;
                    fArray[1][1] = 1.0f;
                    fArray[2][2] = 1.0f;
                    break;
                }
                default: {
                    fArray = new float[4][sampleModel.getNumBands()];
                    fArray[0][0] = 1.0f;
                    fArray[1][1] = 1.0f;
                    fArray[2][2] = 1.0f;
                    fArray[3][3] = 1.0f;
                }
            }
            Raster raster = cachableRed.getData(writableRaster.getBounds());
            BandCombineOp bandCombineOp = new BandCombineOp(fArray, null);
            bandCombineOp.filter(raster, writableRaster);
            return writableRaster;
        }
        if (colorModel.getColorSpace() == ColorSpace.getInstance(1003)) {
            try {
                float[][] fArray = null;
                switch (sampleModel.getNumBands()) {
                    case 1: {
                        fArray = new float[3][1];
                        fArray[0][0] = 1.0f;
                        fArray[1][0] = 1.0f;
                        fArray[2][0] = 1.0f;
                        break;
                    }
                    default: {
                        fArray = new float[4][2];
                        fArray[0][0] = 1.0f;
                        fArray[1][0] = 1.0f;
                        fArray[2][0] = 1.0f;
                        fArray[3][1] = 1.0f;
                    }
                }
                Raster raster = cachableRed.getData(writableRaster.getBounds());
                BandCombineOp bandCombineOp = new BandCombineOp(fArray, null);
                bandCombineOp.filter(raster, writableRaster);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            return writableRaster;
        }
        ColorModel colorModel2 = this.getColorModel();
        if (colorModel.getColorSpace() == colorModel2.getColorSpace()) {
            if (Any2RGBRed.is_INT_PACK_COMP(sampleModel)) {
                cachableRed.copyData(writableRaster);
            } else {
                GraphicsUtil.copyData(cachableRed.getData(writableRaster.getBounds()), writableRaster);
            }
            return writableRaster;
        }
        Raster raster = cachableRed.getData(writableRaster.getBounds());
        WritableRaster writableRaster2 = (WritableRaster)raster;
        ColorModel colorModel3 = colorModel;
        if (colorModel.hasAlpha()) {
            colorModel3 = GraphicsUtil.coerceData(writableRaster2, colorModel, false);
        }
        BufferedImage bufferedImage = new BufferedImage(colorModel3, writableRaster2.createWritableTranslatedChild(0, 0), false, null);
        ColorConvertOp colorConvertOp = new ColorConvertOp(colorModel2.getColorSpace(), null);
        BufferedImage bufferedImage2 = colorConvertOp.filter(bufferedImage, null);
        WritableRaster writableRaster3 = writableRaster.createWritableTranslatedChild(0, 0);
        for (int i = 0; i < colorModel2.getColorSpace().getNumComponents(); ++i) {
            Any2RGBRed.copyBand(bufferedImage2.getRaster(), i, writableRaster3, i);
        }
        if (colorModel2.hasAlpha()) {
            Any2RGBRed.copyBand(writableRaster2, sampleModel.getNumBands() - 1, writableRaster, this.getSampleModel().getNumBands() - 1);
        }
        return writableRaster;
    }

    private static ColorModel mergeColorModel(CachableRed cachableRed, ColorSpace colorSpace) {
        ColorModel colorModel = cachableRed.getColorModel();
        if (colorModel != null) {
            ColorSpace colorSpace2 = colorModel.getColorSpace();
            colorModel = colorSpace2.getType() != 5 ? (colorModel.hasAlpha() ? GraphicsUtil.sRGB_Unpre : GraphicsUtil.sRGB) : ((colorSpace2 = StandardColorSpaces.mergeColorSpace(colorSpace, colorSpace2)) == null || colorSpace2.isCS_sRGB() ? (colorModel.hasAlpha() ? GraphicsUtil.sRGB_Unpre : GraphicsUtil.sRGB) : (colorModel.hasAlpha() ? new DirectColorModel(colorSpace2, 32, 0xFF0000, 65280, 255, -16777216, false, 3) : new DirectColorModel(colorSpace2, 24, 0xFF0000, 65280, 255, -16777216, false, 3)));
        } else {
            int n = cachableRed.getSampleModel().getNumBands();
            if (colorSpace == null || colorSpace.isCS_sRGB()) {
                switch (n) {
                    case 1: 
                    case 3: {
                        colorModel = GraphicsUtil.sRGB;
                        break;
                    }
                    default: {
                        colorModel = GraphicsUtil.sRGB_Unpre;
                        break;
                    }
                }
            } else {
                switch (n) {
                    case 1: 
                    case 3: {
                        colorModel = new DirectColorModel(colorSpace, 24, 0xFF0000, 65280, 255, 0, false, 3);
                        break;
                    }
                    default: {
                        colorModel = new DirectColorModel(colorSpace, 32, 0xFF0000, 65280, 255, -16777216, false, 3);
                    }
                }
            }
        }
        return colorModel;
    }

    private static SampleModel fixSampleModel(CachableRed cachableRed) {
        SampleModel sampleModel = cachableRed.getSampleModel();
        ColorModel colorModel = cachableRed.getColorModel();
        boolean bl = false;
        if (colorModel != null) {
            bl = colorModel.hasAlpha();
        } else {
            switch (sampleModel.getNumBands()) {
                case 1: 
                case 3: {
                    bl = false;
                    break;
                }
                default: {
                    bl = true;
                }
            }
        }
        sampleModel = bl ? new SinglePixelPackedSampleModel(3, sampleModel.getWidth(), sampleModel.getHeight(), new int[]{0xFF0000, 65280, 255, -16777216}) : new SinglePixelPackedSampleModel(3, sampleModel.getWidth(), sampleModel.getHeight(), new int[]{0xFF0000, 65280, 255});
        return sampleModel;
    }
}

