/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.CSSValueSyntax;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.property.AbstractTextValue;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import org.w3c.dom.DOMException;

public class UnknownValue
extends AbstractTextValue {
    private static final long serialVersionUID = 1L;
    private boolean priorityCompat = false;

    public UnknownValue() {
        super(CSSValue.Type.UNKNOWN);
    }

    protected UnknownValue(UnknownValue unknownValue) {
        super(unknownValue);
        this.setCssText(unknownValue.getCssText());
    }

    @Override
    public void setCssText(String string) throws DOMException {
        this.checkModifiableProperty();
        this.setPlainCssText(string);
    }

    @Override
    public void writeCssText(SimpleWriter simpleWriter) throws IOException {
        simpleWriter.write((CharSequence)this.getCssText());
    }

    public boolean isPriorityCompat() {
        return this.priorityCompat;
    }

    @Override
    public CSSValueSyntax.Match matches(CSSValueSyntax cSSValueSyntax) {
        if (cSSValueSyntax != null && cSSValueSyntax.getCategory() == CSSValueSyntax.Category.universal) {
            return CSSValueSyntax.Match.PENDING;
        }
        return CSSValueSyntax.Match.FALSE;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        UnknownValue unknownValue = (UnknownValue)object;
        return this.getCssText().equals(unknownValue.getCssText());
    }

    @Override
    public int hashCode() {
        int n = 31;
        int n2 = super.hashCode();
        n2 = 31 * n2 + this.getCssText().hashCode();
        return n2;
    }

    @Override
    PrimitiveValue.LexicalSetter newLexicalSetter() {
        return new MyLexicalSetter();
    }

    @Override
    public UnknownValue clone() {
        return new UnknownValue(this);
    }

    class MyLexicalSetter
    extends PrimitiveValue.LexicalSetter {
        MyLexicalSetter() {
        }

        @Override
        void setLexicalUnit(LexicalUnit lexicalUnit) {
            String string;
            this.nextLexicalUnit = lexicalUnit.getNextLexicalUnit();
            switch (lexicalUnit.getLexicalUnitType()) {
                case OPERATOR_EXP: {
                    string = "^";
                    break;
                }
                case OPERATOR_GE: {
                    string = ">=";
                    break;
                }
                case OPERATOR_GT: {
                    string = ">";
                    break;
                }
                case OPERATOR_LE: {
                    string = "<=";
                    break;
                }
                case OPERATOR_LT: {
                    string = "<";
                    break;
                }
                case OPERATOR_MINUS: {
                    string = "-";
                    break;
                }
                case OPERATOR_MOD: {
                    string = "%";
                    break;
                }
                case OPERATOR_MULTIPLY: {
                    string = "*";
                    break;
                }
                case OPERATOR_PLUS: {
                    string = "+";
                    break;
                }
                case OPERATOR_TILDE: {
                    string = "~";
                    break;
                }
                case COMPAT_PRIO: {
                    UnknownValue.this.priorityCompat = true;
                }
                case COMPAT_IDENT: {
                    string = lexicalUnit.toString();
                    this.nextLexicalUnit = null;
                    break;
                }
                default: {
                    throw new DOMException(12, "Unsuitable value: " + lexicalUnit.toString());
                }
            }
            UnknownValue.this.setPlainCssText(string);
        }
    }
}

