/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.concurrent.CopyOnWriteArrayList;
import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaMembers;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.MemberBox;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeJavaArray;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.ResolvedOverload;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.Wrapper;

public class NativeJavaMethod
extends BaseFunction {
    private static final long serialVersionUID = -3440381785576412928L;
    private static final int PREFERENCE_EQUAL = 0;
    private static final int PREFERENCE_FIRST_ARG = 1;
    private static final int PREFERENCE_SECOND_ARG = 2;
    private static final int PREFERENCE_AMBIGUOUS = 3;
    private static final boolean debug = false;
    MemberBox[] methods;
    private String functionName;
    private final transient CopyOnWriteArrayList<ResolvedOverload> overloadCache = new CopyOnWriteArrayList();

    NativeJavaMethod(MemberBox[] memberBoxArray) {
        this.functionName = memberBoxArray[0].getName();
        this.methods = memberBoxArray;
    }

    NativeJavaMethod(MemberBox[] memberBoxArray, String string) {
        this.functionName = string;
        this.methods = memberBoxArray;
    }

    NativeJavaMethod(MemberBox memberBox, String string) {
        this.functionName = string;
        this.methods = new MemberBox[]{memberBox};
    }

    public NativeJavaMethod(Method method, String string) {
        this(new MemberBox(method), string);
    }

    @Override
    public String getFunctionName() {
        return this.functionName;
    }

    static String scriptSignature(Object[] objectArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i != objectArray.length; ++i) {
            String string;
            Object object = objectArray[i];
            if (object == null) {
                string = "null";
            } else if (object instanceof Boolean) {
                string = "boolean";
            } else if (object instanceof String) {
                string = "string";
            } else if (object instanceof Number) {
                string = "number";
            } else if (object instanceof Scriptable) {
                if (object instanceof Undefined) {
                    string = "undefined";
                } else if (object instanceof Wrapper) {
                    Object object2 = ((Wrapper)object).unwrap();
                    string = object2.getClass().getName();
                } else {
                    string = object instanceof Function ? "function" : "object";
                }
            } else {
                string = JavaMembers.javaSignature(object.getClass());
            }
            if (i != 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    @Override
    String decompile(int n, int n2) {
        boolean bl;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = bl = 0 != (n2 & 1);
        if (!bl) {
            stringBuilder.append("function ");
            stringBuilder.append(this.getFunctionName());
            stringBuilder.append("() {");
        }
        stringBuilder.append("/*\n");
        stringBuilder.append(this.toString());
        stringBuilder.append(bl ? "*/\n" : "*/}\n");
        return stringBuilder.toString();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = this.methods.length;
        for (int i = 0; i != n; ++i) {
            if (this.methods[i].isMethod()) {
                Method method = this.methods[i].method();
                stringBuilder.append(JavaMembers.javaSignature(method.getReturnType()));
                stringBuilder.append(' ');
                stringBuilder.append(method.getName());
            } else {
                stringBuilder.append(this.methods[i].getName());
            }
            stringBuilder.append(JavaMembers.liveConnectSignature(this.methods[i].argTypes));
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    @Override
    public Object call(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        Class<?> clazz;
        Object object;
        if (this.methods.length == 0) {
            throw new RuntimeException("No methods defined for call");
        }
        int n = this.findCachedFunction(context, objectArray);
        if (n < 0) {
            Class<?> clazz2 = this.methods[0].method().getDeclaringClass();
            String string = clazz2.getName() + '.' + this.getFunctionName() + '(' + NativeJavaMethod.scriptSignature(objectArray) + ')';
            throw Context.reportRuntimeErrorById("msg.java.no_such_method", string);
        }
        MemberBox memberBox = this.methods[n];
        Class<?>[] classArray = memberBox.argTypes;
        if (memberBox.vararg) {
            Object object2;
            object = new Object[classArray.length];
            for (int i = 0; i < classArray.length - 1; ++i) {
                object[i] = Context.jsToJava(objectArray[i], classArray[i]);
            }
            if (objectArray.length == classArray.length && (objectArray[objectArray.length - 1] == null || objectArray[objectArray.length - 1] instanceof NativeArray || objectArray[objectArray.length - 1] instanceof NativeJavaArray)) {
                object2 = Context.jsToJava(objectArray[objectArray.length - 1], classArray[classArray.length - 1]);
            } else {
                clazz = classArray[classArray.length - 1].getComponentType();
                object2 = Array.newInstance(clazz, objectArray.length - classArray.length + 1);
                for (int i = 0; i < Array.getLength(object2); ++i) {
                    Object object3 = Context.jsToJava(objectArray[classArray.length - 1 + i], clazz);
                    Array.set(object2, i, object3);
                }
            }
            object[classArray.length - 1] = object2;
            objectArray = object;
        } else {
            object = objectArray;
            for (int i = 0; i < objectArray.length; ++i) {
                clazz = objectArray[i];
                Object object4 = Context.jsToJava(clazz, classArray[i]);
                if (object4 == clazz) continue;
                if (object == objectArray) {
                    objectArray = (Object[])objectArray.clone();
                }
                objectArray[i] = object4;
            }
        }
        if (memberBox.isStatic()) {
            object = null;
        } else {
            Scriptable scriptable3 = scriptable2;
            clazz = memberBox.getDeclaringClass();
            while (true) {
                if (scriptable3 == null) {
                    throw Context.reportRuntimeErrorById("msg.nonjava.method", this.getFunctionName(), ScriptRuntime.toString(scriptable2), clazz.getName());
                }
                if (scriptable3 instanceof Wrapper && clazz.isInstance(object = ((Wrapper)((Object)scriptable3)).unwrap())) break;
                scriptable3 = scriptable3.getPrototype();
            }
        }
        Object object5 = memberBox.invoke(object, objectArray);
        clazz = memberBox.method().getReturnType();
        Object object6 = context.getWrapFactory().wrap(context, scriptable, object5, clazz);
        if (object6 == null && clazz == Void.TYPE) {
            object6 = Undefined.instance;
        }
        return object6;
    }

    int findCachedFunction(Context context, Object[] objectArray) {
        if (this.methods.length > 1) {
            for (ResolvedOverload resolvedOverload : this.overloadCache) {
                if (!resolvedOverload.matches(objectArray)) continue;
                return resolvedOverload.index;
            }
            int n = NativeJavaMethod.findFunction(context, this.methods, objectArray);
            if (this.overloadCache.size() < this.methods.length * 2) {
                ResolvedOverload resolvedOverload;
                resolvedOverload = new ResolvedOverload(objectArray, n);
                this.overloadCache.addIfAbsent(resolvedOverload);
            }
            return n;
        }
        return NativeJavaMethod.findFunction(context, this.methods, objectArray);
    }

    static int findFunction(Context context, MemberBox[] memberBoxArray, Object[] objectArray) {
        if (memberBoxArray.length == 0) {
            return -1;
        }
        if (memberBoxArray.length == 1) {
            MemberBox memberBox = memberBoxArray[0];
            Class<?>[] classArray = memberBox.argTypes;
            int n = classArray.length;
            if (memberBox.vararg ? --n > objectArray.length : n != objectArray.length) {
                return -1;
            }
            for (int i = 0; i != n; ++i) {
                if (NativeJavaObject.canConvert(objectArray[i], classArray[i])) continue;
                return -1;
            }
            return 0;
        }
        int n = -1;
        int[] nArray = null;
        int n2 = 0;
        block1: for (int i = 0; i < memberBoxArray.length; ++i) {
            int n3;
            MemberBox memberBox = memberBoxArray[i];
            Class<?>[] classArray = memberBox.argTypes;
            int n4 = classArray.length;
            if (memberBox.vararg ? --n4 > objectArray.length : n4 != objectArray.length) continue;
            for (n3 = 0; n3 < n4; ++n3) {
                if (!NativeJavaObject.canConvert(objectArray[n3], classArray[n3])) continue block1;
            }
            if (n < 0) {
                n = i;
                continue;
            }
            n3 = 0;
            int n5 = 0;
            for (int j = -1; j != n2; ++j) {
                int n6 = j == -1 ? n : nArray[j];
                MemberBox memberBox2 = memberBoxArray[n6];
                if (context.hasFeature(13) && memberBox2.isPublic() != memberBox.isPublic()) {
                    if (!memberBox2.isPublic()) {
                        ++n3;
                        continue;
                    }
                    ++n5;
                    continue;
                }
                int n7 = NativeJavaMethod.preferSignature(objectArray, classArray, memberBox.vararg, memberBox2.argTypes, memberBox2.vararg);
                if (n7 == 3) break;
                if (n7 == 1) {
                    ++n3;
                    continue;
                }
                if (n7 == 2) {
                    ++n5;
                    continue;
                }
                if (n7 != 0) {
                    Kit.codeBug();
                }
                if (!memberBox2.isStatic() || !memberBox2.getDeclaringClass().isAssignableFrom(memberBox.getDeclaringClass())) continue block1;
                if (j == -1) {
                    n = i;
                    continue block1;
                }
                nArray[j] = i;
                continue block1;
            }
            if (n3 == 1 + n2) {
                n = i;
                n2 = 0;
                continue;
            }
            if (n5 == 1 + n2) continue;
            if (nArray == null) {
                nArray = new int[memberBoxArray.length - 1];
            }
            nArray[n2] = i;
            ++n2;
        }
        if (n < 0) {
            return -1;
        }
        if (n2 == 0) {
            return n;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = -1; i != n2; ++i) {
            int n8 = i == -1 ? n : nArray[i];
            stringBuilder.append("\n    ");
            stringBuilder.append(memberBoxArray[n8].toJavaDeclaration());
        }
        MemberBox memberBox = memberBoxArray[n];
        String string = memberBox.getName();
        String string2 = memberBox.getDeclaringClass().getName();
        if (memberBoxArray[0].isCtor()) {
            throw Context.reportRuntimeErrorById("msg.constructor.ambiguous", string, NativeJavaMethod.scriptSignature(objectArray), stringBuilder.toString());
        }
        throw Context.reportRuntimeErrorById("msg.method.ambiguous", string2, string, NativeJavaMethod.scriptSignature(objectArray), stringBuilder.toString());
    }

    private static int preferSignature(Object[] objectArray, Class<?>[] classArray, boolean bl, Class<?>[] classArray2, boolean bl2) {
        int n = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            int n2;
            Class<?> clazz;
            Class<?> clazz2 = bl && i >= classArray.length ? classArray[classArray.length - 1] : classArray[i];
            Class<?> clazz3 = clazz = bl2 && i >= classArray2.length ? classArray2[classArray2.length - 1] : classArray2[i];
            if (clazz2 == clazz) continue;
            Object object = objectArray[i];
            int n3 = NativeJavaObject.getConversionWeight(object, clazz2);
            int n4 = n3 < (n2 = NativeJavaObject.getConversionWeight(object, clazz)) ? 1 : (n3 > n2 ? 2 : (n3 == 0 ? (clazz2.isAssignableFrom(clazz) ? 2 : (clazz.isAssignableFrom(clazz2) ? 1 : 3)) : 3));
            if ((n |= n4) == 3) break;
        }
        return n;
    }

    private static void printDebug(String string, MemberBox memberBox, Object[] objectArray) {
    }
}

