/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Decompiler;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.NativeCall;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.UintMap;
import org.mozilla.javascript.debug.DebuggableScript;

public abstract class NativeFunction
extends BaseFunction {
    private static final long serialVersionUID = 8713897114082216401L;

    public final void initScriptFunction(Context context, Scriptable scriptable) {
        this.initScriptFunction(context, scriptable, this.isGeneratorFunction());
    }

    public final void initScriptFunction(Context context, Scriptable scriptable, boolean bl) {
        ScriptRuntime.setFunctionProtoAndParent(this, context, scriptable, bl);
    }

    @Override
    final String decompile(int n, int n2) {
        String string = this.getEncodedSource();
        if (string == null) {
            return super.decompile(n, n2);
        }
        UintMap uintMap = new UintMap(1);
        uintMap.put(1, n);
        return Decompiler.decompile(string, n2, uintMap);
    }

    @Override
    public int getLength() {
        int n = this.getParamCount();
        if (this.getLanguageVersion() != 120) {
            return n;
        }
        Context context = Context.getContext();
        NativeCall nativeCall = ScriptRuntime.findFunctionActivation(context, this);
        if (nativeCall == null) {
            return n;
        }
        return nativeCall.originalArgs.length;
    }

    @Override
    public int getArity() {
        return this.getParamCount();
    }

    @Deprecated
    public String jsGet_name() {
        return this.getFunctionName();
    }

    public String getEncodedSource() {
        return null;
    }

    public DebuggableScript getDebuggableView() {
        return null;
    }

    public Object resumeGenerator(Context context, Scriptable scriptable, int n, Object object, Object object2) {
        throw new EvaluatorException("resumeGenerator() not implemented");
    }

    protected abstract int getLanguageVersion();

    protected abstract int getParamCount();

    protected abstract int getParamAndVarCount();

    protected abstract String getParamOrVarName(int var1);

    protected boolean getParamOrVarConst(int n) {
        return false;
    }
}

