/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.style.css.CSSColor;
import io.sf.carte.doc.style.css.CSSColorValue;
import io.sf.carte.doc.style.css.CSSTypedValue;
import io.sf.carte.doc.style.css.LABColor;
import io.sf.carte.doc.style.css.RGBAColor;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.property.BaseColor;
import io.sf.carte.doc.style.css.property.ColorUtil;
import io.sf.carte.doc.style.css.property.ColorValue;
import io.sf.carte.doc.style.css.property.LABColorImpl;
import io.sf.carte.doc.style.css.property.LABColorValue;
import io.sf.carte.doc.style.css.property.LCHColorValue;
import io.sf.carte.doc.style.css.property.NumberValue;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.RGBColor;
import io.sf.carte.doc.style.css.property.SRGBColorProfile;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.doc.style.css.property.XYZColorImpl;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import org.w3c.dom.DOMException;

class OKLABColorValue
extends ColorValue
implements io.sf.carte.doc.style.css.LABColorValue {
    private static final long serialVersionUID = 1L;
    private final LABColorImpl labColor;

    public OKLABColorValue() {
        this(new LABColorImpl(BaseColor.Space.OK_Lab, "oklab"));
    }

    OKLABColorValue(LABColorImpl lABColorImpl) {
        this.labColor = lABColorImpl;
    }

    OKLABColorValue(OKLABColorValue oKLABColorValue) {
        super(oKLABColorValue);
        this.labColor = oKLABColorValue.labColor.clone();
    }

    @Override
    public CSSColorValue.ColorModel getColorModel() {
        return CSSColorValue.ColorModel.LAB;
    }

    @Override
    void set(StyleValue styleValue) {
        super.set(styleValue);
        OKLABColorValue oKLABColorValue = (OKLABColorValue)styleValue;
        this.labColor.set(oKLABColorValue.labColor);
    }

    @Override
    public String getCssText() {
        return this.labColor.toString();
    }

    @Override
    public String getMinifiedCssText(String string) {
        return this.labColor.toMinifiedString();
    }

    @Override
    public void writeCssText(SimpleWriter simpleWriter) throws IOException {
        this.labColor.writeCssText(simpleWriter);
    }

    @Override
    public PrimitiveValue getComponent(int n) {
        return this.labColor.item(n);
    }

    @Override
    public void setComponent(int n, StyleValue styleValue) {
        this.labColor.setComponent(n, (PrimitiveValue)styleValue);
    }

    @Override
    public RGBAColor toRGBColor() throws DOMException {
        return this.toRGBColor(true);
    }

    @Override
    public RGBAColor toRGBColor(boolean bl) throws DOMException {
        if (!this.labColor.hasConvertibleComponents()) {
            throw new DOMException(11, "Cannot convert.");
        }
        float f = ((CSSTypedValue)((Object)this.labColor.getLightness())).getFloatValue((short)0);
        float f2 = ((CSSTypedValue)((Object)this.labColor.getA())).getFloatValue((short)0);
        float f3 = ((CSSTypedValue)((Object)this.labColor.getB())).getFloatValue((short)0);
        SRGBColorProfile sRGBColorProfile = new SRGBColorProfile();
        double[] dArray = new double[3];
        ColorUtil.oklabToRGB(f, f2, f3, bl, sRGBColorProfile, dArray);
        ColorValue.CSSRGBColor cSSRGBColor = new ColorValue.CSSRGBColor();
        cSSRGBColor.setColorComponents(dArray);
        cSSRGBColor.setAlpha(this.labColor.getAlpha().clone());
        return cSSRGBColor;
    }

    @Override
    public LABColorValue toLABColorValue() {
        if (!this.labColor.hasConvertibleComponents()) {
            throw new DOMException(11, "Cannot convert.");
        }
        float f = ((CSSTypedValue)((Object)this.labColor.getLightness())).getFloatValue((short)0);
        float f2 = ((CSSTypedValue)((Object)this.labColor.getA())).getFloatValue((short)0);
        float f3 = ((CSSTypedValue)((Object)this.labColor.getB())).getFloatValue((short)0);
        double[] dArray = new double[3];
        ColorUtil.oklabToLab(f, f2, f3, dArray);
        NumberValue numberValue = NumberValue.createCSSNumberValue((short)0, (float)dArray[0]);
        NumberValue numberValue2 = NumberValue.createCSSNumberValue((short)0, (float)dArray[1]);
        NumberValue numberValue3 = NumberValue.createCSSNumberValue((short)0, (float)dArray[2]);
        numberValue.setAbsolutizedUnit();
        numberValue2.setAbsolutizedUnit();
        numberValue3.setAbsolutizedUnit();
        LABColorValue lABColorValue = new LABColorValue();
        lABColorValue.setComponent(0, this.labColor.getAlpha().clone());
        lABColorValue.setComponent(1, numberValue);
        lABColorValue.setComponent(2, numberValue2);
        lABColorValue.setComponent(3, numberValue3);
        return lABColorValue;
    }

    @Override
    public LCHColorValue toLCHColorValue() throws DOMException {
        if (!this.labColor.hasConvertibleComponents()) {
            throw new DOMException(11, "Cannot convert.");
        }
        float f = ((CSSTypedValue)((Object)this.labColor.getLightness())).getFloatValue((short)0);
        double d = ((CSSTypedValue)((Object)this.labColor.getA())).getFloatValue((short)0);
        double d2 = ((CSSTypedValue)((Object)this.labColor.getB())).getFloatValue((short)0);
        double[] dArray = new double[3];
        ColorUtil.oklabToLab(f, d, d2, dArray);
        d = dArray[1];
        d2 = dArray[2];
        double d3 = Math.sqrt(d * d + d2 * d2);
        double d4 = Math.atan2(d2, d) * 180.0 / Math.PI;
        if (d4 < 0.0) {
            d4 += 360.0;
        }
        NumberValue numberValue = NumberValue.createCSSNumberValue((short)0, (float)dArray[0]);
        NumberValue numberValue2 = NumberValue.createCSSNumberValue((short)0, (float)d3);
        NumberValue numberValue3 = NumberValue.createCSSNumberValue((short)80, (float)d4);
        numberValue.setAbsolutizedUnit();
        numberValue2.setAbsolutizedUnit();
        numberValue3.setAbsolutizedUnit();
        LCHColorValue lCHColorValue = new LCHColorValue();
        lCHColorValue.setComponent(0, this.labColor.getAlpha().clone());
        lCHColorValue.setComponent(1, numberValue);
        lCHColorValue.setComponent(2, numberValue2);
        lCHColorValue.setComponent(3, numberValue3);
        return lCHColorValue;
    }

    @Override
    public LABColor getColor() {
        return this.labColor;
    }

    LABColorImpl getLABColorImpl() {
        return this.labColor;
    }

    @Override
    boolean hasConvertibleComponents() {
        return this.labColor.hasConvertibleComponents();
    }

    @Override
    public float deltaE2000(CSSColorValue cSSColorValue) {
        CSSColor cSSColor;
        LABColor lABColor;
        if (!this.labColor.hasConvertibleComponents() || !((ColorValue)cSSColorValue).hasConvertibleComponents()) {
            throw new DOMException(11, "Cannot compute delta.");
        }
        switch (cSSColorValue.getColorModel()) {
            case LAB: {
                lABColor = (LABColor)cSSColorValue.getColor();
                if (!"oklab".equals(lABColor.getColorSpace())) break;
                lABColor = cSSColorValue.toLABColorValue().getColor();
                break;
            }
            case LCH: {
                lABColor = cSSColorValue.toLABColorValue().getColor();
                break;
            }
            case RGB: {
                cSSColor = (RGBColor)cSSColorValue.getColor();
                LABColorImpl lABColorImpl = new LABColorImpl(BaseColor.Space.CIE_Lab, "lab");
                ((BaseColor)cSSColor).toLABColor(lABColorImpl);
                lABColor = lABColorImpl;
                break;
            }
            case XYZ: {
                XYZColorImpl xYZColorImpl = (XYZColorImpl)cSSColorValue.getColor();
                LABColorImpl lABColorImpl = new LABColorImpl(BaseColor.Space.CIE_Lab, "lab");
                xYZColorImpl.toLABColor(lABColorImpl);
                lABColor = lABColorImpl;
                break;
            }
            default: {
                RGBAColor rGBAColor = cSSColorValue.toRGBColor(false);
                CSSColorValue cSSColorValue2 = rGBAColor.packInValue();
                lABColor = cSSColorValue2.toLABColorValue().getColor();
            }
        }
        cSSColor = this.toLABColorValue().getColor();
        return ColorUtil.deltaE2000Lab(((CSSTypedValue)cSSColor.getLightness()).getFloatValue((short)0), ((CSSTypedValue)cSSColor.getA()).getFloatValue((short)0), ((CSSTypedValue)cSSColor.getB()).getFloatValue((short)0), ((CSSTypedValue)lABColor.getLightness()).getFloatValue((short)0), ((CSSTypedValue)lABColor.getA()).getFloatValue((short)0), ((CSSTypedValue)lABColor.getB()).getFloatValue((short)0));
    }

    @Override
    PrimitiveValue.LexicalSetter newLexicalSetter() {
        return new MyLexicalSetter();
    }

    @Override
    public int hashCode() {
        int n = 31;
        int n2 = super.hashCode();
        n2 = 31 * n2 + this.labColor.hashCode();
        return n2;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        OKLABColorValue oKLABColorValue = (OKLABColorValue)object;
        return this.labColor.equals(oKLABColorValue.labColor);
    }

    @Override
    public OKLABColorValue clone() {
        return new OKLABColorValue(this);
    }

    class MyLexicalSetter
    extends PrimitiveValue.LexicalSetter {
        MyLexicalSetter() {
            super(OKLABColorValue.this);
        }

        @Override
        void setLexicalUnit(LexicalUnit lexicalUnit) {
            try {
                if (lexicalUnit.getLexicalUnitType() != LexicalUnit.LexicalType.OKLABCOLOR) {
                    throw new DOMException(13, "No oklab() value: " + lexicalUnit.toString());
                }
                this.setLexicalLAB(lexicalUnit);
            }
            catch (DOMException dOMException) {
                throw dOMException;
            }
            catch (RuntimeException runtimeException) {
                throw new DOMException(12, "Bad value: " + lexicalUnit.toString());
            }
            this.nextLexicalUnit = lexicalUnit.getNextLexicalUnit();
        }

        private void setLexicalLAB(LexicalUnit lexicalUnit) {
            LexicalUnit lexicalUnit2 = lexicalUnit.getParameters();
            ValueFactory valueFactory = new ValueFactory();
            PrimitiveValue primitiveValue = valueFactory.createCSSPrimitiveValue(lexicalUnit2, true);
            lexicalUnit2 = lexicalUnit2.getNextLexicalUnit();
            PrimitiveValue primitiveValue2 = valueFactory.createCSSPrimitiveValue(lexicalUnit2, true);
            lexicalUnit2 = lexicalUnit2.getNextLexicalUnit();
            PrimitiveValue primitiveValue3 = valueFactory.createCSSPrimitiveValue(lexicalUnit2, true);
            if ((lexicalUnit2 = lexicalUnit2.getNextLexicalUnit()) != null) {
                if (lexicalUnit2.getLexicalUnitType() != LexicalUnit.LexicalType.OPERATOR_SLASH) {
                    throw new DOMException(12, "Expected slash in: " + lexicalUnit.toString());
                }
                lexicalUnit2 = lexicalUnit2.getNextLexicalUnit();
                PrimitiveValue primitiveValue4 = valueFactory.createCSSPrimitiveValue(lexicalUnit2, true);
                OKLABColorValue.this.labColor.setAlpha(primitiveValue4);
                lexicalUnit2 = lexicalUnit2.getNextLexicalUnit();
                if (lexicalUnit2 != null) {
                    throw new DOMException(12, "Bad value: " + lexicalUnit.toString());
                }
            }
            OKLABColorValue.this.labColor.setLightness(primitiveValue);
            OKLABColorValue.this.labColor.setA(primitiveValue2);
            OKLABColorValue.this.labColor.setB(primitiveValue3);
        }
    }
}

