/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.ShorthandSetter;
import io.sf.carte.doc.style.css.property.IdentifierValue;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.StringValue;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.TypedValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.DOMException;

class FontShorthandSetter
extends ShorthandSetter {
    private boolean lineHeightSet = false;

    FontShorthandSetter(BaseCSSStyleDeclaration baseCSSStyleDeclaration) {
        super(baseCSSStyleDeclaration, "font");
    }

    @Override
    protected List<String> subpropertyList() {
        List<String> list = super.subpropertyList();
        list.remove("line-height");
        list.remove("font-kerning");
        list.remove("font-optical-sizing");
        list.remove("font-feature-settings");
        list.remove("font-variation-settings");
        list.remove("font-size-adjust");
        list.add(0, "font-variant-css21");
        return list;
    }

    @Override
    public void init(LexicalUnit lexicalUnit, boolean bl) {
        lexicalUnit = this.filterNormalIdentifier(lexicalUnit);
        super.init(lexicalUnit, bl);
    }

    @Override
    public boolean assignSubproperties() {
        if (this.currentValue == null) {
            List<String> list = super.subpropertyList();
            Iterator<String> iterator = list.iterator();
            while (iterator.hasNext()) {
                this.addUnassignedProperty(iterator.next());
            }
            this.resetSubproperties();
            this.flush();
            this.getValueItemBuffer().append("normal");
            this.getValueItemBufferMini().append("normal");
            return true;
        }
        if (this.draftSubproperties()) {
            if (this.getUnassignedProperties().contains("font-family")) {
                if (!this.getUnassignedProperties().contains("font-size")) {
                    this.reportMissingPropertySyntaxError("font-family");
                    return false;
                }
                if (!this.getUnassignedProperties().contains("font-stretch")) {
                    this.reportMissingPropertySyntaxError("font-family");
                    return false;
                }
            } else if (this.getUnassignedProperties().contains("font-size")) {
                this.reportMissingPropertySyntaxError("font-size");
                return false;
            }
            this.flush();
            return true;
        }
        return false;
    }

    private void reportMissingPropertySyntaxError(String string) {
        StringBuilder stringBuilder = new StringBuilder(this.getValueItemBuffer().length() + string.length() + 40);
        stringBuilder.append("This syntax requires ");
        stringBuilder.append(string);
        stringBuilder.append(" to be present: ");
        stringBuilder.append((CharSequence)this.getValueItemBuffer());
        this.reportDeclarationError("font", stringBuilder.toString());
    }

    @Override
    protected void nextCurrentValue() {
        if (this.currentValue != null) {
            this.currentValue = this.filterNormalIdentifier(this.currentValue.getNextLexicalUnit());
            this.appendValueItemString();
        }
    }

    private LexicalUnit filterNormalIdentifier(LexicalUnit lexicalUnit) {
        while (lexicalUnit != null && lexicalUnit.getLexicalUnitType() == LexicalUnit.LexicalType.IDENT && "normal".equalsIgnoreCase(lexicalUnit.getStringValue())) {
            lexicalUnit = lexicalUnit.getNextLexicalUnit();
        }
        return lexicalUnit;
    }

    @Override
    protected boolean assignSubproperty(String string) {
        if (string.equals("font-size") && this.assignFontSize()) {
            if (this.currentValue != null && this.currentValue.getLexicalUnitType() == LexicalUnit.LexicalType.OPERATOR_SLASH) {
                this.nextCurrentValue();
                StyleValue styleValue = this.createCSSValue(string, this.currentValue);
                this.setProperty("line-height", styleValue, this.isPriorityImportant());
                this.nextCurrentValue();
                this.lineHeightSet = true;
            }
            return true;
        }
        switch (this.currentValue.getLexicalUnitType()) {
            case IDENT: {
                if (string.equals("font-variant-css21")) {
                    if (!"small-caps".equalsIgnoreCase(this.currentValue.getStringValue())) break;
                    this.setSubpropertyValue("font-variant-caps", this.createCSSValue("font-variant-caps", this.currentValue));
                    this.nextCurrentValue();
                    return true;
                }
                if (super.assignSubproperty(string)) {
                    return true;
                }
                if (!string.equals("font-family")) break;
                this.consumeFontFamilyIdent();
                while (this.currentValue != null) {
                    LexicalUnit.LexicalType lexicalType = this.currentValue.getLexicalUnitType();
                    if (lexicalType == LexicalUnit.LexicalType.OPERATOR_COMMA) {
                        this.nextCurrentValue();
                        if (this.currentValue == null) {
                            throw new DOMException(12, "Unexpected comma at the end of font-family list");
                        }
                        lexicalType = this.currentValue.getLexicalUnitType();
                    }
                    if (lexicalType == LexicalUnit.LexicalType.IDENT) {
                        this.consumeFontFamilyIdent();
                        continue;
                    }
                    if (lexicalType != LexicalUnit.LexicalType.STRING) break;
                    this.consumeFontFamilyString();
                }
                return true;
            }
            case STRING: {
                if (!string.equals("font-family")) break;
                this.consumeFontFamilyString();
                while (this.currentValue != null) {
                    LexicalUnit.LexicalType lexicalType = this.currentValue.getLexicalUnitType();
                    if (lexicalType == LexicalUnit.LexicalType.OPERATOR_COMMA) {
                        this.nextCurrentValue();
                        if (this.currentValue == null) {
                            throw new DOMException(12, "Unexpected comma at the end of font-family list");
                        }
                        lexicalType = this.currentValue.getLexicalUnitType();
                    }
                    if (lexicalType == LexicalUnit.LexicalType.IDENT) {
                        this.consumeFontFamilyIdent();
                        continue;
                    }
                    if (lexicalType != LexicalUnit.LexicalType.STRING) break;
                    this.consumeFontFamilyString();
                }
                return true;
            }
            case INTEGER: {
                if (!string.equals("font-weight")) break;
                this.setSubpropertyValue("font-weight", this.createCSSValue("font-size", this.currentValue));
                this.nextCurrentValue();
                return true;
            }
        }
        return false;
    }

    private void consumeFontFamilyIdent() {
        Object object;
        CSSValue.Type type = CSSValue.Type.IDENT;
        String string = this.currentValue.getStringValue();
        super.nextCurrentValue();
        while (this.currentValue != null && this.currentValue.getLexicalUnitType() == LexicalUnit.LexicalType.IDENT) {
            object = this.currentValue.getStringValue();
            string = string + " " + (String)object;
            type = CSSValue.Type.STRING;
            super.nextCurrentValue();
        }
        object = type == CSSValue.Type.STRING ? new StringValue() : new IdentifierValue();
        ((TypedValue)object).setStringValue(type, string);
        ((PrimitiveValue)object).setSubproperty(true);
        this.addSubpropertyValue("font-family", (StyleValue)object, true);
    }

    private void consumeFontFamilyString() {
        StyleValue styleValue = this.createCSSValue("font-family", this.currentValue);
        this.addSubpropertyValue("font-family", styleValue, true);
        super.nextCurrentValue();
    }

    private boolean assignFontSize() {
        if (this.currentValue.getLexicalUnitType() == LexicalUnit.LexicalType.IDENT) {
            return super.assignSubproperty("font-size");
        }
        if (ValueFactory.isPositiveSizeSACUnit(this.currentValue)) {
            StyleValue styleValue = this.createCSSValue("font-size", this.currentValue);
            this.setSubpropertyValue("font-size", styleValue);
            this.nextCurrentValue();
            return true;
        }
        return false;
    }

    @Override
    protected void resetSubproperties() {
        this.getUnassignedProperties().remove("font-variant-css21");
        super.resetSubproperties();
        if (!this.lineHeightSet) {
            this.setPropertyToDefault("line-height");
        }
        if (!this.isPropertySet("font-variant-caps")) {
            this.setPropertyToDefault("font-variant-caps");
        }
        this.setPropertyToDefault("font-size-adjust");
        this.setPropertyToDefault("font-kerning");
        this.setPropertyToDefault("font-optical-sizing");
        this.setPropertyToDefault("font-feature-settings");
        this.setPropertyToDefault("font-variation-settings");
        this.setPropertyToDefault("font-variant-ligatures");
        this.setPropertyToDefault("font-variant-position");
        this.setPropertyToDefault("font-variant-numeric");
        this.setPropertyToDefault("font-variant-alternates");
        this.setPropertyToDefault("font-variant-east-asian");
    }

    @Override
    protected void setSubpropertiesToKeyword(StyleValue styleValue) {
        this.getUnassignedProperties().remove("font-variant-css21");
        super.setSubpropertiesToKeyword(styleValue);
        this.lineHeightSet = true;
        this.setProperty("line-height", styleValue, this.isPriorityImportant());
        this.setProperty("font-kerning", styleValue, this.isPriorityImportant());
        this.setProperty("font-optical-sizing", styleValue, this.isPriorityImportant());
        this.setProperty("font-feature-settings", styleValue, this.isPriorityImportant());
        this.setProperty("font-variation-settings", styleValue, this.isPriorityImportant());
        this.setProperty("font-variant-ligatures", styleValue, this.isPriorityImportant());
        this.setProperty("font-variant-position", styleValue, this.isPriorityImportant());
        this.setProperty("font-variant-caps", styleValue, this.isPriorityImportant());
        this.setProperty("font-variant-numeric", styleValue, this.isPriorityImportant());
        this.setProperty("font-variant-alternates", styleValue, this.isPriorityImportant());
        this.setProperty("font-variant-east-asian", styleValue, this.isPriorityImportant());
        this.flush();
    }
}

