/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.parser;

import io.sf.carte.doc.style.css.CSSUnit;
import io.sf.carte.doc.style.css.CSSValueSyntax;
import io.sf.carte.doc.style.css.UnitStringToId;
import io.sf.carte.doc.style.css.nsac.CSSBudgetException;
import io.sf.carte.doc.style.css.nsac.CSSException;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.parser.Dimension;
import io.sf.carte.doc.style.css.parser.DimensionalAnalyzer;
import io.sf.carte.doc.style.css.parser.MathFunctionUnitImpl;
import io.sf.carte.doc.style.css.parser.ParseHelper;
import io.sf.carte.doc.style.css.parser.SyntaxParser;
import io.sf.carte.doc.style.css.property.ColorIdentifiers;
import java.io.Serializable;
import java.util.Locale;
import org.w3c.dom.DOMException;

class LexicalUnitImpl
implements LexicalUnit,
Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final int LEXICAL_REPLACE_LIMIT = 262144;
    private LexicalUnit.LexicalType unitType;
    private short cssUnit = (short)255;
    int intValue = 0;
    float floatValue = Float.NaN;
    String dimensionUnitText = "";
    String value = null;
    String identCssText = null;
    LexicalUnitImpl previousLexicalUnit = null;
    LexicalUnitImpl nextLexicalUnit = null;
    LexicalUnitImpl parameters = null;
    LexicalUnitImpl ownerLexicalUnit = null;

    public LexicalUnitImpl(LexicalUnit.LexicalType lexicalType) {
        this.unitType = lexicalType;
    }

    @Override
    public LexicalUnit.LexicalType getLexicalUnitType() {
        return this.unitType;
    }

    void setUnitType(LexicalUnit.LexicalType lexicalType) {
        this.unitType = lexicalType;
    }

    @Override
    public short getCssUnit() {
        return this.cssUnit;
    }

    void setCssUnit(short s) {
        this.cssUnit = s;
    }

    @Override
    public LexicalUnit getNextLexicalUnit() {
        return this.nextLexicalUnit;
    }

    @Override
    public LexicalUnit getPreviousLexicalUnit() {
        return this.previousLexicalUnit;
    }

    @Override
    public void insertNextLexicalUnit(LexicalUnit lexicalUnit) throws CSSException {
        LexicalUnitImpl lexicalUnitImpl;
        if (lexicalUnit == null || lexicalUnit.getLexicalUnitType() == LexicalUnit.LexicalType.EMPTY) {
            return;
        }
        LexicalUnitImpl lexicalUnitImpl2 = (LexicalUnitImpl)lexicalUnit;
        if (lexicalUnitImpl2.ownerLexicalUnit != null) {
            throw new IllegalArgumentException("Argument is a parameter of another unit.");
        }
        if (lexicalUnitImpl2.getPreviousLexicalUnit() != null) {
            throw new IllegalArgumentException("Argument unit has a previous unit.");
        }
        lexicalUnitImpl2.previousLexicalUnit = this;
        lexicalUnitImpl2.ownerLexicalUnit = this.ownerLexicalUnit;
        LexicalUnitImpl lexicalUnitImpl3 = lexicalUnitImpl2;
        do {
            lexicalUnitImpl = lexicalUnitImpl3;
        } while ((lexicalUnitImpl3 = lexicalUnitImpl3.nextLexicalUnit) != null);
        lexicalUnitImpl.nextLexicalUnit = this.nextLexicalUnit;
        if (this.nextLexicalUnit != null) {
            this.nextLexicalUnit.previousLexicalUnit = lexicalUnitImpl;
        }
        this.nextLexicalUnit = lexicalUnitImpl2;
    }

    @Override
    public LexicalUnit replaceBy(LexicalUnit lexicalUnit) throws CSSBudgetException {
        if (lexicalUnit == null || lexicalUnit.getLexicalUnitType() == LexicalUnit.LexicalType.EMPTY) {
            return this.remove();
        }
        LexicalUnitImpl lexicalUnitImpl = (LexicalUnitImpl)lexicalUnit;
        if (lexicalUnitImpl.ownerLexicalUnit != null) {
            throw new IllegalArgumentException("Replacement unit is a parameter.");
        }
        if (this.ownerLexicalUnit != null) {
            if (lexicalUnitImpl.previousLexicalUnit != null) {
                throw new IllegalArgumentException("Replacement unit has a previous unit.");
            }
            LexicalUnitImpl lexicalUnitImpl2 = lexicalUnitImpl;
            do {
                lexicalUnitImpl2.ownerLexicalUnit = this.ownerLexicalUnit;
            } while ((lexicalUnitImpl2 = lexicalUnitImpl2.nextLexicalUnit) != null);
            if (this.previousLexicalUnit == null) {
                this.ownerLexicalUnit.parameters = lexicalUnitImpl;
            }
            this.ownerLexicalUnit = null;
        }
        if (this.previousLexicalUnit != null) {
            this.previousLexicalUnit.nextLexicalUnit = lexicalUnitImpl;
            lexicalUnitImpl.previousLexicalUnit = this.previousLexicalUnit;
        }
        if (this.nextLexicalUnit != null) {
            LexicalUnitImpl lexicalUnitImpl3;
            int n = 0;
            LexicalUnitImpl lexicalUnitImpl4 = lexicalUnitImpl;
            do {
                lexicalUnitImpl3 = lexicalUnitImpl4;
                lexicalUnitImpl4 = lexicalUnitImpl4.nextLexicalUnit;
                if (++n < 262144) continue;
                throw new CSSBudgetException("Exceeded limit of lexical units: 262144");
            } while (lexicalUnitImpl4 != null);
            this.nextLexicalUnit.previousLexicalUnit = lexicalUnitImpl3;
            lexicalUnitImpl3.nextLexicalUnit = this.nextLexicalUnit;
            this.nextLexicalUnit = null;
        }
        this.previousLexicalUnit = null;
        return lexicalUnit;
    }

    @Override
    public int countReplaceBy(LexicalUnit lexicalUnit) throws CSSBudgetException {
        if (lexicalUnit == null) {
            this.remove();
            return 0;
        }
        return this.countReplaceBy(lexicalUnit, 0);
    }

    private int countReplaceBy(LexicalUnit lexicalUnit, int n) throws CSSBudgetException {
        LexicalUnitImpl lexicalUnitImpl;
        LexicalUnitImpl lexicalUnitImpl2 = (LexicalUnitImpl)lexicalUnit;
        if (lexicalUnitImpl2.getLexicalUnitType() == LexicalUnit.LexicalType.EMPTY) {
            ++n;
            LexicalUnitImpl lexicalUnitImpl3 = lexicalUnitImpl2.nextLexicalUnit;
            if (lexicalUnitImpl3 != null) {
                lexicalUnitImpl3.previousLexicalUnit = null;
                if ((n = this.countReplaceBy(lexicalUnitImpl3, n)) >= 262144) {
                    throw new CSSBudgetException("Exceeded limit of lexical units: 262144");
                }
                return n;
            }
            this.remove();
            return n;
        }
        if (lexicalUnitImpl2.ownerLexicalUnit != null) {
            throw new IllegalArgumentException("Replacement unit is a parameter.");
        }
        if (this.ownerLexicalUnit != null) {
            if (lexicalUnitImpl2.previousLexicalUnit != null) {
                throw new IllegalArgumentException("Replacement unit has a previous unit.");
            }
            lexicalUnitImpl = lexicalUnitImpl2;
            do {
                lexicalUnitImpl.ownerLexicalUnit = this.ownerLexicalUnit;
            } while ((lexicalUnitImpl = lexicalUnitImpl.nextLexicalUnit) != null);
            if (this.previousLexicalUnit == null) {
                this.ownerLexicalUnit.parameters = lexicalUnitImpl2;
            }
            this.ownerLexicalUnit = null;
        }
        if (this.previousLexicalUnit != null) {
            this.previousLexicalUnit.nextLexicalUnit = lexicalUnitImpl2;
            lexicalUnitImpl2.previousLexicalUnit = this.previousLexicalUnit;
        }
        if (this.nextLexicalUnit != null) {
            LexicalUnitImpl lexicalUnitImpl4;
            lexicalUnitImpl = lexicalUnitImpl2;
            do {
                lexicalUnitImpl4 = lexicalUnitImpl;
                lexicalUnitImpl = lexicalUnitImpl.nextLexicalUnit;
                if (++n < 262144) continue;
                throw new CSSBudgetException("Exceeded limit of lexical units: 262144");
            } while (lexicalUnitImpl != null);
            this.nextLexicalUnit.previousLexicalUnit = lexicalUnitImpl4;
            lexicalUnitImpl4.nextLexicalUnit = this.nextLexicalUnit;
            this.nextLexicalUnit = null;
        }
        this.previousLexicalUnit = null;
        return n;
    }

    @Override
    public LexicalUnit remove() {
        if (this.previousLexicalUnit != null) {
            this.previousLexicalUnit.nextLexicalUnit = this.nextLexicalUnit;
        }
        LexicalUnitImpl lexicalUnitImpl = this.nextLexicalUnit;
        if (this.nextLexicalUnit != null) {
            this.nextLexicalUnit.previousLexicalUnit = this.previousLexicalUnit;
            this.nextLexicalUnit = null;
        }
        if (this.ownerLexicalUnit != null) {
            if (this.previousLexicalUnit == null) {
                this.ownerLexicalUnit.parameters = lexicalUnitImpl;
            }
            this.ownerLexicalUnit = null;
        }
        this.previousLexicalUnit = null;
        return lexicalUnitImpl;
    }

    @Override
    public int getIntegerValue() {
        return this.intValue;
    }

    @Override
    public float getFloatValue() {
        return this.floatValue;
    }

    @Override
    public String getDimensionUnitText() {
        return this.dimensionUnitText;
    }

    @Override
    public String getFunctionName() {
        return this.value;
    }

    @Override
    public LexicalUnit getParameters() {
        return this.parameters;
    }

    @Override
    public boolean isParameter() {
        return this.ownerLexicalUnit != null;
    }

    @Override
    public String getStringValue() {
        return this.value;
    }

    @Override
    public LexicalUnit getSubValues() {
        if (this.unitType == LexicalUnit.LexicalType.SUB_EXPRESSION || this.unitType == LexicalUnit.LexicalType.UNICODE_RANGE) {
            return this.parameters;
        }
        return null;
    }

    void addFunctionParameter(LexicalUnitImpl lexicalUnitImpl) {
        lexicalUnitImpl.ownerLexicalUnit = this;
        if (this.parameters == null) {
            this.parameters = lexicalUnitImpl;
        } else {
            LexicalUnit lexicalUnit = this.parameters;
            while (lexicalUnit.getNextLexicalUnit() != null) {
                lexicalUnit = lexicalUnit.getNextLexicalUnit();
            }
            LexicalUnitImpl lexicalUnitImpl2 = lexicalUnit;
            lexicalUnitImpl2.nextLexicalUnit = lexicalUnitImpl;
            lexicalUnitImpl.previousLexicalUnit = lexicalUnitImpl2;
        }
    }

    void reset() {
        this.intValue = 0;
        this.floatValue = 0.0f;
        this.dimensionUnitText = "";
        this.parameters = null;
        this.nextLexicalUnit = null;
    }

    @Override
    public String getCssText() {
        return this.currentToString().toString();
    }

    public String toString() {
        if (this.nextLexicalUnit == null) {
            return this.currentToString().toString();
        }
        StringBuilder stringBuilder = new StringBuilder();
        LexicalUnitImpl lexicalUnitImpl = this;
        boolean bl = false;
        while (lexicalUnitImpl != null) {
            switch (lexicalUnitImpl.getLexicalUnitType()) {
                case OPERATOR_EXP: 
                case OPERATOR_GE: 
                case OPERATOR_GT: 
                case OPERATOR_LE: 
                case OPERATOR_LT: 
                case OPERATOR_MULTIPLY: 
                case OPERATOR_SLASH: 
                case OPERATOR_TILDE: 
                case LEFT_BRACKET: 
                case EMPTY: {
                    bl = false;
                }
                case OPERATOR_COMMA: 
                case OPERATOR_SEMICOLON: {
                    break;
                }
                case RIGHT_BRACKET: {
                    bl = true;
                    break;
                }
                default: {
                    if (bl) {
                        stringBuilder.append(' ');
                        break;
                    }
                    bl = true;
                }
            }
            stringBuilder.append(lexicalUnitImpl.currentToString());
            lexicalUnitImpl = lexicalUnitImpl.nextLexicalUnit;
        }
        return stringBuilder.toString();
    }

    CharSequence currentToString() {
        switch (this.unitType) {
            case INTEGER: {
                return Integer.toString(this.intValue);
            }
            case PERCENTAGE: 
            case REAL: 
            case DIMENSION: {
                StringBuilder stringBuilder = new StringBuilder();
                if (this.floatValue % 1.0f != 0.0f) {
                    stringBuilder.append(String.format(Locale.ROOT, "%s", Float.valueOf(this.floatValue)));
                } else {
                    stringBuilder.append(String.format(Locale.ROOT, "%.0f", Float.valueOf(this.floatValue)));
                }
                if (this.dimensionUnitText != null) {
                    stringBuilder.append(this.dimensionUnitText);
                }
                return stringBuilder;
            }
            case RGBCOLOR: {
                if (this.identCssText != null) {
                    return this.identCssText;
                }
            }
            case FUNCTION: 
            case MATH_FUNCTION: {
                return this.functionalSerialization(this.value);
            }
            case CALC: 
            case RECT_FUNCTION: 
            case VAR: 
            case ATTR: 
            case SRC: 
            case HSLCOLOR: 
            case LABCOLOR: 
            case LCHCOLOR: 
            case OKLABCOLOR: 
            case OKLCHCOLOR: 
            case HWBCOLOR: 
            case COLOR_FUNCTION: 
            case COLOR_MIX: 
            case COUNTER_FUNCTION: 
            case COUNTERS_FUNCTION: 
            case CUBIC_BEZIER_FUNCTION: 
            case STEPS_FUNCTION: 
            case TYPE_FUNCTION: {
                return this.functionalSerialization(this.value.toLowerCase(Locale.ROOT));
            }
            case SUB_EXPRESSION: {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append('(');
                LexicalUnitImpl lexicalUnitImpl = this.parameters;
                if (lexicalUnitImpl != null) {
                    stringBuilder.append(((Object)lexicalUnitImpl).toString());
                }
                stringBuilder.append(')');
                return stringBuilder;
            }
            case IDENT: {
                return this.identCssText != null ? this.identCssText : this.value;
            }
            case STRING: {
                return this.identCssText;
            }
            case URI: {
                String string = this.identCssText != null ? this.identCssText : (this.value != null ? ParseHelper.quote(this.value, '\'') : (this.parameters != null ? this.parameters.getCssText() : ""));
                return "url(" + string + ")";
            }
            case INHERIT: {
                return "inherit";
            }
            case INITIAL: {
                return "initial";
            }
            case UNSET: {
                return "unset";
            }
            case REVERT: {
                return "revert";
            }
            case ELEMENT_REFERENCE: {
                if (this.value == null) {
                    if (this.parameters == null) {
                        return "element(#)";
                    }
                    return this.functionalSerialization("element");
                }
                int n = this.value.length();
                StringBuilder stringBuilder = new StringBuilder(n + 10);
                stringBuilder.append("element(#").append(this.value).append(')');
                return stringBuilder;
            }
            case UNICODE_RANGE: {
                StringBuilder stringBuilder = new StringBuilder();
                LexicalUnit lexicalUnit = this.parameters;
                if (lexicalUnit != null) {
                    if (lexicalUnit.getLexicalUnitType() == LexicalUnit.LexicalType.INTEGER) {
                        stringBuilder.append("U+").append(Integer.toHexString(lexicalUnit.getIntegerValue()));
                    } else {
                        stringBuilder.append("U+").append(lexicalUnit.getStringValue());
                    }
                    lexicalUnit = lexicalUnit.getNextLexicalUnit();
                    if (lexicalUnit != null) {
                        stringBuilder.append('-');
                        if (lexicalUnit.getLexicalUnitType() == LexicalUnit.LexicalType.INTEGER) {
                            stringBuilder.append(Integer.toHexString(lexicalUnit.getIntegerValue()));
                        } else {
                            stringBuilder.append(lexicalUnit.getStringValue());
                        }
                    }
                }
                return stringBuilder;
            }
            case UNICODE_WILDCARD: {
                return this.getStringValue();
            }
            case OPERATOR_COMMA: {
                return ",";
            }
            case OPERATOR_SEMICOLON: {
                return ";";
            }
            case OPERATOR_EXP: {
                return "^";
            }
            case OPERATOR_GE: {
                return ">=";
            }
            case OPERATOR_GT: {
                return ">";
            }
            case OPERATOR_LE: {
                return "<=";
            }
            case OPERATOR_LT: {
                return "<";
            }
            case OPERATOR_MINUS: {
                return "-";
            }
            case OPERATOR_MOD: {
                return "%";
            }
            case OPERATOR_MULTIPLY: {
                return "*";
            }
            case OPERATOR_PLUS: {
                return "+";
            }
            case OPERATOR_SLASH: {
                return "/";
            }
            case OPERATOR_TILDE: {
                return "~";
            }
            case LEFT_BRACKET: {
                return "[";
            }
            case RIGHT_BRACKET: {
                return "]";
            }
            case COMPAT_IDENT: 
            case COMPAT_PRIO: {
                return ParseHelper.escapeControl(this.value);
            }
        }
        return "";
    }

    private CharSequence functionalSerialization(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string).append('(');
        LexicalUnitImpl lexicalUnitImpl = this.parameters;
        if (lexicalUnitImpl != null) {
            stringBuilder.append(((Object)lexicalUnitImpl).toString());
        }
        stringBuilder.append(')');
        return stringBuilder;
    }

    @Override
    public CSSValueSyntax.Match matches(CSSValueSyntax cSSValueSyntax) {
        if (cSSValueSyntax != null) {
            switch (this.getLexicalUnitType()) {
                case INHERIT: 
                case INITIAL: 
                case UNSET: 
                case REVERT: {
                    return this.nextLexicalUnit == null ? CSSValueSyntax.Match.PENDING : CSSValueSyntax.Match.FALSE;
                }
            }
            CSSValueSyntax cSSValueSyntax2 = cSSValueSyntax;
            do {
                CSSValueSyntax.Match match;
                CSSValueSyntax.Multiplier multiplier = cSSValueSyntax2.getMultiplier();
                CSSValueSyntax.Category category = cSSValueSyntax2.getCategory();
                if (category == CSSValueSyntax.Category.universal) {
                    return CSSValueSyntax.Match.TRUE;
                }
                if (multiplier == CSSValueSyntax.Multiplier.NONE && this.nextLexicalUnit != null && category != CSSValueSyntax.Category.transformList || (match = this.matchesComponent(cSSValueSyntax, cSSValueSyntax2)) == CSSValueSyntax.Match.FALSE) continue;
                return match;
            } while ((cSSValueSyntax2 = cSSValueSyntax2.getNext()) != null);
        }
        return CSSValueSyntax.Match.FALSE;
    }

    private CSSValueSyntax.Match matchesComponent(CSSValueSyntax cSSValueSyntax, CSSValueSyntax cSSValueSyntax2) {
        CSSValueSyntax.Match match;
        block4: {
            LexicalUnitImpl lexicalUnitImpl = this;
            match = CSSValueSyntax.Match.FALSE;
            while (true) {
                CSSValueSyntax.Match match2;
                if ((match2 = LexicalUnitImpl.matchesComponent(lexicalUnitImpl, cSSValueSyntax, cSSValueSyntax2)) == CSSValueSyntax.Match.FALSE) {
                    return CSSValueSyntax.Match.FALSE;
                }
                if (match != CSSValueSyntax.Match.PENDING) {
                    match = match2;
                }
                if ((lexicalUnitImpl = lexicalUnitImpl.nextLexicalUnit) == null) break block4;
                if (cSSValueSyntax2.getMultiplier() != CSSValueSyntax.Multiplier.NUMBER) continue;
                if (lexicalUnitImpl.unitType == LexicalUnit.LexicalType.OPERATOR_COMMA) {
                    lexicalUnitImpl = lexicalUnitImpl.nextLexicalUnit;
                    if (lexicalUnitImpl != null) continue;
                    break block4;
                }
                if (cSSValueSyntax2.getCategory() != CSSValueSyntax.Category.transformList && lexicalUnitImpl.unitType != LexicalUnit.LexicalType.VAR && lexicalUnitImpl.previousLexicalUnit.unitType != LexicalUnit.LexicalType.VAR) break;
            }
            return CSSValueSyntax.Match.FALSE;
        }
        return match;
    }

    private static CSSValueSyntax.Match matchesComponent(LexicalUnitImpl lexicalUnitImpl, CSSValueSyntax cSSValueSyntax, CSSValueSyntax cSSValueSyntax2) {
        LexicalUnit.LexicalType lexicalType = lexicalUnitImpl.getLexicalUnitType();
        switch (lexicalType) {
            case OPERATOR_COMMA: {
                if (cSSValueSyntax2.getMultiplier() != CSSValueSyntax.Multiplier.NUMBER || lexicalUnitImpl.nextLexicalUnit == null) {
                    return CSSValueSyntax.Match.FALSE;
                }
                return CSSValueSyntax.Match.TRUE;
            }
            case OPERATOR_EXP: 
            case OPERATOR_GE: 
            case OPERATOR_GT: 
            case OPERATOR_LE: 
            case OPERATOR_LT: 
            case OPERATOR_MULTIPLY: 
            case OPERATOR_SLASH: 
            case OPERATOR_TILDE: 
            case OPERATOR_SEMICOLON: 
            case INHERIT: 
            case INITIAL: 
            case UNSET: 
            case REVERT: 
            case OPERATOR_MINUS: 
            case OPERATOR_MOD: 
            case OPERATOR_PLUS: {
                return CSSValueSyntax.Match.FALSE;
            }
        }
        CSSValueSyntax.Category category = cSSValueSyntax2.getCategory();
        if (category == CSSValueSyntax.Category.universal) {
            return CSSValueSyntax.Match.TRUE;
        }
        switch (lexicalType) {
            case IDENT: {
                return LexicalUnitImpl.matchBoolean(category == CSSValueSyntax.Category.customIdent || category == CSSValueSyntax.Category.IDENT && cSSValueSyntax2.getName().equals(lexicalUnitImpl.getStringValue()) || category == CSSValueSyntax.Category.color && ColorIdentifiers.getInstance().isColorIdentifier(lexicalUnitImpl.getStringValue().toLowerCase(Locale.ROOT)));
            }
            case STRING: {
                return LexicalUnitImpl.matchBoolean(category == CSSValueSyntax.Category.string);
            }
            case ATTR: {
                return LexicalUnitImpl.matchAttr(lexicalUnitImpl, cSSValueSyntax, cSSValueSyntax2);
            }
            case SRC: 
            case URI: {
                return LexicalUnitImpl.matchBoolean(category == CSSValueSyntax.Category.url || category == CSSValueSyntax.Category.image);
            }
            case DIMENSION: {
                return LexicalUnitImpl.matchBoolean(LexicalUnitImpl.unitMatchesCategory(lexicalUnitImpl.getCssUnit(), category));
            }
            case PERCENTAGE: {
                return LexicalUnitImpl.matchBoolean(category == CSSValueSyntax.Category.percentage || category == CSSValueSyntax.Category.lengthPercentage);
            }
            case REAL: {
                return LexicalUnitImpl.matchBoolean(category == CSSValueSyntax.Category.number);
            }
            case INTEGER: {
                return LexicalUnitImpl.matchBoolean(category == CSSValueSyntax.Category.integer || category == CSSValueSyntax.Category.number);
            }
            case RGBCOLOR: 
            case HSLCOLOR: 
            case LABCOLOR: 
            case LCHCOLOR: 
            case OKLABCOLOR: 
            case OKLCHCOLOR: 
            case HWBCOLOR: 
            case COLOR_FUNCTION: 
            case COLOR_MIX: {
                return LexicalUnitImpl.matchBoolean(category == CSSValueSyntax.Category.color);
            }
            case CALC: {
                return LexicalUnitImpl.isNumericCategory(category) ? LexicalUnitImpl.matchExpression(lexicalUnitImpl, cSSValueSyntax, cSSValueSyntax2) : CSSValueSyntax.Match.FALSE;
            }
            case FUNCTION: {
                return LexicalUnitImpl.matchFunction(lexicalUnitImpl, cSSValueSyntax, cSSValueSyntax2);
            }
            case MATH_FUNCTION: {
                if (LexicalUnitImpl.isNumericCategory(category)) {
                    Dimension dimension;
                    DimensionalAnalyzer dimensionalAnalyzer = new DimensionalAnalyzer();
                    try {
                        dimension = ((MathFunctionUnitImpl)lexicalUnitImpl).dimension(dimensionalAnalyzer);
                    }
                    catch (DOMException dOMException) {
                        return CSSValueSyntax.Match.FALSE;
                    }
                    return dimension != null ? dimension.matches(cSSValueSyntax2) : CSSValueSyntax.Match.PENDING;
                }
                return CSSValueSyntax.Match.FALSE;
            }
            case ELEMENT_REFERENCE: {
                return LexicalUnitImpl.matchBoolean(category == CSSValueSyntax.Category.image);
            }
            case VAR: {
                return CSSValueSyntax.Match.PENDING;
            }
            case COUNTER_FUNCTION: 
            case COUNTERS_FUNCTION: {
                return LexicalUnitImpl.matchBoolean(category == CSSValueSyntax.Category.counter);
            }
            case UNICODE_RANGE: 
            case UNICODE_WILDCARD: {
                return LexicalUnitImpl.matchBoolean(category == CSSValueSyntax.Category.unicodeRange);
            }
        }
        return CSSValueSyntax.Match.FALSE;
    }

    private static CSSValueSyntax.Match matchBoolean(boolean bl) {
        return bl ? CSSValueSyntax.Match.TRUE : CSSValueSyntax.Match.FALSE;
    }

    private static boolean unitMatchesCategory(short s, CSSValueSyntax.Category category) {
        switch (category) {
            case length: {
                return CSSUnit.isLengthUnitType(s);
            }
            case lengthPercentage: {
                return CSSUnit.isLengthUnitType(s) || s == 2;
            }
            case percentage: {
                return s == 2;
            }
            case angle: {
                return CSSUnit.isAngleUnitType(s);
            }
            case time: {
                return CSSUnit.isTimeUnitType(s);
            }
            case resolution: {
                return CSSUnit.isResolutionUnitType(s);
            }
            case flex: {
                return s == 70;
            }
            case frequency: {
                return s == 100 || s == 101;
            }
            case integer: 
            case number: {
                return s == 0;
            }
        }
        return false;
    }

    private static CSSValueSyntax.Match matchAttr(LexicalUnitImpl lexicalUnitImpl, CSSValueSyntax cSSValueSyntax, CSSValueSyntax cSSValueSyntax2) {
        CSSValueSyntax.Match match = CSSValueSyntax.Match.FALSE;
        LexicalUnit lexicalUnit = lexicalUnitImpl.getParameters();
        if (lexicalUnit != null) {
            Object object;
            Object object2;
            LexicalUnit lexicalUnit2 = null;
            if ((lexicalUnit = lexicalUnit.getNextLexicalUnit()) == null) {
                return cSSValueSyntax2.getCategory() == CSSValueSyntax.Category.string ? CSSValueSyntax.Match.TRUE : CSSValueSyntax.Match.FALSE;
            }
            short s = 1;
            CSSValueSyntax cSSValueSyntax3 = null;
            LexicalUnit.LexicalType lexicalType = lexicalUnit.getLexicalUnitType();
            if (lexicalType == LexicalUnit.LexicalType.OPERATOR_COMMA) {
                cSSValueSyntax3 = SyntaxParser.createSimpleSyntax("string");
                lexicalUnit2 = lexicalUnit.getNextLexicalUnit();
            } else {
                switch (lexicalType) {
                    case OPERATOR_COMMA: {
                        break;
                    }
                    case TYPE_FUNCTION: {
                        object2 = lexicalUnit.getParameters();
                        try {
                            cSSValueSyntax3 = object2.getSyntax();
                            break;
                        }
                        catch (IllegalStateException illegalStateException) {
                            return CSSValueSyntax.Match.FALSE;
                        }
                    }
                    case IDENT: {
                        object = lexicalUnit.getStringValue().toLowerCase(Locale.ROOT);
                        if ("string".equals(object)) {
                            cSSValueSyntax3 = SyntaxParser.createSimpleSyntax("string");
                            break;
                        }
                        s = UnitStringToId.unitFromString((String)object);
                        break;
                    }
                    case OPERATOR_MOD: {
                        s = 2;
                        break;
                    }
                    case VAR: {
                        return CSSValueSyntax.Match.PENDING;
                    }
                    default: {
                        return CSSValueSyntax.Match.FALSE;
                    }
                }
                lexicalUnit = lexicalUnit.getNextLexicalUnit();
                if (lexicalUnit != null) {
                    if (lexicalUnit.getLexicalUnitType() != LexicalUnit.LexicalType.OPERATOR_COMMA) {
                        return CSSValueSyntax.Match.FALSE;
                    }
                    lexicalUnit2 = lexicalUnit.getNextLexicalUnit();
                }
            }
            object2 = null;
            object = cSSValueSyntax;
            block9: do {
                CSSValueSyntax.Match match2;
                if (cSSValueSyntax3 == null) {
                    if (LexicalUnitImpl.unitMatchesCategory(s, object.getCategory())) {
                        match2 = CSSValueSyntax.Match.TRUE;
                        match = CSSValueSyntax.Match.PENDING;
                        object2 = object;
                    } else {
                        match2 = CSSValueSyntax.Match.FALSE;
                    }
                } else {
                    match2 = LexicalUnitImpl.matchAttrTypeSyntax(lexicalUnitImpl.isParameter(), cSSValueSyntax3, object.getCategory());
                    if (match2 != CSSValueSyntax.Match.FALSE) {
                        match = CSSValueSyntax.Match.PENDING;
                        object2 = object;
                    }
                }
                if (lexicalUnit2 != null) {
                    CSSValueSyntax cSSValueSyntax4 = cSSValueSyntax;
                    do {
                        CSSValueSyntax.Match match3;
                        if ((match3 = lexicalUnit2.matches(cSSValueSyntax4)) == CSSValueSyntax.Match.FALSE) {
                            if (match2 == CSSValueSyntax.Match.FALSE || cSSValueSyntax3 == null || cSSValueSyntax3.getCategory() != CSSValueSyntax.Category.url || lexicalUnit2.getLexicalUnitType() != LexicalUnit.LexicalType.STRING || !LexicalUnitImpl.hasNoSiblings(lexicalUnitImpl) || lexicalUnit2.getNextLexicalUnit() != null) continue;
                            match = CSSValueSyntax.Match.TRUE;
                        } else if (match3 == CSSValueSyntax.Match.PENDING) {
                            match = CSSValueSyntax.Match.PENDING;
                            if (match2 != CSSValueSyntax.Match.FALSE) {
                                continue;
                            }
                        } else {
                            if (match2 != CSSValueSyntax.Match.TRUE) {
                                match = CSSValueSyntax.Match.PENDING;
                                continue block9;
                            }
                            if (LexicalUnitImpl.hasNoSiblings(lexicalUnitImpl) || object2 == cSSValueSyntax4) {
                                match = CSSValueSyntax.Match.TRUE;
                            }
                        }
                        return match;
                    } while ((cSSValueSyntax4 = cSSValueSyntax4.getNext()) != null);
                    continue;
                }
                if (match2 != CSSValueSyntax.Match.TRUE) continue;
                return CSSValueSyntax.Match.TRUE;
            } while ((object = object.getNext()) != null);
        }
        return match;
    }

    private static CSSValueSyntax.Match matchAttrTypeSyntax(boolean bl, CSSValueSyntax cSSValueSyntax, CSSValueSyntax.Category category) {
        CSSValueSyntax.Match match = CSSValueSyntax.Match.FALSE;
        do {
            CSSValueSyntax.Category category2;
            CSSValueSyntax.Match match2;
            if ((match2 = LexicalUnitImpl.categoryMatch(bl, false, category2 = cSSValueSyntax.getCategory(), category)) != CSSValueSyntax.Match.FALSE) {
                if (match == CSSValueSyntax.Match.PENDING) continue;
                match = CSSValueSyntax.Match.TRUE;
                break;
            }
            if (match != CSSValueSyntax.Match.TRUE) continue;
            match = CSSValueSyntax.Match.PENDING;
        } while ((cSSValueSyntax = cSSValueSyntax.getNext()) != null);
        return match;
    }

    private static CSSValueSyntax.Match matchExpression(LexicalUnitImpl lexicalUnitImpl, CSSValueSyntax cSSValueSyntax, CSSValueSyntax cSSValueSyntax2) {
        Dimension dimension;
        DimensionalAnalyzer dimensionalAnalyzer = new DimensionalAnalyzer();
        try {
            dimension = dimensionalAnalyzer.expressionDimension(lexicalUnitImpl.parameters);
        }
        catch (DOMException dOMException) {
            return CSSValueSyntax.Match.FALSE;
        }
        if (dimension == null) {
            return CSSValueSyntax.Match.PENDING;
        }
        CSSValueSyntax.Match match = CSSValueSyntax.Match.FALSE;
        boolean bl = false;
        boolean bl2 = false;
        CSSValueSyntax cSSValueSyntax3 = cSSValueSyntax;
        do {
            CSSValueSyntax.Match match2;
            CSSValueSyntax.Category category = cSSValueSyntax3.getCategory();
            boolean bl3 = dimensionalAnalyzer.isAttrPending();
            if (bl3) {
                match2 = LexicalUnitImpl.categoryMatch(true, true, dimension.category, category);
                if (match2 == CSSValueSyntax.Match.PENDING) {
                    if (category == CSSValueSyntax.Category.length) {
                        bl = true;
                        match2 = dimension.isPercentageProcessed() ? CSSValueSyntax.Match.FALSE : CSSValueSyntax.Match.PENDING;
                    } else if (category == CSSValueSyntax.Category.percentage) {
                        bl2 = true;
                        match2 = dimension.isLengthProcessed() ? CSSValueSyntax.Match.FALSE : CSSValueSyntax.Match.PENDING;
                    }
                }
            } else {
                if (category == CSSValueSyntax.Category.length) {
                    bl = true;
                } else if (category == CSSValueSyntax.Category.percentage) {
                    bl2 = true;
                }
                match2 = LexicalUnitImpl.categoryMatch(true, false, dimension.category, category);
            }
            if (match2 == CSSValueSyntax.Match.TRUE) {
                return CSSValueSyntax.Match.TRUE;
            }
            if (match == CSSValueSyntax.Match.PENDING) continue;
            match = match2;
        } while ((cSSValueSyntax3 = cSSValueSyntax3.getNext()) != null);
        if (dimension.category == CSSValueSyntax.Category.lengthPercentage && bl && bl2) {
            match = CSSValueSyntax.Match.TRUE;
        }
        return match;
    }

    private static CSSValueSyntax.Match categoryMatch(boolean bl, boolean bl2, CSSValueSyntax.Category category, CSSValueSyntax.Category category2) {
        if (category == category2 || category == CSSValueSyntax.Category.length && category2 == CSSValueSyntax.Category.lengthPercentage || category == CSSValueSyntax.Category.percentage && category2 == CSSValueSyntax.Category.lengthPercentage || category == CSSValueSyntax.Category.integer && category2 == CSSValueSyntax.Category.number || bl && category == CSSValueSyntax.Category.number && category2 == CSSValueSyntax.Category.integer || category == CSSValueSyntax.Category.url && category2 == CSSValueSyntax.Category.image || category2 == CSSValueSyntax.Category.url && category == CSSValueSyntax.Category.image) {
            return CSSValueSyntax.Match.TRUE;
        }
        if (bl2 && (category == CSSValueSyntax.Category.lengthPercentage && category2 == CSSValueSyntax.Category.length || category == CSSValueSyntax.Category.lengthPercentage && category2 == CSSValueSyntax.Category.percentage)) {
            return CSSValueSyntax.Match.PENDING;
        }
        return CSSValueSyntax.Match.FALSE;
    }

    private static boolean hasNoSiblings(LexicalUnit lexicalUnit) {
        return lexicalUnit.getNextLexicalUnit() == null && lexicalUnit.getPreviousLexicalUnit() == null;
    }

    private static CSSValueSyntax.Match matchFunction(LexicalUnitImpl lexicalUnitImpl, CSSValueSyntax cSSValueSyntax, CSSValueSyntax cSSValueSyntax2) {
        CSSValueSyntax.Category category = cSSValueSyntax2.getCategory();
        String string = lexicalUnitImpl.getFunctionName().toLowerCase(Locale.ROOT);
        if (string.endsWith("-gradient") || string.equals("image") || string.equals("image-set") || string.equals("cross-fade")) {
            return LexicalUnitImpl.matchBoolean(category == CSSValueSyntax.Category.image);
        }
        if (string.equals("env")) {
            return CSSValueSyntax.Match.PENDING;
        }
        return LexicalUnitImpl.matchBoolean((category == CSSValueSyntax.Category.transformFunction || category == CSSValueSyntax.Category.transformList) && ParseHelper.isTransformFunction(string));
    }

    private static boolean isNumericCategory(CSSValueSyntax.Category category) {
        switch (category) {
            case length: 
            case lengthPercentage: 
            case percentage: 
            case angle: 
            case time: 
            case resolution: 
            case flex: 
            case frequency: 
            case integer: 
            case number: {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = 31 * n2 + this.unitType.hashCode();
        n2 = 31 * n2 + this.cssUnit;
        n2 = 31 * n2 + (this.dimensionUnitText == null ? 0 : this.dimensionUnitText.hashCode());
        n2 = 31 * n2 + Float.floatToIntBits(this.floatValue);
        n2 = 31 * n2 + this.intValue;
        n2 = 31 * n2 + (this.value == null ? 0 : this.value.hashCode());
        LexicalUnitImpl lexicalUnitImpl = this.parameters;
        while (lexicalUnitImpl != null) {
            n2 = 31 * n2 + lexicalUnitImpl.hashCode();
            lexicalUnitImpl = lexicalUnitImpl.nextLexicalUnit;
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        LexicalUnitImpl lexicalUnitImpl = (LexicalUnitImpl)object;
        if (this.unitType != lexicalUnitImpl.unitType) {
            return false;
        }
        if (this.cssUnit != lexicalUnitImpl.cssUnit) {
            return false;
        }
        if (this.dimensionUnitText == null ? lexicalUnitImpl.dimensionUnitText != null : !this.dimensionUnitText.equals(lexicalUnitImpl.dimensionUnitText)) {
            return false;
        }
        if (Float.floatToIntBits(this.floatValue) != Float.floatToIntBits(lexicalUnitImpl.floatValue)) {
            return false;
        }
        if (this.value == null ? lexicalUnitImpl.value != null : !this.value.equals(lexicalUnitImpl.value)) {
            return false;
        }
        if (this.intValue != lexicalUnitImpl.intValue) {
            return false;
        }
        if (this.parameters == null) {
            return lexicalUnitImpl.parameters == null;
        }
        if (lexicalUnitImpl.parameters == null) {
            return false;
        }
        LexicalUnitImpl lexicalUnitImpl2 = this.parameters;
        LexicalUnitImpl lexicalUnitImpl3 = lexicalUnitImpl.parameters;
        while (lexicalUnitImpl2 != null) {
            if (!lexicalUnitImpl2.equals(lexicalUnitImpl3)) {
                return false;
            }
            lexicalUnitImpl2 = lexicalUnitImpl2.nextLexicalUnit;
            lexicalUnitImpl3 = lexicalUnitImpl3.nextLexicalUnit;
        }
        return lexicalUnitImpl3 == null;
    }

    @Override
    public LexicalUnitImpl shallowClone() {
        LexicalUnitImpl lexicalUnitImpl = this.instantiateLexicalUnit();
        lexicalUnitImpl.cssUnit = this.cssUnit;
        lexicalUnitImpl.intValue = this.intValue;
        lexicalUnitImpl.floatValue = this.floatValue;
        lexicalUnitImpl.dimensionUnitText = this.dimensionUnitText;
        lexicalUnitImpl.identCssText = this.identCssText;
        lexicalUnitImpl.value = this.value;
        if (this.parameters != null) {
            lexicalUnitImpl.parameters = this.parameters.clone(lexicalUnitImpl);
        }
        return lexicalUnitImpl;
    }

    LexicalUnitImpl instantiateLexicalUnit() {
        return new LexicalUnitImpl(this.unitType);
    }

    @Override
    public LexicalUnitImpl clone() {
        return this.clone(null);
    }

    private LexicalUnitImpl clone(LexicalUnitImpl lexicalUnitImpl) {
        LexicalUnitImpl lexicalUnitImpl2 = this.shallowClone();
        if (this.nextLexicalUnit != null) {
            lexicalUnitImpl2.nextLexicalUnit = this.nextLexicalUnit.clone(lexicalUnitImpl);
            lexicalUnitImpl2.nextLexicalUnit.previousLexicalUnit = lexicalUnitImpl2;
        }
        lexicalUnitImpl2.ownerLexicalUnit = lexicalUnitImpl;
        return lexicalUnitImpl2;
    }
}

