/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.ast;

import org.mozilla.javascript.ast.AstNode;
import org.mozilla.javascript.ast.NodeVisitor;

public class NumberLiteral
extends AstNode {
    private String value;
    private double number;

    public NumberLiteral() {
        this.type = 40;
    }

    public NumberLiteral(int n) {
        super(n);
        this.type = 40;
    }

    public NumberLiteral(int n, int n2) {
        super(n, n2);
        this.type = 40;
    }

    public NumberLiteral(int n, String string) {
        super(n);
        this.type = 40;
        this.setValue(string);
        this.setLength(string.length());
    }

    public NumberLiteral(int n, String string, double d) {
        this(n, string);
        this.setDouble(d);
    }

    public NumberLiteral(double d) {
        this.type = 40;
        this.setDouble(d);
        this.setValue(Double.toString(d));
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String string) {
        this.assertNotNull(string);
        this.value = string;
    }

    public double getNumber() {
        return this.number;
    }

    public void setNumber(double d) {
        this.number = d;
    }

    @Override
    public String toSource(int n) {
        return this.makeIndent(n) + (this.value == null ? "<null>" : this.value);
    }

    @Override
    public void visit(NodeVisitor nodeVisitor) {
        nodeVisitor.visit(this);
    }
}

