/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeError;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Wrapper;

public class JavaScriptException
extends RhinoException {
    private static final long serialVersionUID = -7666130513694669293L;
    private Object value;
    private String details;

    @Deprecated
    public JavaScriptException(Object object) {
        this(object, "", 0);
    }

    public JavaScriptException(Object object, String string, int n) {
        this.recordErrorOrigin(string, n, null, 0);
        this.value = object;
        Object object2 = object;
        if (object instanceof NativeError) {
            NativeError nativeError = (NativeError)object;
            object2 = nativeError.get("javaException", (Scriptable)nativeError);
            if (Context.getContext().hasFeature(10)) {
                if (!nativeError.has("fileName", (Scriptable)nativeError)) {
                    nativeError.put("fileName", (Scriptable)nativeError, (Object)string);
                }
                if (!nativeError.has("lineNumber", (Scriptable)nativeError)) {
                    nativeError.put("lineNumber", (Scriptable)nativeError, (Object)n);
                }
                nativeError.setStackProvider(this);
            }
        }
        if (object2 instanceof Wrapper) {
            object2 = ((Wrapper)object2).unwrap();
        }
        if (object2 instanceof Throwable) {
            this.initCause((Throwable)object2);
        }
        this.details = this.getDetails();
    }

    @Override
    public String details() {
        return this.details;
    }

    public String getDetails() {
        if (this.value == null) {
            return "null";
        }
        if (this.value instanceof NativeError) {
            return this.value.toString();
        }
        try {
            return ScriptRuntime.toString(this.value);
        }
        catch (RuntimeException runtimeException) {
            if (this.value instanceof Scriptable) {
                return ScriptRuntime.defaultObjectToString((Scriptable)this.value);
            }
            return this.value.toString();
        }
    }

    public Object getValue() {
        return this.value;
    }

    @Deprecated
    public String getSourceName() {
        return this.sourceName();
    }

    @Deprecated
    public int getLineNumber() {
        return this.lineNumber();
    }
}

