/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.impl;

import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.CSSValueSyntax;
import io.sf.carte.doc.style.css.UnitStringToId;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.parser.SyntaxParser;
import java.util.Locale;

public class AttrUtil {
    public static boolean isProxyAttr(LexicalUnit lexicalUnit) {
        return AttrUtil.finalAttrType(lexicalUnit) == CSSValue.Type.UNKNOWN;
    }

    public static CSSValue.Type finalAttrType(LexicalUnit lexicalUnit) {
        Object object;
        LexicalUnit lexicalUnit2 = lexicalUnit.getParameters();
        if (lexicalUnit2 == null || lexicalUnit2.getLexicalUnitType() != LexicalUnit.LexicalType.IDENT) {
            return CSSValue.Type.UNKNOWN;
        }
        if ((lexicalUnit2 = lexicalUnit2.getNextLexicalUnit()) == null) {
            return CSSValue.Type.STRING;
        }
        CSSValueSyntax cSSValueSyntax = null;
        short s = 1;
        LexicalUnit.LexicalType lexicalType = lexicalUnit2.getLexicalUnitType();
        if (lexicalType != LexicalUnit.LexicalType.OPERATOR_COMMA) {
            switch (lexicalType) {
                case IDENT: {
                    object = lexicalUnit2.getStringValue().toLowerCase(Locale.ROOT);
                    if (!"string".equals(object)) {
                        s = UnitStringToId.unitFromString((String)object);
                        break;
                    }
                    cSSValueSyntax = SyntaxParser.createSimpleSyntax("string");
                    break;
                }
                case OPERATOR_MOD: {
                    s = 2;
                    break;
                }
                case TYPE_FUNCTION: {
                    try {
                        cSSValueSyntax = lexicalUnit2.getParameters().getSyntax();
                        break;
                    }
                    catch (IllegalStateException illegalStateException) {
                        // empty catch block
                    }
                }
                default: {
                    return CSSValue.Type.UNKNOWN;
                }
            }
            lexicalUnit2 = lexicalUnit2.getNextLexicalUnit();
            if (lexicalUnit2 == null) {
                return AttrUtil.attrTypeToCSSOMType(s, cSSValueSyntax);
            }
            if (lexicalUnit2.getLexicalUnitType() != LexicalUnit.LexicalType.OPERATOR_COMMA) {
                return CSSValue.Type.UNKNOWN;
            }
        } else {
            cSSValueSyntax = SyntaxParser.createSimpleSyntax("string");
        }
        if ((object = lexicalUnit2.getNextLexicalUnit()) == null) {
            return AttrUtil.attrTypeToCSSOMType(s, cSSValueSyntax);
        }
        if (!AttrUtil.valueFitsAttrType((LexicalUnit)object, s, cSSValueSyntax)) {
            return CSSValue.Type.UNKNOWN;
        }
        return AttrUtil.attrTypeToCSSOMType(s, cSSValueSyntax);
    }

    private static CSSValue.Type attrTypeToCSSOMType(short s, CSSValueSyntax cSSValueSyntax) {
        CSSValue.Type type;
        if (cSSValueSyntax == null) {
            return s == 1 ? CSSValue.Type.UNKNOWN : CSSValue.Type.NUMERIC;
        }
        switch (cSSValueSyntax.getCategory()) {
            case string: {
                type = CSSValue.Type.STRING;
                break;
            }
            case url: {
                type = CSSValue.Type.URI;
                break;
            }
            case customIdent: {
                type = CSSValue.Type.IDENT;
                break;
            }
            case color: {
                type = CSSValue.Type.COLOR;
                break;
            }
            case number: 
            case percentage: 
            case length: 
            case angle: 
            case time: 
            case frequency: 
            case flex: {
                type = CSSValue.Type.NUMERIC;
                break;
            }
            default: {
                type = CSSValue.Type.UNKNOWN;
            }
        }
        return type;
    }

    private static boolean valueFitsAttrType(LexicalUnit lexicalUnit, short s, CSSValueSyntax cSSValueSyntax) {
        LexicalUnit.LexicalType lexicalType = lexicalUnit.getLexicalUnitType();
        if (cSSValueSyntax == null) {
            return lexicalType == LexicalUnit.LexicalType.DIMENSION || lexicalType == LexicalUnit.LexicalType.REAL || lexicalType == LexicalUnit.LexicalType.PERCENTAGE || lexicalType == LexicalUnit.LexicalType.INTEGER;
        }
        return lexicalUnit.matches(cSSValueSyntax) == CSSValueSyntax.Match.TRUE;
    }
}

