/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.gvt.filter;

import io.sf.carte.echosvg.ext.awt.image.GraphicsUtil;
import io.sf.carte.echosvg.ext.awt.image.rendered.AbstractRed;
import io.sf.carte.echosvg.ext.awt.image.rendered.AbstractTiledRed;
import io.sf.carte.echosvg.gvt.GraphicsNode;
import io.sf.carte.echosvg.util.Platform;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;

public class GraphicsNodeRed8Bit
extends AbstractRed {
    private GraphicsNode node;
    private AffineTransform node2dev;
    private RenderingHints hints;
    private boolean usePrimitivePaint;

    public GraphicsNodeRed8Bit(GraphicsNode graphicsNode, AffineTransform affineTransform, boolean bl, RenderingHints renderingHints) {
        int n;
        Cloneable cloneable;
        this.node = graphicsNode;
        this.node2dev = affineTransform;
        this.hints = renderingHints;
        this.usePrimitivePaint = bl;
        AffineTransform affineTransform2 = affineTransform;
        Rectangle2D rectangle2D = graphicsNode.getPrimitiveBounds();
        if (rectangle2D == null) {
            rectangle2D = new Rectangle2D.Float(0.0f, 0.0f, 1.0f, 1.0f);
        }
        if (!bl && (cloneable = graphicsNode.getTransform()) != null) {
            affineTransform2 = (AffineTransform)affineTransform2.clone();
            affineTransform2.concatenate((AffineTransform)cloneable);
        }
        cloneable = affineTransform2.createTransformedShape(rectangle2D).getBounds();
        ColorModel colorModel = this.createColorModel();
        int n2 = AbstractTiledRed.getDefaultTileSize();
        int n3 = n2 * (int)Math.floor(((Rectangle)cloneable).x / n2);
        int n4 = n2 * (int)Math.floor(((Rectangle)cloneable).y / n2);
        int n5 = ((Rectangle)cloneable).x + ((Rectangle)cloneable).width - n3;
        if (n5 > n2) {
            n5 = n2;
        }
        if ((n = ((Rectangle)cloneable).y + ((Rectangle)cloneable).height - n4) > n2) {
            n = n2;
        }
        if (n5 <= 0 || n <= 0) {
            n5 = 1;
            n = 1;
        }
        SampleModel sampleModel = colorModel.createCompatibleSampleModel(n5, n);
        this.init(null, (Rectangle)cloneable, colorModel, sampleModel, n3, n4, null);
    }

    public WritableRaster copyData(WritableRaster writableRaster) {
        this.genRect(writableRaster);
        return writableRaster;
    }

    public void genRect(WritableRaster writableRaster) {
        BufferedImage bufferedImage = new BufferedImage(this.cm, writableRaster.createWritableTranslatedChild(0, 0), this.cm.isAlphaPremultiplied(), null);
        Graphics2D graphics2D = GraphicsUtil.createGraphics((BufferedImage)bufferedImage, (RenderingHints)this.hints);
        graphics2D.setComposite(AlphaComposite.Clear);
        graphics2D.fillRect(0, 0, writableRaster.getWidth(), writableRaster.getHeight());
        graphics2D.setComposite(AlphaComposite.SrcOver);
        graphics2D.translate(-writableRaster.getMinX(), -writableRaster.getMinY());
        graphics2D.transform(this.node2dev);
        if (this.usePrimitivePaint) {
            this.node.primitivePaint(graphics2D);
        } else {
            this.node.paint(graphics2D);
        }
        graphics2D.dispose();
    }

    public ColorModel createColorModel() {
        if (Platform.isOSX()) {
            return GraphicsUtil.sRGB_Pre;
        }
        return GraphicsUtil.sRGB_Unpre;
    }
}

