/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.DocumentException;
import io.sf.carte.doc.agent.AbstractUserAgent;
import io.sf.carte.doc.style.css.CSSDocument;
import io.sf.carte.doc.style.css.MediaQueryList;
import io.sf.carte.doc.style.css.nsac.Parser;
import io.sf.carte.doc.style.css.om.AbstractCSSRule;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheetFactory;
import io.sf.carte.doc.style.css.om.AnonymousStyleDeclaration;
import io.sf.carte.doc.style.css.om.BaseCSSStyleSheet;
import io.sf.carte.doc.style.css.om.BaseCSSStyleSheetFactory;
import io.sf.carte.doc.style.css.om.BaseDocumentCSSStyleSheet;
import io.sf.carte.doc.style.css.om.CompatInlineStyle;
import io.sf.carte.doc.style.css.om.ComputedCSSStyle;
import io.sf.carte.doc.style.css.om.DOMCSSStyleSheet;
import io.sf.carte.doc.style.css.om.DOMComputedStyle;
import io.sf.carte.doc.style.css.om.DOMDocumentCSSStyleSheet;
import io.sf.carte.doc.style.css.om.InlineStyle;
import io.sf.carte.doc.style.css.om.StylableDocumentWrapper;
import io.sf.carte.doc.style.css.om.WrapperSelectorMatcher;
import io.sf.carte.doc.xml.dtd.DefaultEntityResolver;
import io.sf.carte.util.agent.AgentUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.EnumSet;
import javax.xml.parsers.DocumentBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class DOMCSSStyleSheetFactory
extends BaseCSSStyleSheetFactory {
    private static final long serialVersionUID = 1L;
    private BaseDocumentCSSStyleSheet defStyleSheet = null;
    private BaseDocumentCSSStyleSheet defQStyleSheet = null;
    private BaseDocumentCSSStyleSheet uaStyleSheet = null;
    private BaseDocumentCSSStyleSheet uaQStyleSheet = null;
    private EntityResolver resolver = this.createEntityResolver();
    private WrapperUserAgent myUserAgent = null;

    public DOMCSSStyleSheetFactory() {
    }

    public DOMCSSStyleSheetFactory(EnumSet<Parser.Flag> enumSet) {
        super(enumSet);
    }

    @Override
    protected DOMDocumentCSSStyleSheet createDocumentStyleSheet(byte by) {
        return new MyDOMDocumentCSSStyleSheet(null, by);
    }

    @Override
    protected DOMCSSStyleSheet createRuleStyleSheet(AbstractCSSRule abstractCSSRule, String string, MediaQueryList mediaQueryList) {
        return new MyDOMCSSStyleSheet(string, null, mediaQueryList, abstractCSSRule, abstractCSSRule.getOrigin());
    }

    @Override
    protected BaseCSSStyleSheet createLinkedStyleSheet(Node node, String string, MediaQueryList mediaQueryList) {
        Node node2;
        NamedNodeMap namedNodeMap;
        if (string == null && node != null && (namedNodeMap = node.getAttributes()) != null && (node2 = namedNodeMap.getNamedItem("title")) != null) {
            string = node2.getNodeValue();
        }
        return new MyDOMCSSStyleSheet(string, node, mediaQueryList, null, 8);
    }

    @Override
    public BaseDocumentCSSStyleSheet getUserAgentStyleSheet(CSSDocument.ComplianceMode complianceMode) {
        if (complianceMode == CSSDocument.ComplianceMode.STRICT) {
            if (this.uaStyleSheet == null) {
                this.uaStyleSheet = this.createDocumentStyleSheet((byte)16);
            }
            return this.uaStyleSheet;
        }
        if (this.uaQStyleSheet == null) {
            this.uaQStyleSheet = this.createDocumentStyleSheet((byte)16);
        }
        return this.uaQStyleSheet;
    }

    @Override
    protected BaseDocumentCSSStyleSheet getDefaultStyleSheet(CSSDocument.ComplianceMode complianceMode) {
        if (this.defStyleSheet == null) {
            this.mergeUserSheets();
        }
        BaseDocumentCSSStyleSheet baseDocumentCSSStyleSheet = complianceMode == CSSDocument.ComplianceMode.STRICT ? this.defStyleSheet : this.defQStyleSheet;
        return baseDocumentCSSStyleSheet;
    }

    @Override
    public void setDefaultHTMLUserAgentSheet() {
        this.uaStyleSheet = this.htmlDefaultSheet();
        this.uaQStyleSheet = this.htmlQuirksDefaultSheet();
        this.defStyleSheet = null;
        this.defQStyleSheet = null;
    }

    private void mergeUserSheets() {
        this.defStyleSheet = this.getUserAgentStyleSheet(CSSDocument.ComplianceMode.STRICT).clone();
        this.defQStyleSheet = this.getUserAgentStyleSheet(CSSDocument.ComplianceMode.QUIRKS).clone();
        AbstractCSSStyleSheet abstractCSSStyleSheet = this.getUserNormalStyleSheet();
        if (abstractCSSStyleSheet != null) {
            this.defStyleSheet.addStyleSheet(abstractCSSStyleSheet);
            this.defQStyleSheet.addStyleSheet(abstractCSSStyleSheet);
        }
    }

    public WrapperUserAgent getUserAgent() {
        if (this.myUserAgent == null) {
            this.myUserAgent = new WrapperUserAgent();
        }
        return this.myUserAgent;
    }

    public StylableDocumentWrapper createCSSDocument(Document document) {
        return new MyStylableDocumentWrapper(document);
    }

    @Override
    public AbstractCSSStyleDeclaration createAnonymousStyleDeclaration(Node node) {
        MyAnonStyleDeclaration myAnonStyleDeclaration = new MyAnonStyleDeclaration(node);
        return myAnonStyleDeclaration;
    }

    @Override
    protected InlineStyle createInlineStyle(Node node) {
        InlineStyle inlineStyle = !this.hasCompatValueFlags() ? new MyInlineStyle() : new MyCompatInlineStyle();
        inlineStyle.setOwnerNode(node);
        return inlineStyle;
    }

    protected EntityResolver createEntityResolver() {
        return new DefaultEntityResolver();
    }

    class MyAnonStyleDeclaration
    extends AnonymousStyleDeclaration {
        private static final long serialVersionUID = 1L;

        MyAnonStyleDeclaration(Node node) {
            super(node);
        }

        private MyAnonStyleDeclaration(AnonymousStyleDeclaration anonymousStyleDeclaration) {
            super(anonymousStyleDeclaration);
        }

        @Override
        protected AbstractCSSStyleSheetFactory getStyleSheetFactory() {
            return DOMCSSStyleSheetFactory.this;
        }

        @Override
        public AnonymousStyleDeclaration clone() {
            MyAnonStyleDeclaration myAnonStyleDeclaration = new MyAnonStyleDeclaration(this);
            return myAnonStyleDeclaration;
        }
    }

    class MyCompatInlineStyle
    extends CompatInlineStyle {
        private static final long serialVersionUID = 1L;

        MyCompatInlineStyle() {
        }

        MyCompatInlineStyle(CompatInlineStyle compatInlineStyle) {
            super(compatInlineStyle);
        }

        @Override
        protected AbstractCSSStyleSheetFactory getStyleSheetFactory() {
            return DOMCSSStyleSheetFactory.this;
        }

        @Override
        public InlineStyle clone() {
            return new MyCompatInlineStyle(this);
        }
    }

    class MyDOMCSSStyleSheet
    extends DOMCSSStyleSheet {
        private static final long serialVersionUID = 1L;

        MyDOMCSSStyleSheet(String string, Node node, MediaQueryList mediaQueryList, AbstractCSSRule abstractCSSRule, byte by) {
            super(string, node, mediaQueryList, abstractCSSRule, by);
        }

        @Override
        protected DOMCSSStyleSheet createCSSStyleSheet(String string, Node node, MediaQueryList mediaQueryList, AbstractCSSRule abstractCSSRule, byte by) {
            return new MyDOMCSSStyleSheet(string, node, mediaQueryList, abstractCSSRule, by);
        }

        @Override
        public BaseCSSStyleSheetFactory getStyleSheetFactory() {
            return DOMCSSStyleSheetFactory.this;
        }
    }

    class MyDOMComputedStyle
    extends DOMComputedStyle {
        private static final long serialVersionUID = 1L;

        MyDOMComputedStyle(BaseDocumentCSSStyleSheet baseDocumentCSSStyleSheet) {
            super(baseDocumentCSSStyleSheet);
        }

        private MyDOMComputedStyle(ComputedCSSStyle computedCSSStyle) {
            super(computedCSSStyle);
        }

        @Override
        protected AbstractCSSStyleSheetFactory getStyleSheetFactory() {
            return DOMCSSStyleSheetFactory.this;
        }

        @Override
        public ComputedCSSStyle clone() {
            MyDOMComputedStyle myDOMComputedStyle = new MyDOMComputedStyle(this);
            return myDOMComputedStyle;
        }
    }

    private class MyDOMDocumentCSSStyleSheet
    extends DOMDocumentCSSStyleSheet {
        private static final long serialVersionUID = 1L;

        MyDOMDocumentCSSStyleSheet(String string, byte by) {
            super(string, by);
        }

        @Override
        protected DOMDocumentCSSStyleSheet createDocumentStyleSheet(String string, byte by) {
            return new MyDOMDocumentCSSStyleSheet(string, by);
        }

        @Override
        protected DOMComputedStyle createComputedCSSStyle() {
            return new MyDOMComputedStyle(this);
        }

        @Override
        public BaseCSSStyleSheetFactory getStyleSheetFactory() {
            return DOMCSSStyleSheetFactory.this;
        }
    }

    class MyInlineStyle
    extends InlineStyle {
        private static final long serialVersionUID = 1L;

        MyInlineStyle() {
        }

        MyInlineStyle(InlineStyle inlineStyle) {
            super(inlineStyle);
        }

        @Override
        protected AbstractCSSStyleSheetFactory getStyleSheetFactory() {
            return DOMCSSStyleSheetFactory.this;
        }

        @Override
        public InlineStyle clone() {
            return new MyInlineStyle(this);
        }
    }

    private class MyStylableDocumentWrapper
    extends StylableDocumentWrapper {
        private long loadingTime;

        MyStylableDocumentWrapper(Document document) {
            super(document);
        }

        @Override
        protected DOMCSSStyleSheetFactory getStyleSheetFactory() {
            return DOMCSSStyleSheetFactory.this;
        }

        @Override
        public URLConnection openConnection(URL uRL) throws IOException {
            return DOMCSSStyleSheetFactory.this.getUserAgent().openConnection(uRL, this.loadingTime);
        }

        @Override
        public void setLoadingTime(long l) {
            this.loadingTime = l;
        }

        @Override
        protected void setReferrerPolicyHeader(String string) {
            super.setReferrerPolicyHeader(string);
        }
    }

    public class WrapperUserAgent
    extends AbstractUserAgent {
        private static final long serialVersionUID = 1L;
        DocumentBuilder docbuilder;

        WrapperUserAgent() {
            super(DOMCSSStyleSheetFactory.this.getParserFlags());
            this.docbuilder = null;
        }

        public void setDocumentBuilder(DocumentBuilder documentBuilder) {
            this.docbuilder = documentBuilder;
            documentBuilder.setEntityResolver(DOMCSSStyleSheetFactory.this.resolver);
        }

        @Override
        public CSSDocument readURL(URL uRL) throws IOException, DocumentException {
            String string;
            Object object;
            Object object2;
            if (this.docbuilder == null) {
                throw new IllegalStateException("Must set a DocumentBuilder first");
            }
            if (this.getOriginPolicy() == null) {
                throw new IllegalStateException("Must set an origin policy first");
            }
            long l = System.currentTimeMillis();
            URLConnection uRLConnection = this.openConnection(uRL, l);
            uRLConnection.connect();
            String string2 = uRLConnection.getContentType();
            String string3 = uRLConnection.getContentEncoding();
            Document document = null;
            try (InputStream inputStream = null;){
                inputStream = uRLConnection.getInputStream();
                object2 = new InputSource(AgentUtil.inputStreamToReader((InputStream)inputStream, (String)string2, (String)string3, (Charset)StandardCharsets.UTF_8));
                document = this.docbuilder.parse((InputSource)object2);
            }
            document.getDocumentElement().normalize();
            document.setDocumentURI(uRL.toExternalForm());
            object2 = DOMCSSStyleSheetFactory.this.createCSSDocument(document);
            ((StylableDocumentWrapper)object2).setLoadingTime(l);
            String string4 = uRLConnection.getHeaderField("Default-Style");
            NodeList nodeList = document.getElementsByTagName("meta");
            int n = nodeList.getLength();
            for (int i = n - 1; i >= 0; --i) {
                String string5;
                object = (Element)nodeList.item(i);
                String string6 = WrapperSelectorMatcher.getAttributeValue((Element)object, "http-equiv");
                if (!"default-style".equalsIgnoreCase(string6) || (string5 = WrapperSelectorMatcher.getAttributeValue((Element)object, "content")).length() == 0) continue;
                string4 = string5;
            }
            if (string4 != null) {
                ((StylableDocumentWrapper)object2).setSelectedStyleSheetSet(string4);
            }
            if ((string = uRLConnection.getHeaderField("Referrer-Policy")) != null) {
                ((StylableDocumentWrapper)object2).setReferrerPolicyHeader(string);
            }
            if (uRLConnection instanceof HttpURLConnection) {
                object = (HttpURLConnection)uRLConnection;
                this.readCookies((HttpURLConnection)object, l);
                ((HttpURLConnection)object).disconnect();
            }
            return object2;
        }

        @Override
        public void setEntityResolver(EntityResolver entityResolver) {
            DOMCSSStyleSheetFactory.this.resolver = entityResolver;
            if (this.docbuilder != null) {
                this.docbuilder.setEntityResolver(entityResolver);
            }
        }

        @Override
        public URLConnection openConnection(URL uRL, long l) throws IOException {
            return super.openConnection(uRL, l);
        }
    }
}

