/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.parser;

import io.sf.carte.echosvg.parser.DefaultLengthHandler;
import io.sf.carte.echosvg.parser.LengthParser;
import io.sf.carte.echosvg.parser.ParseException;
import org.w3c.dom.Element;

public abstract class UnitProcessor {
    public static final short HORIZONTAL_LENGTH = 2;
    public static final short VERTICAL_LENGTH = 1;
    public static final short OTHER_LENGTH = 0;
    static final double SQRT2 = Math.sqrt(2.0);

    protected UnitProcessor() {
    }

    public static float cssToObjectBoundingBox(String string, String string2, final short s, final Context context) throws ParseException {
        UnitResolver unitResolver = new UnitResolver(){

            @Override
            protected float unitToPixels(short s3, float f, short s2) {
                return UnitProcessor.cssToObjectBoundingBox(f, s3, s, context);
            }
        };
        LengthParser lengthParser = new LengthParser(unitResolver);
        lengthParser.parse(string);
        return UnitProcessor.cssToObjectBoundingBox(unitResolver.value, unitResolver.unit, s, context);
    }

    public static float cssToObjectBoundingBox(float f, short s, short s2, Context context) {
        switch (s) {
            case 0: {
                return f;
            }
            case 2: {
                return f / 100.0f;
            }
        }
        return UnitProcessor.cssToUserSpace(f, s, s2, context);
    }

    public static float cssToUserSpace(String string, String string2, final short s, final Context context) throws ParseException {
        UnitResolver unitResolver = new UnitResolver(){

            @Override
            protected float unitToPixels(short s3, float f, short s2) {
                return UnitProcessor.cssToUserSpace(f, s3, s, context);
            }
        };
        LengthParser lengthParser = new LengthParser(unitResolver);
        lengthParser.parse(string);
        return UnitProcessor.cssToUserSpace(unitResolver.value, unitResolver.unit, s, context);
    }

    public static float cssToUserSpace(float f, short s, short s2, Context context) {
        switch (s) {
            case 0: 
            case 3: {
                return f;
            }
            case 2: {
                return UnitProcessor.percentagesToPixels(f, s2, context);
            }
            case 20: {
                return UnitProcessor.emsToPixels(f, s2, context);
            }
            case 21: {
                return UnitProcessor.exsToPixels(f, s2, context);
            }
            case 25: {
                return UnitProcessor.lhToPixels(f, s2, context);
            }
            case 26: {
                return UnitProcessor.remToPixels(f, s2, context);
            }
            case 28: {
                return UnitProcessor.rexToPixels(f, s2, context);
            }
            case 27: {
                return UnitProcessor.rlhToPixels(f, s2, context);
            }
            case 45: {
                return UnitProcessor.vwToPixels(f, s2, context);
            }
            case 41: {
                return UnitProcessor.vhToPixels(f, s2, context);
            }
            case 44: {
                return UnitProcessor.vminToPixels(f, s2, context);
            }
            case 43: {
                return UnitProcessor.vmaxToPixels(f, s2, context);
            }
            case 8: {
                return f * 3.7795277f;
            }
            case 7: {
                return f * 37.795277f;
            }
            case 4: {
                return f * 96.0f;
            }
            case 6: {
                return f / 0.75f;
            }
            case 5: {
                return f * 16.0f;
            }
            case 9: {
                return f * 0.9448819f;
            }
        }
        throw new IllegalArgumentException("Length has unknown type");
    }

    public static float userSpaceToCSS(float f, short s, short s2, Context context) {
        switch (s) {
            case 0: 
            case 3: {
                return f;
            }
            case 8: {
                return f * 0.26458332f;
            }
            case 7: {
                return f * 0.026458334f;
            }
            case 4: {
                return f / 96.0f;
            }
            case 6: {
                return f * 0.75f;
            }
            case 5: {
                return f / 16.0f;
            }
            case 9: {
                return f * 1.0583333f;
            }
            case 20: {
                return UnitProcessor.pixelsToEms(f, s2, context);
            }
            case 21: {
                return UnitProcessor.pixelsToExs(f, s2, context);
            }
            case 25: {
                return UnitProcessor.pixelsToLh(f, s2, context);
            }
            case 26: {
                return UnitProcessor.pixelsToRem(f, s2, context);
            }
            case 28: {
                return UnitProcessor.pixelsToRex(f, s2, context);
            }
            case 27: {
                return UnitProcessor.pixelsToRlh(f, s2, context);
            }
            case 45: {
                return UnitProcessor.pixelsToVw(f, s2, context);
            }
            case 41: {
                return UnitProcessor.pixelsToVh(f, s2, context);
            }
            case 44: {
                return UnitProcessor.pixelsToVmin(f, s2, context);
            }
            case 43: {
                return UnitProcessor.pixelsToVmax(f, s2, context);
            }
            case 2: {
                return UnitProcessor.pixelsToPercentages(f, s2, context);
            }
        }
        throw new IllegalArgumentException("Length has unknown type");
    }

    protected static float percentagesToPixels(float f, short s, Context context) {
        if (s == 2) {
            float f2 = context.getViewportWidth();
            return f2 * f / 100.0f;
        }
        if (s == 1) {
            float f3 = context.getViewportHeight();
            return f3 * f / 100.0f;
        }
        double d = context.getViewportWidth();
        double d2 = context.getViewportHeight();
        double d3 = Math.sqrt(d * d + d2 * d2) / SQRT2;
        return (float)(d3 * (double)f / 100.0);
    }

    protected static float pixelsToPercentages(float f, short s, Context context) {
        if (s == 2) {
            float f2 = context.getViewportWidth();
            return f * 100.0f / f2;
        }
        if (s == 1) {
            float f3 = context.getViewportHeight();
            return f * 100.0f / f3;
        }
        double d = context.getViewportWidth();
        double d2 = context.getViewportHeight();
        double d3 = Math.sqrt(d * d + d2 * d2) / SQRT2;
        return (float)((double)f * 100.0 / d3);
    }

    protected static float pixelsToEms(float f, short s, Context context) {
        return f / context.getFontSize();
    }

    protected static float emsToPixels(float f, short s, Context context) {
        return f * context.getFontSize();
    }

    protected static float pixelsToExs(float f, short s, Context context) {
        float f2 = context.getXHeight();
        return f / f2 / context.getFontSize();
    }

    protected static float exsToPixels(float f, short s, Context context) {
        float f2 = context.getXHeight();
        return f * f2 * context.getFontSize();
    }

    protected static float pixelsToLh(float f, short s, Context context) {
        return f / context.getLineHeight();
    }

    protected static float lhToPixels(float f, short s, Context context) {
        return f * context.getLineHeight();
    }

    protected static float pixelsToRem(float f, short s, Context context) {
        return f / context.getRootFontSize();
    }

    protected static float remToPixels(float f, short s, Context context) {
        return f * context.getRootFontSize();
    }

    protected static float pixelsToRex(float f, short s, Context context) {
        float f2 = context.getRootXHeight();
        return f / f2 / context.getRootFontSize();
    }

    protected static float rexToPixels(float f, short s, Context context) {
        float f2 = context.getRootXHeight();
        return f * f2 * context.getRootFontSize();
    }

    protected static float pixelsToRlh(float f, short s, Context context) {
        return f / context.getRootLineHeight();
    }

    protected static float rlhToPixels(float f, short s, Context context) {
        return f * context.getRootLineHeight();
    }

    private static float pixelsToVw(float f, short s, Context context) {
        return f / context.getViewportWidth() * 100.0f;
    }

    private static float pixelsToVh(float f, short s, Context context) {
        return f / context.getViewportHeight() * 100.0f;
    }

    private static float pixelsToVmax(float f, short s, Context context) {
        float f2 = context.getViewportWidth();
        float f3 = context.getViewportHeight();
        return f / Math.max(f2, f3) * 100.0f;
    }

    private static float pixelsToVmin(float f, short s, Context context) {
        float f2 = context.getViewportWidth();
        float f3 = context.getViewportHeight();
        return f / Math.min(f2, f3) * 100.0f;
    }

    private static float vwToPixels(float f, short s, Context context) {
        return f * context.getViewportWidth() / 100.0f;
    }

    private static float vhToPixels(float f, short s, Context context) {
        return f * context.getViewportHeight() / 100.0f;
    }

    private static float vmaxToPixels(float f, short s, Context context) {
        float f2 = context.getViewportWidth();
        float f3 = context.getViewportHeight();
        return f * Math.max(f2, f3) / 100.0f;
    }

    private static float vminToPixels(float f, short s, Context context) {
        float f2 = context.getViewportWidth();
        float f3 = context.getViewportHeight();
        return f * Math.min(f2, f3) / 100.0f;
    }

    public static interface Context {
        public Element getElement();

        public float getResolution();

        public float getFontSize();

        public float getXHeight();

        public float getLineHeight();

        public float getRootFontSize();

        public float getRootXHeight();

        public float getRootLineHeight();

        public float getViewportWidth();

        public float getViewportHeight();
    }

    public static class UnitResolver
    extends DefaultLengthHandler {
        public float value;
        public short unit = 0;

        @Override
        public void startLength() throws ParseException {
        }

        @Override
        public void lengthValue(float f) throws ParseException {
            this.value = f;
        }

        @Override
        protected void setUnit(short s) {
            this.unit = s;
        }

        @Override
        public void endLength() throws ParseException {
        }
    }
}

