/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.DeclarationFormattingContext;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.ShorthandBuilder;
import io.sf.carte.util.BufferSimpleWriter;
import java.util.Set;

class FontVariantBuilder
extends ShorthandBuilder {
    FontVariantBuilder(BaseCSSStyleDeclaration baseCSSStyleDeclaration) {
        super("font-variant", baseCSSStyleDeclaration);
    }

    @Override
    protected int getMinimumSetSize() {
        return 6;
    }

    @Override
    boolean isInheritedProperty() {
        return true;
    }

    @Override
    int appendShorthandSet(StringBuilder stringBuilder, Set<String> set, boolean bl) {
        if (this.hasPropertiesToExclude(set)) {
            return 1;
        }
        stringBuilder.append(this.getShorthandName()).append(':');
        byte by = this.checkValuesForInherit(set);
        if (by == 1) {
            stringBuilder.append("inherit");
            this.appendPriority(stringBuilder, bl);
            return 0;
        }
        if (by == 2) {
            return 1;
        }
        by = this.checkValuesForType(CSSValue.Type.UNSET, set);
        if (by == 1) {
            stringBuilder.append("unset");
            this.appendPriority(stringBuilder, bl);
            return 0;
        }
        if (by == 2) {
            return 1;
        }
        by = this.checkValuesForType(CSSValue.Type.REVERT, set);
        if (by == 1) {
            stringBuilder.append("revert");
            this.appendPriority(stringBuilder, bl);
            return 0;
        }
        if (by == 2) {
            return 1;
        }
        if (this.checkValuesForType(CSSValue.Type.INTERNAL, set) != 0) {
            return 1;
        }
        BufferSimpleWriter bufferSimpleWriter = new BufferSimpleWriter(stringBuilder);
        DeclarationFormattingContext declarationFormattingContext = this.getParentStyle().getFormattingContext();
        boolean bl2 = false;
        if (set.contains("font-variant-ligatures")) {
            bl2 = this.appendValueIfNotInitial(bufferSimpleWriter, declarationFormattingContext, "font-variant-ligatures", false);
        }
        if (set.contains("font-variant-position")) {
            bl2 = this.appendValueIfNotInitial(bufferSimpleWriter, declarationFormattingContext, "font-variant-position", bl2);
        }
        if (set.contains("font-variant-caps")) {
            bl2 = this.appendValueIfNotInitial(bufferSimpleWriter, declarationFormattingContext, "font-variant-caps", bl2);
        }
        if (set.contains("font-variant-numeric")) {
            bl2 = this.appendValueIfNotInitial(bufferSimpleWriter, declarationFormattingContext, "font-variant-numeric", bl2);
        }
        if (set.contains("font-variant-alternates")) {
            bl2 = this.appendValueIfNotInitial(bufferSimpleWriter, declarationFormattingContext, "font-variant-alternates", bl2);
        }
        if (set.contains("font-variant-east-asian")) {
            bl2 = this.appendValueIfNotInitial(bufferSimpleWriter, declarationFormattingContext, "font-variant-east-asian", bl2);
        }
        if (!bl2) {
            stringBuilder.append("normal");
        }
        this.appendPriority(stringBuilder, bl);
        return 0;
    }
}

