/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.optimizer;

import java.util.Map;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.NodeTransformer;
import org.mozilla.javascript.ObjArray;
import org.mozilla.javascript.ast.ScriptNode;
import org.mozilla.javascript.optimizer.OptFunctionNode;

class OptTransformer
extends NodeTransformer {
    private Map<String, OptFunctionNode> possibleDirectCalls;
    private ObjArray directCallTargets;

    OptTransformer(Map<String, OptFunctionNode> map, ObjArray objArray) {
        this.possibleDirectCalls = map;
        this.directCallTargets = objArray;
    }

    @Override
    protected void visitNew(Node node, ScriptNode scriptNode) {
        this.detectDirectCall(node, scriptNode);
        super.visitNew(node, scriptNode);
    }

    @Override
    protected void visitCall(Node node, ScriptNode scriptNode) {
        this.detectDirectCall(node, scriptNode);
        super.visitCall(node, scriptNode);
    }

    private void detectDirectCall(Node node, ScriptNode scriptNode) {
        if (scriptNode.getType() == 113) {
            Object object;
            Node node2 = node.getFirstChild();
            int n = 0;
            if (node2 != null) {
                object = node2.getNext();
                while (object != null) {
                    object = ((Node)object).getNext();
                    ++n;
                }
            }
            if (n == 0) {
                OptFunctionNode.get((ScriptNode)scriptNode).itsContainsCalls0 = true;
            }
            if (this.possibleDirectCalls != null) {
                OptFunctionNode optFunctionNode;
                object = null;
                if (node2.getType() == 39) {
                    object = node2.getString();
                } else if (node2.getType() == 33) {
                    object = node2.getFirstChild().getNext().getString();
                } else if (node2.getType() == 34) {
                    throw Kit.codeBug();
                }
                if (object != null && (optFunctionNode = this.possibleDirectCalls.get(object)) != null && n == optFunctionNode.fnode.getParamCount() && !optFunctionNode.fnode.requiresActivation() && n <= 32) {
                    node.putProp(9, optFunctionNode);
                    if (!optFunctionNode.isTargetOfDirectCall()) {
                        int n2 = this.directCallTargets.size();
                        this.directCallTargets.add(optFunctionNode);
                        optFunctionNode.setDirectTargetIndex(n2);
                    }
                }
            }
        }
    }
}

