/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.ConsString;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Delegator;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.NativeError;
import org.mozilla.javascript.NativeJSON;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.ScriptStackElement;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;

public class NativeConsole
extends IdScriptableObject {
    private static final long serialVersionUID = 5694613212458273057L;
    private static final Object CONSOLE_TAG = "Console";
    private static final String DEFAULT_LABEL = "default";
    private static final Pattern FMT_REG = Pattern.compile("%[sfdioOc%]");
    private final Map<String, Long> timers = new ConcurrentHashMap<String, Long>();
    private final Map<String, AtomicInteger> counters = new ConcurrentHashMap<String, AtomicInteger>();
    private final ConsolePrinter printer;
    private static final int Id_toSource = 1;
    private static final int Id_trace = 2;
    private static final int Id_debug = 3;
    private static final int Id_log = 4;
    private static final int Id_info = 5;
    private static final int Id_warn = 6;
    private static final int Id_error = 7;
    private static final int Id_assert = 8;
    private static final int Id_count = 9;
    private static final int Id_countReset = 10;
    private static final int Id_time = 11;
    private static final int Id_timeEnd = 12;
    private static final int Id_timeLog = 13;
    private static final int LAST_METHOD_ID = 13;
    private static final int MAX_ID = 13;

    public static void init(Scriptable scriptable, boolean bl, ConsolePrinter consolePrinter) {
        NativeConsole nativeConsole = new NativeConsole(consolePrinter);
        nativeConsole.activatePrototypeMap(13);
        nativeConsole.setPrototype(NativeConsole.getObjectPrototype(scriptable));
        nativeConsole.setParentScope(scriptable);
        if (bl) {
            nativeConsole.sealObject();
        }
        ScriptableObject.defineProperty(scriptable, "console", nativeConsole, 2);
    }

    private NativeConsole(ConsolePrinter consolePrinter) {
        this.printer = consolePrinter;
    }

    @Override
    public String getClassName() {
        return "Console";
    }

    @Override
    protected void initPrototypeId(int n) {
        String string;
        int n2;
        if (n > 13) {
            throw new IllegalStateException(String.valueOf(n));
        }
        switch (n) {
            case 1: {
                n2 = 0;
                string = "toSource";
                break;
            }
            case 2: {
                n2 = 1;
                string = "trace";
                break;
            }
            case 3: {
                n2 = 1;
                string = "debug";
                break;
            }
            case 4: {
                n2 = 1;
                string = "log";
                break;
            }
            case 5: {
                n2 = 1;
                string = "info";
                break;
            }
            case 6: {
                n2 = 1;
                string = "warn";
                break;
            }
            case 7: {
                n2 = 1;
                string = "error";
                break;
            }
            case 8: {
                n2 = 2;
                string = "assert";
                break;
            }
            case 9: {
                n2 = 1;
                string = "count";
                break;
            }
            case 10: {
                n2 = 1;
                string = "countReset";
                break;
            }
            case 11: {
                n2 = 1;
                string = "time";
                break;
            }
            case 12: {
                n2 = 1;
                string = "timeEnd";
                break;
            }
            case 13: {
                n2 = 2;
                string = "timeLog";
                break;
            }
            default: {
                throw new IllegalStateException(String.valueOf(n));
            }
        }
        this.initPrototypeMethod(CONSOLE_TAG, n, string, n2);
    }

    @Override
    public Object execIdCall(IdFunctionObject idFunctionObject, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        if (!idFunctionObject.hasTag(CONSOLE_TAG)) {
            return super.execIdCall(idFunctionObject, context, scriptable, scriptable2, objectArray);
        }
        int n = idFunctionObject.methodId();
        switch (n) {
            case 1: {
                return "Console";
            }
            case 2: {
                ScriptStackElement[] scriptStackElementArray = new EvaluatorException("[object Object]").getScriptStack();
                this.printer.print(context, scriptable, Level.TRACE, objectArray, scriptStackElementArray);
                break;
            }
            case 3: {
                this.printer.print(context, scriptable, Level.DEBUG, objectArray, null);
                break;
            }
            case 4: 
            case 5: {
                this.printer.print(context, scriptable, Level.INFO, objectArray, null);
                break;
            }
            case 6: {
                this.printer.print(context, scriptable, Level.WARN, objectArray, null);
                break;
            }
            case 7: {
                this.printer.print(context, scriptable, Level.ERROR, objectArray, null);
                break;
            }
            case 8: {
                this.jsAssert(context, scriptable, objectArray);
                break;
            }
            case 9: {
                this.count(context, scriptable, objectArray);
                break;
            }
            case 10: {
                this.countReset(context, scriptable, objectArray);
                break;
            }
            case 11: {
                this.time(context, scriptable, objectArray);
                break;
            }
            case 12: {
                this.timeEnd(context, scriptable, objectArray);
                break;
            }
            case 13: {
                this.timeLog(context, scriptable, objectArray);
                break;
            }
            default: {
                throw new IllegalStateException(String.valueOf(n));
            }
        }
        return Undefined.instance;
    }

    private void print(Context context, Scriptable scriptable, Level level, String string) {
        this.printer.print(context, scriptable, level, new String[]{string}, null);
    }

    public static String format(Context context, Scriptable scriptable, Object[] objectArray) {
        Object object;
        if (objectArray == null || objectArray.length == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        Object object2 = objectArray[0];
        if (object2 instanceof String || object2 instanceof ConsString) {
            String string = object2.toString();
            object = FMT_REG.matcher(string);
            n = 1;
            while (((Matcher)object).find()) {
                String string2;
                String string3 = ((Matcher)object).group();
                if (string3.equals("%%")) {
                    string2 = "%";
                } else if (n >= objectArray.length) {
                    string2 = string3;
                    ++n;
                } else {
                    Object object3 = objectArray[n];
                    switch (string3) {
                        case "%s": {
                            string2 = NativeConsole.formatString(object3);
                            break;
                        }
                        case "%d": 
                        case "%i": {
                            string2 = NativeConsole.formatInt(object3);
                            break;
                        }
                        case "%f": {
                            string2 = NativeConsole.formatFloat(object3);
                            break;
                        }
                        case "%o": 
                        case "%O": {
                            string2 = NativeConsole.formatObj(context, scriptable, object3);
                            break;
                        }
                        default: {
                            string2 = "";
                        }
                    }
                    ++n;
                }
                ((Matcher)object).appendReplacement(stringBuffer, Matcher.quoteReplacement(string2));
            }
            ((Matcher)object).appendTail(stringBuffer);
        }
        for (int i = n; i < objectArray.length; ++i) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(' ');
            }
            if ((object = objectArray[i]) instanceof String) {
                stringBuffer.append(NativeConsole.formatString(object));
                continue;
            }
            stringBuffer.append(NativeConsole.formatObj(context, scriptable, object));
        }
        return stringBuffer.toString();
    }

    private static String formatString(Object object) {
        if (object instanceof BigInteger) {
            return ScriptRuntime.toString(object) + "n";
        }
        if (ScriptRuntime.isSymbol(object)) {
            return object.toString();
        }
        return ScriptRuntime.toString(object);
    }

    private static String formatInt(Object object) {
        if (object instanceof BigInteger) {
            return ScriptRuntime.bigIntToString((BigInteger)object, 10) + "n";
        }
        if (ScriptRuntime.isSymbol(object)) {
            return ScriptRuntime.NaNobj.toString();
        }
        double d = ScriptRuntime.toNumber(object);
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            return ScriptRuntime.toString(d);
        }
        return String.valueOf((long)d);
    }

    private static String formatFloat(Object object) {
        if (object instanceof BigInteger || ScriptRuntime.isSymbol(object)) {
            return ScriptRuntime.NaNobj.toString();
        }
        return ScriptRuntime.numberToString(ScriptRuntime.toNumber(object), 10);
    }

    private static String formatObj(Context context, Scriptable scriptable, final Object object) {
        if (object == null) {
            return "null";
        }
        if (Undefined.isUndefined(object)) {
            return Undefined.SCRIPTABLE_UNDEFINED.toString();
        }
        if (object instanceof NativeError) {
            NativeError nativeError = (NativeError)object;
            String string = nativeError.toString();
            string = string + "\n";
            string = string + nativeError.get("stack");
            return string;
        }
        try {
            Callable callable = new Callable(){

                @Override
                public Object call(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
                    Object object2 = objectArray[1];
                    while (object2 instanceof Delegator) {
                        object2 = ((Delegator)object2).getDelegee();
                    }
                    if (object2 instanceof BaseFunction) {
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append("function ").append(((BaseFunction)object2).getFunctionName()).append("() {...}");
                        return stringBuilder.toString();
                    }
                    if (object2 instanceof Callable) {
                        return ScriptRuntime.toString(object2);
                    }
                    if (object instanceof NativeError) {
                        return ((NativeError)object).toString();
                    }
                    return object2;
                }
            };
            Object object2 = NativeJSON.stringify(context, scriptable, object, callable, null);
            return ScriptRuntime.toString(object2);
        }
        catch (EcmaError ecmaError) {
            if ("TypeError".equals(ecmaError.getName())) {
                return ScriptRuntime.toString(object);
            }
            throw ecmaError;
        }
    }

    private void jsAssert(Context context, Scriptable scriptable, Object[] objectArray) {
        if (objectArray != null && objectArray.length > 0 && ScriptRuntime.toBoolean(objectArray[0])) {
            return;
        }
        if (objectArray == null || objectArray.length < 2) {
            this.printer.print(context, scriptable, Level.ERROR, new String[]{"Assertion failed: console.assert"}, null);
            return;
        }
        Object object = objectArray[1];
        if (object instanceof String) {
            objectArray[1] = "Assertion failed: " + object;
            Object[] objectArray2 = new Object[objectArray.length - 1];
            System.arraycopy(objectArray, 1, objectArray2, 0, objectArray2.length);
            objectArray = objectArray2;
        } else {
            objectArray[0] = "Assertion failed:";
        }
        this.printer.print(context, scriptable, Level.ERROR, objectArray, null);
    }

    private void count(Context context, Scriptable scriptable, Object[] objectArray) {
        String string2 = objectArray.length > 0 ? ScriptRuntime.toString(objectArray[0]) : DEFAULT_LABEL;
        int n = this.counters.computeIfAbsent(string2, string -> new AtomicInteger(0)).incrementAndGet();
        this.print(context, scriptable, Level.INFO, string2 + ": " + n);
    }

    private void countReset(Context context, Scriptable scriptable, Object[] objectArray) {
        String string = objectArray.length > 0 ? ScriptRuntime.toString(objectArray[0]) : DEFAULT_LABEL;
        AtomicInteger atomicInteger = this.counters.remove(string);
        if (atomicInteger == null) {
            this.print(context, scriptable, Level.WARN, "Count for '" + string + "' does not exist.");
        }
    }

    private void time(Context context, Scriptable scriptable, Object[] objectArray) {
        String string = objectArray.length > 0 ? ScriptRuntime.toString(objectArray[0]) : DEFAULT_LABEL;
        Long l = this.timers.get(string);
        if (l != null) {
            this.print(context, scriptable, Level.WARN, "Timer '" + string + "' already exists.");
            return;
        }
        this.timers.put(string, System.nanoTime());
    }

    private void timeEnd(Context context, Scriptable scriptable, Object[] objectArray) {
        String string = objectArray.length > 0 ? ScriptRuntime.toString(objectArray[0]) : DEFAULT_LABEL;
        Long l = this.timers.remove(string);
        if (l == null) {
            this.print(context, scriptable, Level.WARN, "Timer '" + string + "' does not exist.");
            return;
        }
        this.print(context, scriptable, Level.INFO, string + ": " + this.nano2Milli(System.nanoTime() - l) + "ms");
    }

    private void timeLog(Context context, Scriptable scriptable, Object[] objectArray) {
        String string = objectArray.length > 0 ? ScriptRuntime.toString(objectArray[0]) : DEFAULT_LABEL;
        Long l = this.timers.get(string);
        if (l == null) {
            this.print(context, scriptable, Level.WARN, "Timer '" + string + "' does not exist.");
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(string + ": " + this.nano2Milli(System.nanoTime() - l) + "ms");
        if (objectArray.length > 1) {
            for (int i = 1; i < objectArray.length; ++i) {
                stringBuilder.append(" ").append(ScriptRuntime.toString(objectArray[i]));
            }
        }
        this.print(context, scriptable, Level.INFO, stringBuilder.toString());
    }

    private double nano2Milli(Long l) {
        return (double)l.longValue() / 1000000.0;
    }

    @Override
    protected int findPrototypeId(String string) {
        int n;
        switch (string) {
            case "log": {
                n = 4;
                break;
            }
            case "info": {
                n = 5;
                break;
            }
            case "time": {
                n = 11;
                break;
            }
            case "warn": {
                n = 6;
                break;
            }
            case "count": {
                n = 9;
                break;
            }
            case "debug": {
                n = 3;
                break;
            }
            case "error": {
                n = 7;
                break;
            }
            case "trace": {
                n = 2;
                break;
            }
            case "assert": {
                n = 8;
                break;
            }
            case "timeEnd": {
                n = 12;
                break;
            }
            case "timeLog": {
                n = 13;
                break;
            }
            case "toSource": {
                n = 1;
                break;
            }
            case "countReset": {
                n = 10;
                break;
            }
            default: {
                n = 0;
            }
        }
        return n;
    }

    public static interface ConsolePrinter
    extends Serializable {
        public void print(Context var1, Scriptable var2, Level var3, Object[] var4, ScriptStackElement[] var5);
    }

    public static enum Level {
        TRACE,
        DEBUG,
        INFO,
        WARN,
        ERROR;

    }
}

