/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.parser;

import io.sf.carte.doc.DOMCharacterException;
import io.sf.carte.doc.DOMNullCharacterException;
import io.sf.carte.doc.style.css.CSSUnit;
import io.sf.carte.doc.style.css.nsac.Condition;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.nsac.PseudoCondition;
import io.sf.carte.doc.style.css.nsac.SelectorList;
import io.sf.carte.doc.style.css.parser.LexicalUnitImpl;
import io.sf.carte.doc.style.css.parser.PseudoConditionImpl;
import org.w3c.dom.DOMException;

public class ParseHelper {
    public static final byte ERR_UNEXPECTED_CHAR = 4;
    public static final byte ERR_WRONG_VALUE = 5;
    public static final byte ERR_UNMATCHED_PARENTHESIS = 6;
    public static final byte ERR_INVALID_IDENTIFIER = 7;
    public static final byte ERR_UNEXPECTED_TOKEN = 9;
    public static final byte ERR_UNKNOWN_NAMESPACE = 15;
    public static final byte ERR_EXPR_SYNTAX = 32;
    public static final byte ERR_RULE_SYNTAX = 33;
    public static final byte ERR_UNEXPECTED_EOF = 10;
    public static final byte ERR_IO = 11;
    public static final byte ERR_UNSUPPORTED = 127;
    public static final byte WARN_DUPLICATE_SELECTOR = -1;
    public static final byte WARN_IDENT_COMPAT = -2;
    public static final byte WARN_PROGID_HACK = -3;
    public static final byte WARN_PROPERTY_NAME = -4;
    public static final byte WARN_VALUE = -5;
    public static final byte WARN_UNEXPECTED_EOF = -6;

    public static String unescapeStringValue(String string) {
        return ParseHelper.unescapeStringValue(string, true, true);
    }

    public static String unescapeStringValue(String string, boolean bl, boolean bl2) throws DOMNullCharacterException {
        int n;
        int n2 = string.indexOf(92);
        if (n2 == -1) {
            return string;
        }
        int n3 = string.length();
        StringBuilder stringBuilder = new StringBuilder(n3);
        if (n2 > 0) {
            ParseHelper.appendString(stringBuilder, string, 0, n2);
        }
        int n4 = ++n2;
        while (n4 < n3) {
            int n5;
            if (n4 - n2 > 5) {
                ParseHelper.appendCodePoint(stringBuilder, string, n2, n4, bl, true);
                n2 = string.indexOf(92, n4);
                if (n2 == -1) {
                    ParseHelper.appendString(stringBuilder, string, n4, n3);
                    break;
                }
                ParseHelper.appendString(stringBuilder, string, n4, n2);
                n4 = ++n2;
                if (n4 == n3) break;
            }
            if ((n5 = Character.digit((char)(n = string.charAt(n4)), 16)) == -1) {
                int n6;
                if (n4 != n2) {
                    if (!ParseHelper.appendCodePoint(stringBuilder, string, n2, n4, bl, bl2) || n == 32) {
                        // empty if block
                    }
                    n6 = ++n4;
                } else {
                    n6 = n4 + 1;
                }
                n2 = string.indexOf(92, n6);
                if (n2 == -1) {
                    ParseHelper.appendString(stringBuilder, string, n4, n3);
                    break;
                }
                ParseHelper.appendString(stringBuilder, string, n4, n2);
                if ((n4 = ++n2) != n3) continue;
                break;
            }
            ++n4;
        }
        if (n2 != -1 && n3 != n2) {
            n = Character.digit(string.charAt(n2), 16);
            if (n == -1) {
                ParseHelper.appendString(stringBuilder, string, n2, n3);
            } else {
                ParseHelper.appendCodePoint(stringBuilder, string, n2, n3, bl, bl2);
            }
        }
        return stringBuilder.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean appendCodePoint(StringBuilder stringBuilder, String string, int n, int n2, boolean bl, boolean bl2) throws DOMNullCharacterException {
        if (n + 1 == n2) {
            char c = string.charAt(n);
            int n3 = Character.digit(c, 16);
            if (n3 == -1) {
                stringBuilder.append(c);
                return false;
            }
            if (n3 == 0 && !bl2) throw new DOMNullCharacterException(n);
            if (ParseHelper.appendCodePoint(stringBuilder, n3, bl)) {
                return true;
            }
        } else {
            try {
                int n4 = Integer.parseInt(string.substring(n, n2), 16);
                if (ParseHelper.appendCodePoint(stringBuilder, n4, bl)) {
                    return true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        ParseHelper.appendString(stringBuilder, string, n - 1, n2);
        return false;
    }

    private static boolean appendCodePoint(StringBuilder stringBuilder, int n, boolean bl) {
        int n2 = Character.getType(n);
        switch (n2) {
            case 0: 
            case 18: {
                return false;
            }
            case 15: {
                if (n == 0) {
                    stringBuilder.append('\ufffd');
                    break;
                }
                if (!bl) {
                    return false;
                }
            }
            default: {
                stringBuilder.appendCodePoint(n);
            }
        }
        return true;
    }

    private static void appendString(StringBuilder stringBuilder, CharSequence charSequence, int n, int n2) {
        int n3 = stringBuilder.length();
        CharSequence charSequence2 = charSequence.subSequence(n, n2);
        stringBuilder.append(charSequence2);
        for (int i = 0; i < charSequence2.length(); ++i) {
            if (charSequence2.charAt(i) != '\n') continue;
            stringBuilder.setCharAt(n3 + i, '\ufffd');
        }
    }

    public static String escape(String string) {
        return ParseHelper.escape(string, true, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String escape(String string, boolean bl, boolean bl2) {
        int n;
        int n2 = string.length();
        if (n2 == 0) {
            return string;
        }
        int n3 = 0;
        StringBuilder stringBuilder = null;
        boolean bl3 = true;
        char c = string.charAt(0);
        if (c == '-') {
            if (n2 == 1) {
                return "\\-";
            }
            n = string.codePointAt(1);
            if (n != 45 && !ParseHelper.isNameStartCharOrEsc((char)n)) {
                stringBuilder = ParseHelper.createStringBuilder(n2);
                n3 = string.offsetByCodePoints(1, 1);
                if (bl2 && n3 > 2 || Character.isISOControl(n)) {
                    stringBuilder.append('-').append('\\').append(Integer.toHexString(n));
                    if (n < 1048575 && ParseHelper.needsSpace(string, n3, n2)) {
                        stringBuilder.append(' ');
                    }
                } else {
                    stringBuilder.append("\\-").appendCodePoint(n);
                }
                if (n3 == n2) {
                    return stringBuilder.toString();
                }
                bl3 = false;
            } else {
                n3 = 1;
            }
            c = string.charAt(n3);
        }
        if (c >= '0' && c <= '9') {
            if (bl3) {
                stringBuilder = ParseHelper.createStringBuilder(n2);
                bl3 = false;
                if (n3 == 1) {
                    stringBuilder.append("\\-").append(c);
                } else {
                    stringBuilder.append("\\3").append(c).append(' ');
                }
            } else {
                stringBuilder.append(c);
            }
            ++n3;
        }
        n = 0;
        while (n3 < n2) {
            block44: {
                int n4;
                block45: {
                    block46: {
                        block43: {
                            n4 = string.codePointAt(n3);
                            if (!(n4 >= 48 && n4 <= 57 || n4 >= 65 && n4 <= 90 || n4 >= 97 && n4 <= 122 || n4 == 45) && n4 != 95) break block43;
                            if (n != 0 && !ParseHelper.isHexCodePoint(n4)) {
                                n = 0;
                            }
                            if (!bl3) {
                                stringBuilder.append((char)n4);
                            }
                            break block44;
                        }
                        if (n4 <= 122) break block45;
                        n = 0;
                        if (n4 >= 127) break block46;
                        if (bl3) {
                            bl3 = false;
                            stringBuilder = new StringBuilder(n2 + 1);
                            stringBuilder.append(string.subSequence(0, n3));
                        }
                        stringBuilder.append('\\').append((char)n4);
                        break block44;
                    }
                    if (n4 <= 159 || n4 == 160 || n4 == 173 || n4 == 65533) {
                        if (bl3) {
                            bl3 = false;
                            stringBuilder = ParseHelper.createStringBuilder(n2);
                            stringBuilder.append(string.subSequence(0, n3));
                        }
                        stringBuilder.append('\\').append(Integer.toHexString(n4));
                        if (ParseHelper.needsSpace(string, n3 + 1, n2)) {
                            stringBuilder.append(' ');
                        }
                        break block44;
                    } else {
                        int n5 = string.offsetByCodePoints(n3, 1);
                        if (n5 == n3 + 1) {
                            if (!bl3) {
                                stringBuilder.append((char)n4);
                            }
                        } else if (!bl2) {
                            if (!bl3) {
                                stringBuilder.appendCodePoint(n4);
                            }
                        } else {
                            if (bl3) {
                                bl3 = false;
                                stringBuilder = ParseHelper.createStringBuilder(n2);
                                stringBuilder.append(string.subSequence(0, n3));
                            }
                            stringBuilder.append('\\').append(Integer.toHexString(n4));
                            if (n4 < 1048575 && ParseHelper.needsSpace(string, n5, n2)) {
                                stringBuilder.append(' ');
                            }
                        }
                        n3 = n5;
                        continue;
                    }
                }
                if (n4 <= 31 || n4 == 32) {
                    if (bl3) {
                        bl3 = false;
                        stringBuilder = ParseHelper.createStringBuilder(n2);
                        stringBuilder.append(string.subSequence(0, n3));
                    }
                    if (n4 == 32) {
                        if (n == 0) {
                            stringBuilder.append('\\');
                        }
                        stringBuilder.append(' ');
                    } else {
                        stringBuilder.append('\\').append(Integer.toHexString(n4));
                        if (ParseHelper.needsSpace(string, n3 + 1, n2)) {
                            stringBuilder.append(' ');
                        }
                    }
                    n = 0;
                } else if (bl && n4 == 92 && n3 != n2 - 1 && ParseHelper.isHexCodePoint(string.codePointAt(n3 + 1))) {
                    n = 1;
                    if (!bl3) {
                        stringBuilder.append('\\');
                    }
                } else {
                    n = 0;
                    if (bl3) {
                        bl3 = false;
                        stringBuilder = new StringBuilder(n2 + 1);
                        stringBuilder.append(string.subSequence(0, n3));
                    }
                    stringBuilder.append('\\').append((char)n4);
                }
            }
            ++n3;
        }
        if (bl3) {
            return string;
        }
        return stringBuilder.toString();
    }

    private static StringBuilder createStringBuilder(int n) {
        return new StringBuilder(n + 24);
    }

    private static boolean needsSpace(CharSequence charSequence, int n, int n2) {
        char c;
        return n >= n2 || (c = charSequence.charAt(n)) == ' ' || ParseHelper.isASCIILetterOrDigitCodePoint(c);
    }

    public static String safeEscape(String string) {
        return ParseHelper.safeEscape(string, false);
    }

    public static String safeEscape(String string, boolean bl) {
        return ParseHelper.safeEscape(string, bl, false);
    }

    static String safeEscape(String string, boolean bl, boolean bl2) {
        int n;
        int n2 = string.length();
        if (n2 == 0) {
            return string;
        }
        int n3 = 0;
        StringBuilder stringBuilder = null;
        boolean bl3 = true;
        char c = string.charAt(0);
        if (c == '-') {
            if (n2 == 1) {
                return "\\-";
            }
            n = string.codePointAt(1);
            if (n != 45 && !ParseHelper.isNameStartCharOrEsc((char)n)) {
                n3 = string.offsetByCodePoints(1, 1);
                stringBuilder = ParseHelper.createStringBuilder(n2);
                if (bl2 && n >= 128 || Character.isISOControl(n) || bl && n3 > 2) {
                    stringBuilder.append('-').append('\\').append(Integer.toHexString(n));
                    if (n < 1048575 && ParseHelper.needsSpace(string, n3, n2)) {
                        stringBuilder.append(' ');
                    }
                } else {
                    stringBuilder.append("\\-").appendCodePoint(n);
                }
                if (n3 == n2) {
                    return stringBuilder.toString();
                }
                bl3 = false;
            } else {
                n3 = 1;
            }
            c = string.charAt(n3);
        }
        if (c >= '0' && c <= '9') {
            if (bl3) {
                stringBuilder = ParseHelper.createStringBuilder(n2);
                bl3 = false;
                if (n3 == 1) {
                    stringBuilder.append("\\-").append(c);
                } else {
                    stringBuilder.append("\\3").append(c).append(' ');
                }
            } else {
                stringBuilder.append(c);
            }
            ++n3;
        }
        while (n3 < n2) {
            n = string.codePointAt(n3);
            if (n >= 48 && n <= 57 || n >= 65 && n <= 90 || n >= 97 && n <= 122 || n == 45 || n == 95) {
                if (!bl3) {
                    stringBuilder.append((char)n);
                }
            } else {
                if (n >= 127) {
                    int n4 = string.offsetByCodePoints(n3, 1);
                    if (n >= 127 && n <= 159 || n == 160 || n == 173 || n == 65533 || bl2) {
                        if (bl3) {
                            bl3 = false;
                            stringBuilder = new StringBuilder(n2 + 24);
                            stringBuilder.append(string.subSequence(0, n3));
                        }
                        stringBuilder.append('\\').append(Integer.toHexString(n));
                        if (n < 1048575 && ParseHelper.needsSpace(string, n4, n2)) {
                            stringBuilder.append(' ');
                        }
                        n3 = n4;
                        continue;
                    }
                    if (n4 == ++n3) {
                        if (bl3) continue;
                        stringBuilder.append((char)n);
                        continue;
                    }
                    if (!bl) {
                        if (!bl3) {
                            stringBuilder.appendCodePoint(n);
                        }
                    } else {
                        if (bl3) {
                            bl3 = false;
                            stringBuilder = new StringBuilder(n2 + 24);
                            stringBuilder.append(string.subSequence(0, n3 - 1));
                        }
                        stringBuilder.append('\\').append(Integer.toHexString(n));
                        if (n < 1048575 && ParseHelper.needsSpace(string, n4, n2)) {
                            stringBuilder.append(' ');
                        }
                    }
                    n3 = n4;
                    continue;
                }
                if (n <= 31 || n == 32) {
                    if (bl3) {
                        bl3 = false;
                        stringBuilder = new StringBuilder(n2 + 24);
                        stringBuilder.append(string.subSequence(0, n3));
                    }
                    if (n != 32) {
                        stringBuilder.append('\\').append(Integer.toHexString(n)).append(' ');
                    } else {
                        stringBuilder.append('\\').append(' ');
                    }
                } else if (n == 92 && n3 != n2 - 1 && ParseHelper.isPrivateOrUnassignedEscape(string, n3 + 1)) {
                    if (!bl3) {
                        stringBuilder.append('\\');
                    }
                } else {
                    if (bl3) {
                        bl3 = false;
                        stringBuilder = new StringBuilder(n2 + 24);
                        stringBuilder.append(string.subSequence(0, n3));
                    }
                    stringBuilder.append('\\').append((char)n);
                }
            }
            ++n3;
        }
        if (bl3) {
            return string;
        }
        return stringBuilder.toString();
    }

    private static boolean isPrivateOrUnassignedEscape(String string, int n) {
        int n2;
        char c = string.charAt(n);
        if (!ParseHelper.isHexCodePoint(c)) {
            return false;
        }
        int n3 = string.length();
        n3 = Math.min(n3, n + 6);
        for (n2 = n + 1; n2 < n3; ++n2) {
            c = string.charAt(n2);
            if (ParseHelper.isHexCodePoint(c)) continue;
            if (c == ' ') {
                int n4 = Integer.parseInt(string.substring(n, n2), 16);
                return ParseHelper.isPrivateOrUnassignedCodePoint(n4);
            }
            return false;
        }
        n2 = Integer.parseInt(string.substring(n, n3), 16);
        return ParseHelper.isPrivateOrUnassignedCodePoint(n2);
    }

    private static boolean isPrivateOrUnassignedCodePoint(int n) {
        int n2 = Character.getType(n);
        return n2 == 0 || n2 == 18;
    }

    public static String escapeString(String string, char c) {
        return ParseHelper.escapeString(string, c, false);
    }

    public static String escapeString(String string, char c, boolean bl) {
        int n = string.length();
        if (n == 0) {
            return string;
        }
        int n2 = 0;
        StringBuilder stringBuilder = null;
        boolean bl2 = true;
        while (n2 < n) {
            int n3 = string.codePointAt(n2);
            int n4 = Character.getType(n3);
            if (n4 == 15 || n4 == 16 || n3 >= 10240 && (n4 == 24 || n4 == 28)) {
                if (bl2) {
                    bl2 = false;
                    stringBuilder = new StringBuilder(n + 16);
                    stringBuilder.append(string.subSequence(0, n2));
                }
                stringBuilder.append('\\').append(Integer.toHexString(n3));
                n2 = string.offsetByCodePoints(n2, 1);
                if (bl && n2 == n) continue;
                stringBuilder.append(' ');
                continue;
            }
            if (n3 == 92) {
                if (n2 != n - 1 && ParseHelper.isPrivateOrUnassignedEscape(string, n2 + 1)) {
                    if (!bl2) {
                        stringBuilder.append('\\');
                    }
                } else {
                    if (bl2) {
                        bl2 = false;
                        stringBuilder = new StringBuilder(n + 16);
                        stringBuilder.append(string.subSequence(0, n2));
                    }
                    stringBuilder.append("\\\\");
                }
            } else if (n3 == c) {
                if (bl2) {
                    bl2 = false;
                    stringBuilder = new StringBuilder(n + 16);
                    stringBuilder.append(string.subSequence(0, n2));
                }
                stringBuilder.append('\\').append(c);
            } else {
                int n5 = string.offsetByCodePoints(n2, 1);
                if (n5 == ++n2) {
                    if (bl2) continue;
                    stringBuilder.append((char)n3);
                    continue;
                }
                if (!bl2) {
                    stringBuilder.appendCodePoint(n3);
                }
                n2 = n5;
                continue;
            }
            ++n2;
        }
        if (bl2) {
            return string;
        }
        return stringBuilder.toString();
    }

    public static String quote(String string, char c) {
        boolean bl;
        int n = string.length();
        boolean bl2 = true;
        boolean bl3 = string.indexOf(34) != -1;
        boolean bl4 = bl = string.indexOf(39) != -1;
        if (bl) {
            if (bl3) {
                int n2;
                int n3 = 0;
                int n4 = 0;
                for (int i = 0; i < n; ++i) {
                    n2 = string.charAt(i);
                    if (n2 == 39) {
                        ++n3;
                        continue;
                    }
                    if (n2 != 34) continue;
                    ++n4;
                }
                if (n3 > n4) {
                    c = (char)34;
                } else {
                    c = (char)39;
                    bl2 = false;
                }
                StringBuilder stringBuilder = new StringBuilder(n + 8);
                for (n2 = 0; n2 < n; ++n2) {
                    char c2 = string.charAt(n2);
                    if (c2 == c) {
                        stringBuilder.append('\\');
                    }
                    stringBuilder.append(c2);
                }
                string = stringBuilder.toString();
            }
        } else if (bl3) {
            bl2 = false;
        }
        StringBuilder stringBuilder = new StringBuilder(n + 2);
        if (bl || bl3) {
            if (bl2) {
                stringBuilder.append('\"');
                ParseHelper.appendAndEscape(stringBuilder, string, n);
                stringBuilder.append('\"');
            } else {
                stringBuilder.append('\'');
                ParseHelper.appendAndEscape(stringBuilder, string, n);
                stringBuilder.append('\'');
            }
        } else {
            stringBuilder.append(c);
            ParseHelper.appendAndEscape(stringBuilder, string, n);
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    private static void appendAndEscape(StringBuilder stringBuilder, String string, int n) {
        boolean bl = false;
        if (n != 0 && string.charAt(n - 1) == '\\') {
            int n2 = 1;
            for (int i = n - 2; i >= 0 && string.charAt(i) == '\\'; --i) {
                ++n2;
            }
            bl = !(n2 & true);
        }
        stringBuilder.append(string);
        if (bl) {
            stringBuilder.append('\\');
        }
    }

    public static CharSequence escapeCssChars(CharSequence charSequence) {
        int n = charSequence.length();
        if (n == 0) {
            return charSequence;
        }
        return ParseHelper.escapeCssChars(charSequence, 0, null);
    }

    public static CharSequence escapeCssCharsAndFirstChar(CharSequence charSequence) {
        StringBuilder stringBuilder;
        boolean bl;
        int n = charSequence.length();
        if (n == 0) {
            return charSequence;
        }
        int n2 = 0;
        char c = charSequence.charAt(0);
        boolean bl2 = bl = c < '0' || c > '9';
        if (bl) {
            stringBuilder = null;
        } else {
            stringBuilder = new StringBuilder(n + 24);
            if (n2 == 1) {
                stringBuilder.append(charSequence.charAt(0));
            }
            stringBuilder.append("\\3").append(c).append(' ');
            ++n2;
        }
        return ParseHelper.escapeCssChars(charSequence, n2, stringBuilder);
    }

    /*
     * WARNING - void declaration
     */
    private static CharSequence escapeCssChars(CharSequence charSequence, int n, StringBuilder stringBuilder) {
        void var5_8;
        char c;
        boolean bl;
        int n2 = charSequence.length();
        boolean bl2 = bl = stringBuilder == null;
        if (n == 0 && (c = charSequence.charAt(0)) == '-') {
            if (n2 == 1) {
                return "-";
            }
            char c2 = charSequence.charAt(1);
            if (c2 >= '0' && c2 <= '9') {
                if (bl) {
                    bl = false;
                    stringBuilder = new StringBuilder(n2 + 20);
                }
                stringBuilder.append("\\-").append(c2);
                n = 2;
            } else {
                n = 1;
            }
        }
        int n3 = n;
        while (var5_8 < n2) {
            char c3 = charSequence.charAt((int)var5_8);
            if (c3 >= '!' && c3 <= ')' || c3 == '*' || c3 == '+' || c3 == ',' || c3 == '.' || c3 == '/' || c3 >= ':' && c3 <= '?' || c3 == '@' || c3 == '[' || c3 == ']' || c3 == '^' || c3 == '`' || c3 >= '{' && c3 <= '~') {
                if (bl) {
                    bl = false;
                    stringBuilder = new StringBuilder(n2 + 20);
                    stringBuilder.append(charSequence.subSequence(0, (int)var5_8));
                }
                stringBuilder.append('\\').append(c3);
            } else if (!bl) {
                stringBuilder.append(c3);
            }
            ++var5_8;
        }
        if (bl) {
            return charSequence;
        }
        return stringBuilder;
    }

    public static CharSequence escapeAllBackslash(CharSequence charSequence) {
        boolean bl = true;
        int n = charSequence.length() - 1;
        StringBuilder stringBuilder = null;
        for (int i = 0; i <= n; ++i) {
            char c = charSequence.charAt(i);
            if (c == '\\') {
                if (bl) {
                    bl = false;
                    stringBuilder = new StringBuilder(n + 6);
                    stringBuilder.append(charSequence.subSequence(0, i));
                }
                stringBuilder.append('\\').append('\\');
                continue;
            }
            if (bl) continue;
            stringBuilder.append(c);
        }
        if (bl) {
            return charSequence;
        }
        return stringBuilder;
    }

    public static CharSequence escapeBackslash(CharSequence charSequence) {
        boolean bl = true;
        int n = charSequence.length() - 1;
        StringBuilder stringBuilder = null;
        for (int i = 0; i <= n; ++i) {
            char c = charSequence.charAt(i);
            if (c == '\\') {
                if (bl) {
                    bl = false;
                    stringBuilder = ParseHelper.createBuffer(i, charSequence, n + 12);
                }
                stringBuilder.append('\\');
                if (i < n) {
                    c = charSequence.charAt(i + 1);
                    if (ParseHelper.isHexCodePoint(c)) continue;
                    if (c == '\\') {
                        ++i;
                    }
                }
                stringBuilder.append('\\');
                continue;
            }
            if (bl) continue;
            stringBuilder.append(c);
        }
        if (bl) {
            return charSequence;
        }
        return stringBuilder;
    }

    private static StringBuilder createBuffer(int n, CharSequence charSequence, int n2) {
        StringBuilder stringBuilder = new StringBuilder(n2);
        stringBuilder.append(charSequence.subSequence(0, n));
        return stringBuilder;
    }

    public static String escapeControl(CharSequence charSequence) {
        boolean bl = true;
        int n = charSequence.length();
        StringBuilder stringBuilder = null;
        for (int i = 0; i < n; ++i) {
            char c = charSequence.charAt(i);
            if (Character.isISOControl(c)) {
                if (bl) {
                    bl = false;
                    stringBuilder = new StringBuilder(n + 20);
                    stringBuilder.append(charSequence.subSequence(0, i));
                }
                stringBuilder.append('\\').append(Integer.toHexString(c)).append(' ');
                continue;
            }
            if (bl) continue;
            stringBuilder.append(c);
        }
        if (bl) {
            return charSequence.toString();
        }
        return stringBuilder.toString();
    }

    public static String parseIdent(String string) throws DOMException {
        int n = (string = string.trim()).length();
        if (n == 0) {
            throw new DOMException(2, "Empty string is no identifier");
        }
        char c = string.charAt(0);
        if (!ParseHelper.isNameStartCharOrEsc(c) && c != '-') {
            throw new DOMCharacterException("Identifier cannot start with U+" + Integer.toHexString(c), 0);
        }
        if (c == '-' && (n == 1 || ParseHelper.isDigitCodepoint(string.charAt(1)))) {
            throw new DOMException(12, "Bad identifier");
        }
        int n2 = 32;
        for (int i = 1; i < n; ++i) {
            c = string.charAt(i);
            if (!(ParseHelper.isNameCharOrEsc(c) || c == ' ' && ParseHelper.isHexCodePoint(n2))) {
                String string2 = Character.isLetterOrDigit(c) ? "Identifier cannot contain '" + c + "'" : "Identifier cannot contain U+" + Integer.toHexString(c);
                throw new DOMCharacterException(string2, i);
            }
            n2 = c;
        }
        return ParseHelper.unescapeStringValue(string);
    }

    private static boolean isNameStartCharOrEsc(char c) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '\u0080' || c == '\\' || c == '_';
    }

    private static boolean isNameCharOrEsc(char c) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c >= '\u0080' || c == '_' || c == '-' || c == '\\';
    }

    private static boolean isDigitCodepoint(char c) {
        return c >= '0' && c <= '9';
    }

    private static boolean isASCIILetterOrDigitCodePoint(char c) {
        return c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z';
    }

    static boolean isHexCodePoint(int n) {
        return n >= 48 && n <= 57 || n >= 65 && n <= 70 || n >= 97 && n <= 102;
    }

    static boolean isValidXMLCharacter(int n) {
        return n == 45 || n == 46 || n == 183 || ParseHelper.isValidXMLStartCharacter(n);
    }

    static boolean isValidXMLStartCharacter(int n) {
        return n == 95 || n >= 192 && n <= 214 || n >= 216 && n <= 246 || n >= 248 && n <= 767 || n >= 880 && n <= 893 || n >= 895 && n <= 8191 || n >= 8204 && n <= 8205 || n >= 8304 && n <= 8591 || n >= 11264 && n <= 12271 || n >= 12289 && n <= 57343 || n >= 63744 && n <= 64975 || n >= 65008 && n <= 65533 || n >= 65536 && n <= 983039;
    }

    public static boolean equalSelectorList(SelectorList selectorList, SelectorList selectorList2) {
        int n;
        if (selectorList == null) {
            return selectorList2 == null;
        }
        if (selectorList2 != null && (n = selectorList.getLength()) == selectorList2.getLength()) {
            for (int i = 0; i < n; ++i) {
                if (selectorList.item(i).equals(selectorList2.item(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean startsWithIgnoreCase(CharSequence charSequence, String string) {
        int n = charSequence.length();
        int n2 = string.length();
        if (n2 > n) {
            return false;
        }
        for (int i = 0; i < n2; ++i) {
            char c;
            char c2 = charSequence.charAt(i);
            if (c2 == (c = string.charAt(i)) || !Character.isLowerCase(c2) && Character.toLowerCase(c2) == c) continue;
            return false;
        }
        return true;
    }

    public static boolean equalsIgnoreCase(CharSequence charSequence, CharSequence charSequence2) {
        int n = charSequence.length();
        if (charSequence2.length() != n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            char c;
            char c2 = charSequence.charAt(i);
            if (c2 == (c = charSequence2.charAt(i)) || !Character.isLowerCase(c2) && Character.toLowerCase(c2) == c) continue;
            return false;
        }
        return true;
    }

    public static PseudoCondition createPseudoElementCondition(String string) {
        if (string == null) {
            throw new NullPointerException("Null pseudo-element");
        }
        PseudoConditionImpl pseudoConditionImpl = new PseudoConditionImpl(Condition.ConditionType.PSEUDO_ELEMENT);
        pseudoConditionImpl.name = string;
        return pseudoConditionImpl;
    }

    public static LexicalUnit createRealLexicalUnit(float f) {
        LexicalUnitImpl lexicalUnitImpl = new LexicalUnitImpl(LexicalUnit.LexicalType.REAL);
        lexicalUnitImpl.floatValue = f;
        lexicalUnitImpl.setCssUnit((short)0);
        return lexicalUnitImpl;
    }

    public static LexicalUnit createDimensionLexicalUnit(short s, float f) {
        LexicalUnitImpl lexicalUnitImpl = new LexicalUnitImpl(LexicalUnit.LexicalType.DIMENSION);
        lexicalUnitImpl.floatValue = f;
        lexicalUnitImpl.setCssUnit(s);
        lexicalUnitImpl.dimensionUnitText = CSSUnit.dimensionUnitString(s);
        return lexicalUnitImpl;
    }

    public static boolean isTransformFunction(String string) {
        return string.equals("matrix") || string.equals("translate") || string.equals("translateX") || string.equals("translateY") || string.equals("scale") || string.equals("scaleX") || string.equals("scaleY") || string.equals("rotate") || string.equals("skew") || string.equals("skewX") || string.equals("skewY");
    }
}

