/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.bridge.svg12;

import io.sf.carte.echosvg.anim.dom.BindableElement;
import io.sf.carte.echosvg.anim.dom.XBLEventSupport;
import io.sf.carte.echosvg.anim.dom.XBLOMContentElement;
import io.sf.carte.echosvg.anim.dom.XBLOMDefinitionElement;
import io.sf.carte.echosvg.anim.dom.XBLOMImportElement;
import io.sf.carte.echosvg.anim.dom.XBLOMShadowTreeElement;
import io.sf.carte.echosvg.anim.dom.XBLOMTemplateElement;
import io.sf.carte.echosvg.bridge.BridgeContext;
import io.sf.carte.echosvg.bridge.BridgeException;
import io.sf.carte.echosvg.bridge.svg12.BindingListener;
import io.sf.carte.echosvg.bridge.svg12.ContentManager;
import io.sf.carte.echosvg.bridge.svg12.ContentSelectionChangedListener;
import io.sf.carte.echosvg.dom.AbstractAttrNS;
import io.sf.carte.echosvg.dom.AbstractDocument;
import io.sf.carte.echosvg.dom.AbstractNode;
import io.sf.carte.echosvg.dom.events.EventSupport;
import io.sf.carte.echosvg.dom.events.NodeEventTarget;
import io.sf.carte.echosvg.dom.xbl.NodeXBL;
import io.sf.carte.echosvg.dom.xbl.ShadowTreeEvent;
import io.sf.carte.echosvg.dom.xbl.XBLManager;
import io.sf.carte.echosvg.dom.xbl.XBLManagerData;
import io.sf.carte.echosvg.dom.xbl.XBLShadowTreeElement;
import io.sf.carte.echosvg.util.DoublyIndexedTable;
import io.sf.carte.echosvg.util.XBLConstants;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.event.EventListenerList;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.DocumentEvent;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.events.MutationEvent;

public class DefaultXBLManager
implements XBLManager,
XBLConstants {
    protected boolean isProcessing;
    protected Document document;
    protected BridgeContext ctx;
    protected DoublyIndexedTable<String, String> definitionLists = new DoublyIndexedTable();
    protected DoublyIndexedTable<Node, Element> definitions = new DoublyIndexedTable();
    protected Map<Element, ContentManager> contentManagers = new HashMap<Element, ContentManager>();
    protected Map<Element, ImportRecord> imports = new HashMap<Element, ImportRecord>();
    protected DocInsertedListener docInsertedListener = new DocInsertedListener();
    protected DocRemovedListener docRemovedListener = new DocRemovedListener();
    protected DocSubtreeListener docSubtreeListener = new DocSubtreeListener();
    protected ImportAttrListener importAttrListener = new ImportAttrListener();
    protected RefAttrListener refAttrListener = new RefAttrListener();
    protected EventListenerList bindingListenerList = new EventListenerList();
    protected EventListenerList contentSelectionChangedListenerList = new EventListenerList();

    public DefaultXBLManager(Document document, BridgeContext bridgeContext) {
        this.document = document;
        this.ctx = bridgeContext;
        ImportRecord importRecord = new ImportRecord(null, null);
        this.imports.put(null, importRecord);
    }

    public void startProcessing() {
        if (this.isProcessing) {
            return;
        }
        NodeList nodeList = this.document.getElementsByTagNameNS("http://www.w3.org/2004/xbl", "definition");
        XBLOMDefinitionElement[] xBLOMDefinitionElementArray = new XBLOMDefinitionElement[nodeList.getLength()];
        for (int i = 0; i < xBLOMDefinitionElementArray.length; ++i) {
            xBLOMDefinitionElementArray[i] = (XBLOMDefinitionElement)nodeList.item(i);
        }
        nodeList = this.document.getElementsByTagNameNS("http://www.w3.org/2004/xbl", "import");
        Element[] elementArray = new Element[nodeList.getLength()];
        for (int i = 0; i < elementArray.length; ++i) {
            elementArray[i] = (Element)nodeList.item(i);
        }
        AbstractDocument abstractDocument = (AbstractDocument)this.document;
        XBLEventSupport xBLEventSupport = (XBLEventSupport)abstractDocument.initializeEventSupport();
        xBLEventSupport.addImplementationEventListenerNS("http://www.w3.org/2001/xml-events", "DOMNodeRemoved", (EventListener)this.docRemovedListener, true);
        xBLEventSupport.addImplementationEventListenerNS("http://www.w3.org/2001/xml-events", "DOMNodeInserted", (EventListener)this.docInsertedListener, true);
        xBLEventSupport.addImplementationEventListenerNS("http://www.w3.org/2001/xml-events", "DOMSubtreeModified", (EventListener)this.docSubtreeListener, true);
        for (XBLOMDefinitionElement xBLOMDefinitionElement : xBLOMDefinitionElementArray) {
            if (xBLOMDefinitionElement.getAttributeNS(null, "ref").length() != 0) {
                this.addDefinitionRef((Element)xBLOMDefinitionElement);
                continue;
            }
            String string = xBLOMDefinitionElement.getElementNamespaceURI();
            String string2 = xBLOMDefinitionElement.getElementLocalName();
            this.addDefinition(string, string2, xBLOMDefinitionElement, null);
        }
        for (Element element : elementArray) {
            this.addImport(element);
        }
        this.isProcessing = true;
        this.bind(this.document.getDocumentElement());
    }

    public void stopProcessing() {
        if (!this.isProcessing) {
            return;
        }
        this.isProcessing = false;
        AbstractDocument abstractDocument = (AbstractDocument)this.document;
        XBLEventSupport xBLEventSupport = (XBLEventSupport)abstractDocument.initializeEventSupport();
        xBLEventSupport.removeImplementationEventListenerNS("http://www.w3.org/2001/xml-events", "DOMNodeRemoved", (EventListener)this.docRemovedListener, true);
        xBLEventSupport.removeImplementationEventListenerNS("http://www.w3.org/2001/xml-events", "DOMNodeInserted", (EventListener)this.docInsertedListener, true);
        xBLEventSupport.removeImplementationEventListenerNS("http://www.w3.org/2001/xml-events", "DOMSubtreeModified", (EventListener)this.docSubtreeListener, true);
        int n = this.imports.size();
        ImportRecord[] importRecordArray = new ImportRecord[n];
        this.imports.values().toArray(importRecordArray);
        for (ImportRecord importRecord : importRecordArray) {
            Object object = importRecord.importElement;
            if (object == null) continue;
            if ("definition".equals(object.getLocalName())) {
                this.removeDefinitionRef((Element)object);
                continue;
            }
            this.removeImport((Element)object);
        }
        Object[] objectArray = this.definitions.getValuesArray();
        this.definitions.clear();
        for (Object object : objectArray) {
            DefinitionRecord definitionRecord = (DefinitionRecord)object;
            TreeSet treeSet = (TreeSet)this.definitionLists.get((Object)definitionRecord.namespaceURI, (Object)definitionRecord.localName);
            if (treeSet == null) continue;
            while (!treeSet.isEmpty()) {
                definitionRecord = (DefinitionRecord)treeSet.first();
                treeSet.remove(definitionRecord);
                this.removeDefinition(definitionRecord);
            }
            this.definitionLists.put((Object)definitionRecord.namespaceURI, (Object)definitionRecord.localName, null);
        }
        this.definitionLists = new DoublyIndexedTable();
        this.contentManagers.clear();
    }

    public boolean isProcessing() {
        return this.isProcessing;
    }

    protected void addDefinitionRef(Element element) {
        String string = element.getAttributeNS(null, "ref");
        Element element2 = this.ctx.getReferencedElement(element, string);
        if (element2 == null) {
            return;
        }
        if (!"http://www.w3.org/2004/xbl".equals(element2.getNamespaceURI()) || !"definition".equals(element2.getLocalName())) {
            throw new BridgeException(this.ctx, element, "uri.badTarget", new Object[]{string});
        }
        ImportRecord importRecord = new ImportRecord(element, element2);
        this.imports.put(element, importRecord);
        NodeEventTarget nodeEventTarget = (NodeEventTarget)element;
        nodeEventTarget.addEventListenerNS("http://www.w3.org/2001/xml-events", "DOMAttrModified", (EventListener)this.refAttrListener, false, null);
        XBLOMDefinitionElement xBLOMDefinitionElement = (XBLOMDefinitionElement)element;
        String string2 = xBLOMDefinitionElement.getElementNamespaceURI();
        String string3 = xBLOMDefinitionElement.getElementLocalName();
        this.addDefinition(string2, string3, (XBLOMDefinitionElement)element2, element);
    }

    protected void removeDefinitionRef(Element element) {
        ImportRecord importRecord = this.imports.get(element);
        NodeEventTarget nodeEventTarget = (NodeEventTarget)element;
        nodeEventTarget.removeEventListenerNS("http://www.w3.org/2001/xml-events", "DOMAttrModified", (EventListener)this.refAttrListener, false);
        DefinitionRecord definitionRecord = (DefinitionRecord)this.definitions.get((Object)importRecord.node, (Object)element);
        this.removeDefinition(definitionRecord);
        this.imports.remove(element);
    }

    protected void addImport(Element element) {
        String string = element.getAttributeNS(null, "bindings");
        Node node = this.ctx.getReferencedNode(element, string);
        if (node == null) {
            return;
        }
        if (!(node.getNodeType() != 1 || "http://www.w3.org/2004/xbl".equals(node.getNamespaceURI()) && "xbl".equals(node.getLocalName()))) {
            throw new BridgeException(this.ctx, element, "uri.badTarget", new Object[]{node});
        }
        ImportRecord importRecord = new ImportRecord(element, node);
        this.imports.put(element, importRecord);
        NodeEventTarget nodeEventTarget = (NodeEventTarget)element;
        nodeEventTarget.addEventListenerNS("http://www.w3.org/2001/xml-events", "DOMAttrModified", (EventListener)this.importAttrListener, false, null);
        nodeEventTarget = (NodeEventTarget)node;
        nodeEventTarget.addEventListenerNS("http://www.w3.org/2001/xml-events", "DOMNodeInserted", (EventListener)importRecord.importInsertedListener, false, null);
        nodeEventTarget.addEventListenerNS("http://www.w3.org/2001/xml-events", "DOMNodeRemoved", (EventListener)importRecord.importRemovedListener, false, null);
        nodeEventTarget.addEventListenerNS("http://www.w3.org/2001/xml-events", "DOMSubtreeModified", (EventListener)importRecord.importSubtreeListener, false, null);
        this.addImportedDefinitions(element, node);
    }

    protected void addImportedDefinitions(Element element, Node node) {
        if (node instanceof XBLOMDefinitionElement) {
            XBLOMDefinitionElement xBLOMDefinitionElement = (XBLOMDefinitionElement)node;
            String string = xBLOMDefinitionElement.getElementNamespaceURI();
            String string2 = xBLOMDefinitionElement.getElementLocalName();
            this.addDefinition(string, string2, xBLOMDefinitionElement, element);
        } else {
            for (node = node.getFirstChild(); node != null; node = node.getNextSibling()) {
                this.addImportedDefinitions(element, node);
            }
        }
    }

    protected void removeImport(Element element) {
        Object[] objectArray;
        ImportRecord importRecord = this.imports.get(element);
        NodeEventTarget nodeEventTarget = (NodeEventTarget)importRecord.node;
        nodeEventTarget.removeEventListenerNS("http://www.w3.org/2001/xml-events", "DOMNodeInserted", (EventListener)importRecord.importInsertedListener, false);
        nodeEventTarget.removeEventListenerNS("http://www.w3.org/2001/xml-events", "DOMNodeRemoved", (EventListener)importRecord.importRemovedListener, false);
        nodeEventTarget.removeEventListenerNS("http://www.w3.org/2001/xml-events", "DOMSubtreeModified", (EventListener)importRecord.importSubtreeListener, false);
        nodeEventTarget = (NodeEventTarget)element;
        nodeEventTarget.removeEventListenerNS("http://www.w3.org/2001/xml-events", "DOMAttrModified", (EventListener)this.importAttrListener, false);
        for (Object object : objectArray = this.definitions.getValuesArray()) {
            DefinitionRecord definitionRecord = (DefinitionRecord)object;
            if (definitionRecord.importElement != element) continue;
            this.removeDefinition(definitionRecord);
        }
        this.imports.remove(element);
    }

    protected void addDefinition(String string, String string2, XBLOMDefinitionElement xBLOMDefinitionElement, Element element) {
        Node node;
        ImportRecord importRecord = this.imports.get(element);
        DefinitionRecord definitionRecord = null;
        TreeSet<DefinitionRecord> treeSet = (TreeSet<DefinitionRecord>)this.definitionLists.get((Object)string, (Object)string2);
        if (treeSet == null) {
            treeSet = new TreeSet<DefinitionRecord>();
            this.definitionLists.put((Object)string, (Object)string2, treeSet);
        } else if (treeSet.size() > 0) {
            definitionRecord = (DefinitionRecord)treeSet.first();
        }
        XBLOMTemplateElement xBLOMTemplateElement = null;
        for (node = xBLOMDefinitionElement.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof XBLOMTemplateElement)) continue;
            xBLOMTemplateElement = (XBLOMTemplateElement)node;
            break;
        }
        DefinitionRecord definitionRecord2 = new DefinitionRecord(string, string2, xBLOMDefinitionElement, xBLOMTemplateElement, element);
        treeSet.add(definitionRecord2);
        this.definitions.put((Object)xBLOMDefinitionElement, (Object)element, (Object)definitionRecord2);
        this.addDefinitionElementListeners(xBLOMDefinitionElement, importRecord);
        if (treeSet.first() != definitionRecord2) {
            return;
        }
        if (definitionRecord != null) {
            node = definitionRecord.definition;
            XBLOMTemplateElement xBLOMTemplateElement2 = definitionRecord.template;
            if (xBLOMTemplateElement2 != null) {
                this.removeTemplateElementListeners(xBLOMTemplateElement2, importRecord);
            }
            this.removeDefinitionElementListeners((XBLOMDefinitionElement)node, importRecord);
        }
        if (xBLOMTemplateElement != null) {
            this.addTemplateElementListeners(xBLOMTemplateElement, importRecord);
        }
        if (this.isProcessing) {
            this.rebind(string, string2, this.document.getDocumentElement());
        }
    }

    protected void addDefinitionElementListeners(XBLOMDefinitionElement xBLOMDefinitionElement, ImportRecord importRecord) {
        XBLEventSupport xBLEventSupport = (XBLEventSupport)xBLOMDefinitionElement.initializeEventSupport();
        xBLEventSupport.addImplementationEventListenerNS("http://www.w3.org/2001/xml-events", "DOMAttrModified", (EventListener)importRecord.defAttrListener, false);
        xBLEventSupport.addImplementationEventListenerNS("http://www.w3.org/2001/xml-events", "DOMNodeInserted", (EventListener)importRecord.defNodeInsertedListener, false);
        xBLEventSupport.addImplementationEventListenerNS("http://www.w3.org/2001/xml-events", "DOMNodeRemoved", (EventListener)importRecord.defNodeRemovedListener, false);
    }

    protected void addTemplateElementListeners(XBLOMTemplateElement xBLOMTemplateElement, ImportRecord importRecord) {
        XBLEventSupport xBLEventSupport = (XBLEventSupport)xBLOMTemplateElement.initializeEventSupport();
        xBLEventSupport.addImplementationEventListenerNS("http://www.w3.org/2001/xml-events", "DOMAttrModified", (EventListener)importRecord.templateMutationListener, false);
        xBLEventSupport.addImplementationEventListenerNS("http://www.w3.org/2001/xml-events", "DOMNodeInserted", (EventListener)importRecord.templateMutationListener, false);
        xBLEventSupport.addImplementationEventListenerNS("http://www.w3.org/2001/xml-events", "DOMNodeRemoved", (EventListener)importRecord.templateMutationListener, false);
        xBLEventSupport.addImplementationEventListenerNS("http://www.w3.org/2001/xml-events", "DOMCharacterDataModified", (EventListener)importRecord.templateMutationListener, false);
    }

    protected void removeDefinition(DefinitionRecord definitionRecord) {
        TreeSet treeSet = (TreeSet)this.definitionLists.get((Object)definitionRecord.namespaceURI, (Object)definitionRecord.localName);
        if (treeSet == null) {
            return;
        }
        Element element = definitionRecord.importElement;
        ImportRecord importRecord = this.imports.get(element);
        DefinitionRecord definitionRecord2 = (DefinitionRecord)treeSet.first();
        treeSet.remove(definitionRecord);
        this.definitions.remove((Object)definitionRecord.definition, (Object)element);
        this.removeDefinitionElementListeners(definitionRecord.definition, importRecord);
        if (definitionRecord != definitionRecord2) {
            return;
        }
        if (definitionRecord.template != null) {
            this.removeTemplateElementListeners(definitionRecord.template, importRecord);
        }
        this.rebind(definitionRecord.namespaceURI, definitionRecord.localName, this.document.getDocumentElement());
    }

    protected void removeDefinitionElementListeners(XBLOMDefinitionElement xBLOMDefinitionElement, ImportRecord importRecord) {
        XBLEventSupport xBLEventSupport = (XBLEventSupport)xBLOMDefinitionElement.initializeEventSupport();
        xBLEventSupport.removeImplementationEventListenerNS("http://www.w3.org/2001/xml-events", "DOMAttrModified", (EventListener)importRecord.defAttrListener, false);
        xBLEventSupport.removeImplementationEventListenerNS("http://www.w3.org/2001/xml-events", "DOMNodeInserted", (EventListener)importRecord.defNodeInsertedListener, false);
        xBLEventSupport.removeImplementationEventListenerNS("http://www.w3.org/2001/xml-events", "DOMNodeRemoved", (EventListener)importRecord.defNodeRemovedListener, false);
    }

    protected void removeTemplateElementListeners(XBLOMTemplateElement xBLOMTemplateElement, ImportRecord importRecord) {
        XBLEventSupport xBLEventSupport = (XBLEventSupport)xBLOMTemplateElement.initializeEventSupport();
        xBLEventSupport.removeImplementationEventListenerNS("http://www.w3.org/2001/xml-events", "DOMAttrModified", (EventListener)importRecord.templateMutationListener, false);
        xBLEventSupport.removeImplementationEventListenerNS("http://www.w3.org/2001/xml-events", "DOMNodeInserted", (EventListener)importRecord.templateMutationListener, false);
        xBLEventSupport.removeImplementationEventListenerNS("http://www.w3.org/2001/xml-events", "DOMNodeRemoved", (EventListener)importRecord.templateMutationListener, false);
        xBLEventSupport.removeImplementationEventListenerNS("http://www.w3.org/2001/xml-events", "DOMCharacterDataModified", (EventListener)importRecord.templateMutationListener, false);
    }

    protected DefinitionRecord getActiveDefinition(String string, String string2) {
        TreeSet treeSet = (TreeSet)this.definitionLists.get((Object)string, (Object)string2);
        if (treeSet == null || treeSet.isEmpty()) {
            return null;
        }
        return (DefinitionRecord)treeSet.first();
    }

    protected void unbind(Element element) {
        if (element instanceof BindableElement) {
            this.setActiveDefinition((BindableElement)element, null);
        } else {
            NodeList nodeList = this.getXblScopedChildNodes(element);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1) continue;
                this.unbind((Element)node);
            }
        }
    }

    protected void bind(Element element) {
        Object object;
        AbstractDocument abstractDocument = (AbstractDocument)element.getOwnerDocument();
        if (abstractDocument != this.document && (object = abstractDocument.getXBLManager()) instanceof DefaultXBLManager) {
            ((DefaultXBLManager)object).bind(element);
            return;
        }
        if (element instanceof BindableElement) {
            object = this.getActiveDefinition(element.getNamespaceURI(), element.getLocalName());
            this.setActiveDefinition((BindableElement)element, (DefinitionRecord)object);
        } else {
            object = this.getXblScopedChildNodes(element);
            for (int i = 0; i < object.getLength(); ++i) {
                Node node = object.item(i);
                if (node.getNodeType() != 1) continue;
                this.bind((Element)node);
            }
        }
    }

    protected void rebind(String string, String string2, Element element) {
        Object object;
        AbstractDocument abstractDocument = (AbstractDocument)element.getOwnerDocument();
        if (abstractDocument != this.document && (object = abstractDocument.getXBLManager()) instanceof DefaultXBLManager) {
            ((DefaultXBLManager)object).rebind(string, string2, element);
            return;
        }
        if (element instanceof BindableElement && string.equals(element.getNamespaceURI()) && string2.equals(element.getLocalName())) {
            object = this.getActiveDefinition(element.getNamespaceURI(), element.getLocalName());
            this.setActiveDefinition((BindableElement)element, (DefinitionRecord)object);
        } else {
            object = this.getXblScopedChildNodes(element);
            for (int i = 0; i < object.getLength(); ++i) {
                Node node = object.item(i);
                if (node.getNodeType() != 1) continue;
                this.rebind(string, string2, (Element)node);
            }
        }
    }

    protected void setActiveDefinition(BindableElement bindableElement, DefinitionRecord definitionRecord) {
        XBLRecord xBLRecord = this.getRecord((Node)bindableElement);
        XBLOMDefinitionElement xBLOMDefinitionElement = xBLRecord.definitionElement = definitionRecord == null ? null : definitionRecord.definition;
        if (definitionRecord != null && definitionRecord.definition != null && definitionRecord.template != null) {
            this.setXblShadowTree(bindableElement, this.cloneTemplate(definitionRecord.template));
        } else {
            this.setXblShadowTree(bindableElement, null);
        }
    }

    protected void setXblShadowTree(BindableElement bindableElement, XBLOMShadowTreeElement xBLOMShadowTreeElement) {
        Node node;
        XBLRecord xBLRecord;
        Object object;
        XBLOMShadowTreeElement xBLOMShadowTreeElement2 = (XBLOMShadowTreeElement)this.getXblShadowTree((Node)bindableElement);
        if (xBLOMShadowTreeElement2 != null) {
            this.fireShadowTreeEvent(bindableElement, "unbinding", (XBLShadowTreeElement)xBLOMShadowTreeElement2);
            object = this.getContentManager((Node)xBLOMShadowTreeElement2);
            if (object != null) {
                ((ContentManager)object).dispose();
            }
            bindableElement.setShadowTree(null);
            xBLRecord = this.getRecord((Node)xBLOMShadowTreeElement2);
            xBLRecord.boundElement = null;
            xBLOMShadowTreeElement2.removeEventListenerNS("http://www.w3.org/2001/xml-events", "DOMSubtreeModified", (EventListener)this.docSubtreeListener, false);
        }
        if (xBLOMShadowTreeElement != null) {
            xBLOMShadowTreeElement.addEventListenerNS("http://www.w3.org/2001/xml-events", "DOMSubtreeModified", (EventListener)this.docSubtreeListener, false, null);
            this.fireShadowTreeEvent(bindableElement, "prebind", (XBLShadowTreeElement)xBLOMShadowTreeElement);
            bindableElement.setShadowTree(xBLOMShadowTreeElement);
            object = this.getRecord((Node)xBLOMShadowTreeElement);
            ((XBLRecord)object).boundElement = bindableElement;
            xBLRecord = (AbstractDocument)bindableElement.getOwnerDocument();
            node = xBLRecord.getXBLManager();
            ContentManager contentManager = new ContentManager(xBLOMShadowTreeElement, (XBLManager)node);
            this.setContentManager((Element)xBLOMShadowTreeElement, contentManager);
        }
        this.invalidateChildNodes((Node)bindableElement);
        if (xBLOMShadowTreeElement != null) {
            object = this.getXblScopedChildNodes((Node)bindableElement);
            for (int i = 0; i < object.getLength(); ++i) {
                node = object.item(i);
                if (node.getNodeType() != 1) continue;
                this.bind((Element)node);
            }
            this.dispatchBindingChangedEvent((Element)bindableElement, (Element)xBLOMShadowTreeElement);
            this.fireShadowTreeEvent(bindableElement, "bound", (XBLShadowTreeElement)xBLOMShadowTreeElement);
        } else {
            this.dispatchBindingChangedEvent((Element)bindableElement, (Element)xBLOMShadowTreeElement);
        }
    }

    protected void fireShadowTreeEvent(BindableElement bindableElement, String string, XBLShadowTreeElement xBLShadowTreeElement) {
        DocumentEvent documentEvent = (DocumentEvent)((Object)bindableElement.getOwnerDocument());
        ShadowTreeEvent shadowTreeEvent = (ShadowTreeEvent)documentEvent.createEvent("ShadowTreeEvent");
        shadowTreeEvent.initShadowTreeEventNS("http://www.w3.org/2004/xbl", string, true, false, xBLShadowTreeElement);
        bindableElement.dispatchEvent((Event)shadowTreeEvent);
    }

    protected XBLOMShadowTreeElement cloneTemplate(XBLOMTemplateElement xBLOMTemplateElement) {
        XBLOMShadowTreeElement xBLOMShadowTreeElement = (XBLOMShadowTreeElement)xBLOMTemplateElement.getOwnerDocument().createElementNS("http://www.w3.org/2004/xbl", "shadowTree");
        NamedNodeMap namedNodeMap = xBLOMTemplateElement.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Attr attr = (Attr)namedNodeMap.item(i);
            if (attr instanceof AbstractAttrNS) {
                xBLOMShadowTreeElement.setAttributeNodeNS(attr);
                continue;
            }
            xBLOMShadowTreeElement.setAttributeNode(attr);
        }
        for (Node node = xBLOMTemplateElement.getFirstChild(); node != null; node = node.getNextSibling()) {
            xBLOMShadowTreeElement.appendChild(node.cloneNode(true));
        }
        return xBLOMShadowTreeElement;
    }

    public Node getXblParentNode(Node node) {
        Node node2;
        XBLOMContentElement xBLOMContentElement = this.getXblContentElement(node);
        Node node3 = node2 = xBLOMContentElement == null ? node.getParentNode() : xBLOMContentElement.getParentNode();
        if (node2 instanceof XBLOMContentElement) {
            node2 = node2.getParentNode();
        }
        if (node2 instanceof XBLOMShadowTreeElement) {
            node2 = this.getXblBoundElement(node2);
        }
        return node2;
    }

    public NodeList getXblChildNodes(Node node) {
        XBLRecord xBLRecord = this.getRecord(node);
        if (xBLRecord.childNodes == null) {
            xBLRecord.childNodes = new XblChildNodes(xBLRecord);
        }
        return xBLRecord.childNodes;
    }

    public NodeList getXblScopedChildNodes(Node node) {
        XBLRecord xBLRecord = this.getRecord(node);
        if (xBLRecord.scopedChildNodes == null) {
            xBLRecord.scopedChildNodes = new XblScopedChildNodes(xBLRecord);
        }
        return xBLRecord.scopedChildNodes;
    }

    public Node getXblFirstChild(Node node) {
        NodeList nodeList = this.getXblChildNodes(node);
        return nodeList.item(0);
    }

    public Node getXblLastChild(Node node) {
        NodeList nodeList = this.getXblChildNodes(node);
        return nodeList.item(nodeList.getLength() - 1);
    }

    public Node getXblPreviousSibling(Node node) {
        Node node2 = this.getXblParentNode(node);
        if (node2 == null || this.getRecord((Node)node2).childNodes == null) {
            return node.getPreviousSibling();
        }
        XBLRecord xBLRecord = this.getRecord(node);
        if (!xBLRecord.linksValid) {
            this.updateLinks(node);
        }
        return xBLRecord.previousSibling;
    }

    public Node getXblNextSibling(Node node) {
        Node node2 = this.getXblParentNode(node);
        if (node2 == null || this.getRecord((Node)node2).childNodes == null) {
            return node.getNextSibling();
        }
        XBLRecord xBLRecord = this.getRecord(node);
        if (!xBLRecord.linksValid) {
            this.updateLinks(node);
        }
        return xBLRecord.nextSibling;
    }

    public Element getXblFirstElementChild(Node node) {
        node = this.getXblFirstChild(node);
        while (node != null && node.getNodeType() != 1) {
            node = this.getXblNextSibling(node);
        }
        return (Element)node;
    }

    public Element getXblLastElementChild(Node node) {
        node = this.getXblLastChild(node);
        while (node != null && node.getNodeType() != 1) {
            node = this.getXblPreviousSibling(node);
        }
        return (Element)node;
    }

    public Element getXblPreviousElementSibling(Node node) {
        while ((node = this.getXblPreviousSibling(node)) != null && node.getNodeType() != 1) {
        }
        return (Element)node;
    }

    public Element getXblNextElementSibling(Node node) {
        while ((node = this.getXblNextSibling(node)) != null && node.getNodeType() != 1) {
        }
        return (Element)node;
    }

    public Element getXblBoundElement(Node node) {
        while (node != null && !(node instanceof XBLShadowTreeElement)) {
            XBLOMContentElement xBLOMContentElement = this.getXblContentElement(node);
            if (xBLOMContentElement != null) {
                node = xBLOMContentElement;
            }
            node = node.getParentNode();
        }
        if (node == null) {
            return null;
        }
        return this.getRecord((Node)node).boundElement;
    }

    public Element getXblShadowTree(Node node) {
        if (node instanceof BindableElement) {
            BindableElement bindableElement = (BindableElement)node;
            return bindableElement.getShadowTree();
        }
        return null;
    }

    public NodeList getXblDefinitions(Node node) {
        final String string = node.getNamespaceURI();
        final String string2 = node.getLocalName();
        return new NodeList(){

            @Override
            public Node item(int n) {
                TreeSet treeSet = (TreeSet)DefaultXBLManager.this.definitionLists.get((Object)string, (Object)string2);
                if (treeSet != null && treeSet.size() != 0 && n == 0) {
                    DefinitionRecord definitionRecord = (DefinitionRecord)treeSet.first();
                    return definitionRecord.definition;
                }
                return null;
            }

            @Override
            public int getLength() {
                Set set = (Set)DefaultXBLManager.this.definitionLists.get((Object)string, (Object)string2);
                return set != null && set.size() != 0 ? 1 : 0;
            }
        };
    }

    protected XBLRecord getRecord(Node node) {
        XBLManagerData xBLManagerData = (XBLManagerData)node;
        XBLRecord xBLRecord = (XBLRecord)xBLManagerData.getManagerData();
        if (xBLRecord == null) {
            xBLRecord = new XBLRecord();
            xBLRecord.node = node;
            xBLManagerData.setManagerData((Object)xBLRecord);
        }
        return xBLRecord;
    }

    protected void updateLinks(Node node) {
        NodeList nodeList;
        XBLRecord xBLRecord = this.getRecord(node);
        xBLRecord.previousSibling = null;
        xBLRecord.nextSibling = null;
        xBLRecord.linksValid = true;
        Node node2 = this.getXblParentNode(node);
        if (node2 != null && (nodeList = this.getXblChildNodes(node2)) instanceof XblChildNodes) {
            ((XblChildNodes)nodeList).update();
        }
    }

    public XBLOMContentElement getXblContentElement(Node node) {
        return this.getRecord((Node)node).contentElement;
    }

    public static int computeBubbleLimit(Node node, Node node2) {
        ArrayList<Node> arrayList = new ArrayList<Node>(10);
        ArrayList<Node> arrayList2 = new ArrayList<Node>(10);
        while (node != null) {
            arrayList.add(node);
            node = ((NodeXBL)node).getXblParentNode();
        }
        while (node2 != null) {
            arrayList2.add(node2);
            node2 = ((NodeXBL)node2).getXblParentNode();
        }
        int n = arrayList.size();
        int n2 = arrayList2.size();
        for (int i = 0; i < n && i < n2; ++i) {
            Node node3;
            Node node4 = (Node)arrayList.get(n - i - 1);
            if (node4 == (node3 = (Node)arrayList2.get(n2 - i - 1))) continue;
            Element element = ((NodeXBL)node4).getXblBoundElement();
            while (i > 0 && element != arrayList.get(n - i - 1)) {
                --i;
            }
            return n - i - 1;
        }
        return 1;
    }

    public ContentManager getContentManager(Node node) {
        Element element;
        Element element2 = this.getXblBoundElement(node);
        if (element2 != null && (element = this.getXblShadowTree(element2)) != null) {
            ContentManager contentManager;
            Document document = element2.getOwnerDocument();
            if (document != this.document) {
                DefaultXBLManager defaultXBLManager = (DefaultXBLManager)((AbstractDocument)document).getXBLManager();
                contentManager = defaultXBLManager.contentManagers.get(element);
            } else {
                contentManager = this.contentManagers.get(element);
            }
            return contentManager;
        }
        return null;
    }

    void setContentManager(Element element, ContentManager contentManager) {
        if (contentManager == null) {
            this.contentManagers.remove(element);
        } else {
            this.contentManagers.put(element, contentManager);
        }
    }

    public void invalidateChildNodes(Node node) {
        XBLRecord xBLRecord = this.getRecord(node);
        if (xBLRecord.childNodes != null) {
            xBLRecord.childNodes.invalidate();
        }
        if (xBLRecord.scopedChildNodes != null) {
            xBLRecord.scopedChildNodes.invalidate();
        }
    }

    public void addContentSelectionChangedListener(ContentSelectionChangedListener contentSelectionChangedListener) {
        this.contentSelectionChangedListenerList.add(ContentSelectionChangedListener.class, contentSelectionChangedListener);
    }

    public void removeContentSelectionChangedListener(ContentSelectionChangedListener contentSelectionChangedListener) {
        this.contentSelectionChangedListenerList.remove(ContentSelectionChangedListener.class, contentSelectionChangedListener);
    }

    protected Object[] getContentSelectionChangedListeners() {
        return this.contentSelectionChangedListenerList.getListenerList();
    }

    void shadowTreeSelectedContentChanged(Set<Node> set, Set<Node> set2) {
        for (Node node : set) {
            if (node.getNodeType() != 1) continue;
            this.unbind((Element)node);
        }
        for (Node node : set2) {
            if (node.getNodeType() != 1) continue;
            this.bind((Element)node);
        }
    }

    public void addBindingListener(BindingListener bindingListener) {
        this.bindingListenerList.add(BindingListener.class, bindingListener);
    }

    public void removeBindingListener(BindingListener bindingListener) {
        this.bindingListenerList.remove(BindingListener.class, bindingListener);
    }

    protected void dispatchBindingChangedEvent(Element element, Element element2) {
        Object[] objectArray = this.bindingListenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            BindingListener bindingListener = (BindingListener)objectArray[i + 1];
            bindingListener.bindingChanged(element, element2);
        }
    }

    protected boolean isActiveDefinition(XBLOMDefinitionElement xBLOMDefinitionElement, Element element) {
        DefinitionRecord definitionRecord = (DefinitionRecord)this.definitions.get((Object)xBLOMDefinitionElement, (Object)element);
        if (definitionRecord == null) {
            return false;
        }
        return definitionRecord == this.getActiveDefinition(definitionRecord.namespaceURI, definitionRecord.localName);
    }

    protected class DefAttrListener
    implements EventListener {
        protected Element importElement;

        public DefAttrListener(Element element) {
            this.importElement = element;
        }

        @Override
        public void handleEvent(Event event) {
            EventTarget eventTarget = event.getTarget();
            if (!(eventTarget instanceof XBLOMDefinitionElement)) {
                return;
            }
            XBLOMDefinitionElement xBLOMDefinitionElement = (XBLOMDefinitionElement)eventTarget;
            if (!DefaultXBLManager.this.isActiveDefinition(xBLOMDefinitionElement, this.importElement)) {
                return;
            }
            MutationEvent mutationEvent = (MutationEvent)event;
            String string = mutationEvent.getAttrName();
            if (string.equals("element")) {
                DefinitionRecord definitionRecord = (DefinitionRecord)DefaultXBLManager.this.definitions.get((Object)xBLOMDefinitionElement, (Object)this.importElement);
                DefaultXBLManager.this.removeDefinition(definitionRecord);
                DefaultXBLManager.this.addDefinition(xBLOMDefinitionElement.getElementNamespaceURI(), xBLOMDefinitionElement.getElementLocalName(), xBLOMDefinitionElement, this.importElement);
            } else if (string.equals("ref") && mutationEvent.getNewValue().length() != 0) {
                DefinitionRecord definitionRecord = (DefinitionRecord)DefaultXBLManager.this.definitions.get((Object)xBLOMDefinitionElement, (Object)this.importElement);
                DefaultXBLManager.this.removeDefinition(definitionRecord);
                DefaultXBLManager.this.addDefinitionRef((Element)xBLOMDefinitionElement);
            }
        }
    }

    protected class DefNodeInsertedListener
    implements EventListener {
        protected Element importElement;

        public DefNodeInsertedListener(Element element) {
            this.importElement = element;
        }

        @Override
        public void handleEvent(Event event) {
            MutationEvent mutationEvent = (MutationEvent)event;
            Node node = mutationEvent.getRelatedNode();
            if (!(node instanceof XBLOMDefinitionElement)) {
                return;
            }
            EventTarget eventTarget = event.getTarget();
            if (!(eventTarget instanceof XBLOMTemplateElement)) {
                return;
            }
            XBLOMTemplateElement xBLOMTemplateElement = (XBLOMTemplateElement)eventTarget;
            DefinitionRecord definitionRecord = (DefinitionRecord)DefaultXBLManager.this.definitions.get((Object)node, (Object)this.importElement);
            if (definitionRecord == null) {
                return;
            }
            ImportRecord importRecord = DefaultXBLManager.this.imports.get(this.importElement);
            if (definitionRecord.template != null) {
                for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                    if (node2 == xBLOMTemplateElement) {
                        DefaultXBLManager.this.removeTemplateElementListeners(definitionRecord.template, importRecord);
                        definitionRecord.template = xBLOMTemplateElement;
                        break;
                    }
                    if (node2 != definitionRecord.template) continue;
                    return;
                }
            } else {
                definitionRecord.template = xBLOMTemplateElement;
            }
            DefaultXBLManager.this.addTemplateElementListeners(xBLOMTemplateElement, importRecord);
            DefaultXBLManager.this.rebind(definitionRecord.namespaceURI, definitionRecord.localName, DefaultXBLManager.this.document.getDocumentElement());
        }
    }

    protected class DefNodeRemovedListener
    implements EventListener {
        protected Element importElement;

        public DefNodeRemovedListener(Element element) {
            this.importElement = element;
        }

        @Override
        public void handleEvent(Event event) {
            MutationEvent mutationEvent = (MutationEvent)event;
            Node node = mutationEvent.getRelatedNode();
            if (!(node instanceof XBLOMDefinitionElement)) {
                return;
            }
            EventTarget eventTarget = event.getTarget();
            if (!(eventTarget instanceof XBLOMTemplateElement)) {
                return;
            }
            XBLOMTemplateElement xBLOMTemplateElement = (XBLOMTemplateElement)eventTarget;
            DefinitionRecord definitionRecord = (DefinitionRecord)DefaultXBLManager.this.definitions.get((Object)node, (Object)this.importElement);
            if (definitionRecord == null || definitionRecord.template != xBLOMTemplateElement) {
                return;
            }
            ImportRecord importRecord = DefaultXBLManager.this.imports.get(this.importElement);
            DefaultXBLManager.this.removeTemplateElementListeners(xBLOMTemplateElement, importRecord);
            definitionRecord.template = null;
            for (Node node2 = xBLOMTemplateElement.getNextSibling(); node2 != null; node2 = node2.getNextSibling()) {
                if (!(node2 instanceof XBLOMTemplateElement)) continue;
                definitionRecord.template = (XBLOMTemplateElement)node2;
                DefaultXBLManager.this.addTemplateElementListeners(definitionRecord.template, importRecord);
                break;
            }
            DefaultXBLManager.this.rebind(definitionRecord.namespaceURI, definitionRecord.localName, DefaultXBLManager.this.document.getDocumentElement());
        }
    }

    protected static class DefinitionRecord
    implements Comparable<DefinitionRecord> {
        public String namespaceURI;
        public String localName;
        public XBLOMDefinitionElement definition;
        public XBLOMTemplateElement template;
        public Element importElement;

        public DefinitionRecord(String string, String string2, XBLOMDefinitionElement xBLOMDefinitionElement, XBLOMTemplateElement xBLOMTemplateElement, Element element) {
            this.namespaceURI = string;
            this.localName = string2;
            this.definition = xBLOMDefinitionElement;
            this.template = xBLOMTemplateElement;
            this.importElement = element;
        }

        public int hashCode() {
            return Objects.hash(this.importElement, this.definition);
        }

        public boolean equals(Object object) {
            return object instanceof DefinitionRecord && this.compareTo((DefinitionRecord)object) == 0;
        }

        @Override
        public int compareTo(DefinitionRecord definitionRecord) {
            Object object;
            XBLOMDefinitionElement xBLOMDefinitionElement;
            if (this.importElement == null) {
                xBLOMDefinitionElement = this.definition;
                object = definitionRecord.importElement == null ? definitionRecord.definition : (AbstractNode)definitionRecord.importElement;
            } else if (definitionRecord.importElement == null) {
                xBLOMDefinitionElement = (AbstractNode)this.importElement;
                object = definitionRecord.definition;
            } else if (this.definition.getOwnerDocument() == definitionRecord.definition.getOwnerDocument()) {
                xBLOMDefinitionElement = this.definition;
                object = definitionRecord.definition;
            } else {
                xBLOMDefinitionElement = (AbstractNode)this.importElement;
                object = (AbstractNode)definitionRecord.importElement;
            }
            short s = xBLOMDefinitionElement.compareDocumentPosition((Node)object);
            if ((s & 2) != 0) {
                return -1;
            }
            if ((s & 4) != 0) {
                return 1;
            }
            return 0;
        }
    }

    protected class DocInsertedListener
    implements EventListener {
        protected DocInsertedListener() {
        }

        @Override
        public void handleEvent(Event event) {
            EventTarget eventTarget = event.getTarget();
            if (eventTarget instanceof XBLOMDefinitionElement) {
                if (DefaultXBLManager.this.getXblBoundElement((Node)((Object)eventTarget)) == null) {
                    XBLOMDefinitionElement xBLOMDefinitionElement = (XBLOMDefinitionElement)eventTarget;
                    if (xBLOMDefinitionElement.getAttributeNS(null, "ref").length() == 0) {
                        DefaultXBLManager.this.addDefinition(xBLOMDefinitionElement.getElementNamespaceURI(), xBLOMDefinitionElement.getElementLocalName(), xBLOMDefinitionElement, null);
                    } else {
                        DefaultXBLManager.this.addDefinitionRef((Element)xBLOMDefinitionElement);
                    }
                }
            } else if (eventTarget instanceof XBLOMImportElement) {
                if (DefaultXBLManager.this.getXblBoundElement((Node)((Object)eventTarget)) == null) {
                    DefaultXBLManager.this.addImport((Element)((Object)eventTarget));
                }
            } else {
                eventTarget = (event = EventSupport.getUltimateOriginalEvent((Event)event)).getTarget();
                Node node = DefaultXBLManager.this.getXblParentNode((Node)((Object)eventTarget));
                if (node != null) {
                    DefaultXBLManager.this.invalidateChildNodes(node);
                }
                if (eventTarget instanceof BindableElement) {
                    for (Node node2 = ((Node)((Object)eventTarget)).getParentNode(); node2 != null; node2 = node2.getParentNode()) {
                        if (!(node2 instanceof BindableElement) || DefaultXBLManager.this.getRecord((Node)node2).definitionElement == null) continue;
                        return;
                    }
                    DefaultXBLManager.this.bind((Element)((Object)eventTarget));
                }
            }
        }
    }

    protected class DocRemovedListener
    implements EventListener {
        protected LinkedList<EventTarget> defsToBeRemoved = new LinkedList();
        protected LinkedList<EventTarget> importsToBeRemoved = new LinkedList();
        protected LinkedList<Node> nodesToBeInvalidated = new LinkedList();

        protected DocRemovedListener() {
        }

        @Override
        public void handleEvent(Event event) {
            Node node;
            EventTarget eventTarget = event.getTarget();
            if (eventTarget instanceof XBLOMDefinitionElement) {
                if (DefaultXBLManager.this.getXblBoundElement((Node)((Object)eventTarget)) == null) {
                    this.defsToBeRemoved.add(eventTarget);
                }
            } else if (eventTarget instanceof XBLOMImportElement && DefaultXBLManager.this.getXblBoundElement((Node)((Object)eventTarget)) == null) {
                this.importsToBeRemoved.add(eventTarget);
            }
            if ((node = DefaultXBLManager.this.getXblParentNode((Node)((Object)eventTarget))) != null) {
                this.nodesToBeInvalidated.add(node);
            }
        }
    }

    protected class DocSubtreeListener
    implements EventListener {
        protected DocSubtreeListener() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void handleEvent(Event event) {
            void var7_14;
            Object object;
            Object[] objectArray = DefaultXBLManager.this.docRemovedListener.defsToBeRemoved.toArray();
            DefaultXBLManager.this.docRemovedListener.defsToBeRemoved.clear();
            for (Object object2 : objectArray) {
                XBLOMDefinitionElement object22 = (XBLOMDefinitionElement)object2;
                if (object22.getAttributeNS(null, "ref").length() == 0) {
                    object = (DefinitionRecord)DefaultXBLManager.this.definitions.get((Object)object22, null);
                    DefaultXBLManager.this.removeDefinition((DefinitionRecord)object);
                    continue;
                }
                DefaultXBLManager.this.removeDefinitionRef((Element)object22);
            }
            Object[] objectArray2 = DefaultXBLManager.this.docRemovedListener.importsToBeRemoved.toArray();
            DefaultXBLManager.this.docRemovedListener.importsToBeRemoved.clear();
            for (Object object3 : objectArray2) {
                DefaultXBLManager.this.removeImport((Element)object3);
            }
            Object[] objectArray3 = DefaultXBLManager.this.docRemovedListener.nodesToBeInvalidated.toArray();
            DefaultXBLManager.this.docRemovedListener.nodesToBeInvalidated.clear();
            Object[] objectArray4 = objectArray3;
            int n = objectArray4.length;
            boolean bl = false;
            while (var7_14 < n) {
                object = objectArray4[var7_14];
                DefaultXBLManager.this.invalidateChildNodes((Node)object);
                ++var7_14;
            }
        }
    }

    protected class ImportAttrListener
    implements EventListener {
        protected ImportAttrListener() {
        }

        @Override
        public void handleEvent(Event event) {
            EventTarget eventTarget = event.getTarget();
            if (eventTarget != event.getCurrentTarget()) {
                return;
            }
            MutationEvent mutationEvent = (MutationEvent)event;
            if (mutationEvent.getAttrName().equals("bindings")) {
                Element element = (Element)((Object)eventTarget);
                DefaultXBLManager.this.removeImport(element);
                DefaultXBLManager.this.addImport(element);
            }
        }
    }

    protected class ImportInsertedListener
    implements EventListener {
        protected Element importElement;

        public ImportInsertedListener(Element element) {
            this.importElement = element;
        }

        @Override
        public void handleEvent(Event event) {
            EventTarget eventTarget = event.getTarget();
            if (eventTarget instanceof XBLOMDefinitionElement) {
                XBLOMDefinitionElement xBLOMDefinitionElement = (XBLOMDefinitionElement)eventTarget;
                DefaultXBLManager.this.addDefinition(xBLOMDefinitionElement.getElementNamespaceURI(), xBLOMDefinitionElement.getElementLocalName(), xBLOMDefinitionElement, this.importElement);
            }
        }
    }

    protected class ImportRecord {
        public Element importElement;
        public Node node;
        public DefNodeInsertedListener defNodeInsertedListener;
        public DefNodeRemovedListener defNodeRemovedListener;
        public DefAttrListener defAttrListener;
        public ImportInsertedListener importInsertedListener;
        public ImportRemovedListener importRemovedListener;
        public ImportSubtreeListener importSubtreeListener;
        public TemplateMutationListener templateMutationListener;

        public ImportRecord(Element element, Node node) {
            this.importElement = element;
            this.node = node;
            this.defNodeInsertedListener = new DefNodeInsertedListener(element);
            this.defNodeRemovedListener = new DefNodeRemovedListener(element);
            this.defAttrListener = new DefAttrListener(element);
            this.importInsertedListener = new ImportInsertedListener(element);
            this.importRemovedListener = new ImportRemovedListener();
            this.importSubtreeListener = new ImportSubtreeListener(element, this.importRemovedListener);
            this.templateMutationListener = new TemplateMutationListener(element);
        }
    }

    protected static class ImportRemovedListener
    implements EventListener {
        protected LinkedList<EventTarget> toBeRemoved = new LinkedList();

        protected ImportRemovedListener() {
        }

        @Override
        public void handleEvent(Event event) {
            this.toBeRemoved.add(event.getTarget());
        }
    }

    protected class ImportSubtreeListener
    implements EventListener {
        protected Element importElement;
        protected ImportRemovedListener importRemovedListener;

        public ImportSubtreeListener(Element element, ImportRemovedListener importRemovedListener) {
            this.importElement = element;
            this.importRemovedListener = importRemovedListener;
        }

        @Override
        public void handleEvent(Event event) {
            Object[] objectArray = this.importRemovedListener.toBeRemoved.toArray();
            this.importRemovedListener.toBeRemoved.clear();
            for (Object object : objectArray) {
                XBLOMDefinitionElement xBLOMDefinitionElement = (XBLOMDefinitionElement)object;
                DefinitionRecord definitionRecord = (DefinitionRecord)DefaultXBLManager.this.definitions.get((Object)xBLOMDefinitionElement, (Object)this.importElement);
                DefaultXBLManager.this.removeDefinition(definitionRecord);
            }
        }
    }

    protected class RefAttrListener
    implements EventListener {
        protected RefAttrListener() {
        }

        @Override
        public void handleEvent(Event event) {
            EventTarget eventTarget = event.getTarget();
            if (eventTarget != event.getCurrentTarget()) {
                return;
            }
            MutationEvent mutationEvent = (MutationEvent)event;
            if (mutationEvent.getAttrName().equals("ref")) {
                Element element = (Element)((Object)eventTarget);
                DefaultXBLManager.this.removeDefinitionRef(element);
                if (mutationEvent.getNewValue().length() == 0) {
                    XBLOMDefinitionElement xBLOMDefinitionElement = (XBLOMDefinitionElement)element;
                    String string = xBLOMDefinitionElement.getElementNamespaceURI();
                    String string2 = xBLOMDefinitionElement.getElementLocalName();
                    DefaultXBLManager.this.addDefinition(string, string2, (XBLOMDefinitionElement)element, null);
                } else {
                    DefaultXBLManager.this.addDefinitionRef(element);
                }
            }
        }
    }

    protected class TemplateMutationListener
    implements EventListener {
        protected Element importElement;

        public TemplateMutationListener(Element element) {
            this.importElement = element;
        }

        @Override
        public void handleEvent(Event event) {
            Node node;
            for (node = (Node)((Object)event.getTarget()); node != null && !(node instanceof XBLOMDefinitionElement); node = node.getParentNode()) {
            }
            DefinitionRecord definitionRecord = (DefinitionRecord)DefaultXBLManager.this.definitions.get((Object)node, (Object)this.importElement);
            if (definitionRecord == null) {
                return;
            }
            DefaultXBLManager.this.rebind(definitionRecord.namespaceURI, definitionRecord.localName, DefaultXBLManager.this.document.getDocumentElement());
        }
    }

    protected class XBLRecord {
        public Node node;
        public XblChildNodes childNodes;
        public XblScopedChildNodes scopedChildNodes;
        public XBLOMContentElement contentElement;
        public XBLOMDefinitionElement definitionElement;
        public BindableElement boundElement;
        public boolean linksValid;
        public Node nextSibling;
        public Node previousSibling;

        protected XBLRecord() {
        }
    }

    protected class XblChildNodes
    implements NodeList {
        protected XBLRecord record;
        protected List<Node> nodes;
        protected int size;

        public XblChildNodes(XBLRecord xBLRecord) {
            this.record = xBLRecord;
            this.nodes = new ArrayList<Node>();
            this.size = -1;
        }

        protected void update() {
            Node node;
            this.size = 0;
            Element element = DefaultXBLManager.this.getXblShadowTree(this.record.node);
            Node node2 = null;
            Node node3 = node = element == null ? this.record.node.getFirstChild() : element.getFirstChild();
            while (node != null) {
                node2 = this.collectXblChildNodes(node, node2);
                node = node.getNextSibling();
            }
            if (node2 != null) {
                XBLRecord xBLRecord = DefaultXBLManager.this.getRecord(node2);
                xBLRecord.nextSibling = null;
                xBLRecord.linksValid = true;
            }
        }

        protected Node collectXblChildNodes(Node node, Node node2) {
            Object object;
            boolean bl = false;
            if (node.getNodeType() == 1) {
                if (!"http://www.w3.org/2004/xbl".equals(node.getNamespaceURI())) {
                    bl = true;
                } else if (node instanceof XBLOMContentElement && (object = DefaultXBLManager.this.getContentManager(node)) != null) {
                    NodeList nodeList = ((ContentManager)object).getSelectedContent((XBLOMContentElement)node);
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        node2 = this.collectXblChildNodes(nodeList.item(i), node2);
                    }
                }
            } else {
                bl = true;
            }
            if (bl) {
                this.nodes.add(node);
                ++this.size;
                if (node2 != null) {
                    object = DefaultXBLManager.this.getRecord(node2);
                    ((XBLRecord)object).nextSibling = node;
                    ((XBLRecord)object).linksValid = true;
                }
                object = DefaultXBLManager.this.getRecord(node);
                ((XBLRecord)object).previousSibling = node2;
                ((XBLRecord)object).linksValid = true;
                node2 = node;
            }
            return node2;
        }

        public void invalidate() {
            for (int i = 0; i < this.size; ++i) {
                XBLRecord xBLRecord = DefaultXBLManager.this.getRecord(this.nodes.get(i));
                xBLRecord.previousSibling = null;
                xBLRecord.nextSibling = null;
                xBLRecord.linksValid = false;
            }
            this.nodes.clear();
            this.size = -1;
        }

        public Node getFirstNode() {
            if (this.size == -1) {
                this.update();
            }
            return this.size == 0 ? null : this.nodes.get(0);
        }

        public Node getLastNode() {
            if (this.size == -1) {
                this.update();
            }
            return this.size == 0 ? null : this.nodes.get(this.nodes.size() - 1);
        }

        @Override
        public Node item(int n) {
            if (this.size == -1) {
                this.update();
            }
            if (n < 0 || n >= this.size) {
                return null;
            }
            return this.nodes.get(n);
        }

        @Override
        public int getLength() {
            if (this.size == -1) {
                this.update();
            }
            return this.size;
        }
    }

    protected class XblScopedChildNodes
    extends XblChildNodes {
        public XblScopedChildNodes(XBLRecord xBLRecord) {
            super(xBLRecord);
        }

        @Override
        protected void update() {
            Node node;
            this.size = 0;
            Element element = DefaultXBLManager.this.getXblShadowTree(this.record.node);
            Node node2 = node = element == null ? this.record.node.getFirstChild() : element.getFirstChild();
            while (node != null) {
                this.collectXblScopedChildNodes(node);
                node = node.getNextSibling();
            }
        }

        protected void collectXblScopedChildNodes(Node node) {
            boolean bl = false;
            if (node.getNodeType() == 1) {
                ContentManager contentManager;
                if (!node.getNamespaceURI().equals("http://www.w3.org/2004/xbl")) {
                    bl = true;
                } else if (node instanceof XBLOMContentElement && (contentManager = DefaultXBLManager.this.getContentManager(node)) != null) {
                    NodeList nodeList = contentManager.getSelectedContent((XBLOMContentElement)node);
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        this.collectXblScopedChildNodes(nodeList.item(i));
                    }
                }
            } else {
                bl = true;
            }
            if (bl) {
                this.nodes.add(node);
                ++this.size;
            }
        }
    }
}

