/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.link;

import java.awt.event.ActionEvent;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.EnabledAction;
import org.freeplane.features.link.LinkController;
import org.freeplane.features.link.NodeLinks;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;

@EnabledAction(checkOnNodeChange=true)
class FollowLinkAction
extends AFreeplaneAction {
    private static final long serialVersionUID = 1L;

    public FollowLinkAction() {
        super("FollowLinkAction");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ModeController modeController = Controller.getCurrentModeController();
        MapController mapController = modeController.getMapController();
        LinkController linkController = LinkController.getController();
        NodeModel selNode = mapController.getSelectedNode();
        linkController.loadURL(selNode, e);
    }

    @Override
    public void setEnabled() {
        this.setEnabled(this.isLinkEnabled());
    }

    private boolean isLinkEnabled() {
        MapController mapController = Controller.getCurrentModeController().getMapController();
        for (NodeModel selNode : mapController.getSelectedNodes()) {
            if (NodeLinks.getValidLink(selNode) == null) continue;
            return true;
        }
        return false;
    }
}

