/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.ProtectionDomain;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.knopflerfish.framework.BundleArchive;
import org.knopflerfish.framework.BundleCapabilityImpl;
import org.knopflerfish.framework.BundleClassLoader;
import org.knopflerfish.framework.BundleClassPath;
import org.knopflerfish.framework.BundleImpl;
import org.knopflerfish.framework.BundleNameVersionCapability;
import org.knopflerfish.framework.BundlePackages;
import org.knopflerfish.framework.BundleRequirementImpl;
import org.knopflerfish.framework.BundleRevisionImpl;
import org.knopflerfish.framework.BundleWireImpl;
import org.knopflerfish.framework.FileArchive;
import org.knopflerfish.framework.Fragment;
import org.knopflerfish.framework.HeaderDictionary;
import org.knopflerfish.framework.NativeRequirement;
import org.knopflerfish.framework.Util;
import org.knopflerfish.framework.Validator;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.Version;
import org.osgi.framework.wiring.BundleRequirement;

public class BundleGeneration
implements Comparable<BundleGeneration> {
    static final String KNOPFLERFISH_SYMBOLICNAME = "org.knopflerfish.framework";
    final BundleImpl bundle;
    final BundlePackages bpkgs;
    final BundleArchive archive;
    final int generation;
    final boolean v2Manifest;
    final String symbolicName;
    final Util.HeaderEntry symbolicNameParameters;
    final boolean singleton;
    final Version version;
    final String attachPolicy;
    final Fragment fragment;
    final Map<String, List<BundleRequirementImpl>> requirements;
    final Map<String, List<BundleCapabilityImpl>> capabilities;
    final boolean lazyActivation;
    private final Set<String> lazyIncludes;
    private final Set<String> lazyExcludes;
    final long timeStamp;
    Vector<BundleGeneration> fragments;
    private volatile HeaderDictionary cachedRawHeaders;
    private volatile ClassLoader classLoader;
    private ProtectionDomain protectionDomain;
    private BundleClassPath unresolvedBundleClassPath;
    final BundleRevisionImpl bundleRevision;
    final BundleCapabilityImpl identity;
    final BundleNameVersionCapability bundleCapability;
    final BundleNameVersionCapability hostCapability;
    final NativeRequirement nativeRequirement;

    BundleGeneration(BundleImpl b, String exportStr, String capabilityStr) {
        this.requirements = new HashMap<String, List<BundleRequirementImpl>>();
        this.capabilities = new HashMap<String, List<BundleCapabilityImpl>>();
        this.fragments = null;
        this.cachedRawHeaders = null;
        this.unresolvedBundleClassPath = null;
        this.bundle = b;
        this.archive = null;
        this.generation = 0;
        this.v2Manifest = true;
        this.symbolicName = KNOPFLERFISH_SYMBOLICNAME;
        this.symbolicNameParameters = null;
        this.singleton = false;
        this.version = new Version(Util.readFrameworkVersion());
        this.attachPolicy = "always";
        this.fragment = null;
        this.protectionDomain = null;
        this.lazyActivation = false;
        this.lazyIncludes = null;
        this.lazyExcludes = null;
        this.timeStamp = System.currentTimeMillis();
        this.bpkgs = new BundlePackages(this, exportStr);
        this.bundleRevision = new BundleRevisionImpl(this);
        this.classLoader = b.getClassLoader();
        this.processCapabilities(capabilityStr);
        this.capabilities.put("osgi.native", Collections.singletonList(new BundleCapabilityImpl(this, b.fwCtx.props)));
        this.identity = new BundleCapabilityImpl(this);
        this.bundleCapability = new BundleNameVersionCapability(this, "osgi.wiring.bundle");
        this.hostCapability = new BundleNameVersionCapability(this, "osgi.wiring.host");
        this.nativeRequirement = null;
    }

    BundleGeneration(BundleImpl b, BundleArchive ba, BundleGeneration prev, Bundle caller) throws BundleException {
        long lastModified;
        Version newVer;
        block33: {
            this.requirements = new HashMap<String, List<BundleRequirementImpl>>();
            this.capabilities = new HashMap<String, List<BundleCapabilityImpl>>();
            this.fragments = null;
            this.cachedRawHeaders = null;
            this.unresolvedBundleClassPath = null;
            this.bundle = b;
            this.generation = (prev != null ? prev.generation : -1) + 1;
            this.archive = ba;
            this.checkCertificates();
            String mv = this.archive.getAttribute("Bundle-ManifestVersion");
            this.v2Manifest = mv != null && mv.trim().equals("2");
            String mbv = this.archive.getAttribute("Bundle-Version");
            newVer = Version.emptyVersion;
            if (mbv != null) {
                try {
                    newVer = new Version(mbv);
                }
                catch (Exception ee) {
                    if (!this.v2Manifest) break block33;
                    throw new IllegalArgumentException("Bundle does not specify a valid Bundle-Version header. Got exception: " + ee.getMessage());
                }
            }
        }
        this.version = newVer;
        List<Util.HeaderEntry> hes = Util.parseManifestHeader("Fragment-Host", this.archive.getAttribute("Fragment-Host"), true, true, true);
        this.fragment = !hes.isEmpty() ? new Fragment(this, hes.get(0)) : null;
        hes = Util.parseManifestHeader("Bundle-ActivationPolicy", this.archive.getAttribute("Bundle-ActivationPolicy"), true, true, true);
        if (!hes.isEmpty()) {
            Util.HeaderEntry he = hes.get(0);
            this.lazyActivation = "lazy".equals(he.getKey());
            if (this.lazyActivation) {
                this.lazyIncludes = he.getDirectives().containsKey("include") ? Util.parseEnumeration("include", he.getDirectives().get("include")) : null;
                if (he.getDirectives().containsKey("exclude")) {
                    this.lazyExcludes = Util.parseEnumeration("exclude", he.getDirectives().get("exclude"));
                    if (this.lazyIncludes != null) {
                        for (String entry : this.lazyExcludes) {
                            if (!this.lazyIncludes.contains(entry)) continue;
                            throw new IllegalArgumentException("Conflicting include/exclude entries in Bundle-ActivationPolicy: '" + entry + "' both included and excluded");
                        }
                    }
                } else {
                    this.lazyExcludes = null;
                }
            } else {
                this.lazyIncludes = null;
                this.lazyExcludes = null;
            }
        } else {
            this.lazyActivation = false;
            this.lazyIncludes = null;
            this.lazyExcludes = null;
        }
        hes = Util.parseManifestHeader("Require-Capability", this.archive.getAttribute("Require-Capability"), true, true, false);
        for (Util.HeaderEntry e : hes) {
            BundleRequirementImpl bri = new BundleRequirementImpl(this, e);
            String ns = bri.getNamespace();
            List<BundleRequirementImpl> nsReqs = this.requirements.get(ns);
            if (null == nsReqs) {
                if (this.isExtension() && !ns.equals("osgi.ee")) {
                    throw new IllegalArgumentException("An extension bundle can only specify capability requirements in the osgi.ee namespace. Not in " + ns);
                }
                nsReqs = new ArrayList<BundleRequirementImpl>();
                this.requirements.put(ns, nsReqs);
            }
            nsReqs.add(bri);
        }
        String ee = this.archive.getAttribute("Bundle-RequiredExecutionEnvironment");
        if (ee != null) {
            BundleRequirementImpl bri = new BundleRequirementImpl(this, ee);
            List<BundleRequirementImpl> nsReqs = this.requirements.get(bri.getNamespace());
            if (null == nsReqs) {
                nsReqs = new ArrayList<BundleRequirementImpl>();
                this.requirements.put(bri.getNamespace(), nsReqs);
            }
            nsReqs.add(bri);
        }
        this.processCapabilities(this.archive.getAttribute("Provide-Capability"));
        this.bpkgs = new BundlePackages(this);
        try {
            if (b.fwCtx.startLevelController == null) {
                this.archive.setStartLevel(0);
            } else if (this.archive.getStartLevel() == -1) {
                this.archive.setStartLevel(b.fwCtx.startLevelController.getInitialBundleStartLevel());
            }
        }
        catch (Exception exc) {
            b.fwCtx.frameworkError(b, (Throwable)exc, new FrameworkListener[0]);
        }
        this.archive.setBundleGeneration(this);
        long l = lastModified = prev != null ? 0L : this.archive.getLastModified();
        if (lastModified == 0L) {
            lastModified = System.currentTimeMillis();
        }
        this.bundleRevision = new BundleRevisionImpl(this);
        this.timeStamp = lastModified;
        hes = Util.parseManifestHeader("Bundle-SymbolicName", this.archive.getAttribute("Bundle-SymbolicName"), true, true, true);
        Util.HeaderEntry he = null;
        if (!hes.isEmpty()) {
            he = hes.get(0);
            this.symbolicName = he.getKey();
        } else {
            if (this.v2Manifest) {
                throw new IllegalArgumentException("Bundle has no symbolic name, location=" + this.bundle.location);
            }
            this.symbolicName = null;
        }
        if (he != null) {
            Collection<Bundle> snbl;
            this.singleton = "true".equals(he.getDirectives().get("singleton"));
            String tmp = he.getDirectives().get("fragment-attachment");
            this.attachPolicy = tmp == null ? "always" : tmp;
            this.symbolicNameParameters = he;
            if (!(this.bundle.fwCtx.bsnversionMode.equals("multiple") || (snbl = b.fwCtx.bundles.getBundles(this.symbolicName, this.version)).isEmpty() || snbl.size() <= 1 && snbl.contains(this.bundle))) {
                boolean fail;
                if (this.bundle.fwCtx.bsnversionMode.equals("managed")) {
                    this.bundle.fwCtx.bundleHooks.filterCollisions(prev != null ? 2 : 1, caller, snbl);
                    fail = !snbl.isEmpty() && (snbl.size() > 1 || !snbl.contains(this.bundle));
                } else {
                    fail = true;
                }
                if (fail) {
                    throw new BundleException("Bundle#" + b.id + ", a bundle with same symbolic name and version " + "is already installed (" + this.symbolicName + ", " + this.version, 9);
                }
            }
        } else {
            this.attachPolicy = "always";
            this.singleton = false;
            this.symbolicNameParameters = null;
        }
        BundleCapabilityImpl bundleCapabilityImpl = this.identity = this.symbolicName != null ? new BundleCapabilityImpl(this) : null;
        if (this.v2Manifest && this.fragment == null) {
            this.bundleCapability = new BundleNameVersionCapability(this, "osgi.wiring.bundle");
            this.hostCapability = !this.attachPolicy.equals("never") ? new BundleNameVersionCapability(this, "osgi.wiring.host") : null;
        } else {
            this.bundleCapability = null;
            this.hostCapability = null;
        }
        String nc = this.archive.getAttribute("Bundle-NativeCode");
        this.nativeRequirement = nc != null ? new NativeRequirement(this, nc) : null;
    }

    BundleGeneration(BundleGeneration prev) {
        this.requirements = new HashMap<String, List<BundleRequirementImpl>>();
        this.capabilities = new HashMap<String, List<BundleCapabilityImpl>>();
        this.fragments = null;
        this.cachedRawHeaders = null;
        this.unresolvedBundleClassPath = null;
        this.bundle = prev.bundle;
        this.archive = null;
        this.generation = prev.generation + 1;
        this.v2Manifest = prev.v2Manifest;
        this.symbolicName = prev.symbolicName;
        this.symbolicNameParameters = prev.symbolicNameParameters;
        this.singleton = prev.singleton;
        this.version = prev.version;
        this.attachPolicy = "never";
        this.fragment = prev.fragment;
        this.protectionDomain = null;
        this.lazyActivation = false;
        this.lazyIncludes = null;
        this.lazyExcludes = null;
        this.timeStamp = System.currentTimeMillis();
        this.bpkgs = null;
        this.cachedRawHeaders = prev.cachedRawHeaders;
        this.classLoader = null;
        this.bundleRevision = null;
        this.identity = null;
        this.bundleCapability = null;
        this.hostCapability = null;
        this.nativeRequirement = null;
    }

    private void processCapabilities(String capabilityStr) {
        if (capabilityStr != null && capabilityStr.length() > 0) {
            for (Util.HeaderEntry he : Util.parseManifestHeader("Provide-Capability", capabilityStr, true, true, false)) {
                BundleCapabilityImpl bci = new BundleCapabilityImpl(this, he);
                List<BundleCapabilityImpl> nsCaps = this.capabilities.get(bci.getNamespace());
                if (null == nsCaps) {
                    nsCaps = new ArrayList<BundleCapabilityImpl>();
                    this.capabilities.put(bci.getNamespace(), nsCaps);
                }
                nsCaps.add(bci);
            }
        }
    }

    @Override
    public int compareTo(BundleGeneration bg) {
        long diff = this.bundle.id - bg.bundle.id;
        if (diff < 0L) {
            return -1;
        }
        if (diff == 0L) {
            return 0;
        }
        return 1;
    }

    public String toString() {
        return "BundleGeneration[bid=" + this.bundle.id + ", gen=" + this.generation + "]";
    }

    void checkPermissions(Object checkContext) {
        this.protectionDomain = this.bundle.secure.getProtectionDomain(this);
        try {
            this.bundle.secure.checkExtensionLifecycleAdminPerm(this.bundle, checkContext);
            if (this.isExtension() && !this.bundle.secure.okAllPerm(this.bundle)) {
                throw new IllegalArgumentException("An extension bundle must have AllPermission");
            }
        }
        catch (RuntimeException re) {
            this.purgeProtectionDomain();
            throw re;
        }
        if (this.archive.getLastModified() != this.timeStamp) {
            try {
                this.archive.setLastModified(this.timeStamp);
            }
            catch (IOException ioe) {
                this.bundle.fwCtx.frameworkError(this.bundle, (Throwable)ioe, new FrameworkListener[0]);
            }
        }
    }

    Map<String, List<BundleCapabilityImpl>> getDeclaredCapabilities() {
        return this.capabilities;
    }

    Map<String, List<BundleRequirementImpl>> getDeclaredRequirements() {
        return this.requirements;
    }

    boolean resolvePackages(BundleImpl[] triggers, boolean isResolve) throws BundleException {
        ArrayList<BundleGeneration> detached = null;
        if (!isResolve) {
            this.attachFragments();
        }
        while (true) {
            if (this.bpkgs.resolvePackages(triggers)) {
                if (detached != null) {
                    for (int i = detached.size() - 2; i >= 0; --i) {
                        BundleGeneration bg = (BundleGeneration)detached.get(i);
                        if (!bg.bundle.attachToFragmentHost(this, false)) continue;
                        this.fragments.add(bg);
                    }
                }
                this.classLoader = this.bundle.secure.newBundleClassLoader(this);
                return true;
            }
            if (isResolve || !this.isFragmentHost()) break;
            if (this.bundle.fwCtx.debug.resolver) {
                this.bundle.fwCtx.debug.println("Resolve failed, remove last fragment and retry");
            }
            if (detached == null) {
                detached = new ArrayList<BundleGeneration>();
            }
            detached.add(this.detachLastFragment(true));
        }
        return false;
    }

    boolean isPkgActivationTrigger(String packageName) {
        return this.lazyActivation && (this.lazyIncludes == null && this.lazyExcludes == null || this.lazyIncludes != null && this.lazyIncludes.contains(packageName) || this.lazyExcludes != null && !this.lazyExcludes.contains(packageName));
    }

    ClassLoader getClassLoader() {
        return this.classLoader;
    }

    ProtectionDomain getProtectionDomain() {
        return this.protectionDomain;
    }

    private void attachFragments() throws BundleException {
        Collection<BundleGeneration> hosting;
        if (!this.attachPolicy.equals("never") && (hosting = this.bundle.fwCtx.bundles.getFragmentBundles(this)).size() > 0 && this.bundle.secure.okHostBundlePerm(this.bundle)) {
            for (BundleGeneration fbg : hosting) {
                fbg.bundle.attachToFragmentHost(this, false);
            }
        }
    }

    void attachFragment(BundleGeneration fragmentBundle, boolean isResolve) throws BundleException {
        int i;
        if (this.attachPolicy.equals("never")) {
            throw new IllegalStateException("Bundle does not allow fragments to attach");
        }
        if (this.attachPolicy.equals("resolve-time") && this.bundle.isResolved()) {
            throw new IllegalStateException("Bundle does not allow fragments to attach dynamically");
        }
        if (fragmentBundle.nativeRequirement != null) {
            try {
                fragmentBundle.nativeRequirement.checkNativeCode();
            }
            catch (BundleException e) {
                throw new IllegalStateException(e.getMessage());
            }
        }
        if (!this.bundle.fwCtx.resolverHooks.filterMatches((BundleRequirement)fragmentBundle.fragment, this.hostCapability)) {
            throw new IllegalStateException("Resolver hooks vetoed attach to: " + this);
        }
        String failReason = this.bpkgs.attachFragment(fragmentBundle.bpkgs, isResolve);
        if (failReason != null) {
            throw new IllegalStateException("Failed to attach: " + failReason);
        }
        if (this.classLoader != null && this.classLoader instanceof BundleClassLoader) {
            try {
                ((BundleClassLoader)this.classLoader).attachFragment(fragmentBundle);
            }
            catch (BundleException be) {
                throw new IllegalStateException(be.getMessage());
            }
        }
        if (this.bundle.fwCtx.debug.resolver) {
            this.bundle.fwCtx.debug.println("Fragment(" + fragmentBundle.bundle + ") attached to host(id=" + this.bundle.id + ",gen=" + this.generation + ")");
        }
        if (this.fragments == null) {
            this.fragments = new Vector();
        }
        for (i = 0; i < this.fragments.size(); ++i) {
            BundleGeneration b = this.fragments.get(i);
            if (b.bundle.id > fragmentBundle.bundle.id) break;
        }
        this.fragments.add(i, fragmentBundle);
    }

    private BundleGeneration detachLastFragment(boolean unregister) {
        int last = this.fragments.size() - 1;
        if (last >= 0) {
            BundleGeneration fbg = this.fragments.remove(last);
            this.bpkgs.detachFragmentSynchronized(fbg, unregister);
            if (this.bundle.fwCtx.debug.resolver) {
                this.bundle.fwCtx.debug.println("Fragment(id=" + fbg.bundle.id + ") detached from host(id=" + this.bundle.id + ",gen=" + this.generation + ")");
            }
            if (fbg.bundle.state != 1) {
                fbg.fragment.removeHost(this);
                if (!fbg.fragment.hasHosts() && fbg.isCurrent()) {
                    fbg.bundle.setStateInstalled(true);
                }
            }
            return fbg;
        }
        return null;
    }

    void updateStateFragments() {
        if (this.fragments != null) {
            Vector fix = (Vector)this.fragments.clone();
            for (BundleGeneration bundleGeneration : fix) {
                BundleImpl fb = bundleGeneration.bundle;
                fb.getUpdatedState(null, false);
            }
        }
    }

    Vector<BundleGeneration> getHosts() {
        return this.fragment != null ? this.fragment.getHosts() : null;
    }

    boolean isFragment() {
        return this.fragment != null;
    }

    boolean isFragmentHost() {
        return this.fragments != null && !this.fragments.isEmpty();
    }

    boolean isBootClassPathExtension() {
        return this.fragment != null && this.fragment.extension != null && this.fragment.extension.equals("bootclasspath");
    }

    boolean isExtension() {
        return this.fragment != null && this.fragment.extension != null;
    }

    private Dictionary<String, String> getLocaleDictionary(String locale, String baseName) {
        Vector<BundleGeneration> h;
        String defaultLocale = Locale.getDefault().toString();
        if (locale == null) {
            locale = defaultLocale;
        } else if (locale.equals("")) {
            return null;
        }
        Hashtable<String, String> localization_entries = new Hashtable<String, String>();
        if (baseName == null) {
            baseName = "OSGI-INF/l10n/bundle";
        }
        if ((h = this.getHosts()) != null) {
            BundleGeneration best;
            while (true) {
                try {
                    best = null;
                    Iterator<BundleGeneration> i$ = h.iterator();
                    while (i$.hasNext()) {
                        BundleGeneration bundleGeneration;
                        BundleGeneration bg = bundleGeneration = i$.next();
                        if (best != null && bg.version.compareTo(best.version) <= 0) continue;
                        best = bg;
                    }
                }
                catch (ConcurrentModificationException ignore) {
                    continue;
                }
                break;
            }
            if (best == this.bundle.fwCtx.systemBundle.current()) {
                this.bundle.fwCtx.systemBundle.readLocalization("", localization_entries, baseName);
                this.bundle.fwCtx.systemBundle.readLocalization(defaultLocale, localization_entries, baseName);
                if (!locale.equals(defaultLocale)) {
                    this.bundle.fwCtx.systemBundle.readLocalization(locale, localization_entries, baseName);
                }
                return localization_entries;
            }
            if (best != null) {
                return best.getLocaleDictionary(locale, baseName);
            }
        }
        this.readLocalization("", localization_entries, baseName);
        this.readLocalization(defaultLocale, localization_entries, baseName);
        if (!locale.equals(defaultLocale)) {
            this.readLocalization(locale, localization_entries, baseName);
        }
        return localization_entries;
    }

    HeaderDictionary getHeaders0(String locale) {
        if (this.cachedRawHeaders == null) {
            this.cachedRawHeaders = this.archive.getUnlocalizedAttributes();
        }
        if ("".equals(locale)) {
            return (HeaderDictionary)this.cachedRawHeaders.clone();
        }
        if (this.bundle.state != 1) {
            String base = this.cachedRawHeaders.get("Bundle-Localization");
            return this.localize(this.getLocaleDictionary(locale, base));
        }
        return null;
    }

    void addResourceEntries(Vector<URL> res, String path, String pattern, boolean recurse) {
        if (this.archive == null) {
            throw new IllegalStateException("Bundle is in UNINSTALLED state");
        }
        Enumeration<String> e = this.archive.findResourcesPath(path);
        if (e != null) {
            while (e.hasMoreElements()) {
                URL url;
                String fp = e.nextElement();
                boolean isDirectory = fp.endsWith("/");
                int searchBackwardFrom = fp.length() - 1;
                if (isDirectory) {
                    --searchBackwardFrom;
                }
                int l = fp.lastIndexOf(47, searchBackwardFrom);
                String lastComponentOfPath = fp.substring(l + 1, searchBackwardFrom + 1);
                if ((pattern == null || Util.filterMatch(pattern, lastComponentOfPath)) && (url = this.getURL(0, fp)) != null) {
                    res.add(url);
                }
                if (!isDirectory || !recurse) continue;
                this.addResourceEntries(res, fp, pattern, recurse);
            }
        }
    }

    Vector<URL> findEntries(String path, String filePattern, boolean recurse) {
        Vector<URL> res = new Vector<URL>();
        this.addResourceEntries(res, path, filePattern, recurse);
        if (this.isFragmentHost()) {
            Vector fix = (Vector)this.fragments.clone();
            for (BundleGeneration fbg : fix) {
                fbg.addResourceEntries(res, path, filePattern, recurse);
            }
        }
        return res;
    }

    URL getURL(int subId, String path) {
        try {
            StringBuffer u = new StringBuffer("bundle");
            u.append("://");
            u.append(this.bundle.id);
            if (this.generation > 0) {
                u.append('.').append(this.generation);
            }
            if (this.bundle.fwCtx.id > 0) {
                u.append('!').append(this.bundle.fwCtx.id);
            }
            if (subId > 0) {
                u.append(':').append(subId);
            }
            if (!path.startsWith("/")) {
                u.append('/');
            }
            u.append(path);
            return this.bundle.secure.getBundleURL(this.bundle.fwCtx, u.toString());
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    void closeClassLoader() {
        BundleClassLoader tmp;
        if (this.bundle.fwCtx.debug.classLoader) {
            this.bundle.fwCtx.debug.println("closeClassLoader: " + this.bundle + " gen = " + this.generation);
        }
        if ((tmp = (BundleClassLoader)this.classLoader) != null) {
            this.classLoader = null;
            tmp.close();
        }
    }

    void purge(boolean unregister) {
        if (this.bundle.fwCtx.debug.classLoader) {
            this.bundle.fwCtx.debug.println("BundleGeneration.purge: " + this.bundle + " gen = " + this.generation);
        }
        if (unregister) {
            this.unregisterPackages(true);
        }
        this.closeClassLoader();
        this.purgeProtectionDomain();
        if (this.archive != null) {
            this.archive.purge();
        }
        this.clearWiring();
    }

    boolean unregisterPackages(boolean force) {
        boolean res = this.bpkgs.unregisterPackages(force);
        if (res && this.isFragmentHost()) {
            while (this.detachLastFragment(false) != null) {
            }
        }
        return res;
    }

    void purgeProtectionDomain() {
        this.bundle.secure.purge(this.bundle, this.protectionDomain);
    }

    private void checkCertificates() {
        ArrayList<List<X509Certificate>> cs = this.archive.getCertificateChains(false);
        if (cs != null && this.bundle.fwCtx.validator != null) {
            if (this.bundle.fwCtx.debug.certificates) {
                this.bundle.fwCtx.debug.println("Validate certs for bundle #" + this.archive.getBundleId());
            }
            cs = new ArrayList<List<X509Certificate>>(cs);
            Iterator<Validator> vi = this.bundle.fwCtx.validator.iterator();
            while (!cs.isEmpty() && vi.hasNext()) {
                Validator v = vi.next();
                Iterator<List<X509Certificate>> ci = cs.iterator();
                while (ci.hasNext()) {
                    List<X509Certificate> c = ci.next();
                    if (v.validateCertificateChain(c)) {
                        this.archive.trustCertificateChain(c);
                        ci.remove();
                        if (!this.bundle.fwCtx.debug.certificates) continue;
                        this.bundle.fwCtx.debug.println("Validated cert: " + c.get(0));
                        continue;
                    }
                    if (!this.bundle.fwCtx.debug.certificates) continue;
                    this.bundle.fwCtx.debug.println("Failed to validate cert: " + c.get(0));
                }
            }
            if (cs.isEmpty()) {
                return;
            }
        }
        if (this.bundle.fwCtx.props.getBooleanProperty("org.knopflerfish.framework.all_signed")) {
            throw new IllegalArgumentException("All installed bundles must be signed!");
        }
    }

    private HeaderDictionary localize(Dictionary<String, String> localization_entries) {
        HeaderDictionary localized = (HeaderDictionary)this.cachedRawHeaders.clone();
        if (localization_entries != null) {
            Enumeration<String> e = localized.keys();
            while (e.hasMoreElements()) {
                String key = e.nextElement();
                String unlocalizedEntry = localized.get(key);
                if (!unlocalizedEntry.startsWith("%")) continue;
                String k = unlocalizedEntry.substring(1);
                String val = localization_entries.get(k);
                if (val == null) {
                    localized.put(key, k);
                    continue;
                }
                localized.put(key, val);
            }
        }
        return localized;
    }

    private void readLocalization(String locale, Hashtable<String, String> localization_entries, String baseName) {
        if (!locale.equals("")) {
            locale = "_" + locale;
        }
        while (true) {
            String l;
            Hashtable<String, String> res;
            if ((res = this.getLocalizationEntries(l = baseName + locale + ".properties")) != null) {
                localization_entries.putAll(res);
                break;
            }
            int pos = locale.lastIndexOf(95);
            if (pos == -1) break;
            locale = locale.substring(0, pos);
        }
    }

    private Hashtable<String, String> getLocalizationEntries(String name) {
        Hashtable<String, String> res = this.archive.getLocalizationEntries(name);
        if (res == null && this.isFragmentHost()) {
            Vector fix = (Vector)this.fragments.clone();
            for (BundleGeneration bg : fix) {
                if (bg.archive == null || (res = bg.archive.getLocalizationEntries(name)) == null) continue;
                break;
            }
        }
        return res;
    }

    boolean isUninstalled() {
        return this.bpkgs == null;
    }

    Vector<URL> getBundleClassPathEntries(String name, boolean onlyFirst) {
        Vector<FileArchive> fas;
        BundleClassPath bcp = this.unresolvedBundleClassPath;
        if (bcp == null) {
            this.unresolvedBundleClassPath = bcp = new BundleClassPath(this.archive, this.bundle.fwCtx);
        }
        if ((fas = bcp.componentExists(name, onlyFirst, false)) != null) {
            Vector<URL> res = new Vector<URL>();
            for (FileArchive fa : fas) {
                URL url = fa.getBundleGeneration().getURL(fa.getSubId(), name);
                if (url != null) {
                    res.addElement(url);
                    continue;
                }
                return null;
            }
            return res;
        }
        return null;
    }

    List<BundleWireImpl> getCapabilityWires() {
        if (this.bpkgs != null) {
            ArrayList<BundleWireImpl> res = new ArrayList<BundleWireImpl>();
            for (List<BundleCapabilityImpl> lbc : this.bpkgs.getOtherCapabilities().values()) {
                for (BundleCapabilityImpl bc : lbc) {
                    bc.getWires(res);
                }
            }
            return res;
        }
        return null;
    }

    List<BundleWireImpl> getRequirementWires() {
        ArrayList<BundleWireImpl> res = new ArrayList<BundleWireImpl>();
        for (List<BundleRequirementImpl> lbr : this.getOtherRequirements().values()) {
            for (BundleRequirementImpl br : lbr) {
                BundleWireImpl wire = br.getWire();
                if (wire == null) continue;
                res.add(wire);
            }
        }
        return res;
    }

    Map<String, List<BundleRequirementImpl>> getOtherRequirements() {
        Map<String, List<BundleRequirementImpl>> res = this.getDeclaredRequirements();
        if (this.isFragmentHost()) {
            boolean copied = false;
            Vector fix = (Vector)this.fragments.clone();
            for (BundleGeneration fbg : fix) {
                Map<String, List<BundleRequirementImpl>> frm = fbg.getDeclaredRequirements();
                if (frm.isEmpty()) continue;
                if (!copied) {
                    res = new HashMap<String, List<BundleRequirementImpl>>(res);
                    copied = true;
                }
                for (Map.Entry<String, List<BundleRequirementImpl>> e : frm.entrySet()) {
                    String ns = e.getKey();
                    List<BundleRequirementImpl> p = res.get(ns);
                    if (p != null) {
                        p = new ArrayList<BundleRequirementImpl>(p);
                        p.addAll((Collection<BundleRequirementImpl>)e.getValue());
                    } else {
                        p = e.getValue();
                    }
                    res.put(ns, p);
                }
            }
        }
        return res;
    }

    boolean isCurrent() {
        return this == this.bundle.current();
    }

    boolean bsnAttrMatch(Map<String, Object> attributes) {
        if (this.symbolicNameParameters != null) {
            Map<String, Object> attr = this.symbolicNameParameters.getAttributes();
            String mandatory = this.symbolicNameParameters.getDirectives().get("mandatory");
            HashSet<String> mAttr = new HashSet<String>();
            if (mandatory != null) {
                String[] split;
                for (String e : split = Util.splitwords(mandatory, ",")) {
                    mAttr.add(e.trim());
                }
            }
            for (Map.Entry<String, Object> e : attributes.entrySet()) {
                String key = e.getKey();
                if (e.getValue().equals(attr.get(key))) {
                    mAttr.remove(key);
                    continue;
                }
                return false;
            }
            return mAttr.isEmpty();
        }
        return true;
    }

    void setWired() {
        this.bundleRevision.setWired();
    }

    void clearWiring() {
        this.bundleRevision.clearWiring();
    }

    Set<BundleImpl> getResolvedHosts() {
        HashSet<BundleImpl> res = new HashSet<BundleImpl>();
        List<BundleGeneration> tgts = this.fragment.targets();
        for (BundleGeneration t : tgts) {
            if (!t.bundle.isResolved()) continue;
            res.add(t.bundle);
        }
        return res;
    }
}

