/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.core.importer;

import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaMember;
import com.tngtech.archunit.core.domain.JavaMethod;
import com.tngtech.archunit.core.importer.DomainBuilders;
import com.tngtech.archunit.core.importer.HasRawCodeUnitOrigin;
import com.tngtech.archunit.core.importer.JavaClassDescriptorImporter;
import com.tngtech.archunit.core.importer.RawAccessRecord;
import com.tngtech.archunit.core.importer.RawCodeUnitDependency;
import com.tngtech.archunit.core.importer.RawInstanceofCheck;
import com.tngtech.archunit.core.importer.RawReferencedClassObject;
import com.tngtech.archunit.core.importer.RawTryCatchBlock;
import com.tngtech.archunit.thirdparty.com.google.common.base.Preconditions;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ArrayListMultimap;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ForwardingSet;
import com.tngtech.archunit.thirdparty.com.google.common.collect.HashMultimap;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ListMultimap;
import com.tngtech.archunit.thirdparty.com.google.common.collect.SetMultimap;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ClassFileImportRecord {
    private static final Logger log = LoggerFactory.getLogger(ClassFileImportRecord.class);
    private static final DomainBuilders.JavaClassTypeParametersBuilder NO_TYPE_PARAMETERS = new DomainBuilders.JavaClassTypeParametersBuilder(Collections.emptyList());
    private final Map<String, JavaClass> classes = new HashMap<String, JavaClass>();
    private final Map<String, String> superclassNamesByOwner = new HashMap<String, String>();
    private final ListMultimap<String, String> interfaceNamesByOwner = ArrayListMultimap.create();
    private final Map<String, DomainBuilders.JavaClassTypeParametersBuilder> typeParametersBuilderByOwner = new HashMap<String, DomainBuilders.JavaClassTypeParametersBuilder>();
    private final Map<String, DomainBuilders.JavaParameterizedTypeBuilder<JavaClass>> genericSuperclassBuilderByOwner = new HashMap<String, DomainBuilders.JavaParameterizedTypeBuilder<JavaClass>>();
    private final Map<String, List<DomainBuilders.JavaParameterizedTypeBuilder<JavaClass>>> genericInterfaceBuildersByOwner = new HashMap<String, List<DomainBuilders.JavaParameterizedTypeBuilder<JavaClass>>>();
    private final SetMultimap<String, DomainBuilders.JavaFieldBuilder> fieldBuildersByOwner = HashMultimap.create();
    private final SetMultimap<String, DomainBuilders.JavaMethodBuilder> methodBuildersByOwner = HashMultimap.create();
    private final SetMultimap<String, DomainBuilders.JavaConstructorBuilder> constructorBuildersByOwner = HashMultimap.create();
    private final Map<String, DomainBuilders.JavaStaticInitializerBuilder> staticInitializerBuildersByOwner = new HashMap<String, DomainBuilders.JavaStaticInitializerBuilder>();
    private final SetMultimap<String, DomainBuilders.JavaAnnotationBuilder> annotationsByOwner = HashMultimap.create();
    private final Map<String, DomainBuilders.JavaAnnotationBuilder.ValueBuilder> annotationDefaultValuesByOwner = new HashMap<String, DomainBuilders.JavaAnnotationBuilder.ValueBuilder>();
    private final EnclosingDeclarationsByInnerClasses enclosingDeclarationsByOwner = new EnclosingDeclarationsByInnerClasses();
    private final Set<RawAccessRecord.ForField> rawFieldAccessRecords = new HashSet<RawAccessRecord.ForField>();
    private final Set<RawAccessRecord> rawMethodCallRecords = new HashSet<RawAccessRecord>();
    private final Set<RawAccessRecord> rawConstructorCallRecords = new HashSet<RawAccessRecord>();
    private final Set<RawAccessRecord> rawMethodReferenceRecords = new HashSet<RawAccessRecord>();
    private final Set<RawAccessRecord> rawConstructorReferenceRecords = new HashSet<RawAccessRecord>();
    private final Set<RawReferencedClassObject> rawReferencedClassObjects = new HashSet<RawReferencedClassObject>();
    private final Set<RawInstanceofCheck> rawInstanceofChecks = new HashSet<RawInstanceofCheck>();
    private final Set<RawTryCatchBlock> rawTryCatchBlocks = new HashSet<RawTryCatchBlock>();
    private final SyntheticAccessRecorder syntheticLambdaAccessRecorder = ClassFileImportRecord.createSyntheticLambdaAccessRecorder();
    private final SyntheticAccessRecorder syntheticPrivateAccessRecorder = ClassFileImportRecord.createSyntheticPrivateAccessRecorder();
    private final SyntheticallyResolvedAccessRecords syntheticallyResolvedAccessRecords = new SyntheticallyResolvedAccessRecords();
    private static final Function<RawAccessRecord, RawAccessRecord.Builder> COPY_RAW_ACCESS_RECORD = access -> ClassFileImportRecord.copyInto(new RawAccessRecord.Builder(), access);
    private static final Function<RawAccessRecord.ForField, RawAccessRecord.ForField.Builder> COPY_RAW_FIELD_ACCESS_RECORD = access -> ClassFileImportRecord.copyInto(new RawAccessRecord.ForField.Builder(), access).withAccessType(access.accessType);
    private static final Function<RawReferencedClassObject, RawReferencedClassObject.Builder> COPY_RAW_REFERENCED_CLASS_OBJECT = referencedClassObject -> ClassFileImportRecord.copyInto(new RawReferencedClassObject.Builder(), referencedClassObject);
    private static final Function<RawInstanceofCheck, RawInstanceofCheck.Builder> COPY_RAW_INSTANCEOF_CHECK = instanceofCheck -> ClassFileImportRecord.copyInto(new RawInstanceofCheck.Builder(), instanceofCheck);
    private static final Function<RawTryCatchBlock, RawTryCatchBlock.Builder> COPY_RAW_TRY_CATCH_BLOCK = RawTryCatchBlock.Builder::from;

    ClassFileImportRecord() {
    }

    void setSuperclass(String ownerName, String superclassName) {
        Preconditions.checkState(!this.superclassNamesByOwner.containsKey(ownerName), "Attempted to add %s as a second superclass to %s, this is most likely a bug", (Object)superclassName, (Object)ownerName);
        this.superclassNamesByOwner.put(ownerName, superclassName);
    }

    void addInterfaces(String ownerName, List<String> interfaceNames) {
        this.interfaceNamesByOwner.putAll(ownerName, interfaceNames);
    }

    void addTypeParameters(String ownerName, DomainBuilders.JavaClassTypeParametersBuilder builder) {
        this.typeParametersBuilderByOwner.put(ownerName, builder);
    }

    void addGenericSuperclass(String ownerName, DomainBuilders.JavaParameterizedTypeBuilder<JavaClass> genericSuperclassBuilder) {
        this.genericSuperclassBuilderByOwner.put(ownerName, genericSuperclassBuilder);
    }

    public void addGenericInterfaces(String ownerName, List<DomainBuilders.JavaParameterizedTypeBuilder<JavaClass>> genericInterfaceBuilders) {
        this.genericInterfaceBuildersByOwner.put(ownerName, genericInterfaceBuilders);
    }

    void addField(String ownerName, DomainBuilders.JavaFieldBuilder fieldBuilder) {
        this.fieldBuildersByOwner.put(ownerName, fieldBuilder);
    }

    void addMethod(String ownerName, DomainBuilders.JavaMethodBuilder methodBuilder) {
        this.methodBuildersByOwner.put(ownerName, methodBuilder);
    }

    void addConstructor(String ownerName, DomainBuilders.JavaConstructorBuilder constructorBuilder) {
        this.constructorBuildersByOwner.put(ownerName, constructorBuilder);
    }

    void setStaticInitializer(String ownerName, DomainBuilders.JavaStaticInitializerBuilder builder) {
        Preconditions.checkState(!this.staticInitializerBuildersByOwner.containsKey(ownerName), "Tried to add a second static initializer to %s, this is most likely a bug", (Object)ownerName);
        this.staticInitializerBuildersByOwner.put(ownerName, builder);
    }

    void addClassAnnotations(String ownerName, Set<DomainBuilders.JavaAnnotationBuilder> annotations) {
        this.annotationsByOwner.putAll(ownerName, annotations);
    }

    void addMemberAnnotations(String declaringClassName, String memberName, String descriptor, Set<DomainBuilders.JavaAnnotationBuilder> annotations) {
        this.annotationsByOwner.putAll(ClassFileImportRecord.getMemberKey(declaringClassName, memberName, descriptor), annotations);
    }

    void addAnnotationDefaultValue(String declaringClassName, String methodName, String descriptor, DomainBuilders.JavaAnnotationBuilder.ValueBuilder valueBuilder) {
        this.annotationDefaultValuesByOwner.put(ClassFileImportRecord.getMemberKey(declaringClassName, methodName, descriptor), valueBuilder);
    }

    void setEnclosingClass(String ownerName, String enclosingClassName) {
        this.enclosingDeclarationsByOwner.registerEnclosingClass(ownerName, enclosingClassName);
    }

    void setEnclosingCodeUnit(String ownerName, RawAccessRecord.CodeUnit enclosingCodeUnit) {
        this.enclosingDeclarationsByOwner.registerEnclosingCodeUnit(ownerName, enclosingCodeUnit);
    }

    void addTryCatchBlocks(Set<RawTryCatchBlock> tryCatchBlocks) {
        this.rawTryCatchBlocks.addAll(tryCatchBlocks);
    }

    Optional<String> getSuperclassFor(String name) {
        return Optional.ofNullable(this.superclassNamesByOwner.get(name));
    }

    List<String> getInterfaceNamesFor(String ownerName) {
        return this.interfaceNamesByOwner.get((Object)ownerName);
    }

    DomainBuilders.JavaClassTypeParametersBuilder getTypeParameterBuildersFor(String ownerName) {
        if (!this.typeParametersBuilderByOwner.containsKey(ownerName)) {
            return NO_TYPE_PARAMETERS;
        }
        return this.typeParametersBuilderByOwner.get(ownerName);
    }

    Optional<DomainBuilders.JavaParameterizedTypeBuilder<JavaClass>> getGenericSuperclassFor(JavaClass owner) {
        return Optional.ofNullable(this.genericSuperclassBuilderByOwner.get(owner.getName()));
    }

    Optional<List<DomainBuilders.JavaParameterizedTypeBuilder<JavaClass>>> getGenericInterfacesFor(JavaClass owner) {
        return Optional.ofNullable(this.genericInterfaceBuildersByOwner.get(owner.getName()));
    }

    Set<DomainBuilders.JavaFieldBuilder> getFieldBuildersFor(String ownerName) {
        return this.fieldBuildersByOwner.get((Object)ownerName);
    }

    Set<DomainBuilders.JavaMethodBuilder> getMethodBuildersFor(String ownerName) {
        return this.methodBuildersByOwner.get((Object)ownerName);
    }

    Set<DomainBuilders.JavaConstructorBuilder> getConstructorBuildersFor(String ownerName) {
        return this.constructorBuildersByOwner.get((Object)ownerName);
    }

    Optional<DomainBuilders.JavaStaticInitializerBuilder> getStaticInitializerBuilderFor(String ownerName) {
        return Optional.ofNullable(this.staticInitializerBuildersByOwner.get(ownerName));
    }

    Set<DomainBuilders.JavaAnnotationBuilder> getAnnotationsFor(JavaClass owner) {
        return this.annotationsByOwner.get((Object)owner.getName());
    }

    Set<DomainBuilders.JavaAnnotationBuilder> getAnnotationsFor(JavaMember owner) {
        return this.annotationsByOwner.get((Object)ClassFileImportRecord.getMemberKey(owner));
    }

    Optional<DomainBuilders.JavaAnnotationBuilder.ValueBuilder> getAnnotationDefaultValueBuilderFor(JavaMethod method) {
        return Optional.ofNullable(this.annotationDefaultValuesByOwner.get(ClassFileImportRecord.getMemberKey(method)));
    }

    Optional<String> getEnclosingClassFor(String ownerName) {
        return this.enclosingDeclarationsByOwner.getEnclosingClassName(ownerName);
    }

    Optional<RawAccessRecord.CodeUnit> getEnclosingCodeUnitFor(String ownerName) {
        return this.enclosingDeclarationsByOwner.getEnclosingCodeUnit(ownerName);
    }

    void registerFieldAccess(RawAccessRecord.ForField record) {
        if (!JavaClassDescriptorImporter.isSyntheticEnumSwitchMapFieldName(((RawAccessRecord.TargetInfo)record.getTarget()).name)) {
            this.rawFieldAccessRecords.add(record);
        }
    }

    void registerMethodCall(RawAccessRecord record) {
        if (JavaClassDescriptorImporter.isSyntheticAccessMethodName(record.getTarget().name)) {
            this.syntheticPrivateAccessRecorder.registerSyntheticMethodInvocation(record);
        } else {
            this.rawMethodCallRecords.add(record);
        }
    }

    void registerConstructorCall(RawAccessRecord record) {
        this.rawConstructorCallRecords.add(record);
    }

    void registerMethodReference(RawAccessRecord record) {
        this.rawMethodReferenceRecords.add(record);
    }

    void registerConstructorReference(RawAccessRecord record) {
        this.rawConstructorReferenceRecords.add(record);
    }

    void registerLambdaInvocation(RawAccessRecord record) {
        this.syntheticLambdaAccessRecorder.registerSyntheticMethodInvocation(record);
    }

    void registerReferencedClassObject(RawReferencedClassObject referencedClassObject) {
        this.rawReferencedClassObjects.add(referencedClassObject);
    }

    void registerInstanceofCheck(RawInstanceofCheck instanceofCheck) {
        this.rawInstanceofChecks.add(instanceofCheck);
    }

    void forEachRawFieldAccessRecord(Consumer<RawAccessRecord.ForField> doWithRecord) {
        this.resolveSyntheticOrigins(this.rawFieldAccessRecords, COPY_RAW_FIELD_ACCESS_RECORD, this.syntheticPrivateAccessRecorder, this.syntheticLambdaAccessRecorder).forEach(doWithRecord);
    }

    void forEachRawMethodCallRecord(Consumer<RawAccessRecord> doWithRecord) {
        this.resolveSyntheticOrigins(this.rawMethodCallRecords, COPY_RAW_ACCESS_RECORD, this.syntheticPrivateAccessRecorder, this.syntheticLambdaAccessRecorder).forEach(doWithRecord);
    }

    void forEachRawConstructorCallRecord(Consumer<RawAccessRecord> doWithRecord) {
        this.resolveSyntheticOrigins(this.rawConstructorCallRecords, COPY_RAW_ACCESS_RECORD, this.syntheticPrivateAccessRecorder, this.syntheticLambdaAccessRecorder).forEach(doWithRecord);
    }

    void forEachRawMethodReferenceRecord(Consumer<RawAccessRecord> doWithRecord) {
        this.resolveSyntheticOrigins(this.rawMethodReferenceRecords, COPY_RAW_ACCESS_RECORD, this.syntheticPrivateAccessRecorder, this.syntheticLambdaAccessRecorder).forEach(doWithRecord);
    }

    void forEachRawConstructorReferenceRecord(Consumer<RawAccessRecord> doWithRecord) {
        this.resolveSyntheticOrigins(this.rawConstructorReferenceRecords, COPY_RAW_ACCESS_RECORD, this.syntheticLambdaAccessRecorder).forEach(doWithRecord);
    }

    void forEachRawReferencedClassObject(Consumer<RawReferencedClassObject> doWithReferencedClassObject) {
        this.resolveSyntheticOrigins(this.rawReferencedClassObjects, COPY_RAW_REFERENCED_CLASS_OBJECT, this.syntheticLambdaAccessRecorder).forEach(doWithReferencedClassObject);
    }

    void forEachRawInstanceofCheck(Consumer<RawInstanceofCheck> doWithInstanceofCheck) {
        this.resolveSyntheticOrigins(this.rawInstanceofChecks, COPY_RAW_INSTANCEOF_CHECK, this.syntheticLambdaAccessRecorder).forEach(doWithInstanceofCheck);
    }

    public void forEachRawTryCatchBlock(Consumer<RawTryCatchBlock> doWithTryCatchBlock) {
        this.resolveSyntheticOrigins(this.rawTryCatchBlocks, COPY_RAW_TRY_CATCH_BLOCK, this.syntheticLambdaAccessRecorder).map(rawTryCatchBlock -> {
            Set<RawAccessRecord> fixedAccessesInTryBlock = this.resolveSyntheticOrigins(rawTryCatchBlock.getAccessesInTryBlock(), COPY_RAW_ACCESS_RECORD, this.syntheticPrivateAccessRecorder, this.syntheticLambdaAccessRecorder).collect(Collectors.toSet());
            return RawTryCatchBlock.Builder.from(rawTryCatchBlock).withRawAccessesContainedInTryBlock(fixedAccessesInTryBlock).build();
        }).forEach(doWithTryCatchBlock);
    }

    private <HAS_RAW_CODE_UNIT_ORIGIN extends HasRawCodeUnitOrigin> Stream<HAS_RAW_CODE_UNIT_ORIGIN> resolveSyntheticOrigins(Set<HAS_RAW_CODE_UNIT_ORIGIN> objectsWithCodeUnitOrigins, Function<HAS_RAW_CODE_UNIT_ORIGIN, ? extends HasRawCodeUnitOrigin.Builder<HAS_RAW_CODE_UNIT_ORIGIN>> copyObjectWithCodeUnitOrigin, SyntheticAccessRecorder ... syntheticAccessRecorders) {
        return objectsWithCodeUnitOrigins.stream().flatMap(objectWithCodeUnitOrigin -> this.syntheticallyResolvedAccessRecords.resolveSyntheticOrigin(objectWithCodeUnitOrigin, copyObjectWithCodeUnitOrigin, syntheticAccessRecorders));
    }

    void add(JavaClass javaClass) {
        this.classes.put(javaClass.getName(), javaClass);
    }

    Map<String, JavaClass> getClasses() {
        return this.classes;
    }

    private static <TARGET, BUILDER extends RawCodeUnitDependency.Builder<?, TARGET>> BUILDER copyInto(BUILDER builder, RawCodeUnitDependency<TARGET> referencedClassObject) {
        builder.withOrigin(referencedClassObject.getOrigin()).withTarget(referencedClassObject.getTarget()).withLineNumber(referencedClassObject.getLineNumber()).withDeclaredInLambda(referencedClassObject.isDeclaredInLambda());
        return builder;
    }

    private static SyntheticAccessRecorder createSyntheticLambdaAccessRecorder() {
        return new SyntheticAccessRecorder(codeUnit -> JavaClassDescriptorImporter.isLambdaMethodName(codeUnit.getName()), (accessBuilder, newOrigin) -> accessBuilder.withOrigin((RawAccessRecord.CodeUnit)newOrigin).withDeclaredInLambda(true));
    }

    private static SyntheticAccessRecorder createSyntheticPrivateAccessRecorder() {
        return new SyntheticAccessRecorder(codeUnit -> JavaClassDescriptorImporter.isSyntheticAccessMethodName(codeUnit.getName()), HasRawCodeUnitOrigin.Builder::withOrigin);
    }

    private static String getMemberKey(RawAccessRecord.MemberSignature member) {
        return ClassFileImportRecord.getMemberKey(member.getDeclaringClassName(), member.getName(), member.getDescriptor());
    }

    private static String getMemberKey(JavaMember member) {
        return ClassFileImportRecord.getMemberKey(member.getOwner().getName(), member.getName(), member.getDescriptor());
    }

    private static String getMemberKey(String declaringClassName, String methodName, String descriptor) {
        return declaringClassName + "|" + methodName + "|" + descriptor;
    }

    private static class EnclosingDeclarationsByInnerClasses {
        private final Map<String, String> innerClassNameToEnclosingClassName = new HashMap<String, String>();
        private final Map<String, RawAccessRecord.CodeUnit> innerClassNameToEnclosingCodeUnit = new HashMap<String, RawAccessRecord.CodeUnit>();

        private EnclosingDeclarationsByInnerClasses() {
        }

        void registerEnclosingClass(String innerName, String outerName) {
            Preconditions.checkArgument(!this.innerClassNameToEnclosingClassName.containsKey(innerName) || this.innerClassNameToEnclosingClassName.get(innerName).equals(outerName), "Can't register multiple enclosing classes, this is likely a bug!");
            this.innerClassNameToEnclosingClassName.put(innerName, outerName);
        }

        void registerEnclosingCodeUnit(String innerName, RawAccessRecord.CodeUnit codeUnit) {
            Preconditions.checkArgument(!this.innerClassNameToEnclosingCodeUnit.containsKey(innerName) || this.innerClassNameToEnclosingCodeUnit.get(innerName).equals(codeUnit), "Can't register multiple enclosing code units, this is likely a bug!");
            this.innerClassNameToEnclosingCodeUnit.put(innerName, codeUnit);
        }

        Optional<String> getEnclosingClassName(String ownerName) {
            return Optional.ofNullable(this.innerClassNameToEnclosingClassName.get(ownerName));
        }

        Optional<RawAccessRecord.CodeUnit> getEnclosingCodeUnit(String ownerName) {
            return Optional.ofNullable(this.innerClassNameToEnclosingCodeUnit.get(ownerName));
        }
    }

    private static class SyntheticAccessRecorder {
        private final SetMultimap<String, RawAccessRecord> rawSyntheticMethodInvocationRecordsByTarget = HashMultimap.create();
        private final Predicate<RawAccessRecord.CodeUnit> isSyntheticOrigin;
        private final BiConsumer<HasRawCodeUnitOrigin.Builder<?>, RawAccessRecord.CodeUnit> fixOrigin;

        SyntheticAccessRecorder(Predicate<RawAccessRecord.CodeUnit> isSyntheticOrigin, BiConsumer<HasRawCodeUnitOrigin.Builder<?>, RawAccessRecord.CodeUnit> fixOrigin) {
            this.isSyntheticOrigin = isSyntheticOrigin;
            this.fixOrigin = fixOrigin;
        }

        void registerSyntheticMethodInvocation(RawAccessRecord record) {
            this.rawSyntheticMethodInvocationRecordsByTarget.put(ClassFileImportRecord.getMemberKey(record.getTarget()), record);
        }

        <ACCESS extends HasRawCodeUnitOrigin> Set<ACCESS> fixSyntheticAccess(ACCESS access, Function<ACCESS, ? extends HasRawCodeUnitOrigin.Builder<ACCESS>> copyAccess) {
            return this.isSyntheticOrigin.test(access.getOrigin()) ? this.replaceOriginByFixedOrigin(access, copyAccess) : Collections.singleton(access);
        }

        private <ACCESS extends HasRawCodeUnitOrigin> Set<ACCESS> replaceOriginByFixedOrigin(ACCESS accessFromSyntheticMethod, Function<ACCESS, ? extends HasRawCodeUnitOrigin.Builder<ACCESS>> copyAccess) {
            Set result = this.findNonSyntheticOriginOf(accessFromSyntheticMethod).map(accessWithCorrectOrigin -> {
                HasRawCodeUnitOrigin.Builder copiedBuilder = (HasRawCodeUnitOrigin.Builder)copyAccess.apply(accessFromSyntheticMethod);
                this.fixOrigin.accept(copiedBuilder, accessWithCorrectOrigin.getOrigin());
                return (HasRawCodeUnitOrigin)copiedBuilder.build();
            }).collect(Collectors.toSet());
            if (result.isEmpty()) {
                log.warn("Could not find matching origin for synthetic method {}", accessFromSyntheticMethod);
            }
            return result;
        }

        private <ACCESS extends HasRawCodeUnitOrigin> Stream<HasRawCodeUnitOrigin> findNonSyntheticOriginOf(ACCESS access) {
            return this.isSyntheticOrigin.test(access.getOrigin()) ? this.rawSyntheticMethodInvocationRecordsByTarget.get((Object)ClassFileImportRecord.getMemberKey(access.getOrigin())).stream().flatMap(this::findNonSyntheticOriginOf) : Stream.of(access);
        }
    }

    private static class SyntheticallyResolvedAccessRecords {
        private final Map<HasRawCodeUnitOrigin, ResolvedAccesses<? extends HasRawCodeUnitOrigin>> resolvedAccessRecords = new HashMap<HasRawCodeUnitOrigin, ResolvedAccesses<? extends HasRawCodeUnitOrigin>>();

        private SyntheticallyResolvedAccessRecords() {
        }

        <HAS_RAW_CODE_UNIT_ORIGIN extends HasRawCodeUnitOrigin> Stream<HAS_RAW_CODE_UNIT_ORIGIN> resolveSyntheticOrigin(HAS_RAW_CODE_UNIT_ORIGIN hasRawCodeUnitOrigin, Function<HAS_RAW_CODE_UNIT_ORIGIN, ? extends HasRawCodeUnitOrigin.Builder<HAS_RAW_CODE_UNIT_ORIGIN>> createWithNewOrigin, SyntheticAccessRecorder ... syntheticAccessRecorders) {
            ResolvedAccesses resolvedAccesses = this.getResolvedAccessRecordsTyped().computeIfAbsent(hasRawCodeUnitOrigin, it -> SyntheticallyResolvedAccessRecords.fixSyntheticAccesses(it, createWithNewOrigin, syntheticAccessRecorders));
            return resolvedAccesses.areUnchanged() ? Stream.of(hasRawCodeUnitOrigin) : resolvedAccesses.stream();
        }

        private static <HAS_RAW_CODE_UNIT_ORIGIN extends HasRawCodeUnitOrigin> ResolvedAccesses<HAS_RAW_CODE_UNIT_ORIGIN> fixSyntheticAccesses(HAS_RAW_CODE_UNIT_ORIGIN hasRawCodeUnitOrigin, Function<HAS_RAW_CODE_UNIT_ORIGIN, ? extends HasRawCodeUnitOrigin.Builder<HAS_RAW_CODE_UNIT_ORIGIN>> createWithNewOrigin, SyntheticAccessRecorder[] syntheticAccessRecorders) {
            Set<HAS_RAW_CODE_UNIT_ORIGIN> unresolvedResult;
            Set<Object> result = unresolvedResult = Collections.singleton(hasRawCodeUnitOrigin);
            for (SyntheticAccessRecorder syntheticAccessRecorder : syntheticAccessRecorders) {
                result = result.stream().flatMap(it -> syntheticAccessRecorder.fixSyntheticAccess(it, createWithNewOrigin).stream()).collect(Collectors.toSet());
            }
            return result.equals(unresolvedResult) ? ResolvedAccesses.unchanged() : new ResolvedAccesses(result);
        }

        private <HAS_RAW_CODE_UNIT_ORIGIN extends HasRawCodeUnitOrigin> Map<HAS_RAW_CODE_UNIT_ORIGIN, ResolvedAccesses<HAS_RAW_CODE_UNIT_ORIGIN>> getResolvedAccessRecordsTyped() {
            return this.resolvedAccessRecords;
        }

        private static class ResolvedAccesses<HAS_RAW_CODE_UNIT_ORIGIN extends HasRawCodeUnitOrigin>
        extends ForwardingSet<HAS_RAW_CODE_UNIT_ORIGIN> {
            private static final ResolvedAccesses<HasRawCodeUnitOrigin> UNCHANGED = new ResolvedAccesses(Collections.emptySet());
            private final Set<HAS_RAW_CODE_UNIT_ORIGIN> accesses;

            private ResolvedAccesses(Set<HAS_RAW_CODE_UNIT_ORIGIN> accesses) {
                this.accesses = accesses;
            }

            @Override
            protected Set<HAS_RAW_CODE_UNIT_ORIGIN> delegate() {
                return this.accesses;
            }

            boolean areUnchanged() {
                return this == UNCHANGED;
            }

            static <HAS_RAW_CODE_UNIT_ORIGIN extends HasRawCodeUnitOrigin> ResolvedAccesses<HAS_RAW_CODE_UNIT_ORIGIN> unchanged() {
                return UNCHANGED;
            }
        }
    }
}

